/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.application;

import malik.emulator.util.*;

public class RequestableQueue extends RunnableQueue
{
    protected long[] longs;

    public RequestableQueue() {
        this(0x10);
    }

    public RequestableQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = capacity;
        this.longs = new long[initialCapacity];
    }

    public void clear() {
        long[] q = longs;
        for(int c = capacity, t = tail, i = head; i != t; i = nextIndex(i, c)) q[i] = 0L;
        super.clear();
    }

    public void removeHeadElement() {
        int h;
        if((h = head) != tail)
        {
            longs[h] = 0L;
            runnables[h] = null;
            advanceHead(h);
        }
    }

    public void addTailElement(Runnable runnableElement) {
        int t;
        long[] q1 = longs;
        Runnable[] q2 = runnables;
        if(freeElements() == 0)
        {
            int c = (capacity << 1) - 1;
            q1 = longs = expand(q1, c);
            q2 = runnables = (Runnable[]) expand(q2, c);
            reset(c);
        }
        t = tail;
        q1[t] = -1L;
        q2[t] = runnableElement;
        advanceTail(t);
    }

    public void addTailElement(Runnable runnableElement, long longElement) {
        int t;
        long[] q1 = longs;
        Runnable[] q2 = runnables;
        if(freeElements() == 0)
        {
            int c = (capacity << 1) - 1;
            q1 = longs = expand(q1, c);
            q2 = runnables = (Runnable[]) expand(q2, c);
            reset(c);
        }
        t = tail;
        q1[t] = longElement;
        q2[t] = runnableElement;
        advanceTail(t);
    }

    public final long peekHeadLong() {
        return longs[head];
    }
}
