/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.io.cloud;

import java.io.*;

public class FileInputStream extends HandleInputStream
{
    private final long fileSize;

    public FileInputStream(String fileName) {
        super(fileName, 1);
        int h = handle;
        this.fileSize = h == 0 ? -1L : MalikSystem.syscall((long) h, 0x0015);
    }

    FileInputStream(String fileName, int handle) {
        super(fileName, null, handle);
        this.fileSize = MalikSystem.syscall((long) handle, 0x0015);
    }

    public void close() throws IOException {
        checkOpenError();
        synchronized(descriptor)
        {
            closeHandle();
        }
    }

    public final long getFileSize() {
        return fileSize;
    }

    protected void $finalize$() {
        closeHandle();
    }

    private void closeHandle() {
        int h;
        if((h = handle) != 0)
        {
            MalikSystem.syscall((long) h, 0x0011);
            handle = 0;
        }
    }
}
