/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.media.graphics;

public class Paint extends Clip
{
    private boolean alpha;
    private int color;

    public Paint(int clipWidth, int clipHeight) {
        super(clipWidth, clipHeight);
    }

    public Paint(int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public Paint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
    }

    public Paint(int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(clipLeft, clipTop, clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public Paint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
    }

    public Paint(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight, int colorARGB, boolean alpha) {
        super(translateX, translateY, clipLeft, clipTop, clipWidth, clipHeight);
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }

    public void setColor(int colorARGB) {
        this.color = colorARGB;
    }

    public void setColor(int colorARGB, boolean alpha) {
        this.alpha = alpha;
        this.color = colorARGB;
    }

    public void setColorRGB(int red, int green, int blue) {
        this.alpha = false;
        this.color = (red & 0xff) << 0x10 | (green & 0xff) << 0x08 | (blue & 0xff);
    }

    public void setColorARGB(int red, int green, int blue, int alpha) {
        this.alpha = true;
        this.color = alpha << 0x18 | (red & 0xff) << 0x10 | (green & 0xff) << 0x08 | (blue & 0xff);
    }

    public final boolean hasAlpha() {
        return alpha;
    }

    public final int getColor() {
        return color;
    }

    public final int getAlphaComponent() {
        return color >>> 0x18;
    }

    public final int getRedComponent() {
        return (color >> 0x10) & 0xff;
    }

    public final int getGreenComponent() {
        return (color >> 0x08) & 0xff;
    }

    public final int getBlueComponent() {
        return color & 0xff;
    }
}
