/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.midlet;

public class MIDletDispatcher extends Object
{
    public static final int OK              = 0;
    public static final int MUST_STOPPED    = 1;
    public static final int MUST_TERMINATED = 2;

    private MIDlet application;
    private final String applicationTypeName;

    public MIDletDispatcher(String applicationTypeName) {
        this.applicationTypeName = applicationTypeName;
    }

    public void stop() {
        MIDlet application;
        if((application = this.application) != null)
        {
            try
            {
                application.destroyApp(true);
            }
            catch(Exception e)
            {
                e.printRealStackTrace();
            }
        }
    }

    public int start() {
        MIDlet application = null;
        try
        {
            this.application = application = (MIDlet) Class.forName(applicationTypeName).newInstance();
        }
        catch(Exception e)
        {
            e.printRealStackTrace();
            return MUST_TERMINATED;
        }
        try
        {
            for(int i = 4; i-- > 0; )
            {
                try
                {
                    application.startApp();
                    break;
                }
                catch(MIDletStateChangeException e)
                {
                    e.printRealStackTrace();
                }
                if(i == 0) return MUST_STOPPED;
                try
                {
                    Thread.sleep(1000L);
                }
                catch(InterruptedException e)
                {
                    e.printRealStackTrace();
                }
            }
        }
        catch(RuntimeException e)
        {
            e.printRealStackTrace();
            return MUST_STOPPED;
        }
        return OK;
    }
}
