/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.lcdui;

public final class AvailableInputModes extends Object
{
    public static final AvailableInputModes instance;

    static {
        instance = new AvailableInputModes();
    }

    private final InputMode[] modes;
    private final InputMode system;

    private AvailableInputModes() {
        int len = 0;
        InputMode[] modes = new InputMode[3];
        InputMode system = new SystemInputMode();
        do
        {
            InputMode mode;
            String className;
            if((className = System.getProperty("input.mode.".concat(Integer.toString(len)))) == null) break;
            try
            {
                mode = (InputMode) Class.forName(className).newInstance();
            }
            catch(Exception e)
            {
                break;
            }
            if(len == modes.length) Array.copy(modes, 0, modes = new InputMode[(len << 1) + 1], 0, len);
            modes[len++] = mode;
        } while(len > 0);
        if(len < modes.length) Array.copy(modes, 0, modes = new InputMode[len], 0, len);
        this.modes = modes;
        this.system = system;
    }

    public int size() {
        return modes.length;
    }

    public InputMode system() {
        return system;
    }

    public InputMode get(int index) {
        InputMode[] modes = this.modes;
        Array.checkIndex("AvailableInputModes.get", modes.length, index);
        return modes[index];
    }

    public InputMode get(String characterSubset) {
        InputMode[] modes;
        for(int i = (modes = this.modes).length; i-- > 0; )
        {
            InputMode current;
            if((current = modes[i]).isCharacterSubset(characterSubset)) return current;
        }
        return system;
    }
}
