/*
    Zlib – библиотека сжатия данных общего назначения. Версия 1.1.0
    Это изменённая объектно-ориентированная версия библиотеки, полностью
    совместимая с оригинальной библиотекой.
    
    Copyright © 1995–2005 Jean-loup Gailly и Mark Adler
    Copyright © 2000–2011 ymnk, JCraft, Inc.
    Copyright © 2016–2017, 2019–2022 Малик Разработчик
    
    Эта библиотека поставляется «как есть», без каких-либо явных или
    подразумеваемых гарантий. Ни при каких обстоятельствах авторы не
    несут какой-либо ответственности в случае потери данных вследствие
    использования данной библиотеки.
    
    Разрешается всем использовать эту библиотеку для любых целей, в том
    числе и для коммерческих приложений, а также изменять её и
    распространять свободно при соблюдении следующих условий:
    
        1. Оригинал библиотеки не должен быть искажён; вы не должны
    заявлять, что именно вы написали оригинальную библиотеку. Если вы
    используете эту библиотеку в своём программном продукте, то ссылка
    на авторов библиотеки была бы желательна, но это не является
    обязательным требованием.
    
        2. Изменённые версии исходных текстов должны быть отчётливо
    маркированы и не должны выдаваться за оригинал библиотеки.
    
        3. Эти замечания не могут быть удалены либо изменены при
    каком-либо варианте распространения исходных текстов.
*/

package malik.emulator.compression.zlib;

public class CRC32 extends Checksum32
{
    private static final int[] TABLE;

    static {
        int[] table = new int[256];
        for(int i = 0; i < 256; i++)
        {
            int c = i;
            for(int j = 8; j-- > 0; ) c = (c & 0x01) != 0 ? 0xedb88320 ^ (c >>> 1) : c >>> 1;
            table[i] = c;
        }
        TABLE = table;
    }

    public CRC32() {
    }

    public CRC32(int value) {
        super(value);
    }

    public void update(byte[] buf, int offset, int length) {
        int c = ~value;
        while(length-- > 0) c = TABLE[(c ^ buf[offset++]) & 0xff] ^ (c >>> 8);
        value = ~c;
    }

    public Checksum32 copy() {
        return new CRC32(value);
    }
}
