{
    Этот исходный текст является частью Малик Эмулятора.
    Файл исходного текста lifecycle.inc
    Используется в emulmalik.pas

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Малик Эмулятор – свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Малик Эмулятор распространяется в надежде, что он может быть полезен,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

    function MalikProcessor.writeEBP(newEBP: int; context: MalikContext): Pointer; assembler; nostackframe;
    asm
                call    virtualAddressToPhysical
                mov     dword[ecx+offset MalikContext.stackBlock], eax
                mov     dword[ecx+offset MalikContext.regEBP], edx
    end;

    function MalikProcessor.readEBP(context: MalikContext): int; assembler; nostackframe;
    asm
                push    ecx
                push    edx
                lea     ecx, [edx+$00]
                mov     edx, [ecx+offset MalikContext.stackBlock]
                test    edx, edx
                jz      @0
                call    physicalAddressToVirtual
                jmp     @1
        @0:     mov     eax, [ecx+offset MalikContext.regEBP]
        @1:     pop     edx
                pop     ecx
    end;

    function MalikProcessor.getRegionIndex(address: int): int; assembler; nostackframe;
    asm
                push    ebx
                push    ecx
                push    edx
                mov     ecx, [eax+offset regionsCount]
                jecxz   @2
                mov     eax, [eax+offset regions]
        @0:     mov     edx, [eax+ecx*4-$04]
                mov     ebx, [edx+offset MalikMemoryRegion.start]
                cmp     dword[esp+$00], ebx
                jl      @1
                add     ebx, [edx+offset MalikMemoryRegion.size]
                cmp     dword[esp+$00], ebx
                jge     @1
                lea     eax, [ecx-$01]
                jmp     @3
        @1:     loop    @0
        @2:     mov     eax, -$01
        @3:     pop     edx
                pop     ecx
                pop     ebx
    end;

    function MalikProcessor.virtualAddressToPhysical(address: int): Pointer; assembler; nostackframe;
    asm
                push    edx
                sub     edx, MEMORY_START
                jl      @0
                cmp     edx, $80000000-MEMORY_START
                jl      @1
        @0:     xor     eax, eax
                pop     edx
                ret
        @1:     push    ebx
                push    ecx
                lea     ecx, [edx+$00]
                and     ecx, PAGE_SIZE-$01
                shr     edx, $0a
                mov     ebx, [eax+offset pages]
                mov     eax, [ebx+edx*4]
                test    eax, eax
                jz      @2
                lea     eax, [eax+ecx]
        @2:     pop     ecx
                pop     ebx
                pop     edx
    end;

    function MalikProcessor.physicalAddressToVirtual(address: Pointer): int; assembler; nostackframe;
    asm
                push    esi
                push    edi
                push    ebx
                push    ecx
                push    edx
                mov     edx, [eax+offset regions]
                mov     ecx, [eax+offset regionsCount]
        @0:     mov     ebx, [edx+ecx*4-$04]
                mov     esi, [ebx+offset MalikMemoryRegion.memory]
                lea     edi, [esi+$00]
                add     edi, [ebx+offset MalikMemoryRegion.size]
                cmp     dword[esp+$00], esi
                jb      @1
                cmp     dword[esp+$00], edi
                ja      @1
                mov     eax, [esp+$00]
                add     eax, [ebx+offset MalikMemoryRegion.start]
                sub     eax, esi
                jmp     @2
        @1:     loop    @0
                xor     eax, eax
        @2:     pop     edx
                pop     ecx
                pop     ebx
                pop     edi
                pop     esi
    end;

    procedure MalikProcessor.addref(obj: int); assembler; nostackframe;
    asm
                push    eax
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @0
                inc     dword[eax+$00]
        @0:     pop     eax
    end;

    procedure MalikProcessor.release(obj: int); assembler; nostackframe;
    asm
                push    eax
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @0
                dec     dword[eax+$00]
        @0:     pop     eax
    end;

    procedure MalikProcessor.idle(); assembler; nostackframe;
    asm
                mov     byte [eax+offset paused], true
                pushad
                call    invokeProgrammePause
                popad
                mov     byte [eax+offset paused], false
    end;

    procedure MalikProcessor.lifecycle(); assembler;
    var
        prevESP: int;
        prevEBX: int;
        prevESI: int;
        prevEDI: int;
        ourSelf: MalikProcessor;
        dat: packed array [0..7] of int;
        aux: packed array [0..7] of int;
    asm
                (*** ВХОД ***)

                mov     dword[prevESP], esp
                mov     dword[prevEBX], ebx
                mov     dword[prevESI], esi
                mov     dword[prevEDI], edi
                mov     dword[ourSelf], eax
                call    configureFPU
                mov     ebx, [eax+offset contexts]
                mov     ebx, [ebx+$00]


                (*** ГЛАВНЫЙ ЦИКЛ ***)

        @mloop: mov     esp, [prevESP]


                (*** ОБРАБОТКА ПРЕРЫВАНИЙ ***)

                mov     esi, [ebx+offset MalikContext.stackTop]
                call    @interrupt


                (*** ПРОВЕРКА УСЛОВИЙ ВЫПОЛНЕНИЯ ***)

        @0:     mov     eax, [ourSelf]
                test    byte [eax+offset debugging], true
                jz      @1
                mov     dword[dat+$00], ebx
                mov     edx, [ebx+offset MalikContext.id]
                call    invokeInstructionExecuting
                mov     ebx, [dat+$00]
                mov     esi, [ebx+offset MalikContext.stackTop]
                mov     eax, [ourSelf]
        @1:     test    byte [eax+offset terminated], true
                jnz     @exit
                cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_ACTIVE
                jne     @chctx
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @@EF


                (*** ОСНОВНАЯ ПРОГРАММА (ВЫБОРКА И ВЫПОЛНЕНИЕ ИНСТРУКЦИИ) ***)

                lea     edi, [eax+$00]
                movzx   eax, byte[edi+$00]
                jmp     dword[@0IT+eax*4]
                align   $04

        @0IT:   dd      @000, @001, @002, @003, @004, @005, @006, @007, @008, @009, @00a, @00b, @00c, @00d, @00e, @00f
                dd      @010, @011, @012, @013, @014, @015, @016, @017, @018, @019, @01a, @01b, @01c, @01d, @01e, @01f
                dd      @020, @021, @022, @023, @024, @025, @026, @027, @028, @029, @02a, @02b, @02c, @02d, @02e, @02f
                dd      @030, @031, @032, @033, @034, @035, @036, @037, @038, @039, @03a, @03b, @03c, @03d, @03e, @03f
                dd      @040, @041, @042, @043, @044, @045, @046, @047, @048, @049, @04a, @04b, @04c, @04d, @04e, @04f
                dd      @050, @051, @052, @053, @054, @055, @056, @057, @058, @059, @05a, @05b, @05c, @05d, @05e, @05f
                dd      @060, @061, @062, @063, @064, @065, @066, @067, @068, @069, @06a, @06b, @06c, @06d, @06e, @06f
                dd      @070, @071, @072, @073, @074, @075, @076, @077, @078, @079, @07a, @07b, @07c, @07d, @07e, @07f
                dd      @080, @081, @082, @083, @084, @085, @086, @087, @088, @089, @08a, @08b, @08c, @08d, @08e, @08f
                dd      @090, @091, @092, @093, @094, @095, @096, @097, @098, @099, @09a, @09b, @09c, @09d, @09e, @09f
                dd      @0a0, @0a1, @0a2, @0a3, @0a4, @0a5, @0a6, @0a7, @0a8, @0a9, @0aa, @0ab, @0ac, @0ad, @0ae, @0af
                dd      @0b0, @0b1, @0b2, @0b3, @0b4, @0b5, @0b6, @0b7, @0b8, @0b9, @0ba, @0bb, @0bc, @0bd, @0be, @0bf
                dd      @0c0, @0c1, @0c2, @0c3, @0c4, @0c5, @0c6, @0c7, @0c8, @0c9, @0ca, @0cb, @0cc, @0cd, @0ce, @0cf
                dd      @0d0, @0d1, @0d2, @0d3, @0d4, @0d5, @0d6, @0d7, @0d8, @0d9, @0da, @0db, @0dc, @0dd, @0de, @0df
                dd      @0e0, @0e1, @0e2, @0e3, @0e4, @0e5, @0e6, @0e7, @0e8, @0e9, @0ea, @0eb, @0ec, @0ed, @0ee, @0ef
                dd      @0f0, @0f1, @0f2, @0f3, @0f4, @0f5, @0f6, @0f7, @0f8, @0f9, @0fa, @0fb, @0fc, @0fd, @0fe, @0ff
        @1IT:   dd      @100, @101, @102, @103, @104, @105, @106, @107, @108, @109, @10a, @10b, @10c, @10d, @10e, @10f
                dd      @110, @111, @112, @113, @114, @115, @116, @117, @118, @119, @11a, @11b, @11c, @11d, @11e, @11f
                dd      @120, @121, @122, @123, @124, @125, @126, @127, @128, @129, @12a, @12b, @12c, @12d, @12e, @12f
                dd      @130, @131, @132, @133, @134, @135, @136, @137, @138, @139, @13a, @13b, @13c, @13d, @13e, @13f
                dd      @140, @141, @142, @143, @144, @145, @146, @147, @148, @149, @14a, @14b, @14c, @14d, @14e, @14f
                dd      @150, @151, @152, @153, @154, @155, @156, @157, @158, @159, @15a, @15b, @15c, @15d, @15e, @15f
                dd      @160, @161, @162, @163, @164, @165, @166, @167, @168, @169, @16a, @16b, @16c, @16d, @16e, @16f
                dd      @170, @171, @172, @173, @174, @175, @176, @177, @178, @179, @17a, @17b, @17c, @17d, @17e, @17f
                dd      @180, @181, @182, @183, @184, @185, @186, @187, @188, @189, @18a, @18b, @18c, @18d, @18e, @18f
                dd      @190, @191, @192, @193, @194, @195, @196, @197, @198, @199, @19a, @19b, @19c, @19d, @19e, @19f
                dd      @1a0, @1a1, @1a2, @1a3, @1a4, @1a5, @1a6, @1a7, @1a8, @1a9, @1aa, @1ab, @1ac, @1ad, @1ae, @1af
                dd      @1b0, @1b1, @1b2, @1b3, @1b4, @1b5, @1b6, @1b7, @1b8, @1b9, @1ba, @1bb, @1bc, @1bd, @1be, @1bf
                dd      @1c0, @1c1, @1c2, @1c3, @1c4, @1c5, @1c6, @1c7, @1c8, @1c9, @1ca, @1cb, @1cc, @1cd, @1ce, @1cf
                dd      @1d0, @1d1, @1d2, @1d3, @1d4, @1d5, @1d6, @1d7, @1d8, @1d9, @1da, @1db, @1dc, @1dd, @1de, @1df
                dd      @1e0, @1e1, @1e2, @1e3, @1e4, @1e5, @1e6, @1e7, @1e8, @1e9, @1ea, @1eb, @1ec, @1ed, @1ee, @1ef
                dd      @1f0, @1f1, @1f2, @1f3, @1f4, @1f5, @1f6, @1f7, @1f8, @1f9, @1fa, @1fb, @1fc, @1fd, @1fe, @1ff
        @2IT:   dd      @200, @201, @202, @203, @204, @205, @206, @207, @208, @209, @20a, @20b, @20c, @20d, @20e, @20f
                dd      @210, @211, @212, @213, @214, @215, @216, @217, @218, @219, @21a, @21b, @21c, @21d, @21e, @21f
                dd      @220, @221, @222, @223, @224, @225, @226, @227, @228, @229, @22a, @22b, @22c, @22d, @22e, @22f
                dd      @230, @231, @232, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO, @@UO
                dd      $cccccccc, $cccccccc, $cccccccc, $cccccccc


                (*** РЕАЛИЗАЦИЯ ИНСТРУКЦИЙ ***)

        @000: { nop }
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @001: { load    byte as long $xx }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                movsx   eax, byte[edi+$01]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @002: { load    short as long $jjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                movsx   eax, word[edi+$01]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @003: { load    int as long $llkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [edi+$01]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @004: { load    long $ppoonnmmllkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [edi+$01]
                mov     edx, [edi+$05]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $09
                jmp     @next
                align   $04

        @005: { load    float <num: float> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [edi+$01]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @006: { load    double <num: double> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [edi+$01]
                mov     edx, [edi+$05]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $09
                jmp     @next
                align   $04

        @007: { load    real <num: real> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                fld     tbyte[edi+$01]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $0b
                jmp     @next
                align   $04

        @008: { load    except ±$llkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ourSelf]
                lea     edx, [ebx+$00]
                call    readEBP
                mov     edx, [ebx+offset MalikContext.regEIP]
                lea     edx, [edx+$05]
                add     edx, [edi+$01]
                mov     ecx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], eax
                mov     dword[esi+$08], ecx
                mov     dword[esi+$0c], STACKITEM_EXCEPT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @009: { load    byte as int $xx }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                movsx   eax, byte[edi+$01]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @00a: { load    short as int $jjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                movsx   eax, word[edi+$01]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @00b: { load    int $llkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [edi+$01]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @00c: { load    wchar $jjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                movzx   eax, word[edi+$01]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @00d: { load    float as double <num: float> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                fld     dword[edi+$01]
                fstp    qword[esi+$00]
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @00e: { load    float as real <num: float> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                fld     dword[edi+$01]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $01
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @00f: { load    double as real <num: double> }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                fld     qword[edi+$01]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $02
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $09
                jmp     @next
                align   $04

        @010: { pop }
                call    @checkOperand
                mov     eax, [esi+$0c]
                call    @isValueExcept
                test    dl,  dl
                jz      @@OF
                cmp     eax, STACKITEM_OBJECT
                jne     @010_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
        @010_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @011: { pop     $jjii }
                movzx   eax, word[edi+$01]
                test    eax, eax
                jz      @011_2
                lea     edi, [eax+$00]
                call    @checkItems
                lea     eax, [edi+$00]
                call    @checkItemTypesExcept
                lea     ecx, [edi+$00]
                jecxz   @011_2
                mov     eax, [ourSelf]
        @011_0: cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @011_1
                mov     edx, [esi+$00]
                call    release
        @011_1: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                loop    @011_0
                mov     dword[ebx+offset MalikContext.stackTop], esi
        @011_2: add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @012: { dup }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, $01
                call    @checkItems
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                cmp     eax, STACKITEM_OBJECT
                jne     @012_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @012_0: lea     edi, [esi-$10]
                cld
                movsd
                movsd
                movsd
                movsd
                lea     esi, [esi-$20]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @013: { dup     $jjii }
                movzx   eax, word[edi+$01]
                test    eax, eax
                jnz     @013_0
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
        @013_0: mov     dword[dat+$00], eax
                call    @checkTopItems
                mov     eax, [dat+$00]
                call    @checkItems
                mov     eax, [dat+$00]
                call    @checkItemTypes
                mov     ecx, [dat+$00]
                lea     eax, [ecx+$00]
                sal     eax, $04
                lea     edi, [esi+$00]
                sub     edi, eax
        @013_1: cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @013_2
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @013_2: cld
                movsd
                movsd
                movsd
                movsd
                loop    @013_1
                mov     eax, [dat+$00]
                sal     eax, $05
                sub     esi, eax
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @014: { dup     x 1 }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, $02
                call    @checkItems
                mov     eax, $02
                call    @checkItemTypes
                lea     edi, [esi-$10]
                mov     ecx, $08
                cld
                rep movsd
                lea     esi, [esi-$30]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @014_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @014_0: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @015: { dup     x $jjii }
                movzx   eax, word[edi+$01]
                lea     eax, [eax+$01]
                mov     dword[dat+$00], eax
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [dat+$00]
                call    @checkItems
                mov     eax, [dat+$00]
                call    @checkItemTypes
                mov     eax, [dat+$00]
                lea     eax, [eax*4]
                lea     edi, [esi-$10]
                lea     ecx, [eax+$00]
                cld
                rep movsd
                neg     eax
                lea     esi, [esi+eax*4-$10]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @015_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @015_0: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$10
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @016: { swap }
                mov     eax, $02
                call    @checkItems
                mov     eax, $02
                call    @checkItemTypesExcept
                mov     ecx, $04
        @016_0: mov     eax, [esi+ecx*4-$04]
                xchg    eax, [esi+ecx*4+$0c]
                mov     dword[esi+ecx*4-$04], eax
                loop    @016_0
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @017: { dup     $jjii x $llkk }
                mov     eax, [edi+$01]
                test    ax,  ax
                jnz     @017_0
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
        @017_0: movzx   edx, ax
                shr     eax, $10
                mov     dword[dat+$00], edx
                lea     eax, [eax+edx]
                mov     dword[dat+$08], eax
                mov     eax, [dat+$00]
                call    @checkTopItems
                mov     eax, [dat+$08]
                call    @checkItems
                mov     eax, [dat+$08]
                call    @checkItemTypes
                mov     eax, [dat+$08]
                lea     eax, [eax*4]
                mov     edx, [dat+$00]
                lea     edx, [edx*4]
                neg     edx
                lea     edi, [esi+edx*4]
                lea     ecx, [eax+$00]
                cld
                rep movsd
                lea     ecx, [eax+$00]
                sub     ecx, edx
                lea     ecx, [ecx*4]
                sub     esi, ecx
                mov     ecx, [dat+$00]
        @017_1: cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @017_2
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @017_2: cld
                movsd
                movsd
                movsd
                movsd
                loop    @017_1
                mov     eax, [dat+$00]
                sal     eax, $04
                sub     dword[ebx+offset MalikContext.stackTop], eax
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @018: { popdw }
                call    @checkOperand
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @018_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
        @018_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @019: { popdw2 }
                call    @checkOperand
                lea     eax, [esi+$00]
                call    @isTwoDW
                test    al,  al
                jnz     @019_1
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @019_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
        @019_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
        @019_1: cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @019_2
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
        @019_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01a: { dupdw }
                mov     eax, $01
                call    @checkTopItems
                call    @checkOperand
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01a_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01a_0: lea     edi, [esi-$10]
                cld
                movsd
                movsd
                movsd
                movsd
                lea     esi, [esi-$20]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01b: { dupdw2 }
                mov     eax, $01
                call    @checkTopItems
                call    @checkOperand
                lea     eax, [esi+$00]
                call    @isTwoDW
                test    al,  al
                jz      @01b_0
                lea     edi, [esi-$10]
                cld
                movsd
                movsd
                movsd
                movsd
                lea     esi, [esi-$20]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
        @01b_0: mov     eax, $02
                call    @checkTopItems
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     edi, [esi-$20]
                mov     ecx, $02
        @01b_1: cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01b_2
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01b_2: cld
                movsd
                movsd
                movsd
                movsd
                loop    @01b_1
                lea     esi, [esi-$40]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01c: { dupdw   x 1 }
                mov     eax, $01
                call    @checkTopItems
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
        @dupdw_x1:
                lea     edi, [esi-$10]
                mov     ecx, $08
                cld
                rep movsd
                lea     esi, [esi-$30]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01c_0
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01c_0: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01d: { dupdw2  x 1 }
                mov     eax, $01
                call    @checkTopItems
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isTwoDW
                test    al,  al
                jz      @01d_0
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jnz     @dupdw_x1
        @01d_0: mov     eax, $02
                call    @checkTopItems
                call    @check3Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$20]
                call    @isOneDW
                test    al,  al
                jz      @@OF
        @dupdw2_x1:
                lea     edi, [esi-$20]
                mov     ecx, $0c
                cld
                rep movsd
                lea     esi, [esi-$50]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01d_1
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01d_1: cld
                movsd
                movsd
                movsd
                movsd
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01d_2
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01d_2: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$20
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01e: { dupdw   x 2 }
                mov     eax, $01
                call    @checkTopItems
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @01e_0
                lea     eax, [esi+$10]
                call    @isTwoDW
                test    al,  al
                jnz     @dupdw_x1
        @01e_0: call    @check3Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$20]
                call    @isOneDW
                test    al,  al
                jz      @@OF
        @dupdw_x2:
                lea     edi, [esi-$10]
                mov     ecx, $0c
                cld
                rep movsd
                lea     esi, [esi-$40]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01e_1
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01e_1: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @01f: { dupdw2  x 2 }
                mov     eax, $01
                call    @checkTopItems
                call    @check2Operands
                lea     eax, [esi+$00]
                call    @isTwoDW
                test    al,  al
                jz      @01f_0
                lea     eax, [esi+$10]
                call    @isTwoDW
                test    al,  al
                jnz     @dupdw_x1
        @01f_0: call    @check3Operands
                lea     eax, [esi+$00]
                call    @isTwoDW
                test    al,  al
                jz      @01f_1
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @01f_1
                lea     eax, [esi+$20]
                call    @isOneDW
                test    al,  al
                jnz     @dupdw_x2
        @01f_1: mov     eax, $02
                call    @checkTopItems
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @01f_2
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al, al
                jz      @01f_2
                lea     eax, [esi+$20]
                call    @isTwoDW
                test    al,  al
                jnz     @dupdw2_x1
        @01f_2: call    @check4Operands
                lea     eax, [esi+$00]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$10]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$20]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     eax, [esi+$30]
                call    @isOneDW
                test    al,  al
                jz      @@OF
                lea     edi, [esi-$20]
                mov     ecx, $10
                cld
                rep movsd
                lea     esi, [esi-$60]
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01f_3
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01f_3: cld
                movsd
                movsd
                movsd
                movsd
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @01f_4
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
        @01f_4: cld
                movsd
                movsd
                movsd
                movsd
                add     dword[ebx+offset MalikContext.stackTop], -$20
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @020: { load    byte as long [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                movsx   eax, byte[eax+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @021: { load    short as long [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                movsx   eax, word[eax+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @022: { load    int as long [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                mov     eax, [eax+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @023: { load    long [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                mov     edx, [eax+$04]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @024: { load    float [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @025: { load    double [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                mov     edx, [eax+$04]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @026: { load    real [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                fld     tbyte[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @027: { load    object [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [eax+$00]
                mov     eax, [ourSelf]
                call    addref
                lea     esi, [esi-$10]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @028: { load    byte as int [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                movsx   eax, byte[eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @029: { load    short as int [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                movsx   eax, word[eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02a: { load    int [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02b: { load    wchar [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                movzx   eax, word[eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02c: { load    float as double [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                fld     dword[eax+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02d: { load    float as real [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                fld     dword[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $01
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02e: { load    double as real [$llkkjjii] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     esi, [esi-$10]
                fld     qword[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $02
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @02f: { load    null }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     dword[esi+$00], $00
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @030: { store   long as byte [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     dl,  [esi+$00]
                mov     byte [eax+$00], dl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @031: { store   long as short [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     dx,  [esi+$00]
                mov     word [eax+$00], dx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @032: { store   long as int [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [esi+$00]
                mov     dword[eax+$00], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @033: { store   long [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [esi+$00]
                mov     ecx, [esi+$04]
                mov     dword[eax+$00], edx
                mov     dword[eax+$04], ecx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @034: { store   float [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [esi+$00]
                mov     dword[eax+$00], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @035: { store   double [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [esi+$00]
                mov     ecx, [esi+$04]
                mov     dword[eax+$00], edx
                mov     dword[eax+$04], ecx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @036: { store   real [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                fld     tbyte[esi+$00]
                fstp    tbyte[eax+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @037: { store   object [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     ecx, [eax+$00]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @038: { store   int as byte [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     dl,  [esi+$00]
                mov     byte [eax+$00], dl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @039: { store   int as short [$llkkjjii] }
        @03b: { store   wchar [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     dx,  [esi+$00]
                mov     word [eax+$00], dx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @03a: { store   int [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                mov     edx, [esi+$00]
                mov     dword[eax+$00], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @03c: { store   double as float [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @03d: { store   real as float [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @03e: { store   real as double [$llkkjjii] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$01]
                call    @checkMemory
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @03f: { breakpoint }
                inc     dword[ebx+offset MalikContext.regEIP]
                mov     dword[dat+$00], ebx
                mov     eax, [ourSelf]
                call    invokeProgrammeBreakpoint
                mov     ebx, [dat+$00]
                jmp     @0
                align   $04

        @040: { load    [esp+jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
                call    @load
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @041: { load    [esp+$lkkjjii0] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                sal     eax, $04
                call    @checkLoadESP
                call    @load
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @042: { load    int [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_int:
                cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     esi, [esi-$10]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @043: { load    long [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_long:
                cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     esi, [esi-$10]
                mov     edx, [eax+$04]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @044: { load    float [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_float:
                mov     edx, [eax+$0c]
                cmp     edx, STACKITEM_FLOAT
                je      @044_0
                cmp     edx, STACKITEM_REAL
                jne     @@OF
                lea     esi, [esi-$10]
                fld     tbyte[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $01
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
        @044_0: lea     esi, [esi-$10]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @045: { load    double [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_double:
                mov     edx, [eax+$0c]
                cmp     edx, STACKITEM_DOUBLE
                je      @045_0
                cmp     edx, STACKITEM_REAL
                jne     @@OF
                lea     esi, [esi-$10]
                fld     tbyte[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $02
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
        @045_0: lea     esi, [esi-$10]
                mov     edx, [eax+$04]
                mov     eax, [eax+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @046: { load    real [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_real:
                cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esi, [esi-$10]
                fld     tbyte[eax+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @047: { load    object [esp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadESP
        @load_object:
                mov     edx, [eax+$0c]
                cmp     edx, STACKITEM_OBJECT
                je      @047_0
                cmp     edx, STACKITEM_OVERFLOW
                jne     @@OF
        @047_0: mov     edx, [eax+$00]
                mov     eax, [ourSelf]
                call    addref
                lea     esi, [esi-$10]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @048: { store   [esp+$jjii0] }
                call    @checkOperand
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @049: { store   [esp+$lkkjjii0] }
                call    @checkOperand
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                mov     eax, [edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @04a: { store   int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @04b: { store   long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @04c: { store   float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @04d: { store   double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @04e: { store   real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @04f: { store   object [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                movzx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreESP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @050: { add     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                add     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @051: { add     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                add     dword[esi+$10], eax
                adc     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @052: { add     float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$10]
                fld     dword[esi+$00]
                faddp   st(1), st
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @053: { add     double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$10]
                fld     qword[esi+$00]
                faddp   st(1), st
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @054: { sub     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                sub     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @055: { sub     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                sub     dword[esi+$10], eax
                sbb     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @056: { sub     float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$10]
                fld     dword[esi+$00]
                fsubp   st(1), st
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @057: { sub     double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$10]
                fld     qword[esi+$00]
                fsubp   st(1), st
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @058: { mul     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                mul     dword[esi+$00]
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @059: { mul     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$04]
                mul     dword[esi+$10]
                lea     ecx, [eax+$00]
                mov     eax, [esi+$14]
                mul     dword[esi+$00]
                lea     ecx, [ecx+eax]
                mov     eax, [esi+$10]
                mul     dword[esi+$00]
                lea     edx, [ecx+edx]
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05a: { mul     float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$10]
                fld     dword[esi+$00]
                fmulp   st(1), st
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05b: { mul     double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$10]
                fld     qword[esi+$00]
                fmulp   st(1), st
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05c: { div     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [esi+$00]
                test    ecx, ecx
                jz      @@DZ
                mov     eax, [esi+$10]
                cmp     eax, $80000000
                jne     @05c_0
                cmp     ecx, $ffffffff
                je      @05c_1
        @05c_0: cdq
                idiv    ecx
        @05c_1: mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05d: { div     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                test    edx, edx
                jnz     @05d_0
                test    eax, eax
                jz      @@DZ
        @05d_0: lea     ecx, [dat+$00]
                push    ecx
                push    edx
                push    eax
                push    dword[esi+$14]
                push    dword[esi+$10]
                call    divLong
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05e: { div     float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$10]
                fld     dword[esi+$00]
                fdivp   st(1), st
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @05f: { div     double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$10]
                fld     qword[esi+$00]
                fdivp   st(1), st
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @060: { or      int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                or      dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @061: { or      long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                or      dword[esi+$10], eax
                or      dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @062: { and     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                and     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @063: { and     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                and     dword[esi+$10], eax
                and     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @064: { xor     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                xor     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @065: { xor     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                xor     dword[esi+$10], eax
                xor     dword[esi+$14], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @066: { sar     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                sar     dword[esi+$10], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @067: { sar     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                mov     eax, [esi+$14]
                test    cl,  $20
                jz      @067_0
                sar     eax, cl
                cdq
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], edx
                jmp     @067_1
        @067_0: and     cl,  $1f
                shrd    dword[esi+$10], eax, cl
                sar     dword[esi+$14], cl
        @067_1: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @068: { sal     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                sal     dword[esi+$10], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @069: { sal     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                mov     eax, [esi+$10]
                test    cl,  $20
                jz      @069_0
                sal     eax, cl
                xor     edx, edx
                mov     dword[esi+$10], edx
                mov     dword[esi+$14], eax
                jmp     @069_1
        @069_0: and     cl,  $1f
                shld    dword[esi+$14], eax, cl
                sal     dword[esi+$10], cl
        @069_1: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06a: { shr     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                shr     dword[esi+$10], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06b: { shr     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                mov     eax, [esi+$14]
                test    cl,  $20
                jz      @06b_0
                shr     eax, cl
                xor     edx, edx
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], edx
                jmp     @06b_1
        @06b_0: and     cl,  $1f
                shrd    dword[esi+$10], eax, cl
                shr     dword[esi+$14], cl
        @06b_1: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06c: { rem     int }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [esi+$00]
                test    ecx, ecx
                jz      @@DZ
                mov     eax, [esi+$10]
                cmp     eax, $80000000
                jne     @06c_0
                cmp     ecx, $ffffffff
                jne     @06c_0
                xor     edx, edx
                jmp     @06c_1
        @06c_0: cdq
                idiv    ecx
        @06c_1: mov     dword[esi+$10], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06d: { rem     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                test    edx, edx
                jnz     @06d_0
                test    eax, eax
                jz      @@DZ
        @06d_0: lea     ecx, [esi+$10]
                push    ecx
                push    edx
                push    eax
                push    dword[esi+$14]
                push    dword[esi+$10]
                call    divLong
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06e: { rem     float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$00]
                fld     dword[esi+$10]
        @06e_0: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @06e_0
                fstp    st(1)
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @06f: { rem     double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fld     qword[esi+$10]
        @06f_0: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @06f_0
                fstp    st(1)
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @070: { add     real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$10]
                fld     tbyte[esi+$00]
                faddp   st(1), st
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @071: { sub     real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$10]
                fld     tbyte[esi+$00]
                fsubp   st(1), st
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @072: { mul     real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$10]
                fld     tbyte[esi+$00]
                fmulp   st(1), st
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @073: { div     real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$10]
                fld     tbyte[esi+$00]
                fdivp   st(1), st
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @074: { sar     int $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$01]
                sar     dword[esi+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @075: { sal     int $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$01]
                sal     dword[esi+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @076: { shr     int $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$01]
                shr     dword[esi+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @077: { rem     real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fld     tbyte[esi+$10]
        @077_0: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @077_0
                fstp    st(1)
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @078: { sar     long $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$01]
                mov     eax, [esi+$04]
                test    cl,  $20
                jz      @078_0
                sar     eax, cl
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                jmp     @078_1
        @078_0: and     cl,  $1f
                shrd    dword[esi+$00], eax, cl
                sar     dword[esi+$04], cl
        @078_1: add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @079: { sal     long $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$01]
                mov     eax, [esi+$00]
                test    cl,  $20
                jz      @079_0
                sal     eax, cl
                xor     edx, edx
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], eax
                jmp     @079_1
        @079_0: and     cl,  $1f
                shld    dword[esi+$04], eax, cl
                sal     dword[esi+$00], cl
        @079_1: add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @07a: { shr     long $xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$01]
                mov     eax, [esi+$04]
                test    cl,  $20
                jz      @07a_0
                shr     eax, cl
                xor     edx, edx
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                jmp     @07a_1
        @07a_0: and     cl,  $1f
                shrd    dword[esi+$00], eax, cl
                shr     dword[esi+$04], cl
        @07a_1: add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @07b: { neg     real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                xor     dword[esi+$08], $00008000
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @07c: { neg     int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                neg     dword[esi+$00]
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @07d: { neg     long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                neg     dword[esi+$00]
                adc     dword[esi+$04], $00
                neg     dword[esi+$04]
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @07e: { neg     float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                xor     dword[esi+$00], $80000000
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @07f: { neg     double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                xor     dword[esi+$04], $80000000
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @080: { cast    int to long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                cdq
                mov     dword[esi+$04], edx
                mov     dword[esi+$0c], STACKITEM_LONG
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @081: { cast    int to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fild    dword[esi+$00]
                fstp    dword[esi+$00]
                mov     dword[esi+$0c], STACKITEM_FLOAT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @082: { cast    int to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                fild    dword[esi+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @083: { cast    int to real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                fild    dword[esi+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @084: { cast    long to int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @085: { cast    long to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fild    qword[esi+$00]
                fstp    dword[esi+$00]
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @086: { cast    long to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fild    qword[esi+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @087: { cast    long to real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                fild    qword[esi+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @088: { cast    float to int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    toInt
                mov     dword[esi+$00], eax
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @089: { cast    float to long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    toLong
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$0c], STACKITEM_LONG
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08a: { cast    float to double }
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_FLOAT
                je      @08a_0
                cmp     eax, STACKITEM_REAL
                jne     @@OF
                cmp     byte [esi+$0a], $01
                jne     @@OF
                mov     word [esi+$0a], $02
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
        @08a_0: fld     dword[esi+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08b: { cast    float to real }
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_FLOAT
                je      @08b_0
                cmp     eax, STACKITEM_REAL
                jne     @@OF
                cmp     byte [esi+$0a], $01
                jne     @@OF
                mov     word [esi+$0a], $00
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
        @08b_0: fld     dword[esi+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08c: { cast    double to int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    toInt
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08d: { cast    double to long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    toLong
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$0c], STACKITEM_LONG
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08e: { cast    double to float }
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_DOUBLE
                je      @08e_0
                cmp     eax, STACKITEM_REAL
                jne     @@OF
                cmp     byte [esi+$0a], $02
                jne     @@OF
                mov     word [esi+$0a], $01
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
        @08e_0: mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[esi+$00]
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @08f: { cast    double to real }
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_DOUBLE
                je      @08f_0
                cmp     eax, STACKITEM_REAL
                jne     @@OF
                cmp     byte [esi+$0a], $02
                jne     @@OF
                mov     word [esi+$0a], $00
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
        @08f_0: fld     qword[esi+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @090: { cast    real to int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    toInt
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @091: { cast    real to long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    toLong
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @092: { cast    real to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[esi+$00]
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @093: { cast    real to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @094: { cast    int to byte }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, byte[esi+$00]
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @095: { cast    int to short }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[esi+$00]
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @096: { cast    int to wchar }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[esi+$00]
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @097: { cast    int to object }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    addref
                mov     dword[esi+$0c], STACKITEM_OBJECT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @098: { cast    long to byte as int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, byte[esi+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @099: { cast    long to short as int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[esi+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09a: { cast    long to wchar as int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[esi+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09b: { cast    object to int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09c: { cast    long to byte as long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, byte[esi+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09d: { cast    long to short as long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[esi+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09e: { cast    long to wchar as long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[esi+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @09f: { cast    long to int as long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a0: { eq      object null ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                test    edx, edx
                setz    al
                movzx   eax, al
                mov     dword[esi+$00], eax
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a1: { ne      object null ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                test    edx, edx
                setnz   al
                movzx   eax, al
                mov     dword[esi+$00], eax
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a2: { gt      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                setg    al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a3: { le      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                setle   al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a4: { eq      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                sete    al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a5: { ne      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                setne   al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a6: { lt      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                setl    al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a7: { ge      int 0 ? }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$00], $00
                setge   al
                movzx   eax, al
                mov     dword[esi+$00], eax
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a8: { eq      object ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     ecx, [esi+$00]
                lea     edx, [ecx+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                cmp     ecx, edx
                sete    al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0a9: { ne      object ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     ecx, [esi+$00]
                lea     edx, [ecx+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                cmp     ecx, edx
                setne   al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0aa: { gt      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                setg    al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0ab: { le      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                setle   al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0ac: { eq      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                sete    al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0ad: { ne      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                setne   al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0ae: { lt      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                setl    al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0af: { ge      int ? }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                setge   al
                movzx   eax, al
                mov     dword[esi+$10], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0b0: { jmp     ±$xx }
                movsx   eax, byte[edi+$01]
                lea     eax, [eax+$02]
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b1: { jmp     ±$jjii }
                movsx   eax, word[edi+$01]
                lea     eax, [eax+$03]
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b2: { jmp     ±$llkkjjii }
                mov     eax, [edi+$01]
                lea     eax, [eax+$05]
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b3: { jmp     $llkkjjii }
                mov     eax, [edi+$01]
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b4: { call    ±$xx }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$02]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_RETURN
                movsx   edx, byte[edi+$01]
                lea     eax, [eax+edx]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b5: { call    ±$jjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$03]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_RETURN
                movsx   edx, word[edi+$01]
                lea     eax, [eax+edx]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b6: { call    ±$llkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$05]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_RETURN
                mov     edx, [edi+$01]
                lea     eax, [eax+edx]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b7: { call    $llkkjjii }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$05]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_RETURN
                mov     eax, [edi+$01]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b8: { jmp     int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [esi+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0b9: { call    int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [ebx+offset MalikContext.regEIP]
                inc     eax
                xchg    eax, [esi+$00]
                mov     dword[esi+$0c], STACKITEM_RETURN
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0ba: { iret1 }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_IRETURN
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$10]
                call    release
                mov     eax, [esi+$00]
                mov     dl,  [esi+$08]
                and     dl,  $01
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     byte [ebx+offset MalikContext.regIF], dl
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0bb: { iret2 }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_IRETURN
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$1c]
                cmp     edx, STACKITEM_INT
                je      @0bb_0
                cmp     edx, STACKITEM_LONG
                je      @0bb_0
                cmp     edx, STACKITEM_FLOAT
                je      @0bb_0
                cmp     edx, STACKITEM_DOUBLE
                je      @0bb_0
                cmp     edx, STACKITEM_REAL
                je      @0bb_0
                cmp     edx, STACKITEM_OBJECT
                jne     @@OF
                mov     edx, [esi+$10]
                call    release
        @0bb_0: mov     edx, [esi+$20]
                call    release
                mov     eax, [esi+$00]
                mov     dl,  [esi+$08]
                and     dl,  $01
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                mov     byte [ebx+offset MalikContext.regIF], dl
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0bc: { ret }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_RETURN
                jne     @@OF
                mov     eax, [esi+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0bd: { ret     $xx }
                movzx   eax, byte[edi+$01]
                mov     dword[dat+$00], eax
                lea     eax, [eax+$01]
                call    @checkItems
                cmp     dword[esi+$0c], STACKITEM_RETURN
                jne     @@OF
                mov     eax, [esi+$00]
                mov     dword[dat+$04], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                mov     eax, [dat+$00]
                call    @checkItemTypes
                mov     eax, [ourSelf]
                lea     edx, [esi+$00]
                mov     ecx, [dat+$00]
                jecxz   @0bd_2
        @0bd_0: cmp     dword[edx+$0c], STACKITEM_OBJECT
                jne     @0bd_1
                mov     dword[dat+$0c], edx
                mov     edx, [edx+$00]
                call    release
                mov     edx, [dat+$0c]
        @0bd_1: mov     dword[edx+$0c], STACKITEM_EMPTY
                lea     edx, [edx+$10]
                loop    @0bd_0
                lea     esi, [edx+$00]
        @0bd_2: mov     eax, [dat+$04]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0be: { retval }
                call    @check2Operands
                cmp     dword[esi+$1c], STACKITEM_RETURN
                jne     @@OF
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                mov     eax, [esi+$10]
                lea     edi, [esi+$10]
                cld
                movsd
                movsd
                movsd
                movsd
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0bf: { retval  $xx }
                movzx   eax, byte[edi+$01]
                mov     dword[dat+$00], eax
                lea     eax, [eax+$02]
                call    @checkItems
                cmp     dword[esi+$1c], STACKITEM_RETURN
                jne     @@OF
                mov     eax, [esi+$10]
                mov     dword[dat+$04], eax
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                mov     dword[dat+$08], esi
                lea     esi, [esi+$20]
                mov     eax, [dat+$00]
                call    @checkItemTypes
                mov     eax, [ourSelf]
                lea     edx, [esi+$00]
                mov     ecx, [dat+$00]
                jecxz   @0bf_2
        @0bf_0: cmp     dword[edx+$0c], STACKITEM_OBJECT
                jne     @0bf_1
                mov     dword[dat+$0c], edx
                mov     edx, [edx+$00]
                call    release
                mov     edx, [dat+$0c]
        @0bf_1: mov     dword[edx+$0c], STACKITEM_EMPTY
                lea     edx, [edx+$10]
                loop    @0bf_0
        @0bf_2: lea     edx, [edx-$10]
                mov     esi, [dat+$08]
                lea     edi, [edx+$00]
                cld
                movsd
                movsd
                movsd
                movsd
                mov     eax, [dat+$04]
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], edx
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @0c0: { getfield byte as long ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                movsx   eax, byte[ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c1: { getfield short as long ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                movsx   eax, word[ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c2: { getfield int as long ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c3: { getfield long ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     edx, [ecx+$04]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c4: { getfield float ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c5: { getfield double ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     edx, [ecx+$04]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c6: { getfield real ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                fld     tbyte[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c7: { getfield object ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    addref
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c8: { getfield byte as int ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                movsx   eax, byte[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0c9: { getfield short as int ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                movsx   eax, word[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0ca: { getfield int ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0cb: { getfield wchar ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                movzx   eax, word[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0cc: { getfield float as double ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                fld     dword[ecx+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0cd: { getfield float as real ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                fld     dword[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $01
                mov     dword[esi+$0c], STACKITEM_REAL
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0ce: { getfield double as real ±$kkjjii }
                call    @checkOperand
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                fld     qword[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $02
                mov     dword[esi+$0c], STACKITEM_REAL
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0cf: { getclass }
                call    @checkOperand
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    addref
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0d0: { setfield long as byte ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     al,  [esi+$00]
                mov     byte [ecx+$00], al
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d1: { setfield long as short ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     ax,  [esi+$00]
                mov     word [ecx+$00], ax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d2: { setfield long as int ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d3: { setfield long ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                mov     dword[ecx+$00], eax
                mov     dword[ecx+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d4: { setfield float ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d5: { setfield double ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                mov     dword[ecx+$00], eax
                mov     dword[ecx+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d6: { setfield real ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                fld     tbyte[esi+$00]
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d7: { setfield object ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d8: { setfield int as byte ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     al,  [esi+$00]
                mov     byte [ecx+$00], al
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0d9: { setfield int as short ±$kkjjii }
        @0db: { setfield wchar ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     ax,  [esi+$00]
                mov     word [ecx+$00], ax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0da: { setfield int ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0dc: { setfield double as float ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0dd: { setfield real as float ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0de: { setfield real as double ±$kkjjii }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, [edi+$00]
                sar     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @0df: { setclass }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0e0: { load    [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                call    @load
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0e1: { load    [ebp+$lkkjjii0] }
                mov     eax, $01
                call    @checkTopItems
                mov     eax, [edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                call    @load
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @0e2: { load    int [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_int
                align   $04

        @0e3: { load    long [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_long
                align   $04

        @0e4: { load    float [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_float
                align   $04

        @0e5: { load    double [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_double
                align   $04

        @0e6: { load    real [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_real
                align   $04

        @0e7: { load    object [ebp+$jjii0] }
                mov     eax, $01
                call    @checkTopItems
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @load_object
                align   $04

        @0e8: { store   [ebp+$jjii0] }
                call    @checkOperand
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0e9: { store   [ebp+$lkkjjii0] }
                call    @checkOperand
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                mov     eax, [edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @0ea: { store   int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0eb: { store   long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0ec: { store   float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0ed: { store   double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0ee: { store   real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0ef: { store   object [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                movsx   eax, word[edi+$01]
                sal     eax, $04
                call    @checkStoreEBP
                call    @store
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0f0: { getrefcount }
                call    @checkOperand
                xor     eax, eax
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f1: { cmp     long }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$14]
                cmp     eax, [esi+$04]
                jl      @0f1_0
                jg      @0f1_1
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jb      @0f1_0
                ja      @0f1_1
                mov     dword[esi+$10], $00
                jmp     @0f1_2
        @0f1_0: mov     dword[esi+$10], -$01
                jmp     @0f1_2
        @0f1_1: mov     dword[esi+$10], $01
        @0f1_2: mov     dword[esi+$14], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f2: { cmpl    float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$18]
                fld     dword[esi+$00]
                fld     dword[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmplReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f3: { cmpg    float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$18]
                fld     dword[esi+$00]
                fld     dword[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmpgReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f4: { cmpl    double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$18]
                fld     qword[esi+$00]
                fld     qword[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmplReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f5: { cmpg    double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$18]
                fld     qword[esi+$00]
                fld     qword[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmpgReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f6: { cmpl    real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$18]
                fld     tbyte[esi+$00]
                fld     tbyte[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmplReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f7: { cmpg    real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$18]
                fld     tbyte[esi+$00]
                fld     tbyte[esi+$10]
                fstp    tbyte[esp+$00]
                fstp    tbyte[esp+$0c]
                call    cmpgReal
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f8: { setrefcount }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                xor     eax, eax
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0f9: { syscall $jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, [ebx+offset MalikContext.id]
                mov     dword[dat+$00], eax
                mov     dword[dat+$04], esi
                push    dword[esi+$04]
                push    dword[esi+$00]
                movzx   ecx, word[edi+$01]
                lea     edx, [ebx+$00]
                mov     eax, [ourSelf]
                call    syscall
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                test    byte [eax+offset terminated], true
                jnz     @exit
                mov     eax, [eax+offset contexts]
                mov     edx, [dat+$00]
                mov     edx, [eax+edx*4]
                test    edx, edx
                jnz     @0f9_0
                mov     ebx, [eax+$00]
                mov     eax, [ebx+offset MalikContext.priority]
                mov     dword[ebx+offset MalikContext.priorityCount], eax
                jmp     @mloop
        @0f9_0: lea     ebx, [edx+$00]
                mov     esi, [dat+$04]
                mov     eax, [dat+$08]
                mov     edx, [dat+$0c]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0fa: { interrupt object $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                movzx   eax, byte[edi+$01]
                call    @getInterruptDescriptor
                lea     edi, [esi-$10]
                cld
                movsd
                movsd
                movsd
                movsd
                lea     esi, [esi-$30]
                movzx   ecx, byte[ebx+offset MalikContext.regIF]
                mov     edx, [ebx+offset MalikContext.regEIP]
                lea     edx, [edx+$02]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], ecx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [eax+$00]
                mov     edx, [eax+$04]
                mov     eax, [ourSelf]
                call    addref
                mov     dword[esi+$20], edx
                mov     dword[esi+$24], $00
                mov     dword[esi+$28], $00
                mov     dword[esi+$2c], STACKITEM_OBJECT
                mov     byte [ebx+offset MalikContext.regIF], $00
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @0fb: { enter   $jjii }
                movzx   eax, word[edi+$01]
                mov     dword[dat+$00], eax
                lea     eax, [eax+$01]
                call    @checkTopItems
                mov     eax, [ourSelf]
                lea     edx, [ebx+$00]
                call    readEBP
                lea     esi, [esi-$10]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OLDEBP
                mov     dword[ebx+offset MalikContext.stackBlock], esi
                mov     eax, [dat+$00]
                sal     eax, $04
                sub     esi, eax
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @0fc: { leave }
                xor     eax, eax
                call    @checkLoadEBP
                cmp     dword[eax+$0c], STACKITEM_OLDEBP
                jne     @@SF
                lea     ecx, [eax+$00]
                mov     eax, [ourSelf]
        @0fc_0: cmp     esi, ecx
                jae     @0fc_3
                mov     edx, [esi+$0c]
                cmp     edx, STACKITEM_OBJECT
                je      @0fc_1
                cmp     edx, STACKITEM_OVERFLOW
                jne     @0fc_2
        @0fc_1: mov     edx, [esi+$00]
                call    release
        @0fc_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                jmp     @0fc_0
        @0fc_3: mov     edx, [esi+$00]
                lea     ecx, [ebx+$00]
                call    writeEBP
                mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0fd: { leaveval }
                mov     eax, $01
                call    @checkItems
                mov     eax, [esi+$0c]
                call    @isValue
                test    dl,  dl
                jz      @@OF
                xor     eax, eax
                call    @checkLoadEBP
                cmp     dword[eax+$0c], STACKITEM_OLDEBP
                jne     @@SF
                lea     edi, [esi+$00]
                lea     esi, [esi+$10]
                lea     ecx, [eax+$00]
                mov     eax, [ourSelf]
        @0fd_0: cmp     esi, ecx
                jae     @0fd_3
                mov     edx, [esi+$0c]
                cmp     edx, STACKITEM_OBJECT
                je      @0fd_1
                cmp     edx, STACKITEM_OVERFLOW
                jne     @0fd_2
        @0fd_1: mov     edx, [esi+$00]
                call    release
        @0fd_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                lea     esi, [esi+$10]
                jmp     @0fd_0
        @0fd_3: mov     edx, [esi+$00]
                lea     ecx, [ebx+$00]
                call    writeEBP
                xchg    esi, edi
                cld
                movsd
                movsd
                movsd
                movsd
                lea     edi, [edi-$10]
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], edi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0fe: { currthrd int }
                mov     eax, $01
                call    @checkTopItems
                lea     esi, [esi-$10]
                mov     eax, [ebx+offset MalikContext.id]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                inc     dword[ebx+offset MalikContext.regEIP]
                jmp     @next
                align   $04

        @0ff: { <prefix> }
                sal     eax, $08
                mov     al,  [edi+$01]
                jmp     dword[@1IT+eax*4-$0003fc00]
                align   $04

        @100: { getarraycell byte as long }
                call    @check2Operands
                mov     eax, $01
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                movsx   eax, byte[ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @101: { getarraycell short as long }
                call    @check2Operands
                mov     eax, $02
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                movsx   eax, word[ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @102: { getarraycell int as long }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                mov     eax, [ecx+$00]
                cdq
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @103: { getarraycell long }
                call    @check2Operands
                mov     eax, $08
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                mov     eax, [ecx+$00]
                mov     edx, [ecx+$04]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @104: { getarraycell float }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_FLOAT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @105: { getarraycell double }
                call    @check2Operands
                mov     eax, $08
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                mov     eax, [ecx+$00]
                mov     edx, [ecx+$04]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @106: { getarraycell real }
                call    @check2Operands
                mov     eax, $0a
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                fld     tbyte[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $00
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @107: { getarraycell object }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    addref
                lea     esi, [esi+$10]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @108: { getarraycell byte as int }
                call    @check2Operands
                mov     eax, $01
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                movsx   eax, byte[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @109: { getarraycell short as int }
                call    @check2Operands
                mov     eax, $02
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                movsx   eax, word[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10a: { getarraycell int }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10b: { getarraycell wchar }
                call    @check2Operands
                mov     eax, $02
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                movzx   eax, word[ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10c: { getarraycell float as double }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                fld     dword[ecx+$00]
                fstp    qword[esi+$00]
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_DOUBLE
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10d: { getarraycell float as real }
                call    @check2Operands
                mov     eax, $04
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                fld     dword[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $01
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10e: { getarraycell double as real }
                call    @check2Operands
                mov     eax, $08
                lea     edx, [esi+$00]
                call    @checkCell
                lea     esi, [esi+$10]
                fld     qword[ecx+$00]
                fstp    tbyte[esi+$00]
                mov     word [esi+$0a], $02
                mov     dword[esi+$0c], STACKITEM_REAL
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @10f: { getarraylength }
                call    @checkOperand
                mov     eax, $08
                lea     edx, [esi+$00]
                call    @checkField
                mov     eax, [ecx+$00]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_INT
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @110: { setarraycell long as byte }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, $01
                lea     edx, [esi+$10]
                call    @checkCell
                mov     al,  [esi+$00]
                mov     byte [ecx+$00], al
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @111: { setarraycell long as short }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, $02
                lea     edx, [esi+$10]
                call    @checkCell
                mov     ax,  [esi+$00]
                mov     word [ecx+$00], ax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @112: { setarraycell long as int }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @113: { setarraycell long }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                mov     eax, $08
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                mov     dword[ecx+$00], eax
                mov     dword[ecx+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @114: { setarraycell float }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @115: { setarraycell double }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, $08
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                mov     dword[ecx+$00], eax
                mov     dword[ecx+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @116: { setarraycell real }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, $0a
                lea     edx, [esi+$10]
                call    @checkCell
                fld     tbyte[esi+$00]
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @117: { setarraycell object }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @118: { setarraycell int as byte }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, $01
                lea     edx, [esi+$10]
                call    @checkCell
                mov     al,  [esi+$00]
                mov     byte [ecx+$00], al
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @119: { setarraycell int as short }
        @11b: { setarraycell wchar }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, $02
                lea     edx, [esi+$10]
                call    @checkCell
                mov     ax,  [esi+$00]
                mov     word [ecx+$00], ax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @11a: { setarraycell int }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @11c: { setarraycell double as float }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @11d: { setarraycell real as float }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, $04
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @11e: { setarraycell real as double }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, $08
                lea     edx, [esi+$10]
                call    @checkCell
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $30
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @11f: { setarraylength }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     eax, $08
                lea     edx, [esi+$10]
                call    @checkField
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @120: { je      object null ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                test    edx, edx
                jnz     @120_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @120_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @121: { jne     object null ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                test    edx, edx
                jz      @121_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @121_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @122: { jg      int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                jng     @122_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @122_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @123: { jle     int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                jnle    @123_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @123_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @124: { je      int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                jne     @124_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @124_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @125: { jne     int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                je      @125_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @125_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @126: { jl      int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                jnl     @126_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @126_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @127: { jge     int 0 ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                cmp     dword[esi+$00], $00
                jnge    @127_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @127_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @128: { je      object ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jne     @128_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @128_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @129: { jne     object ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                je      @129_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @129_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12a: { jg      int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jng     @12a_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12a_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12b: { jle     int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnle    @12b_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12b_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12c: { je      int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jne     @12c_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12c_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12d: { jne     int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                je      @12d_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12d_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12e: { jl      int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnl     @12e_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12e_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @12f: { jge     int ±$xx }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$03]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnge    @12f_0
                movsx   eax, byte[edi+$02]
                lea     ecx, [ecx+eax]
        @12f_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @130: { je      object null ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                test    edx, edx
                jnz     @130_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @130_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @131: { jne     object null ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                test    edx, edx
                jz      @131_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @131_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @132: { jg      int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                jng     @132_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @132_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @133: { jle     int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                jnle    @133_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @133_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @134: { je      int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                jne     @134_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @134_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @135: { jne     int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                je      @135_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @135_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @136: { jl      int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                jnl     @136_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @136_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @137: { jge     int 0 ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                cmp     dword[esi+$00], $00
                jnge    @137_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @137_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @138: { je      object ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jne     @138_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @138_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @139: { jne     object ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                je      @139_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @139_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13a: { jg      int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jng     @13a_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13a_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13b: { jle     int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnle    @13b_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13b_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13c: { je      int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jne     @13c_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13c_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13d: { jne     int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                je      @13d_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13d_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13e: { jl      int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnl     @13e_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13e_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @13f: { jge     int ±$jjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$04]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnge    @13f_0
                movsx   eax, word[edi+$02]
                lea     ecx, [ecx+eax]
        @13f_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @140: { je      object null ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                test    edx, edx
                jnz     @140_0
                add     ecx, [edi+$02]
        @140_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @141: { jne     object null ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                test    edx, edx
                jz      @141_0
                add     ecx, [edi+$02]
        @141_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @142: { jg      int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                jng     @142_0
                add     ecx, [edi+$02]
        @142_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @143: { jle     int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                jnle    @143_0
                add     ecx, [edi+$02]
        @143_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @144: { je      int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                jne     @144_0
                add     ecx, [edi+$02]
        @144_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @145: { jne     int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                je      @145_0
                add     ecx, [edi+$02]
        @145_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @146: { jl      int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                jnl     @146_0
                add     ecx, [edi+$02]
        @146_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @147: { jge     int 0 ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                cmp     dword[esi+$00], $00
                jnge    @147_0
                add     ecx, [edi+$02]
        @147_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @148: { je      object ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$00]
                cmp     eax, [esi+$10]
                jne     @148_0
                add     ecx, [edi+$02]
        @148_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @149: { jne     object ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$10]
                call    release
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$00]
                cmp     eax, [esi+$10]
                je      @149_0
                add     ecx, [edi+$02]
        @149_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14a: { jg      int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jng     @14a_0
                add     ecx, [edi+$02]
        @14a_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14b: { jle     int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnle    @14b_0
                add     ecx, [edi+$02]
        @14b_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14c: { je      int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jne     @14c_0
                add     ecx, [edi+$02]
        @14c_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14d: { jne     int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                je      @14d_0
                add     ecx, [edi+$02]
        @14d_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14e: { jl      int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnl     @14e_0
                add     ecx, [edi+$02]
        @14e_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @14f: { jge     int ±$llkkjjii }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [ebx+offset MalikContext.regEIP]
                lea     ecx, [ecx+$06]
                mov     eax, [esi+$10]
                cmp     eax, [esi+$00]
                jnge    @14f_0
                add     ecx, [edi+$02]
        @14f_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @150: { interrupt $xx }
                mov     eax, $02
                call    @checkTopItems
                movzx   eax, byte[edi+$02]
                call    @getInterruptDescriptor
                lea     esi, [esi-$20]
                movzx   ecx, byte[ebx+offset MalikContext.regIF]
                mov     edx, [ebx+offset MalikContext.regEIP]
                lea     edx, [edx+$03]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], ecx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [eax+$00]
                mov     edx, [eax+$04]
                mov     eax, [ourSelf]
                call    addref
                mov     dword[esi+$10], edx
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_OBJECT
                mov     byte [ebx+offset MalikContext.regIF], $00
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04

        @151: { interrupt int $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                jmp     @interruptType
                align   $04

        @152: { interrupt long $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                jmp     @interruptType
                align   $04

        @153: { interrupt float $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                jmp     @interruptType
                align   $04

        @154: { interrupt double $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                jmp     @interruptType
                align   $04

        @155: { interrupt real $xx }
                mov     eax, $02
                call    @checkTopItems
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                jmp     @interruptType
                align   $04

        @156: { check   arraybound }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [esi+$10]
                mov     edx, [esi+$00]
                call    @checkMemory
                cmp     edx, $00
                jl      @@AF
                cmp     edx, [eax+$08]
                jge     @@AF
                dec     dword[eax+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @157: { runexcept object }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                lea     edi, [esi+$00]
                mov     eax, [ourSelf]
        @157_0: lea     esi, [esi+$10]
                cmp     esi, [ebx+offset MalikContext.stackEnd]
                jb      @157_1
                mov     edx, [edi+$00]
                mov     dword[edi+$0c], $00
                jmp     @@UE
        @157_1: mov     edx, [esi+$0c]
                cmp     edx, STACKITEM_EXCEPT
                je      @157_4
                cmp     edx, STACKITEM_OVERFLOW
                je      @157_3
                cmp     edx, STACKITEM_OBJECT
                jne     @157_2
                mov     edx, [esi+$00]
                call    release
        @157_2: mov     dword[esi+$0c], $00
                jmp     @157_0
        @157_3: mov     edx, [esi+$00]
                call    release
                mov     dword[esi+$00], $00
                jmp     @157_0
        @157_4: mov     eax, [ourSelf]
                mov     edx, [esi+$04]
                lea     ecx, [ebx+$00]
                call    writeEBP
                mov     eax, [esi+$00]
                mov     dl,  [esi+$08]
                and     dl,  $01
                mov     ecx, [edi+$00]
                mov     dword[edi+$0c], $00
                mov     dword[esi+$00], ecx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_OBJECT
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     byte [ebx+offset MalikContext.regIF], dl
                mov     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @158: { tableswitch byte }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, byte[edi+$03]
                movsx   edx, byte[edi+$02]
                sub     eax, edx
                jl      @@UO
                cmp     eax, $00ff
                jg      @@UO
                lea     eax, [eax*4+$0b]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @158_0
                mov     eax, [esi+$00]
                cdq
                jmp     @158_1
        @158_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @158_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                movsx   eax, byte[edi+$02]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @158_2
                movsx   eax, byte[edi+$03]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @158_2
                mov     eax, [dat+$00]
                movsx   edx, byte[edi+$02]
                sub     eax, edx
                mov     eax, [edi+eax*4+$08]
                jmp     @158_3
        @158_2: mov     eax, [edi+$04]
        @158_3: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @159: { tableswitch short }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, word[edi+$04]
                movsx   edx, word[edi+$02]
                sub     eax, edx
                jl      @@UO
                cmp     eax, $3ffc
                jg      @@UO
                lea     eax, [eax*4+$0d]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @159_0
                mov     eax, [esi+$00]
                cdq
                jmp     @159_1
        @159_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @159_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                movsx   eax, word[edi+$02]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @159_2
                movsx   eax, word[edi+$04]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @159_2
                mov     eax, [dat+$00]
                movsx   edx, word[edi+$02]
                sub     eax, edx
                mov     eax, [edi+eax*4+$0a]
                jmp     @159_3
        @159_2: mov     eax, [edi+$06]
        @159_3: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15a: { tableswitch int }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                mov     eax, [edi+$06]
                mov     edx, [edi+$02]
                sub     eax, edx
                jl      @@UO
                cmp     eax, $3ffb
                jg      @@UO
                lea     eax, [eax*4+$11]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15a_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15a_1
        @15a_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15a_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                mov     eax, [edi+$02]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @15a_2
                mov     eax, [edi+$06]
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @15a_2
                mov     eax, [dat+$00]
                sub     eax, [edi+$02]
                mov     eax, [edi+eax*4+$0e]
                jmp     @15a_3
        @15a_2: mov     eax, [edi+$0a]
        @15a_3: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15b: { tableswitch long }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                mov     eax, [edi+$0a]
                mov     edx, [edi+$0e]
                sub     eax, [edi+$02]
                sbb     edx, [edi+$06]
                jnz     @@UO
                cmp     eax, $3ff9
                ja      @@UO
                lea     eax, [eax*4+$19]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15b_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15b_1
        @15b_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15b_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                mov     eax, [edi+$02]
                mov     edx, [edi+$06]
                call    @cmpData0
                cmp     cl,  $00
                jg      @15b_2
                mov     eax, [edi+$0a]
                mov     edx, [edi+$0e]
                call    @cmpData0
                cmp     cl,  $00
                jl      @15b_2
                mov     eax, [dat+$00]
                sub     eax, [edi+$02]
                mov     eax, [edi+eax*4+$16]
                jmp     @15b_3
        @15b_2: mov     eax, [edi+$12]
        @15b_3: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15c: { lookupswitch byte }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, word[edi+$02]
                cmp     eax, $00
                jl      @@UO
                cmp     eax, $0100
                jg      @@UO
                lea     eax, [eax+eax*4+$07]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15c_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15c_1
        @15c_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15c_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                mov     eax, -$80
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @15c_4
                mov     eax, $7f
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @15c_4
                movsx   ecx, word[edi+$02]
                jecxz   @15c_4
                lea     eax, [edi+$08]
        @15c_2: movsx   edx, byte[eax+$00]
                cmp     edx, [dat+$00]
                jne     @15c_3
                mov     eax, [eax+$01]
                jmp     @15c_5
        @15c_3: lea     eax, [eax+$05]
                loop    @15c_2
        @15c_4: mov     eax, [edi+$04]
        @15c_5: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15d: { lookupswitch short }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, word[edi+$02]
                cmp     eax, $00
                jl      @@UO
                cmp     eax, $2aa9
                jg      @@UO
                lea     eax, [eax+eax]
                lea     eax, [eax+eax*2+$07]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15d_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15d_1
        @15d_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15d_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                mov     eax, -$8000
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @15d_4
                mov     eax, $7fff
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @15d_4
                movsx   ecx, word[edi+$02]
                jecxz   @15d_4
                lea     eax, [edi+$08]
        @15d_2: movsx   edx, word[eax+$00]
                cmp     edx, [dat+$00]
                jne     @15d_3
                mov     eax, [eax+$02]
                jmp     @15d_5
        @15d_3: lea     eax, [eax+$06]
                loop    @15d_2
        @15d_4: mov     eax, [edi+$04]
        @15d_5: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15e: { lookupswitch int }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, word[edi+$02]
                cmp     eax, $00
                jl      @@UO
                cmp     eax, $1fff
                jg      @@UO
                lea     eax, [eax*8+$07]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15e_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15e_1
        @15e_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15e_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                mov     eax, MIN_INT
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jg      @15e_4
                mov     eax, MAX_INT
                cdq
                call    @cmpData0
                cmp     cl,  $00
                jl      @15e_4
                movsx   ecx, word[edi+$02]
                jecxz   @15e_4
                lea     eax, [edi+$08]
        @15e_2: mov     edx, [eax+$00]
                cmp     edx, [dat+$00]
                jne     @15e_3
                mov     eax, [eax+$04]
                jmp     @15e_5
        @15e_3: lea     eax, [eax+$08]
                loop    @15e_2
        @15e_4: mov     eax, [edi+$04]
        @15e_5: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @15f: { lookupswitch long }
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEIP]
                call    getRegionIndex
                lea     ecx, [eax+$00]
                movsx   eax, word[edi+$02]
                cmp     eax, $00
                jl      @@UO
                cmp     eax, $1554
                jg      @@UO
                lea     eax, [eax*4]
                lea     eax, [eax+eax*2+$07]
                lea     edx, [eax+$00]
                add     edx, [ebx+offset MalikContext.regEIP]
                lea     eax, [eax+$01]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, ecx
                jne     @@UO
                call    @checkOperand
                mov     eax, [esi+$0c]
                cmp     eax, STACKITEM_INT
                jne     @15f_0
                mov     eax, [esi+$00]
                cdq
                jmp     @15f_1
        @15f_0: cmp     eax, STACKITEM_LONG
                jne     @@OF
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @15f_1: mov     dword[dat+$00], eax
                mov     dword[dat+$04], edx
                movsx   ecx, word[edi+$02]
                jecxz   @15f_4
                lea     eax, [edi+$08]
        @15f_2: mov     edx, [eax+$00]
                cmp     edx, [dat+$00]
                jne     @15f_3
                mov     edx, [eax+$04]
                cmp     edx, [dat+$04]
                jne     @15f_3
                mov     eax, [eax+$08]
                jmp     @15f_5
        @15f_3: lea     eax, [eax+$0c]
                loop    @15f_2
        @15f_4: mov     eax, [edi+$04]
        @15f_5: add     eax, [dat+$08]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04

        @160: { int     float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     dword[esi+$00]
                frndint
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @161: { frac    float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     dword[esi+$00]
                fld     st
                frndint
                fsubp   st(1), st
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @162: { sqrt    float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$00]
                fsqrt
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @163: { atan    float }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$10]
                fld     dword[esi+$00]
                fpatan
                fstp    dword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @164: { sin     float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    sin
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @165: { cos     float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    cos
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @166: { pow2    float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    pow2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @167: { log2    float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     dword[esi+$00]
                fstp    tbyte[esp+$00]
                call    log2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @168: { int     double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     qword[esi+$00]
                frndint
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @169: { frac    double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     qword[esi+$00]
                fld     st
                frndint
                fsubp   st(1), st
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16a: { sqrt    double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fsqrt
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16b: { atan    double }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$10]
                fld     qword[esi+$00]
                fpatan
                fstp    qword[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16c: { sin     double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    sin
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16d: { cos     double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    cos
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16e: { pow2    double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    pow2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @16f: { log2    double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    log2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @170: { int     real }
        @1bc: { roundtz real to integer }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     tbyte[esi+$00]
                frndint
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @171: { frac    real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     tbyte[esi+$00]
                fld     st
                frndint
                fsubp   st(1), st
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @172: { sqrt    real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fsqrt
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @173: { atan    real }
                call    @check2Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$10]
                fld     tbyte[esi+$00]
                fpatan
                fstp    tbyte[esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @174: { sin     real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    sin
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @175: { cos     real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    cos
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @176: { pow2    real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    pow2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @177: { log2    real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    log2
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @178: { floor   float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     dword[esi+$00]
                frndint
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @179: { ceil    float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     dword[esi+$00]
                frndint
                fstp    dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17a: { floor   double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     qword[esi+$00]
                frndint
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17b: { ceil    double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     qword[esi+$00]
                frndint
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17c: { floor   real }
        @1b4: { roundtni real to integer }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     tbyte[esi+$00]
                frndint
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17d: { ceil    real }
        @1b8: { roundtpi real to integer }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     tbyte[esi+$00]
                frndint
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17e: { round   double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     qword[esi+$00]
                fstp    tbyte[esp+$00]
                call    round
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @17f: { round   real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                lea     esp, [esp-$0c]
                fld     tbyte[esi+$00]
                fstp    tbyte[esp+$00]
                call    round
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], edx
                mov     dword[esi+$08], $00
                mov     dword[esi+$0c], STACKITEM_LONG
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @180: { add     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @180_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [esi+$00]
                add     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @181: { add     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @181_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                add     dword[edi+$00], eax
                adc     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @182: { add     float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @182_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[ecx+$00]
                fld     dword[esi+$00]
                faddp   st(1), st
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @183: { add     double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @183_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[ecx+$00]
                fld     qword[esi+$00]
                faddp   st(1), st
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @184: { sub     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @184_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [esi+$00]
                sub     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @185: { sub     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @185_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                sub     dword[edi+$00], eax
                sbb     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @186: { sub     float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @186_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[ecx+$00]
                fld     dword[esi+$00]
                fsubp   st(1), st
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @187: { sub     double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @187_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[ecx+$00]
                fld     qword[esi+$00]
                fsubp   st(1), st
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @188: { mul     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @188_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [ecx+$00]
                imul    eax, [esi+$00]
                mov     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @189: { mul     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @189_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [edi+$00]
                mul     dword[esi+$04]
                lea     ecx, [eax+$00]
                mov     eax, [edi+$04]
                mul     dword[esi+$00]
                lea     ecx, [ecx+eax]
                mov     eax, [edi+$00]
                mul     dword[esi+$00]
                lea     edx, [ecx+edx]
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18a: { mul     float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18a_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[ecx+$00]
                fld     dword[esi+$00]
                fmulp   st(1), st
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18b: { mul     double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18b_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[ecx+$00]
                fld     qword[esi+$00]
                fmulp   st(1), st
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18c: { div     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18c_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     edi, [eax+$00]
                mov     ecx, [esi+$00]
                test    ecx, ecx
                jz      @@DZ
                mov     eax, [edi+$00]
                cmp     eax, $80000000
                jne     @18c_1
                cmp     ecx, $ffffffff
                je      @18c_2
        @18c_1: cdq
                idiv    ecx
        @18c_2: mov     dword[edi+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18d: { div     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18d_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                test    edx, edx
                jne     @18d_1
                test    eax, eax
                je      @@DZ
        @18d_1: lea     ecx, [dat+$00]
                push    ecx
                push    edx
                push    eax
                push    dword[edi+$04]
                push    dword[edi+$00]
                call    divLong
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18e: { div     float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18e_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[ecx+$00]
                fld     dword[esi+$00]
                fdivp   st(1), st
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @18f: { div     double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @18f_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[ecx+$00]
                fld     qword[esi+$00]
                fdivp   st(1), st
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @190: { or      int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @190_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [esi+$00]
                or      dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @191: { or      long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @191_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                or      dword[edi+$00], eax
                or      dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @192: { and     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @192_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [esi+$00]
                and     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @193: { and     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @193_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                and     dword[edi+$00], eax
                and     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @194: { xor     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @194_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, [esi+$00]
                xor     dword[ecx+$00], eax
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @195: { xor     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @195_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                xor     dword[edi+$00], eax
                xor     dword[edi+$04], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @196: { sar     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @196_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                sar     dword[eax+$00], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @197: { sar     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @197_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                lea     edi, [eax+$00]
                mov     eax, [edi+$04]
                test    cl,  $20
                jz      @197_1
                sar     eax, cl
                cdq
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                jmp     @197_2
        @197_1: and     cl,  $1f
                shrd    dword[edi+$00], eax, cl
                sar     dword[edi+$04], cl
        @197_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @198: { sal     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @198_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                sal     dword[eax+$00], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @199: { sal     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @199_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                lea     edi, [eax+$00]
                mov     eax, [edi+$00]
                test    cl,  $20
                jz      @199_1
                sal     eax, cl
                xor     edx, edx
                mov     dword[edi+$00], edx
                mov     dword[edi+$04], eax
                jmp     @199_2
        @199_1: and     cl,  $1f
                shld    dword[edi+$04], eax, cl
                sal     dword[edi+$00], cl
        @199_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19a: { shr     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19a_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [esi+$00]
                shr     dword[eax+$00], cl
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19b: { shr     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19b_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [esi+$00]
                lea     edi, [eax+$00]
                mov     eax, [edi+$04]
                test    cl,  $20
                jz      @19b_1
                shr     eax, cl
                xor     edx, edx
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                jmp     @19b_2
        @19b_1: and     cl,  $1f
                shrd    dword[edi+$00], eax, cl
                shr     dword[edi+$04], cl
        @19b_2: mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19c: { rem     int [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19c_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                lea     edi, [eax+$00]
                mov     ecx, [esi+$00]
                test    ecx, ecx
                jz      @@DZ
                mov     eax, [edi+$00]
                cmp     eax, $80000000
                jne     @19c_1
                cmp     ecx, $ffffffff
                jne     @19c_1
                xor     edx, edx
                jmp     @19c_2
        @19c_1: cdq
                idiv    ecx
        @19c_2: mov     dword[edi+$00], edx
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19d: { rem     long [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19d_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                test    edx, edx
                jne     @19d_1
                test    eax, eax
                je      @@DZ
        @19d_1: push    edi
                push    edx
                push    eax
                push    dword[edi+$04]
                push    dword[edi+$00]
                call    divLong
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19e: { rem     float [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19e_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     dword[esi+$00]
                fld     dword[ecx+$00]
        @19e_1: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @19e_1
                fstp    st(1)
                fstp    dword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @19f: { rem     double [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @19f_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fld     qword[ecx+$00]
        @19f_1: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @19f_1
                fstp    st(1)
                fstp    qword[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a0: { add     real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @1a0_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[ecx+$00]
                fld     tbyte[esi+$00]
                faddp   st(1), st
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a1: { sub     real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @1a1_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[ecx+$00]
                fld     tbyte[esi+$00]
                fsubp   st(1), st
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a2: { mul     real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @1a2_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[ecx+$00]
                fld     tbyte[esi+$00]
                fmulp   st(1), st
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a3: { div     real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @1a3_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[ecx+$00]
                fld     tbyte[esi+$00]
                fdivp   st(1), st
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a4: { sar     int [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1a4_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$04]
                sar     dword[eax+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1a5: { sal     int [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1a5_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$04]
                sal     dword[eax+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1a6: { shr     int [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1a6_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                mov     cl,  [edi+$04]
                shr     dword[eax+$00], cl
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1a7: { rem     real [esp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreESP
        @1a7_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                lea     ecx, [eax+$00]
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fld     tbyte[ecx+$00]
        @1a7_1: fprem
                fstsw   ax
                test    eax, $0400
                jnz     @1a7_1
                fstp    st(1)
                fstp    tbyte[ecx+$00]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $10
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1a8: { sar     long [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1a8_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$04]
                lea     edi, [eax+$00]
                mov     eax, [edi+$04]
                test    cl,  $20
                jz      @1a8_1
                sar     eax, cl
                cdq
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                jmp     @1a8_2
        @1a8_1: and     cl,  $1f
                shrd    dword[edi+$00], eax, cl
                sar     dword[edi+$04], cl
        @1a8_2: add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1a9: { sal     long [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1a9_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$04]
                lea     edi, [eax+$00]
                mov     eax, [edi+$00]
                test    cl,  $20
                jz      @1a9_1
                sal     eax, cl
                xor     edx, edx
                mov     dword[edi+$00], edx
                mov     dword[edi+$04], eax
                jmp     @1a9_2
        @1a9_1: and     cl,  $1f
                shld    dword[edi+$04], eax, cl
                sal     dword[edi+$00], cl
        @1a9_2: add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1aa: { shr     long [esp+$jjii0], $xx }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1aa_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                mov     cl,  [edi+$04]
                lea     edi, [eax+$00]
                mov     eax, [edi+$04]
                test    cl,  $20
                jz      @1aa_1
                shr     eax, cl
                xor     edx, edx
                mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                jmp     @1aa_2
        @1aa_1: and     cl,  $1f
                shrd    dword[edi+$00], eax, cl
                shr     dword[edi+$04], cl
        @1aa_2: add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @1ab: { neg     real [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1ab_0: cmp     dword[eax+$0c], STACKITEM_REAL
                jne     @@OF
                xor     dword[eax+$08], $00008000
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1ac: { neg     int [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1ac_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                neg     dword[eax+$00]
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1ad: { neg     long [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1ad_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                neg     dword[eax+$00]
                adc     dword[eax+$04], $00
                neg     dword[eax+$04]
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1ae: { neg     float [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1ae_0: cmp     dword[eax+$0c], STACKITEM_FLOAT
                jne     @@OF
                xor     dword[eax+$00], $80000000
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1af: { neg     double [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1af_0: cmp     dword[eax+$0c], STACKITEM_DOUBLE
                jne     @@OF
                xor     dword[eax+$04], $80000000
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1b0: { roundtn real to integer }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                frndint
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b1: { roundtn real to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[dat+$00]
                fld     qword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b2: { roundtn real to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b3: { roundtn double to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TO_NEAREST
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b5: { roundtni real to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[dat+$00]
                fld     qword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b6: { roundtni real to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b7: { roundtni double to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_DOWN
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1b9: { roundtpi real to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[dat+$00]
                fld     qword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1ba: { roundtpi real to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1bb: { roundtpi double to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_UP
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1bd: { roundtz real to double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    qword[dat+$00]
                fld     qword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1be: { roundtz real to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     tbyte[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    tbyte[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1bf: { roundtz double to float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                mov     eax, ROUND_TOWARD_ZERO
                call    setRoundMode
                fld     qword[esi+$00]
                fstp    dword[dat+$00]
                fld     dword[dat+$00]
                fstp    qword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1c0: { add     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @180_0
                align   $04

        @1c1: { add     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @181_0
                align   $04

        @1c2: { add     float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @182_0
                align   $04

        @1c3: { add     double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @183_0
                align   $04

        @1c4: { sub     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @184_0
                align   $04

        @1c5: { sub     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @185_0
                align   $04

        @1c6: { sub     float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @186_0
                align   $04

        @1c7: { sub     double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @187_0
                align   $04

        @1c8: { mul     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @188_0
                align   $04

        @1c9: { mul     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @189_0
                align   $04

        @1ca: { mul     float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18a_0
                align   $04

        @1cb: { mul     double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18b_0
                align   $04

        @1cc: { div     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18c_0
                align   $04

        @1cd: { div     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18d_0
                align   $04

        @1ce: { div     float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18e_0
                align   $04

        @1cf: { div     double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @18f_0
                align   $04

        @1d0: { or      int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @190_0
                align   $04

        @1d1: { or      long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @191_0
                align   $04

        @1d2: { and     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @192_0
                align   $04

        @1d3: { and     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @193_0
                align   $04

        @1d4: { xor     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @194_0
                align   $04

        @1d5: { xor     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @195_0
                align   $04

        @1d6: { sar     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @196_0
                align   $04

        @1d7: { sar     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @197_0
                align   $04

        @1d8: { sal     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @198_0
                align   $04

        @1d9: { sal     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @199_0
                align   $04

        @1da: { shr     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19a_0
                align   $04

        @1db: { shr     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19b_0
                align   $04

        @1dc: { rem     int [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19c_0
                align   $04

        @1dd: { rem     long [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19d_0
                align   $04

        @1de: { rem     float [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19e_0
                align   $04

        @1df: { rem     double [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @19f_0
                align   $04

        @1e0: { add     real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @1a0_0
                align   $04

        @1e1: { sub     real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @1a1_0
                align   $04

        @1e2: { mul     real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @1a2_0
                align   $04

        @1e3: { div     real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @1a3_0
                align   $04

        @1e4: { sar     int [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1a4_0
                align   $04

        @1e5: { sal     int [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1a5_0
                align   $04

        @1e6: { shr     int [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1a6_0
                align   $04

        @1e7: { rem     real [ebp+$jjii0] }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkStoreEBP
                jmp     @1a7_0
                align   $04

        @1e8: { sar     long [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1a8_0
                align   $04

        @1e9: { sal     long [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1a9_0
                align   $04

        @1ea: { shr     long [ebp+$jjii0], $xx }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1aa_0
                align   $04

        @1eb: { neg     real [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1ab_0
                align   $04

        @1ec: { neg     int [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1ac_0
                align   $04

        @1ed: { neg     long [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1ad_0
                align   $04

        @1ee: { neg     float [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1ae_0
                align   $04

        @1ef: { neg     double [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1af_0
                align   $04

        @1f0: { inc     int [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1f0_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                inc     dword[eax+$00]
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1f1: { inc     int [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1f0_0
                align   $04

        @1f2: { inc     int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                inc     dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1f3: { mkreal  real }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     byte [esi+$0a], $00
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1f4: { inc     long [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1f4_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                add     dword[eax+$00], $01
                adc     dword[eax+$04], $00
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1f5: { inc     long [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1f4_0
                align   $04

        @1f6: { inc     long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                add     dword[esi+$00], $01
                adc     dword[esi+$04], $00
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1f7: { mkreal  float }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     byte [esi+$0a], $01
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1f8: { dec     int [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1f8_0: cmp     dword[eax+$0c], STACKITEM_INT
                jne     @@OF
                dec     dword[eax+$00]
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1f9: { dec     int [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1f8_0
                align   $04

        @1fa: { dec     int }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                dec     dword[esi+$00]
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1fb: { mkreal  double }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                mov     byte [esi+$0a], $02
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1fc: { dec     long [esp+$jjii0] }
                movzx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadESP
        @1fc_0: cmp     dword[eax+$0c], STACKITEM_LONG
                jne     @@OF
                add     dword[eax+$00], -$01
                adc     dword[eax+$04], -$01
                add     dword[ebx+offset MalikContext.regEIP], $04
                jmp     @next
                align   $04

        @1fd: { dec     long [ebp+$jjii0] }
                movsx   eax, word[edi+$02]
                sal     eax, $04
                call    @checkLoadEBP
                jmp     @1fc_0
                align   $04

        @1fe: { dec     long }
                call    @checkOperand
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                add     dword[esi+$00], -$01
                adc     dword[esi+$04], -$01
                add     dword[ebx+offset MalikContext.regEIP], $02
                jmp     @next
                align   $04

        @1ff: { <prefix> }
                sal     eax, $08
                mov     al,  [edi+$02]
                cmp     al,  $40
                jae     @@UO
                jmp     dword[@2IT+eax*4-$03fffc00]
                align   $04

        @200: { arraycopyf byte }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $01
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                add     eax, [esi+$30]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                add     eax, [esi+$10]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @200_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
                rep movsb
        @200_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @201: { arraycopyf short }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $02
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @201_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
                rep movsw
        @201_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @202: { arraycopyf int }
        @204: { arraycopyf float }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @202_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
                rep movsd
        @202_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @203: { arraycopyf long }
        @205: { arraycopyf double }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*8]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*8]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @203_0
                lea     ecx, [ecx+ecx]
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
                rep movsd
        @203_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @206: { arraycopyf real }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $0a
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$30]
                lea     edx, [edx+edx*4]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$10]
                lea     edx, [edx+edx*4]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @206_0
                lea     ecx, [ecx+ecx*4]
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
                rep movsw
        @206_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @207: { arraycopyf object }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @207_1
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                cld
        @207_0: mov     edx, [esi+$00]
                call    addref
                mov     edx, [edi+$00]
                call    release
                movsd
                loop    @207_0
        @207_1: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @208: { arraycopyb byte }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $01
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                add     eax, [esi+$30]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                add     eax, [esi+$10]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @208_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$01]
                lea     edi, [edi-$01]
                std
                rep movsb
                cld
        @208_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @209: { arraycopyb short }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $02
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @209_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$02]
                lea     edi, [edi-$02]
                std
                rep movsw
                cld
        @209_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @20a: { arraycopyb int }
        @20c: { arraycopyb float }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @20a_0
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$04]
                lea     edi, [edi-$04]
                std
                rep movsd
                cld
        @20a_0: add     dword [ebx+offset MalikContext.stackTop], $50
                add     dword [ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @20b: { arraycopyb long }
        @20d: { arraycopyb double }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*8]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*8]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @20b_0
                lea     ecx, [ecx+ecx]
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$04]
                lea     edi, [edi-$04]
                std
                rep movsd
                cld
        @20b_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @20e: { arraycopyb real }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $0a
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$30]
                lea     edx, [edx+edx*4]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$10]
                lea     edx, [edx+edx*4]
                lea     eax, [eax+edx*2]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @20e_0
                lea     ecx, [ecx+ecx*4]
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$02]
                lea     edi, [edi-$02]
                std
                rep movsw
                cld
        @20e_0: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @20f: { arraycopyb object }
                call    @check5Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$4c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$40]
                mov     edx, [esi+$30]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$30]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$08], eax
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, [esi+$00]
                sub     edx, ecx
                call    @checkArray
                mov     edx, [esi+$10]
                lea     eax, [eax+edx*4]
                mov     dword[dat+$0c], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     edx, [esi+$40]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     dword[esi+$4c], STACKITEM_EMPTY
                mov     ecx, [esi+$00]
                jecxz   @20f_1
                mov     esi, [dat+$08]
                mov     edi, [dat+$0c]
                lea     esi, [esi-$04]
                lea     edi, [edi-$04]
                std
        @20f_0: mov     edx, [esi+$00]
                call    addref
                mov     edx, [edi+$00]
                call    release
                movsd
                loop    @20f_0
                cld
        @20f_1: add     dword[ebx+offset MalikContext.stackTop], $50
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @210: { arrayfindf byte }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $01
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                add     eax, [esi+$10]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     al,  [esi+$00]
                cld
                repne scasb
                jne     @210_0
                lea     edx, [edx-$01]
        @210_0: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @211: { arrayfindf short }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $02
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     ax,  [esi+$00]
                cld
                repne scasw
                jne     @211_0
                lea     edx, [edx-$01]
        @211_0: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @212: { arrayfindf int }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                cld
                repne scasd
                jne     @212_0
                lea     edx, [edx-$01]
        @212_0: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @213: { arrayfindf long }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
        @213_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @213_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                je      @213_2
        @213_1: lea     edi, [edi+$08]
                loop    @213_0
        @213_2: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @214: { arrayfindf float }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                cld
                repne scasd
                jne     @214_0
                lea     edx, [edx-$01]
        @214_0: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @215: { arrayfindf double }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
        @215_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @215_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                je      @215_2
        @215_1: lea     edi, [edi+$08]
                loop    @215_0
        @215_2: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @216: { arrayfindf real }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $0a
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+ecx*4]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
        @216_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @216_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                jne     @216_1
                mov     ax,  [esi+$08]
                cmp     ax,  [edi+$08]
                je      @216_2
        @216_1: lea     edi, [edi+$0a]
                loop    @216_0
        @216_2: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @217: { arrayfindf object }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     edx, [dat+$0c]
                lea     ecx, [edx+$00]
                sub     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                cld
                repne scasd
                jne     @217_0
                lea     edx, [edx-$01]
        @217_0: sub     edx, ecx
                mov     dword[esi+$20], edx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @218: { arrayfindb byte }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $01
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                add     eax, [esi+$10]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
                mov     al,  [esi+$00]
                std
                repne scasb
                je      @218_0
                lea     ecx, [ecx-$01]
        @218_0: cld
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @219: { arrayfindb short }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $02
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
                mov     ax,  [esi+$00]
                std
                repne scasw
                je      @219_0
                lea     ecx, [ecx-$01]
        @219_0: cld
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21a: { arrayfindb int }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                std
                repne scasd
                je      @21a_0
                lea     ecx, [ecx-$01]
        @21a_0: cld
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21b: { arrayfindb long }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
        @21b_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @21b_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                je      @21b_2
        @21b_1: lea     edi, [edi-$08]
                loop    @21b_0
        @21b_2: lea     ecx, [ecx-$01]
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21c: { arrayfindb float }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                std
                repne scasd
                je      @21c_0
                lea     ecx, [ecx-$01]
        @21c_0: cld
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21d: { arrayfindb double }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
        @21d_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @21d_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                je      @21d_2
        @21d_1: lea     edi, [edi-$08]
                loop    @21d_0
        @21d_2: lea     ecx, [ecx-$01]
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21e: { arrayfindb real }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $0a
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+ecx*4]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     dword[dat+$0c], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
        @21e_0: mov     eax, [esi+$00]
                cmp     eax, [edi+$00]
                jne     @21e_1
                mov     eax, [esi+$04]
                cmp     eax, [edi+$04]
                jne     @21e_1
                mov     ax,  [esi+$08]
                cmp     ax,  [edi+$08]
                je      @21e_2
        @21e_1: lea     edi, [edi-$0a]
                loop    @21e_0
        @21e_2: lea     ecx, [ecx-$01]
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @21f: { arrayfindb object }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     ecx, [esi+$10]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                lea     ecx, [ecx+$01]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                std
                repne scasd
                je      @21f_0
                lea     ecx, [ecx-$01]
        @21f_0: cld
                mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @220: { arrayfill byte }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $01
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                add     eax, [esi+$20]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     al,  [esi+$00]
                cld
                rep stosb
                add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @221: { arrayfill short }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $02
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     ax,  [esi+$00]
                cld
                rep stosw
                add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @222: { arrayfill int }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                cld
                rep stosd
                add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @223: { arrayfill long }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_LONG
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                jecxz   @223_1
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @223_0: mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                lea     edi, [edi+$08]
                loop    @223_0
        @223_1: add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @224: { arrayfill float }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_FLOAT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                cld
                rep stosd
                add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @225: { arrayfill double }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_DOUBLE
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*8]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                jecxz   @225_1
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
        @225_0: mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                lea     edi, [edi+$08]
                loop    @225_0
        @225_1: add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @226: { arrayfill real }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_REAL
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $0a
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     ecx, [ecx+ecx*4]
                lea     eax, [eax+ecx*2]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                jecxz   @226_1
                mov     edi, [dat+$08]
                mov     eax, [esi+$00]
                mov     edx, [esi+$04]
                mov     si,  [esi+$08]
        @226_0: mov     dword[edi+$00], eax
                mov     dword[edi+$04], edx
                mov     word [edi+$08], si
                lea     edi, [edi+$0a]
                loop    @226_0
        @226_1: add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @227: { arrayfill object }
                call    @check4Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$3c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $04
                mov     eax, [esi+$30]
                mov     edx, [esi+$20]
                mov     ecx, [esi+$10]
                call    @checkArray
                mov     ecx, [esi+$20]
                lea     eax, [eax+ecx*4]
                mov     dword[dat+$08], eax
                mov     eax, [ourSelf]
                mov     edx, [esi+$30]
                call    release
                mov     edx, [esi+$00]
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @227_0
                mov     ecx, [esi+$10]
                lea     ecx, [ecx-$01]
                add     dword[eax+$00], ecx
        @227_0: mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_EMPTY
                mov     dword[esi+$3c], STACKITEM_EMPTY
                mov     ecx, [esi+$10]
                jecxz   @227_2
                mov     edi, [dat+$08]
                mov     eax, [ourSelf]
        @227_1: mov     edx, [edi+$00]
                call    release
                mov     edx, [esi+$00]
                mov     dword[edi+$00], edx
                lea     edi, [edi+$04]
                loop    @227_1
        @227_2: add     dword[ebx+offset MalikContext.stackTop], $40
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @228: { findfreef }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                lea     edi, [eax+$00]
                mov     dword[dat+$04], edx
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                {
                        edi – desc
                        ecx – index
                        dword[esi+$00] – size
                        dword[dat+$04] – length
                        dword[dat+$08] – currentBlock
                        dword[dat+$0c] – currentSize
                        edx – nextBlock
                        dword[dat+$10] – descriptor
                }
                mov     eax, [dat+$04]
                lea     edx, [eax-$01]
                cmp     ecx, edx
                jne     @228_0
                lea     ecx, [eax+$00]
                jmp     @228_2
        @228_0: lea     eax, [edi+ecx*8]
                mov     edx, [eax+$04]
                mov     dword[dat+$10], edx
                mov     edx, [eax+$00]
                mov     dword[dat+$08], edx
                test    edx, edx
                jz      @228_2
                lea     ecx, [ecx+$01]
        @228_1: mov     eax, [dat+$10]
                mov     dword[dat+$0c], eax
                lea     eax, [edi+ecx*8]
                mov     edx, [eax+$04]
                mov     dword[dat+$10], edx
                mov     edx, [eax+$00]
                test    edx, edx
                jz      @228_2
                lea     eax, [edx+$00]
                sub     eax, [dat+$08]
                sub     eax, [dat+$0c]
                cmp     eax, [esi+$00]
                jge     @228_2
                mov     dword[dat+$08], edx
                lea     ecx, [ecx+$01]
                cmp     ecx, [dat+$04]
                jl      @228_1
        @228_2: mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @229: { findfreeb }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                lea     edi, [eax+$00]
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
                {
                        edi – desc
                        ecx – index
                        dword[esi+$00] – size
                        edx – currentBlock
                        dword[dat+$0c] – currentSize
                        dword[dat+$08] – nextBlock
                }
                test    ecx, ecx
                jnz     @229_0
                mov     ecx, -$01
                jmp     @229_3
        @229_0: lea     eax, [edi+ecx*8]
                mov     edx, [eax+$00]
                mov     dword[dat+$08], edx
                test    edx, edx
                jz      @229_3
                lea     ecx, [ecx-$01]
        @229_1: lea     eax, [edi+ecx*8]
                mov     edx, [eax+$04]
                mov     dword[dat+$0c], edx
                mov     edx, [eax+$00]
                test    edx, edx
                jz      @229_2
                mov     eax, [dat+$08]
                sub     eax, edx
                sub     eax, [dat+$0c]
                cmp     eax, [esi+$00]
                jge     @229_2
                mov     dword[dat+$08], edx
                lea     ecx, [ecx-$01]
                cmp     ecx, $00
                jge     @229_1
                jmp     @229_3
        @229_2: lea     ecx, [ecx+$01]
        @229_3: mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22a: { findzerof }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     dword[dat+$00], edx
                lea     edi, [eax+$00]
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
        @22a_0: mov     eax, [ourSelf]
                mov     edx, [edi+ecx*8]
                add     edx, [esi+$00]
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @22a_1
                mov     eax, [eax+$00]
                test    eax, eax
                jz      @22a_2
        @22a_1: lea     ecx, [ecx+$01]
                cmp     ecx, [dat+$00]
                jl      @22a_0
        @22a_2: mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22b: { findzerob }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                lea     edi, [eax+$00]
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$2c], STACKITEM_INT
                mov     ecx, [esi+$10]
        @22b_0: mov     eax, [ourSelf]
                mov     edx, [edi+ecx*8]
                add     edx, [esi+$00]
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @22b_1
                mov     eax, [eax+$00]
                test    eax, eax
                jz      @22b_2
        @22b_1: lea     ecx, [ecx-$01]
                cmp     ecx, $00
                jge     @22b_0
        @22b_2: mov     dword[esi+$20], ecx
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22c: { getobjectrefs }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [esi+$00]
                call    @checkMemory
                mov     dword[dat+$00], $04
                mov     ecx, [eax+$08]
                mov     eax, [esi+$00]
                xor     edx, edx
                call    @checkArray
                mov     dword[dat+$08], $00
                cmp     edx, $00
                jle     @22c_2
                lea     edi, [eax+$00]
                lea     ecx, [edx+$00]
                mov     edx, [esi+$20]
        @22c_0: mov     eax, [edi+ecx*4-$04]
                lea     eax, [edx+eax]
                call    @checkMemory
                mov     eax, [eax+$00]
                cmp     eax, [esi+$10]
                jne     @22c_1
                inc     dword[dat+$08]
        @22c_1: loop    @22c_0
        @22c_2: mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     eax, [dat+$08]
                mov     dword[esi+$20], eax
                mov     dword[esi+$2c], STACKITEM_INT
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22d: { getarrayrefs }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [esi+$00]
                call    @checkMemory
                mov     dword[dat+$00], $04
                mov     ecx, [eax+$08]
                mov     eax, [esi+$00]
                xor     edx, edx
                call    @checkArray
                mov     dword[dat+$08], $00
                cmp     edx, $00
                jle     @22d_2
                lea     edi, [eax+$00]
                lea     ecx, [edx+$00]
                mov     edx, [esi+$20]
        @22d_0: mov     eax, [edi+ecx*4-$04]
                lea     eax, [edx+eax]
                call    @checkMemory
                mov     eax, [eax+$00]
                cmp     eax, [esi+$10]
                jne     @22d_1
                inc     dword[dat+$08]
        @22d_1: loop    @22d_0
        @22d_2: mov     eax, [esi+$20]
                call    @checkMemory
                mov     dword[dat+$00], $04
                mov     ecx, [eax+$08]
                mov     eax, [esi+$20]
                xor     edx, edx
                call    @checkArray
                cmp     edx, $00
                jle     @22d_5
                lea     ecx, [edx+$00]
                lea     edi, [eax+$00]
                mov     eax, [esi+$10]
        @22d_3: cmp     dword[edi+ecx*4-$04], eax
                jne     @22d_4
                inc     dword[dat+$08]
        @22d_4: loop    @22d_3
        @22d_5: mov     eax, [ourSelf]
                mov     edx, [esi+$00]
                call    release
                mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     eax, [dat+$08]
                mov     dword[esi+$20], eax
                mov     dword[esi+$2c], STACKITEM_INT
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22e: { blockfindf }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                mov     dword[dat+$00], edx
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     ecx, [esi+$10]
        @22e_0: cmp     dword[edi+ecx*8], eax
                je      @22e_1
                lea     ecx, [ecx+$01]
                cmp     ecx, [dat+$00]
                jl      @22e_0
        @22e_1: mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$20], ecx
                mov     dword[esi+$2c], STACKITEM_INT
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @22f: { blockfindb }
                call    @check3Operands
                cmp     dword[esi+$0c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$1c], STACKITEM_INT
                jne     @@OF
                cmp     dword[esi+$2c], STACKITEM_OBJECT
                jne     @@OF
                mov     dword[dat+$00], $08
                mov     eax, [esi+$20]
                mov     edx, [esi+$10]
                mov     ecx, $01
                call    @checkArray
                lea     edi, [eax+$00]
                mov     eax, [esi+$00]
                mov     ecx, [esi+$10]
        @22f_0: cmp     dword[edi+ecx*8], eax
                je      @22f_1
                lea     ecx, [ecx-$01]
                cmp     ecx, $00
                jge     @22f_0
        @22f_1: mov     eax, [ourSelf]
                mov     edx, [esi+$20]
                call    release
                mov     dword[esi+$20], ecx
                mov     dword[esi+$2c], STACKITEM_INT
                mov     dword[esi+$1c], STACKITEM_EMPTY
                mov     dword[esi+$0c], STACKITEM_EMPTY
                add     dword[ebx+offset MalikContext.stackTop], $20
                add     dword[ebx+offset MalikContext.regEIP], $03
                jmp     @next
                align   $04

        @230: { check   object null [esp+$jjii0] }
                movzx   eax, word[edi+$03]
                sal     eax, $04
                call    @checkLoadESP
                cmp     dword[eax+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [eax+$00]
                call    @checkMemory
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @231: { check   object null [ebp+$jjii0] }
                movsx   eax, word[edi+$03]
                sal     eax, $04
                call    @checkLoadEBP
                cmp     dword[eax+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [eax+$00]
                call    @checkMemory
                add     dword[ebx+offset MalikContext.regEIP], $05
                jmp     @next
                align   $04

        @232: { jmponce ±$xx }
                movsx   eax, byte[edi+$03]
                mov     byte [edi+$03], $00
                lea     eax, [eax+$04]
                add     dword[ebx+offset MalikContext.regEIP], eax
                jmp     @next
                align   $04


                (*** ОБЩИЕ ЧАСТИ КОМАНД ***)

        @interruptType:
                movzx   eax, byte[edi+$02]
                call    @getInterruptDescriptor
                lea     edi, [esi-$10]
                cld
                movsd
                movsd
                movsd
                movsd
                lea     esi, [esi-$30]
                mov     ecx, [ebx+offset MalikContext.regIF]
                mov     edx, [ebx+offset MalikContext.regEIP]
                lea     edx, [edx+$03]
                mov     dword[esi+$00], edx
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], ecx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [eax+$00]
                mov     edx, [eax+$04]
                mov     eax, [ourSelf]
                call    addref
                mov     dword[esi+$20], edx
                mov     dword[esi+$24], $00
                mov     dword[esi+$28], $00
                mov     dword[esi+$2c], STACKITEM_OBJECT
                mov     byte [ebx+offset MalikContext.regIF], $00
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], ecx
                jmp     @next
                align   $04


                (*** ВСПОМОГАТЕЛЬНЫЕ ФУНКЦИИ ***)

        @checkOperand:
                mov     edx, [ebx+offset MalikContext.stackEnd]
                lea     edx, [edx-$10]
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @check2Operands:
                mov     edx, [ebx+offset MalikContext.stackEnd]
                lea     edx, [edx-$20]
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @check3Operands:
                mov     edx, [ebx+offset MalikContext.stackEnd]
                lea     edx, [edx-$30]
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @check4Operands:
                mov     edx, [ebx+offset MalikContext.stackEnd]
                lea     edx, [edx-$40]
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @check5Operands:
                mov     edx, [ebx+offset MalikContext.stackEnd]
                lea     edx, [edx-$50]
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @checkItems:
                {
                Вход:   eax – минимальное количество элементов на вершине стака
                }
                sal     eax, $04
                mov     edx, [ebx+offset MalikContext.stackEnd]
                sub     edx, eax
                cmp     esi, edx
                ja      @@OF
                ret
                align   $04

        @checkTopItems:
                {
                Вход:   eax – количество свободных элементов выше вершины стака
                }
                call    @isTopItems
                jmp     dword[@CTI_0+eax*4]
                align   $04
        @CTI_0: dd      @CTI_1, @destroyCtx, @@SO, $cccccccc
        @CTI_1: ret
                align   $04

        @checkItemTypes:
                {
                Вход:   eax – количество элементов на стаке
                }
                lea     ecx, [eax+$00]
                jecxz   @CIT_2
                sal     eax, $04
        @CIT_0: mov     edx, [esi+eax-$04]
                cmp     edx, STACKITEM_INT
                je      @CIT_1
                cmp     edx, STACKITEM_LONG
                je      @CIT_1
                cmp     edx, STACKITEM_FLOAT
                je      @CIT_1
                cmp     edx, STACKITEM_DOUBLE
                je      @CIT_1
                cmp     edx, STACKITEM_REAL
                je      @CIT_1
                cmp     edx, STACKITEM_OBJECT
                jne     @@OF
        @CIT_1: loop    @CIT_0
        @CIT_2: ret
                align   $04

        @checkItemTypesExcept:
                {
                Вход:   eax – количество элементов на стаке
                }
                lea     ecx, [eax+$00]
                jecxz   @CITE2
                sal     eax, $04
        @CITE0: mov     edx, [esi+eax-$04]
                cmp     edx, STACKITEM_EXCEPT
                je      @CITE1
                cmp     edx, STACKITEM_INT
                je      @CITE1
                cmp     edx, STACKITEM_LONG
                je      @CITE1
                cmp     edx, STACKITEM_FLOAT
                je      @CITE1
                cmp     edx, STACKITEM_DOUBLE
                je      @CITE1
                cmp     edx, STACKITEM_REAL
                je      @CITE1
                cmp     edx, STACKITEM_OBJECT
                jne     @@OF
        @CITE1: loop    @CITE0
        @CITE2: ret
                align   $04

        @checkMemory:
                {
                Вход:   eax – виртуальный адрес
                Выход:  eax – реальный адрес
                }
                cmp     eax, MEMORY_START
                jl      @@NP
                push    edx
                lea     edx, [eax+$00]
                mov     eax, [ourSelf]
                call    virtualAddressToPhysical
                pop     edx
                test    eax, eax
                jz      @@MF
                ret
                align   $04

        @checkField:
                {
                Вход:   eax – смещение поля
                        edx – ссылка на ячейку стака с объектной ссылкой STACKITEM_OBJECT или указателем STACKITEM_INT
                Выход:  ecx – адрес поля
                }
                mov     ecx, [edx+$0c]
                cmp     ecx, STACKITEM_INT
                je      @CFL_0
                cmp     ecx, STACKITEM_OBJECT
                jne     @@OF
                add     eax, [edx+$00]
                call    @checkMemory
                lea     ecx, [eax+$00]
                mov     eax, [ourSelf]
                mov     edx, [edx+$00]
                call    release
                ret
        @CFL_0: add     eax, [edx+$00]
                call    @checkMemory
                lea     ecx, [eax+$00]
                ret
                align   $04

        @checkCell:
                {
                Вход:   eax – размер одной ячейки массива
                        edx – ссылка на пару ячеек стака (первая – индекс ячейки массива типа STACKITEM_INT, вторая – с объектной ссылкой STACKITEM_OBJECT или указателем STACKITEM_INT)
                Выход:  ecx – адрес ячейки массива
                }
                cmp     dword[edx+$0c], STACKITEM_INT
                jne     @@OF
                mov     ecx, [edx+$1c]
                cmp     ecx, STACKITEM_OBJECT
                je      @CCL_0
                cmp     ecx, STACKITEM_INT
                jne     @@OF
                lea     ecx, [edx+$00]
                mov     edx, [ecx+$00]
                imul    edx, eax
                add     edx, [ecx+$10]
                lea     eax, [edx+$00]
                call    @checkMemory
                lea     ecx, [eax+$00]
                ret
        @CCL_0: mov     dword[aux+$00], eax
                lea     ecx, [edx+$00]
                mov     edx, [ecx+$00]
                mov     eax, [ecx+$10]
                call    @checkMemory
                cmp     edx, $00
                jl      @@AF
                cmp     edx, [eax+$08]
                jge     @@AF
                imul    edx, [aux+$00]
                add     edx, [eax+$0c]
                xchg    eax, ecx
                mov     eax, [eax+$10]
                lea     eax, [eax+edx+$10]
                call    @checkMemory
                dec     dword[ecx+$00]
                lea     ecx, [eax+$00]
                ret
                align   $04

        @checkArray:
                {
                Вход:   eax – объектная ссылка на массив
                        edx – индекс первого элемента
                        ecx – количество элементов
                        dword[dat+$00] – размер одного элемента в байтах
                Выход:  eax – реальный адрес нулевого элемента массива
                        edx – длина массива
                Перем.: dword[aux+$00] – виртуальный адрес массива
                        dword[aux+$04] – реальный адрес массива
                        dword[aux+$08] – длина массива
                        dword[aux+$0c] – индекс региона памяти
                        dword[aux+$10] – виртуальный адрес нулевого элемента массива
                        dword[aux+$14] – индекс первого элемента
                }
                mov     dword[aux+$00], eax
                mov     dword[aux+$14], edx
                call    @checkMemory
                mov     dword[aux+$04], eax
                cmp     ecx, $00
                jge     @CAR_0
                lea     edx, [ecx+$00]
                jmp     @@AF
        @CAR_0: cmp     edx, $00
                jl      @@AF
                cmp     edx, [eax+$08]
                jg      @@AF
                lea     edx, [ecx+edx]
                cmp     edx, $00
                jl      @@AF
                cmp     edx, [eax+$08]
                jg      @@AF
                mov     edx, [eax+$08]
                cmp     edx, $00
                jg      @CAR_1
                mov     edx, [aux+$04]
                mov     eax, [aux+$00]
                add     eax, [edx+$0c]
                lea     eax, [eax+$10]
                call    @checkMemory
                xor     edx, edx
                ret
        @CAR_1: mov     dword[aux+$08], edx
                lea     ecx, [edx+$00]
                mov     eax, $7ffffff0
                xor     edx, edx
                idiv    dword[dat+$00]
                cmp     ecx, eax
                jg      @@MF
                mov     eax, [aux+$04]
                mov     edx, [aux+$00]
                add     edx, [eax+$0c]
                lea     edx, [edx+$10]
                mov     dword[aux+$10], edx
                mov     eax, [ourSelf]
                call    getRegionIndex
                mov     dword[aux+$0c], eax
                mov     edx, [aux+$10]
                mov     ecx, [aux+$08]
                imul    ecx, [dat+$00]
                lea     edx, [ecx+edx-$01]
                mov     eax, [ourSelf]
                call    getRegionIndex
                cmp     eax, [aux+$0c]
                jne     @@MF
                mov     eax, [aux+$10]
                call    @checkMemory
                mov     edx, [aux+$08]
                ret
                align   $04

        @checkLoadESP:
                {
                Вход:   eax – смещение от ESP
                Выход:  eax – реальный адрес ячейки стака
                }
                lea     eax, [esi+eax]
                cmp     eax, esi
                jb      @@SF
                cmp     eax, [ebx+offset MalikContext.stackEnd]
                jae     @@SF
                ret
                align   $04

        @checkLoadEBP:
                {
                Вход:   eax – смещение от EBP
                Выход:  eax – реальный адрес ячейки стака
                }
                push    eax
                mov     eax, [ebx+offset MalikContext.stackBlock]
                test    eax, eax
                jnz     @CLB_0
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEBP]
                call    virtualAddressToPhysical
        @CLB_0: add     eax, [esp+$00]
                lea     esp, [esp+$04]
                cmp     eax, esi
                jb      @@SF
                cmp     eax, [ebx+offset MalikContext.stackEnd]
                jae     @@SF
                ret
                align   $04

        @checkStoreESP:
                {
                Вход:   eax – смещение от ESP
                Выход:  eax – реальный адрес ячейки стака
                }
                lea     edx, [esi+$10]
                lea     eax, [eax+edx]
                cmp     eax, edx
                jb      @@SF
                cmp     eax, [ebx+offset MalikContext.stackEnd]
                jae     @@SF
                ret
                align   $04

        @checkStoreEBP:
                {
                Вход:   eax – смещение от EBP
                Выход:  eax – реальный адрес ячейки стака
                }
                push    eax
                mov     eax, [ebx+offset MalikContext.stackBlock]
                test    eax, eax
                jnz     @CSB_0
                mov     eax, [ourSelf]
                mov     edx, [ebx+offset MalikContext.regEBP]
                call    virtualAddressToPhysical
        @CSB_0: add     eax, [esp+$00]
                lea     esp, [esp+$04]
                lea     edx, [esi+$10]
                cmp     eax, edx
                jb      @@SF
                cmp     eax, [ebx+offset MalikContext.stackEnd]
                jae     @@SF
                ret
                align   $04

        @load:
                {
                Вход:   eax – ссылка на загружаемую ячейку стака
                }
                lea     ecx, [eax+$00]
                mov     eax, [ecx+$0c]
                cmp     eax, STACKITEM_INT
                je      @LD_3
                cmp     eax, STACKITEM_LONG
                je      @LD_3
                cmp     eax, STACKITEM_FLOAT
                je      @LD_3
                cmp     eax, STACKITEM_DOUBLE
                je      @LD_3
                cmp     eax, STACKITEM_REAL
                je      @LD_3
                cmp     eax, STACKITEM_OBJECT
                je      @LD_0
                cmp     eax, STACKITEM_OVERFLOW
                jne     @LD_1
        @LD_0:  mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    addref
                mov     eax, STACKITEM_OBJECT
                jmp     @LD_3
        @LD_1:  cmp     eax, STACKITEM_OLDEBP
                je      @LD_2
                cmp     eax, STACKITEM_RETURN
                je      @LD_2
                cmp     eax, STACKITEM_IRETURN
                je      @LD_2
                jmp     @@OF
        @LD_2:  mov     eax, STACKITEM_INT
        @LD_3:  lea     edi, [esi-$10]
                lea     esi, [ecx+$00]
                cld
                movsd
                movsd
                movsd
                stosd
                add     dword[ebx+offset MalikContext.stackTop], -$10
                ret
                align   $04

        @store:
                {
                Вход:   eax – ссылка на перезаписываемую ячейку стака
                }
                lea     ecx, [eax+$00]
                mov     eax, [ecx+$0c]
                cmp     eax, STACKITEM_OVERFLOW
                jne     @ST_0
                cmp     dword[esi+$0c], STACKITEM_OBJECT
                jne     @@OF
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                mov     eax, [esi+$00]
                mov     dword[ecx+$00], eax
                lea     esi, [esi+$10]
                mov     dword[esi+$0c], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                ret
        @ST_0:  cmp     eax, STACKITEM_INT
                je      @ST_2
                cmp     eax, STACKITEM_LONG
                je      @ST_2
                cmp     eax, STACKITEM_FLOAT
                je      @ST_2
                cmp     eax, STACKITEM_DOUBLE
                je      @ST_2
                cmp     eax, STACKITEM_REAL
                je      @ST_2
                cmp     eax, STACKITEM_OBJECT
                jne     @ST_1
                mov     eax, [ourSelf]
                mov     edx, [ecx+$00]
                call    release
                jmp     @ST_2
        @ST_1:  cmp     eax, STACKITEM_OLDEBP
                je      @@OF
                cmp     eax, STACKITEM_RETURN
                je      @@OF
                cmp     eax, STACKITEM_IRETURN
                je      @@OF
                cmp     eax, STACKITEM_EXCEPT
                je      @@OF
        @ST_2:  lea     edi, [ecx+$00]
                cld
                movsd
                movsd
                movsd
                movsd
                mov     dword[esi-$04], STACKITEM_EMPTY
                mov     dword[ebx+offset MalikContext.stackTop], esi
                ret
                align   $04

        @cmpData0:
                {
                Вход:   edx:eax – число типа long, которое следует сравнить с [dat+$00]
                Выход:  cl – результат: 1 = edx:eax > [dat+$00], 0 = edx:eax = [dat+$00], (-1) = edx:eax < [dat+$00].
                }
                cmp     edx, [dat+$04]
                jl      @CD0_0
                jg      @CD0_1
                cmp     eax, [dat+$00]
                jb      @CD0_0
                ja      @CD0_1
                xor     cl,  cl
                ret
        @CD0_0: mov     cl,  -$01
                ret
        @CD0_1: mov     cl,  $01
                ret
                align   $04

        @isTopItems:
                {
                Вход:   eax – количество свободных элементов выше вершины стака
                Выход:  eax – состояние: 0 = доступно, 1 = меньше, 2 = обнаружена ячейка STACKITEM_OVERFLOW
                        edx – ссылка на ячейку стака, следующую после STACKITEM_OVERFLOW, если eax = 2
                }
                sal     eax, $04
                mov     ecx, [ebx+offset MalikContext.stackBegin]
                lea     ecx, [ecx+eax]
                cmp     esi, ecx
                jae     @ITI_0
                mov     eax, $01
                ret
        @ITI_0: lea     ecx, [eax+$00]
                lea     eax, [esi+$00]
                shr     ecx, $04
                jecxz   @ITI_3
        @ITI_1: lea     eax, [eax-$10]
                cmp     dword[eax+$0c], STACKITEM_OVERFLOW
                jne     @ITI_2
                lea     edx, [eax+$10]
                mov     eax, $02
                ret
        @ITI_2: loop    @ITI_1
        @ITI_3: xor     eax, eax
                ret
                align   $04

        @isValue:
                {
                Вход:   eax – тип ячейки стака
                Выход:  dl – состояние: 0 = служебная или пустая ячейка, 1 = ячейка с данными
                }
                cmp     eax, STACKITEM_INT
                je      @IVL_0
                cmp     eax, STACKITEM_LONG
                je      @IVL_0
                cmp     eax, STACKITEM_FLOAT
                je      @IVL_0
                cmp     eax, STACKITEM_DOUBLE
                je      @IVL_0
                cmp     eax, STACKITEM_REAL
                je      @IVL_0
                cmp     eax, STACKITEM_OBJECT
                je      @IVL_0
                xor     dl,  dl
                ret
        @IVL_0: mov     dl,  $01
                ret
                align   $04

        @isValueExcept:
                {
                Вход:   eax – тип ячейки стака
                Выход:  dl – состояние: 0 = служебная или пустая ячейка, 1 = ячейка с данными или STACKITEM_EXCEPT
                }
                cmp     eax, STACKITEM_EXCEPT
                je      @IVL_0
                jmp     @isValue
                align   $04

        @isOneDW:
                {
                Вход:   eax – ссылка на ячейку стака
                Выход:  al – состояние: 0 = в ячейке не двойное слово, 1 = в ячейке двойное слово
                }
                mov     edx, [eax+$0c]
                cmp     edx, STACKITEM_INT
                je      @I1D_1
                cmp     edx, STACKITEM_FLOAT
                je      @I1D_1
                cmp     edx, STACKITEM_OBJECT
                je      @I1D_1
                cmp     edx, STACKITEM_REAL
                jne     @I1D_0
                cmp     byte [eax+$0a], $01
                je      @I1D_1
        @I1D_0: xor     al,  al
                ret
        @I1D_1: mov     al,  $01
                ret
                align   $04

        @isTwoDW:
                {
                Вход:   eax – ссылка на ячейку стака
                Выход:  al – состояние: 0 = в ячейке не два двойных слова, 1 = в ячейке два двойных слова
                }
                mov     edx, [eax+$0c]
                cmp     edx, STACKITEM_LONG
                je      @I2D_1
                cmp     edx, STACKITEM_DOUBLE
                je      @I2D_1
                cmp     edx, STACKITEM_REAL
                jne     @I2D_0
                cmp     byte [eax+$0a], $02
                je      @I2D_1
        @I2D_0: xor     al,  al
                ret
        @I2D_1: mov     al,  $01
                ret
                align   $04

        @getInterruptDescriptor:
                {
                Вход:   eax – порядковый номер прерывания
                Выход:  eax – ссылка на дескриптор
                }
                lea     edx, [eax*8]
                mov     eax, [ourSelf]
                mov     eax, [eax+offset regions]
                mov     eax, [eax+$00]
                mov     eax, [eax+offset MalikMemoryRegion.memory]
                lea     eax, [eax+edx]
                ret
                align   $04

        @destroyCtx:
                mov     eax, [ourSelf]
                lea     edx, [ebx+$00]
                call    destroyContext
                mov     eax, [ourSelf]
                test    byte [eax+offset terminated], true
                jnz     @exit
                mov     ebx, [eax+offset contexts]
                mov     ebx, [ebx+$00]
                mov     ecx, [ebx+offset MalikContext.priority]
                mov     dword[ebx+offset MalikContext.priorityCount], ecx
                jmp     @mloop
                align   $04


                (*** ПРОЦЕДУРА ОБРАБОТКИ ПРЕРЫВАНИЙ ***)

        @interrupt:
                test    byte [ebx+offset MalikContext.regIF], true
                jz      @INT_2
                push    eax
                push    edx
                push    ecx
                mov     eax, [ebx+offset MalikContext.state]
                cmp     eax, CONTEXT_STATE_ACTIVE
                je      @INT_0
                cmp     eax, CONTEXT_STATE_WAITING
                jne     @INT_1
        @INT_0: mov     eax, [ourSelf]
                mov     edx, [eax+offset interruptsTail]
                cmp     edx, [eax+offset interruptsHead]
                je      @INT_1
                mov     ecx, [eax+offset interrupts]
                lea     edx, [edx+edx]
                lea     ecx, [ecx+edx*8]
                mov     dword[dat+$00], ecx
                mov     edx, [ecx+offset InterruptRecord.number]
                lea     edx, [edx*8]
                mov     ecx, [eax+offset regions]
                mov     ecx, [ecx+$00]
                add     edx, [ecx+offset MalikMemoryRegion.memory]
                mov     dword[dat+$08], edx
                cmp     dword[edx+$00], $00
                je      @INT_1
                mov     eax, $03
                call    @isTopItems
                test    eax, eax
                jnz     @INT_1
                lea     esi, [esi-$30]
                mov     eax, [ebx+offset MalikContext.regEIP]
                mov     edx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], edx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [dat+$00]
                mov     eax, [ecx+offset InterruptRecord.parameter]
                mov     edx, [ecx+offset InterruptRecord.parameter+$04]
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], edx
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_LONG
                mov     ecx, [dat+$08]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$04]
                call    addref
                mov     dword[esi+$20], edx
                mov     dword[esi+$24], $00
                mov     dword[esi+$28], $00
                mov     dword[esi+$2c], STACKITEM_OBJECT
                mov     eax, [ecx+$00]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                mov     dword[ebx+offset MalikContext.regIF], $00
                mov     dword[ebx+offset MalikContext.state], CONTEXT_STATE_ACTIVE
                mov     eax, [ourSelf]
                mov     edx, [eax+offset interruptsTail]
                lea     edx, [edx+$01]
                and     edx, INTERRUPTS_QUEUE_LENGTH-$01
                mov     dword[eax+offset interruptsTail], edx
        @INT_1: pop     ecx
                pop     edx
                pop     eax
        @INT_2: ret
                align   $04


                (*** ВОЗБУДИТЕЛИ ИСКЛЮЧЕНИЙ ***)

        @raise: lea     eax, [eax*8]
                mov     ecx, [ourSelf]
                mov     ecx, [ecx+offset regions]
                mov     ecx, [ecx+$00]
                add     eax, [ecx+offset MalikMemoryRegion.memory]
                mov     dword[dat+$00], eax
                mov     eax, $02
                call    @isTopItems
                test    eax, eax
                jnz     @destroyCtx
                lea     esi, [esi-$20]
                mov     eax, [ebx+offset MalikContext.regEIP]
                mov     edx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], edx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [dat+$00]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$04]
                call    addref
                mov     dword[esi+$10], edx
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_OBJECT
                mov     eax, [ecx+$00]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                mov     dword[ebx+offset MalikContext.regIF], $00
                jmp     @next
                align   $04

        @raiseEF:
                lea     ecx, [eax*8]
                mov     edx, [ourSelf]
                mov     edx, [edx+offset regions]
                mov     edx, [edx+$00]
                add     ecx, [edx+offset MalikMemoryRegion.memory]
                mov     edx, [ecx+$00]
                lea     ecx, [eax+$00]
                mov     eax, [ourSelf]
                call    virtualAddressToPhysical
                test    eax, eax
                jz      @destroyCtx
                lea     eax, [ecx+$00]
                jmp     @raise
                align   $04

        @raiseSO:
                lea     eax, [eax*8]
                mov     ecx, [ourSelf]
                mov     ecx, [ecx+offset regions]
                mov     ecx, [ecx+$00]
                add     eax, [ecx+offset MalikMemoryRegion.memory]
                mov     dword[dat+$00], eax
                lea     esi, [esi-$20]
                cmp     esi, [ebx+offset MalikContext.stackBegin]
                jb      @destroyCtx
                mov     eax, [ebx+offset MalikContext.regEIP]
                mov     edx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], edx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     ecx, [dat+$00]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$04]
                call    addref
                mov     dword[esi+$10], edx
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_OVERFLOW
                mov     eax, [ecx+$00]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                mov     dword[ebx+offset MalikContext.regIF], $00
                jmp     @next
                align   $04

        @raiseInt:
                mov     dword[dat+$08], edx
                lea     eax, [eax*8]
                mov     ecx, [ourSelf]
                mov     ecx, [ecx+offset regions]
                mov     ecx, [ecx+$00]
                add     eax, [ecx+offset MalikMemoryRegion.memory]
                mov     dword[dat+$00], eax
                mov     eax, $03
                call    @isTopItems
                test    eax, eax
                jnz     @destroyCtx
                lea     esi, [esi-$30]
                mov     eax, [ebx+offset MalikContext.regEIP]
                mov     edx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], edx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     eax, [dat+$08]
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_INT
                mov     ecx, [dat+$00]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$04]
                call    addref
                mov     dword[esi+$20], edx
                mov     dword[esi+$24], $00
                mov     dword[esi+$28], $00
                mov     dword[esi+$2c], STACKITEM_OBJECT
                mov     eax, [ecx+$00]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                mov     dword[ebx+offset MalikContext.regIF], $00
                jmp     @next
                align   $04

        @raiseObject:
                mov     dword[dat+$08], edx
                lea     eax, [eax*8]
                mov     ecx, [ourSelf]
                mov     ecx, [ecx+offset regions]
                mov     ecx, [ecx+$00]
                add     eax, [ecx+offset MalikMemoryRegion.memory]
                mov     dword[dat+$00], eax
                mov     eax, $03
                call    @isTopItems
                test    eax, eax
                jz      @RSO_0
                mov     eax, [ourSelf]
                mov     edx, [dat+$08]
                call    release
                jmp     @destroyCtx
        @RSO_0: lea     esi, [esi-$30]
                mov     eax, [ebx+offset MalikContext.regEIP]
                mov     edx, [ebx+offset MalikContext.regIF]
                mov     dword[esi+$00], eax
                mov     dword[esi+$04], $00
                mov     dword[esi+$08], edx
                mov     dword[esi+$0c], STACKITEM_IRETURN
                mov     eax, [dat+$08]
                mov     dword[esi+$10], eax
                mov     dword[esi+$14], $00
                mov     dword[esi+$18], $00
                mov     dword[esi+$1c], STACKITEM_OBJECT
                mov     ecx, [dat+$00]
                mov     eax, [ourSelf]
                mov     edx, [ecx+$04]
                call    addref
                mov     dword[esi+$20], edx
                mov     dword[esi+$24], $00
                mov     dword[esi+$28], $00
                mov     dword[esi+$2c], STACKITEM_OBJECT
                mov     eax, [ecx+$00]
                mov     dword[ebx+offset MalikContext.stackTop], esi
                mov     dword[ebx+offset MalikContext.regEIP], eax
                mov     dword[ebx+offset MalikContext.regIF], $00
                jmp     @next
                align   $04

        @@DZ:   mov     eax, EXCEPTION_DIVIDE_BY_ZERO
                jmp     @raise
        @@NP:   mov     eax, EXCEPTION_NULL_POINTER
                jmp     @raise
        @@MF:   mov     eax, EXCEPTION_MEMORY_FAULT
                jmp     @raise
        @@EF:   mov     eax, EXCEPTION_EXECUTION_FAULT
                jmp     @raiseEF
        @@OF:   mov     eax, EXCEPTION_OPERAND_FAULT
                jmp     @raise
        @@SF:   mov     eax, EXCEPTION_STACK_FAULT
                jmp     @raise
        @@SO:   mov     eax, EXCEPTION_STACK_OVERFLOW
                mov     esi, edx
                jmp     @raiseSO
        @@UO:   mov     eax, EXCEPTION_UNKNOWN_OPERATION
                jmp     @raise
        @@AF:   mov     eax, EXCEPTION_ARRAY_FAULT
                jmp     @raiseInt
        @@UE:   mov     eax, EXCEPTION_UNHANDLED
                jmp     @raiseObject
                align   $04


                (*** ПЕРЕХОД К СЛЕДУЮЩЕЙ ИНСТРУКЦИИ ***)

        @next:  mov     eax, [ourSelf]
                test    byte [eax+offset terminated], true
                jnz     @exit
                cmp     dword[ebx+offset MalikContext.lockedCount], $00
                je      @4
                cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_PAUSED
                je      @chctx
                jmp     @3
        @2:     test    byte [eax+offset terminated], true
                jnz     @exit
                mov     esi, [ebx+offset MalikContext.stackTop]
                call    idle
                call    @interrupt
        @3:     cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_WAITING
                je      @2
                jmp     @mloop
        @4:     cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_ACTIVE
                jne     @chctx
                dec     dword[ebx+offset MalikContext.priorityCount]
                jnz     @mloop
                align   $04


                (*** ПЕРЕКЛЮЧЕНИЕ КОНТЕКСТА ***)

        @chctx: mov     eax, [ourSelf]
                test    byte [eax+offset terminated], true
                jnz     @exit
                mov     ebx, [ebx+offset MalikContext.next]
                lea     edx, [ebx+$00]
                jmp     @6
        @5:     test    byte [eax+offset terminated], true
                jnz     @exit
                mov     esi, [ebx+offset MalikContext.stackTop]
                call    @interrupt
                cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_ACTIVE
                je      @7
                mov     ebx, [ebx+offset MalikContext.next]
                cmp     ebx, edx
                jne     @6
                call    idle
        @6:     cmp     dword[ebx+offset MalikContext.state], CONTEXT_STATE_ACTIVE
                jne     @5
        @7:     mov     ecx, [ebx+offset MalikContext.priority]
                mov     dword[ebx+offset MalikContext.priorityCount], ecx
                jmp     @mloop
                align   $04


                (*** ВЫХОД ***)

        @exit:  mov     esp, [prevESP]
                mov     ebx, [prevEBX]
                mov     esi, [prevESI]
                mov     edi, [prevEDI]
    end;

