/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.obex;

import java.io.*;

public interface HeaderSet
{
	public static final int NAME = 1;
	public static final int DESCRIPTION = 5;
	public static final int TYPE = 66;
	public static final int TIME_ISO_8601 = 68;
	public static final int TARGET = 70;
	public static final int HTTP = 71;
	public static final int WHO = 74;
	public static final int APPLICATION_PARAMETER = 76;
	public static final int OBJECT_CLASS = 79;
	public static final int COUNT = 192;
	public static final int LENGTH = 195;
	public static final int TIME_4_BYTE = 196;

	public void createAuthenticationChallenge(String realm, boolean usedID, boolean access);

	public void setHeader(int id, Object value);

	public int getResponseCode()
			throws IOException;

	public int[] getHeaderList()
			throws IOException;

	public Object getHeader(int id)
			throws IOException;
}
