/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.obex;

import java.util.*;

final class Headers extends Object
		implements HeaderSet
{
	private static final int HEADERS_COUNT = 12;
	private static final Class[] HEADER_TYPES;

	static
	{
		Class byteArray1dType = byte[].class;
		Class calendarType = Calendar.class;
		Class stringType = String.class;
		Class longType = Long.class;
		HEADER_TYPES = new Class[] {
				stringType, stringType, stringType, calendarType,
				byteArray1dType, byteArray1dType, byteArray1dType, byteArray1dType,
				byteArray1dType, longType, longType, calendarType
		};
	}

	private static int getIndex(int id)
	{
		switch(id)
		{
		default:
			return -1;
		case NAME:
			return 0;
		case DESCRIPTION:
			return 1;
		case TYPE:
			return 2;
		case TIME_ISO_8601:
			return 3;
		case TARGET:
			return 4;
		case HTTP:
			return 5;
		case WHO:
			return 6;
		case APPLICATION_PARAMETER:
			return 7;
		case OBJECT_CLASS:
			return 8;
		case COUNT:
			return 9;
		case LENGTH:
			return 10;
		case TIME_4_BYTE:
			return 11;
		}
	}

	private static int getHeaderID(int index)
	{
		switch(index)
		{
		default:
			return 0;
		case 0:
			return NAME;
		case 1:
			return DESCRIPTION;
		case 2:
			return TYPE;
		case 3:
			return TIME_ISO_8601;
		case 4:
			return TARGET;
		case 5:
			return HTTP;
		case 6:
			return WHO;
		case 7:
			return APPLICATION_PARAMETER;
		case 8:
			return OBJECT_CLASS;
		case 9:
			return COUNT;
		case 10:
			return LENGTH;
		case 11:
			return TIME_4_BYTE;
		}
	}


	private Object[] values;

	Headers()
	{
		this.values = new Object[HEADERS_COUNT];
	}

	public void createAuthenticationChallenge(String realm, boolean usedID, boolean access)
	{
	}

	public void setHeader(int id, Object value)
	{
		int index;
		if((index = getIndex(id)) < 0)
		{
			throw new IllegalArgumentException("HeaderSet.setHeader: " +
					"недопустимое значение параметра id.");
		}
		if(value != null && !HEADER_TYPES[index].isAssignableFrom(value.getClass()))
		{
			throw new IllegalArgumentException("HeaderSet.setHeader: " +
					"тип параметра value не соответствует типу заголовка.");
		}
		values[index] = value;
	}

	public int getResponseCode()
	{
		return ResponseCodes.OBEX_HTTP_NOT_IMPLEMENTED;
	}

	public int[] getHeaderList()
	{
		int i;
		int len;
		int[] result = new int[HEADERS_COUNT];
		Object[] values = this.values;
		for(len = 0, i = 0; i < HEADERS_COUNT; i++)
		{
			if(values[i] != null)
			{
				result[len++] = getHeaderID(i);
			}
		}
		if(len != HEADERS_COUNT)
		{
			Array.copy(result, 0, result = new int[len], 0, len);
		}
		return result;
	}

	public Object getHeader(int id)
	{
		int index;
		if((index = getIndex(id)) < 0)
		{
			throw new IllegalArgumentException("HeaderSet.setHeader: " +
					"недопустимое значение параметра id.");
		}
		return values[index];
	}
}
