/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public class ByteArrayOutputStream extends OutputStream
{
	protected int count;
	protected byte[] buf;

	public ByteArrayOutputStream()
	{
		this.count = 0;
		this.buf = new byte[32];
	}

	public ByteArrayOutputStream(int initialCapacity)
	{
		if(initialCapacity < 0)
		{
			throw new IllegalArgumentException("ByteArrayOutputStream: " +
					"параметр initialCapacity не может быть отрицательным.");
		}
		this.count = 0;
		this.buf = new byte[initialCapacity];
	}

	public void close()
			throws IOException
	{
	}

	public void write(int src)
	{
		int newCount;
		int count;
		byte[] buf;
		if((newCount = (count = this.count) + 1) > (buf = this.buf).length)
		{
			Array.copy(buf, 0,
					buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)], 0, count);
		}
		buf[count] = (byte) src;
		this.count = newCount;
	}

	public void write(byte[] src)
			throws IOException
	{
		int length;
		int newCount;
		int count;
		byte[] buf;
		if(src == null)
		{
			throw new NullPointerException("ByteArrayOutputStream.write: " +
					"параметр src равен нулевой ссылке.");
		}
		if((length = src.length) <= 0)
		{
			return;
		}
		if((newCount = (count = this.count) + length) > (buf = this.buf).length)
		{
			Array.copy(buf, 0,
					buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)], 0, count);
		}
		Array.copy(src, 0, buf, count, length);
		this.count = newCount;
	}

	public void write(byte[] src, int offset, int length)
	{
		int lim;
		int len;
		int newCount;
		int count;
		byte[] buf;
		if(src == null)
		{
			throw new NullPointerException("ByteArrayOutputStream.write: " +
					"параметр src равен нулевой ссылке.");
		}
		if((lim = offset + length) > (len = src.length) ||
				lim < offset || offset > len || offset < 0)
		{
			throw new ArrayIndexOutOfBoundsException("ByteArrayOutputStream.write: " +
					"индекс выходит из диапазона.");
		}
		if(length <= 0)
		{
			return;
		}
		if((newCount = (count = this.count) + length) > (buf = this.buf).length)
		{
			Array.copy(buf, 0,
					buf = this.buf = new byte[Math.max((count << 1) + 1, newCount)], 0, count);
		}
		Array.copy(src, offset, buf, count, length);
		this.count = newCount;
	}

	public String toString()
	{
		return new String(buf, 0, count);
	}

	public void reset()
	{
		count = 0;
	}

	public int size()
	{
		return count;
	}

	public byte[] toByteArray()
	{
		int len;
		byte[] result;
		Array.copy(buf, 0, result = new byte[len = count], 0, len);
		return result;
	}
}
