/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

public final class Character extends Object
{
	public static final char MIN_VALUE = '\u0000';
	public static final char MAX_VALUE = '\uffff';
	public static final int MIN_RADIX = 2;
	public static final int MAX_RADIX = 36;

	public static boolean isLowerCase(char character)
	{
		return character >= 'a' && character <= 'z' || character >= '\u00df' && character <= '\u00f6' || character >= '\u00f8' && character <= '\u00ff' || character >= '\u0430' && character <= '\u045f';
	}

	public static boolean isUpperCase(char character)
	{
		return character >= 'A' && character <= 'Z' || character >= '\u00c0' && character <= '\u00d6' || character >= '\u00d8' && character <= '\u00de' || character >= '\u0400' && character <= '\u042f';
	}

	public static boolean isDigit(char character)
	{
		return character >= '0' && character <= '9';
	}

	public static char toLowerCase(char character)
	{
		return (char) (isUpperCase(character) ? character >= '\u0400' && character <= '\u040f' ? character + 0x0050 : character + 0x0020 : character);
	}

	public static char toUpperCase(char character)
	{
		return (char) (isLowerCase(character) ? character >= '\u0450' && character <= '\u045f' ? character - 0x0050 : character - 0x0020 : character);
	}

	public static int digit(char character, int radix)
	{
		int result = -1;
		if(radix >= MIN_RADIX && radix <= MAX_RADIX)
		{
			if(character >= '0' && character <= '9')
			{
				result = character - '0';
			}
			else if(character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z')
			{
				result = (character & 0x1f) + 9;
			}
		}
		return result >= radix ? -1 : result;
	}

	static char getDigitRepresentation(int digit)
	{
		return (char) (digit >= 0 && digit <= 9 ? digit + '0' : digit >= 10 && digit < MAX_RADIX ? digit + ('a' - 0x0a) : '?');
	}


	private final int value;

	public Character(char value)
	{
		this.value = value;
	}

	public boolean equals(Object anot)
	{
		return anot == this || anot instanceof Character && value == ((Character) anot).value;
	}

	public int hashCode()
	{
		return value;
	}

	public String toString()
	{
		return String.valueOf(value);
	}

	public char charValue()
	{
		return (char) value;
	}
}
