/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.lang;

public final class MalikSystem extends Object
{
	static final int STACKITEM_FLOAT = 0x7e4100ff;
	static final int STACKITEM_DOUBLE = 0x7e8100ff;
	static final int STACKITEM_REAL = 0x7ea100ff;
	static final int STACKITEM_INT = 0x107900ff;
	static final int STACKITEM_LONG = 0x10f900ff;
	static final int STACKITEM_OBJECT = 0x0b7ec1ff;
	static final int STACKITEM_OVERFLOW = 0x0fe700ff;
	static final int STACKITEM_EXCEPT = 0x177000ff;
	static final int STACKITEM_OLDEBP = 0x01db00ff;
	static final int STACKITEM_RETURN = 0x7e107dff;
	static final int STACKITEM_IRETURN = 0x7e107eff;
	static final int STACKITEM_EMPTY = 0x00000000;

	public static native int getLocalVariableAddress(boolean variable);

	public static native int getLocalVariableAddress(float variable);

	public static native int getLocalVariableAddress(double variable);

	public static native int getLocalVariableAddress(int variable);

	public static native int getLocalVariableAddress(long variable);

	public static native int getLocalVariableAddress(Object variable);

	public static native int getObjectFieldAddress(boolean field);

	public static native int getObjectFieldAddress(float field);

	public static native int getObjectFieldAddress(double field);

	public static native int getObjectFieldAddress(int field);

	public static native int getObjectFieldAddress(long field);

	public static native int getObjectFieldAddress(Object field);

	public static long syscall(int number)
	{
		return syscall(0L, number);
	}

	public static long syscall(int loWord, int number)
	{
		return syscall((long) loWord & 0x00000000ffffffffL, number);
	}

	public static long syscall(int loWord, int hiWord, int number)
	{
		return syscall((long) loWord & 0x00000000ffffffffL | (long) hiWord << 32, number);
	}

	public static native long syscall(long argument, int number);

	static native void interrupt(int number) throws Throwable;

	static native void interrupt(int argument, int number) throws Throwable;

	static native void interrupt(long argument, int number) throws Throwable;

	static native void interrupt(Object argument, int number) throws Throwable;

	static native void runExcept(int address, Throwable throwingException) throws Throwable;

	static native void invokeDefaultConstructor(Object uninitializedInstance);

	static native void arraycopyf_float(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_double(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_byte(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_short(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_int(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_long(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyf_object(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_float(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_double(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_byte(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_short(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_int(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_long(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arraycopyb_object(Object src, int srcOffset, Object dst, int dstOffset, int length);

	static native void arrayfill_byte(Object dst, int offset, int length, int value);

	static native void arrayfill_short(Object dst, int offset, int length, int value);

	static native void arrayfill_int(Object dst, int offset, int length, int value);

	static native void arrayfill_long(Object dst, int offset, int length, long value);

	static native void arrayfill_object(Object dst, int offset, int length, Object value);

	static native void setFloatAt(int address, float value);

	static native void setDoubleAt(int address, double value);

	static native void setByteAt(int address, byte value);

	static native void setShortAt(int address, short value);

	static native void setIntAt(int address, int value);

	static native void setLongAt(int address, long value);

	static native void setObjectAt(int address, Object value);

	static native int arrayfindf_float(Object src, int startFromIndex, float findValue);

	static native int arrayfindf_double(Object src, int startFromIndex, double findValue);

	static native int arrayfindf_byte(Object src, int startFromIndex, int findValue);

	static native int arrayfindf_short(Object src, int startFromIndex, int findValue);

	static native int arrayfindf_int(Object src, int startFromIndex, int findValue);

	static native int arrayfindf_long(Object src, int startFromIndex, long findValue);

	static native int arrayfindf_object(Object src, int startFromIndex, Object findValue);

	static native int arrayfindb_float(Object src, int startFromIndex, float findValue);

	static native int arrayfindb_double(Object src, int startFromIndex, double findValue);

	static native int arrayfindb_byte(Object src, int startFromIndex, int findValue);

	static native int arrayfindb_short(Object src, int startFromIndex, int findValue);

	static native int arrayfindb_int(Object src, int startFromIndex, int findValue);

	static native int arrayfindb_long(Object src, int startFromIndex, long findValue);

	static native int arrayfindb_object(Object src, int startFromIndex, Object findValue);

	static native int blockfindf(long[] descriptors, int startFromIndex, int block);

	static native int blockfindb(long[] descriptors, int startFromIndex, int block);

	static native int findfreef(long[] descriptors, int startFromIndex, int size);

	static native int findfreeb(long[] descriptors, int startFromIndex, int size);

	static native int findzerof(long[] descriptors, int startFromIndex, int refCountFieldOffset);

	static native int findzerob(long[] descriptors, int startFromIndex, int refCountFieldOffset);

	static native int getObjectRefs(Object refThis, int refAnot, int[] refOffsets);

	static native int getArrayRefs(Object refThis, int refAnot, int[] refOffsets);

	static native int getCurrentThreadID();

	static native int getReturnAddress();

	static native int getMethodAddress(String internalRepresentation);

	static native float getFloatAt(int address);

	static native double getDoubleAt(int address);

	static native byte getByteAt(int address);

	static native short getShortAt(int address);

	static native int getIntAt(int address);

	static native long getLongAt(int address);

	static native Object getObjectAt(int address);

	static native Class getClassInstance(String internalRepresentation);

	static native int convertToReference(Object obj);

	static native Object convertToObject(int ref);

	static void throwAbstractMethodError()
	{
		throw new AbstractMethodError("Отсутствует реализация некоторого абстрактного метода.");
	}

	static void disableThreadSwitching()
	{
		syscall(0L, 0x0004);
	}

	static void enableThreadSwitching()
	{
		syscall(0L, 0x0005);
	}

	static void leaveMonopolyAccess(boolean status)
	{
		enableThreadSwitching();
		MalikInterrupt.enable(status);
	}

	static boolean enterMonopolyAccess()
	{
		boolean result = MalikInterrupt.enabled();
		MalikInterrupt.disable();
		disableThreadSwitching();
		return result;
	}


	private MalikSystem()
	{
	}
}
