/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.fileformats.text.mapped;

import java.io.*;
import java.util.*;
import malik.emulator.fileformats.*;

public abstract class CustomKeyValueList extends Object
		implements InputAdapter, InputEncodingAdapter, DataHolder, MappedTextDecoder
{
	private Hashtable list;

	protected CustomKeyValueList()
	{
		this.list = new Hashtable();
	}

	public abstract void loadFromInputStream(InputStream stream)
			throws IOException, InvalidDataFormatException;

	public abstract void loadFromDataStream(DataInputStream stream)
			throws IOException, InvalidDataFormatException;

	public abstract void loadFromInputStream(InputStream stream, String encoding)
			throws IOException, InvalidDataFormatException, UnsupportedEncodingException;

	public abstract void loadFromDataStream(DataInputStream stream, String encoding)
			throws IOException, InvalidDataFormatException, UnsupportedEncodingException;

	public void clear()
	{
		list.clear();
	}

	public boolean isEmpty()
	{
		return list.isEmpty();
	}

	public void set(String key, String value)
	{
		if(value == null)
		{
			list.remove(key);
			return;
		}
		list.put(key, value);
	}

	public String[] listKeys()
	{
		String[] result;
		Vector v = new Vector();
		Enumeration e = list.keys();
		for(; e.hasMoreElements(); v.addElement(e.nextElement()));
		v.copyInto(result = new String[v.size()]);
		return result;
	}

	public String get(String key)
	{
		return (String) list.get(key);
	}
}
