/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

import java.lang.ref.*;

public abstract class Container extends ScrollingScreen
{
	private static final Object LOCK;

	static
	{
		LOCK = new Object();
	}

	static Object getOwningLock()
	{
		return LOCK;
	}


	private Reference ref;

	Container(boolean system, String title, Ticker ticker,
			Command[] commands, Command defaultCommand, CommandListener listener,
			int scrollbars)
	{
		super(system, false, title, ticker, commands, defaultCommand, listener, scrollbars);
		this.ref = new WeakReference(this);
	}

	abstract void paint(GraphicsClipRestricted render,
			ScrollBar horzScrollBar, ScrollBar vertScrollBar);

	abstract void setCurrent(Item item, Display display);
	
	abstract void notifyPlaceItems();

	boolean isFocused(Item item)
	{
		return false;
	}

	final void paint(Graphics render, ScrollBar horzScrollBar, ScrollBar vertScrollBar)
	{
		paint((GraphicsClipRestricted) render, horzScrollBar, vertScrollBar);
	}

	final void setFullScreenMode(boolean fullScreen)
	{
		throw new IllegalStateException("Container.setFullScreenMode: " +
				"невозможно перевести контейнер в полноэкранный режим.");
	}

	final Reference getOwningReference()
	{
		return ref;
	}
}
