/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

public abstract class CustomDisplayable extends Displayable
{
	public static final int ALL = Displayable.ALL;
	public static final int TITLE = Displayable.TITLE;
	public static final int TICKER = Displayable.TICKER;
	public static final int CLIENT = Displayable.CLIENT;
	public static final int COMMANDS = Displayable.COMMANDS;

	protected static final int GUI_ELEMENT_TITLE = Displayable.GUI_ELEMENT_TITLE;
	protected static final int GUI_ELEMENT_TICKER = Displayable.GUI_ELEMENT_TICKER;
	protected static final int GUI_ELEMENT_CLIENT = Displayable.GUI_ELEMENT_CLIENT;
	protected static final int GUI_ELEMENT_COMMANDS = Displayable.GUI_ELEMENT_COMMANDS;


	protected CustomDisplayable(boolean fullScreenMode, String title, Ticker ticker,
			Command[] commands, Command defaultCommand, CommandListener listener)
	{
		super(true, fullScreenMode, title, ticker, commands, defaultCommand, listener);
	}

	public void setDefaultCommand(Command command)
	{
		super.setDefaultCommand(command);
	}

	public void setFullScreenMode(boolean fullScreenMode)
	{
		super.setFullScreenMode(fullScreenMode);
	}

	public final void setEvent(Runnable event)
	{
		callSerially(event);
	}

	public final void setEventSizeChanged()
	{
		callSeriallySizeChanged();
	}

	public final void setEventCommandAction(Command command)
	{
		callSeriallyCommandAction(command);
	}

	public final void repaint(int guiElements)
	{
		callSeriallyPaintScreen(guiElements);
	}

	public final void repaint()
	{
		callSeriallyPaintClient(0, 0, getClientWidth(), getClientHeight());
	}

	public final void repaint(int left, int top, int width, int height)
	{
		callSeriallyPaintClient(left, top, width, height);
	}

	public final void serviceRepaints()
	{
		MIDletProxy.getInstance().getEmulatorScreen().serviceRepaints(this);
	}

	protected abstract void paint(Graphics render);

	protected void paintTitle(Graphics render, int width, int height, String title)
	{
		super.paintTitle(render, width, height, title);
	}

	protected void paintTicker(Graphics render, int width, int height, Ticker ticker)
	{
		super.paintTicker(render, width, height, ticker);
	}

	protected void paintClient(Graphics render, int width, int height,
			int clipLeft, int clipTop, int clipWidth, int clipHeight)
	{
		super.paintClient(render, width, height, clipLeft, clipTop, clipWidth, clipHeight);
	}

	protected void paintCommands(Graphics render, int width, int height,
			Command[] commands, int pressedIndex, Font defaultCommandFont)
	{
		super.paintCommands(render, width, height, commands, pressedIndex, defaultCommandFont);
	}

	protected void paintCommand(Graphics render, int left, int top, int width, int height,
			Command command, boolean asDefault, boolean asPressed)
	{
		super.paintCommand(render, left, top, width, height, command, asDefault, asPressed);
	}

	protected void onShow()
	{
		super.onShow();
	}

	protected void onHide()
	{
		super.onHide();
	}

	protected void onSizeChanged(int width, int height)
	{
		super.onSizeChanged(width, height);
	}

	protected void onKeyPressed(int key, int charCode)
	{
		super.onKeyPressed(key, charCode);
	}

	protected void onKeyRepeated(int key, int charCode)
	{
		super.onKeyRepeated(key, charCode);
	}

	protected void onKeyReleased(int key)
	{
		super.onKeyReleased(key);
	}

	protected void onPointerPressed(int x, int y, int button)
	{
		super.onPointerPressed(x, y, button);
	}

	protected void onPointerDragged(int x, int y)
	{
		super.onPointerDragged(x, y);
	}

	protected void onPointerReleased(int x, int y, int button)
	{
		super.onPointerReleased(x, y, button);
	}

	protected void onPaint(Graphics render, int guiElements, int clipLeft, int clipTop, int clipWidth, int clipHeight)
	{
		super.onPaint(render, guiElements, clipLeft, clipTop, clipWidth, clipHeight);
	}

	protected void onCommandAction(Command command)
	{
		super.onCommandAction(command);
	}

	protected boolean keyHandling(int key)
	{
		return super.keyHandling(key);
	}

	protected boolean coordinateHandling(int x, int y)
	{
		return super.coordinateHandling(x, y);
	}

	protected int getPanelCommandIndex(int x, int y, int width, int height)
	{
		return super.getPanelCommandIndex(x, y, width, height);
	}

	protected int getClientLeft()
	{
		return super.getClientLeft();
	}

	protected int getClientTop()
	{
		return super.getClientTop();
	}

	protected int getClientWidth()
	{
		return super.getClientWidth();
	}

	protected int getClientHeight()
	{
		return super.getClientHeight();
	}

	protected Font getGUIElementFont(int guiElement)
	{
		return super.getGUIElementFont(guiElement);
	}

	protected Font getDefaultCommandFont()
	{
		return super.getDefaultCommandFont();
	}

	protected CommandEnumeration getCommands()
	{
		return super.getCommands();
	}

	protected Object getMonitor()
	{
		return getCommandsMonitor();
	}

	protected final void invalidateCommands()
	{
		updateCommands();
	}

	protected final void getGUIElementMetrics(int guiElement, int[] metrics, int offset)
	{
		Display display;
		if(guiElement < 0 || guiElement >= 4)
		{
			throw new IllegalArgumentException("CustomDisplayable.getGUIElementMetrics: " +
					"недопустимое значение параметра guiElement.");
		}
		if(metrics == null)
		{
			throw new NullPointerException("CustomDisplayable.getGUIElementMetrics: " +
					"параметр metrics равен нулевой ссылке.");
		}
		if(offset < 0 || offset > metrics.length - 4)
		{
			throw new ArrayIndexOutOfBoundsException("CustomDisplayable.getGUIElementMetrics: " +
					"индекс выходит из диапазона.");
		}
		display = MIDletProxy.getInstance().getEmulatorScreen();
		metrics[offset + 0] = display.getGUIElementLeft(this, guiElement);
		metrics[offset + 1] = display.getGUIElementTop(this, guiElement);
		metrics[offset + 2] = display.getGUIElementWidth(this, guiElement);
		metrics[offset + 3] = display.getGUIElementHeight(this, guiElement);
	}

	protected final Graphics getClientGraphics()
	{
		return getClientContext();
	}
}
