/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

import javax.microedition.lcdui.*;
import malik.emulator.application.*;

public class LaunchScreen extends Canvas
		implements Runnable
{
	private static final String[] LINES;

	static
	{
		LINES = new String[] {
				"Приложение", "запускается…"
		};
	}


	private boolean eventPushed;
	private Class midletClass;
	private SystemGUI owner;

	public LaunchScreen(SystemGUI owner, Class midletClass)
	{
		super(true, null, null, null, null, null, false);
		this.midletClass = midletClass;
		this.owner = owner;
	}

	public void run()
	{
		owner.prepareForStartMIDlet();
		MIDletProxy.getInstance().startMIDlet(midletClass);
	}

	protected void paint(Graphics render)
	{
		int l;
		int t;
		int w;
		int h;
		int fh;
		int sw;
		int sh;
		int i;
		int tmp;
		int len;
		String[] lines;
		Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);
		for(w = 0, i = len = (lines = LINES).length; i-- > 0; )
		{
			if(w < (tmp = font.stringWidth(lines[i])))
			{
				w = tmp;
			}
		}
		h = len * (fh = font.getHeight());
		render.setFont(font);
		render.setColor(0x000000);
		render.fillRect(0, 0, sw = getWidth(), sh = getHeight());
		render.setColor(0xffffff);
		render.drawRoundRect((l = (sw - w) / 2) - 8, (t = sh - h - l / 2) - 8,
				w + 16, h + 16, 8, 8);
		for(l += w / 2, i = 0; i < len; t += fh, i++)
		{
			render.drawString(lines[i], l, t, Graphics.HCENTER | Graphics.TOP);
		}
		if(!eventPushed)
		{
			eventPushed = true;
			Run.getInstance().setEvent(this);
		}
	}
}
