/*
	Zlib – библиотека сжатия данных общего назначения. Версия 1.1.0
	Это изменённая объектно-ориентированная версия библиотеки, полностью
	совместимая с оригинальной библиотекой.
	
	Copyright © 1995–2005 Jean-loup Gailly и Mark Adler
	Copyright © 2000–2011 ymnk, JCraft, Inc.
	Copyright © 2016, 2019 Малик Разработчик
	
	Эта библиотека поставляется «как есть», без каких-либо явных или
	подразумеваемых гарантий. Ни при каких обстоятельствах авторы не
	несут какой-либо ответственности в случае потери данных вследствие
	использования данной библиотеки.
	
	Разрешается всем использовать эту библиотеку для любых целей, в том
	числе и для коммерческих приложений, а также изменять её и
	распространять свободно при соблюдении следующих условий:
	
		1. Оригинал библиотеки не должен быть искажён; вы не должны
	заявлять, что именно вы написали оригинальную библиотеку. Если вы
	используете эту библиотеку в своём программном продукте, то ссылка
	на авторов библиотеки была бы желательна, но это не является
	обязательным требованием.
	
		2. Изменённые версии исходных текстов должны быть отчётливо
	маркированы и не должны выдаваться за оригинал библиотеки.
	
		3. Эти замечания не могут быть удалены либо изменены при
	каком-либо варианте распространения исходных текстов.
*/


package malik.emulator.compression.zlib;

public class Adler32 extends Zlib
		implements Checksum32
{
	private static final int BASE = 65521;
	private static final int NMAX = 5552;


	private int adler;

	public Adler32()
	{
		this.adler = 1;
	}

	public Adler32(int adler)
	{
		this.adler = adler;
	}

	public void update(byte[] src, int offset, int length)
	{
		int a;
		int k;
		long s1 = (long) ((a = adler) & 0xffff);
		long s2 = (long) (a >>> 16);
		while(length > 0)
		{
			for(length -= (k = length < NMAX ? length : NMAX); k-- > 0;)
			{
				s2 += (s1 += (long) (src[offset++] & 0xff));
			}
			s1 %= (long) BASE;
			s2 %= (long) BASE;
		}
		adler = ((int) s1) | ((int) (s2 << 16));
	}

	public void reset(int init)
	{
		adler = init;
	}

	public void reset()
	{
		adler = 1;
	}

	public int getValue()
	{
		return adler;
	}

	public Checksum32 copy()
	{
		return new Adler32(adler);
	}
}
