/*
	Zlib – библиотека сжатия данных общего назначения. Версия 1.1.0
	Это изменённая объектно-ориентированная версия библиотеки, полностью
	совместимая с оригинальной библиотекой.
	
	Copyright © 1995–2005 Jean-loup Gailly и Mark Adler
	Copyright © 2000–2011 ymnk, JCraft, Inc.
	Copyright © 2016, 2019 Малик Разработчик
	
	Эта библиотека поставляется «как есть», без каких-либо явных или
	подразумеваемых гарантий. Ни при каких обстоятельствах авторы не
	несут какой-либо ответственности в случае потери данных вследствие
	использования данной библиотеки.
	
	Разрешается всем использовать эту библиотеку для любых целей, в том
	числе и для коммерческих приложений, а также изменять её и
	распространять свободно при соблюдении следующих условий:
	
		1. Оригинал библиотеки не должен быть искажён; вы не должны
	заявлять, что именно вы написали оригинальную библиотеку. Если вы
	используете эту библиотеку в своём программном продукте, то ссылка
	на авторов библиотеки была бы желательна, но это не является
	обязательным требованием.
	
		2. Изменённые версии исходных текстов должны быть отчётливо
	маркированы и не должны выдаваться за оригинал библиотеки.
	
		3. Эти замечания не могут быть удалены либо изменены при
	каком-либо варианте распространения исходных текстов.
*/


package malik.emulator.compression.zlib;

public final class Inflater extends ZStream
{
	public Inflater()
	{
		init();
	}

	public Inflater(int wbits)
			throws GZIPException
	{
		this(wbits, false);
	}

	public Inflater(int wbits, boolean nowrap)
			throws GZIPException
	{
		int ret;
		if((ret = init(wbits, nowrap)) != OK)
		{
			throw new GZIPException(ret + ": " + msg);
		}
	}

	public int inflate(int flush)
	{
		return istate == null ? STREAM_ERROR : istate.inflate(flush);
	}

	public int init()
	{
		return init(DEF_WBITS);
	}

	public int init(boolean nowrap)
	{
		return init(DEF_WBITS, nowrap);
	}

	public int init(int wbits)
	{
		return init(wbits, false);
	}

	public int init(int wbits, boolean nowrap)
	{
		return (istate = new Inflate(this)).inflateInit(nowrap ? -wbits : wbits);
	}

	public int end()
	{
		int result;
		if(istate == null)
		{
			return STREAM_ERROR;
		}
		result = istate.inflateEnd();
		istate = null;
		free();
		return result;
	}

	public int sync()
	{
		return istate == null ? STREAM_ERROR : istate.inflateSync();
	}

	public int syncPoint()
	{
		return istate == null ? STREAM_ERROR : istate.inflateSyncPoint();
	}

	public int setDictionary(byte[] dictionary, int dictLength)
	{
		return istate == null ? STREAM_ERROR : istate.inflateSetDictionary(dictionary, dictLength);
	}

	public boolean finished()
	{
		return istate.mode == 12;
	}
}
