/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

import malik.emulator.util.*;

public abstract class InputStream extends Object
{
    public InputStream() {
    }

    public abstract int read() throws IOException;

    public void close() throws IOException {
    }

    public void reset() throws IOException {
        throw new IOException((new StringBuilder()).append("InputStream.reset: класс ").append(getClass().getCanonicalName()).append(" не поддерживает метод reset.").toString());
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return 0;
    }

    public int read(byte[] dst) throws IOException {
        if(dst == null)
        {
            throw new NullPointerException("InputStream.read: аргумент dst равен нулевой ссылке.");
        }
        return read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int offset, int length) throws IOException {
        int result;
        if(dst == null)
        {
            throw new NullPointerException("InputStream.read: аргумент dst равен нулевой ссылке.");
        }
        Array.checkBound("InputStream.read", dst.length, offset, length);
        for(result = 0; result < length; result++)
        {
            try
            {
                int readed;
                if((readed = read()) < 0)
                {
                    if(result == 0) result--;
                    break;
                }
                dst[offset++] = (byte) readed;
            }
            catch(IOException e)
            {
                if(result > 0) break;
                throw e;
            }
        }
        return result;
    }

    public long skip(long quantity) throws IOException {
        long result;
        if(quantity <= 0L) return 0L;
        for(result = 0L; result < quantity; result++)
        {
            try
            {
                if(read() < 0) break;
            }
            catch(IOException e)
            {
                if(result > 0L) break;
                throw e;
            }
        }
        return result;
    }
}
