/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

import malik.emulator.i18n.*;

public class InputStreamReader extends Reader
{
    private final Reader in;

    public InputStreamReader(InputStream stream) {
        Reader reader;
        this.in = reader = Helper.createReader(stream);
        this.lock = reader.lock;
    }

    public InputStreamReader(InputStream stream, String encoding) throws UnsupportedEncodingException {
        Reader reader;
        this.in = reader = Helper.createReader(stream, encoding);
        this.lock = reader.lock;
    }

    public void close() throws IOException {
        in.close();
    }

    public void reset() throws IOException {
        in.reset();
    }

    public void mark(int readLimit) throws IOException {
        in.mark(readLimit);
    }

    public boolean markSupported() {
        return in.markSupported();
    }

    public boolean ready() throws IOException {
        return in.ready();
    }

    public int read() throws IOException {
        return in.read();
    }

    public int read(char[] dst, int offset, int length) throws IOException {
        long bounds;
        offset = (int) (bounds = Array.intersectBound(dst == null ? 0 : dst.length, offset, length));
        length = (int) (bounds >> 32);
        return in.read(dst, offset, length);
    }

    public long skip(long quantity) throws IOException {
        return in.skip(quantity);
    }
}
