/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.media.graphics;

public class Clip extends Object implements Rectangle
{
    private int left;
    private int top;
    private int width;
    private int height;
    private int translateX;
    private int translateY;

    public Clip(int clipWidth, int clipHeight) {
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public Clip(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft;
        this.top = clipTop;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public Clip(int translateX, int translateY, int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft + translateX;
        this.top = clipTop + translateY;
        this.width = clipWidth;
        this.height = clipHeight;
        this.translateX = translateX;
        this.translateY = translateY;
    }

    public void translateReset() {
        translateX = 0;
        translateY = 0;
    }

    public void translate(int deltaX, int deltaY) {
        translateX += deltaX;
        translateY += deltaY;
    }

    public void translateTo(int rawX, int rawY) {
        translateX = rawX;
        translateY = rawY;
    }

    public void clipRect(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        int tmp;
        int left = this.left;
        int top = this.top;
        int right = left + this.width;
        int bottom = top + this.height;
        clipLeft += translateX;
        clipTop += translateY;
        if(left < clipLeft) left = clipLeft;
        if(top < clipTop) top = clipTop;
        if(right > (tmp = clipLeft + clipWidth)) right = tmp;
        if(bottom > (tmp = clipTop + clipHeight)) bottom = tmp;
        this.left = left;
        this.top = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void clipRect(Rectangle clip) {
        int tmp;
        int left;
        int top;
        int right;
        int bottom;
        int clipLeft;
        int clipTop;
        int clipWidth;
        int clipHeight;
        if(clip == null)
        {
            throw new NullPointerException("Clip.clipRect: аргумент clip равен нулевой ссылке.");
        }
        clipLeft = clip.getLeft();
        clipTop = clip.getTop();
        clipWidth = clip.getWidth();
        clipHeight = clip.getHeight();
        left = this.left;
        top = this.top;
        right = left + this.width;
        bottom = top + this.height;
        clipLeft += translateX;
        clipTop += translateY;
        if(left < clipLeft) left = clipLeft;
        if(top < clipTop) top = clipTop;
        if(right > (tmp = clipLeft + clipWidth)) right = tmp;
        if(bottom > (tmp = clipTop + clipHeight)) bottom = tmp;
        this.left = left;
        this.top = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void setClip(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.left = clipLeft + translateX;
        this.top = clipTop + translateY;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public void setClip(Rectangle clip) {
        int clipLeft;
        int clipTop;
        int clipWidth;
        int clipHeight;
        if(clip == null)
        {
            throw new NullPointerException("Clip.setClip: аргумент clip равен нулевой ссылке.");
        }
        clipLeft = clip.getLeft();
        clipTop = clip.getTop();
        clipWidth = clip.getWidth();
        clipHeight = clip.getHeight();
        this.left = clipLeft + translateX;
        this.top = clipTop + translateY;
        this.width = clipWidth;
        this.height = clipHeight;
    }

    public final int getLeft() {
        return left;
    }

    public final int getTop() {
        return top;
    }

    public final int getWidth() {
        return width;
    }

    public final int getHeight() {
        return height;
    }

    public final int getTranslateX() {
        return translateX;
    }

    public final int getTranslateY() {
        return translateY;
    }

    public final int getClipLeft() {
        return left - translateX;
    }

    public final int getClipTop() {
        return top - translateY;
    }

    public final int getClipWidth() {
        return width;
    }

    public final int getClipHeight() {
        return height;
    }

    public final Rectangle getClipRect() {
        return new Rectangle() {
            public int getLeft() {
                return (Clip.this).getClipLeft();
            }

            public int getTop() {
                return (Clip.this).getClipTop();
            }

            public int getWidth() {
                return (Clip.this).getClipWidth();
            }

            public int getHeight() {
                return (Clip.this).getClipHeight();
            }
        };
    }
}
