/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.time;

import java.util.*;
import malik.emulator.util.*;

public class BasicTimeZone extends TimeZone
{
    public static char[] offsetToString(int offsetInMillis) {
        boolean negative;
        int ofs;
        int hrs;
        int min = (hrs = (negative = (ofs = offsetInMillis / 60000) < 0) ? -ofs : ofs) % 60;
        return new char[] { negative ? '-' : '+', (char) (((hrs /= 60) / 10) % 10 + '0'), (char) (hrs % 10 + '0'), ':', (char) (min / 10 + '0'), (char) (min % 10 + '0') };
    }

    private final int offsetInMillis;
    private final String[] ids;
    private final String name;

    public BasicTimeZone(String id) {
        this(id, null, null, 0);
    }

    public BasicTimeZone(String id, String[] ids, String name, int offsetInMillis) {
        super(id);
        String[] copyids;
        if(ids == null)
        {
            copyids = null;
        } else
        {
            int len = ids.length;
            int copylen = 0;
            copyids = new String[len];
            for(int i = 0; i < len; i++)
            {
                String currid;
                if((currid = ids[i]) != null) copyids[copylen++] = currid;
            }
            if(copylen < len) Array.copy(copyids, 0, copyids = new String[copylen], 0, copylen);
        }
        this.offsetInMillis = offsetInMillis;
        this.ids = copyids;
        this.name = name;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof BasicTimeZone && offsetInMillis == ((BasicTimeZone) anot).offsetInMillis;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public int hashCode() {
        return offsetInMillis;
    }

    public int getRawOffset() {
        return offsetInMillis;
    }

    public int getOffset(int era, int year, int month, int day, int weekday, int millis) {
        if(era < 0 || era > 1)
        {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: аргумент era имеет недопустимое значение.");
        }
        if(year <= 0)
        {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: аргумент year может быть только положительным.");
        }
        if(++month < 1 || month > 12)
        {
            throw new IllegalArgumentException("BasicTimeZone.getOffset: аргумент month имеет недопустимое значение.");
        }
        return offsetInMillis;
    }

    public String toString() {
        int offset = getRawOffset();
        return (new StringBuilder()).append(getName()).append(" (UTC").append(offsetToString(offset)).append(")").toString();
    }

    public String toString(int era, int year, int month, int day, int weekday, int millis) {
        int offset = getOffset(era, year, month, day, weekday, millis);
        return (new StringBuilder()).append(getName()).append(" (UTC").append(offsetToString(offset)).append(")").toString();
    }

    public String getName() {
        return name;
    }

    public final boolean isID(String id) {
        Object[] ids;
        if(id == null) return getID() == null;
        if(id.equals(getID())) return true;
        for(int len = (ids = this.ids) == null ? 0 : ids.length, i = 0; i < len; i++) if(id.equals(ids[i])) return true;
        return false;
    }

    public final int getIDsCount() {
        Object[] ids;
        return (ids = this.ids) != null ? ids.length + 1 : 1;
    }

    public final String getID(int index) {
        String[] ids;
        if(index < 0 || index > ((ids = this.ids) == null ? 0 : ids.length))
        {
            throw new IndexOutOfBoundsException("BasicTimeZone.getID: аргумент index выходит из диапазона.");
        }
        return index == 0 ? getID() : ids[index - 1];
    }
}
