/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.microedition.lcdui.*;

public class Command extends Object
{
    static interface Enumeration
    {
        public int size();

        public Command commandAt(int index);

        public Command defaultCommand();
    }

    static interface Owner extends Enumeration
    {
        public boolean isMyOwnedCommand(Command command);
    }

    public static final int SCREEN = 1;
    public static final int BACK = 2;
    public static final int CANCEL = 3;
    public static final int OK = 4;
    public static final int HELP = 5;
    public static final int STOP = 6;
    public static final int EXIT = 7;
    public static final int ITEM = 8;

    static final Object MONITOR;

    static {
        MONITOR = new Object();
    }

    final int type;
    final int priority;
    private int truncatedWidth;
    private Font truncatedFont;
    private String truncatedLabel;
    private final String longLabel;
    private final String label;

    public Command(String label, int type, int priority) {
        this(label, null, type, priority);
    }

    public Command(String label, String longLabel, int type, int priority) {
        if(label == null)
        {
            throw new NullPointerException("Command: аргумент label равен нулевой ссылке.");
        }
        if(type < 1 || type > 8)
        {
            throw new IllegalArgumentException("Command: аргумент type имеет недопустимое значение.");
        }
        this.type = type;
        this.priority = priority;
        this.longLabel = longLabel;
        this.label = label;
    }

    public int getCommandType() {
        return type;
    }

    public int getPriority() {
        return priority;
    }

    public String getLabel() {
        return label;
    }

    public String getLongLabel() {
        return longLabel;
    }

    public final String getTruncatedLabel(int width, Font font) {
        String result;
        if(font == truncatedFont && width == truncatedWidth) return truncatedLabel;
        truncatedFont = font;
        truncatedWidth = width;
        truncatedLabel = result = MultilinedStringBuilder.truncate(label, font, width);
        return result;
    }
}
