/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.application.*;
import malik.emulator.microedition.lcdui.*;

public abstract class CustomSurfaceScreen extends SurfaceScreen
{
    protected CustomSurfaceScreen(boolean scrollbarVisibility, ScrollBarStyle style) {
        super(null, 0, scrollbarVisibility, style);
    }

    protected CustomSurfaceScreen(int verticalRange, boolean scrollbarVisibility, ScrollBarStyle style) {
        super(null, verticalRange, scrollbarVisibility, style);
    }

    protected CustomSurfaceScreen(String title, int verticalRange, boolean scrollbarVisibility, ScrollBarStyle style) {
        super(title, verticalRange, scrollbarVisibility, style);
    }

    public void setDefaultCommand(Command command) {
        super.setDefaultCommand(command);
    }

    protected abstract void paint(Graphics render);

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyboardNotify(KeyboardEvent event) {
    }

    protected void pointerNotify(PointerEvent event) {
    }

    protected void commandNotify(Command command) {
    }

    protected void scrollNotify(int position, int clientWidth, int clientHeight) {
    }

    protected final void repaint() {
        requestPaintAll();
    }

    protected final void serviceRepaints() {
        servicePaint();
    }

    void paint(ScreenGraphics render) {
        paint((Graphics) render);
    }

    void onShow() {
        showNotify();
    }

    void onHide() {
        hideNotify();
    }

    void onCommandAction(Command command) {
        try
        {
            commandNotify(command);
        }
        catch(RuntimeException e)
        {
            e.printRealStackTrace();
        }
        super.onCommandAction(command);
    }

    void onClientKeyboardEvent(KeyboardEvent event) {
        keyboardNotify(event);
    }

    void onClientPointerEvent(PointerEvent event) {
        pointerNotify(event);
    }

    void onClientScroll(int position, int clientWidth, int clientHeight) {
        scrollNotify(position, clientWidth, clientHeight);
    }
}
