/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public abstract class FocusItem extends Item
{
    boolean focused;

    FocusItem(String label) {
        super(label);
    }

    FocusItem(String label, int layout) {
        super(label, layout);
    }

    abstract void paint(Graphics render, int contentWidth, int contentHeight);

    abstract int getMinimumContentWidth();

    abstract int getMinimumContentHeight();

    void onFocusLost() {
        focused = false;
        requestPaint();
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean result = focused;
        focused = true;
        if(!result) requestPaint();
        return result;
    }

    int getPreferredContentWidth(int contentHeight) {
        return 0;
    }

    int getPreferredContentHeight(int contentWidth) {
        return 0;
    }
}
