/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public abstract class ScrollBar extends VisibleElement
{
    protected static final int VISIBILITY = 1;
    protected static final int POSITION = 2;
    protected static final int RANGE = 4;

    protected int position;
    protected int range;
    protected final Object monitor;

    protected ScrollBar() {
        this.monitor = new Object();
    }

    protected ScrollBar(boolean visibility, int range, Object monitor) {
        super(visibility);
        this.range = range;
        this.monitor = monitor == null ? new Object() : monitor;
    }

    public abstract void repaint();

    public abstract int getPage();

    public void setVisibility(boolean visibility) {
        boolean exec = false;
        synchronized(monitor)
        {
            if(this.visibility != visibility)
            {
                this.visibility = visibility;
                exec = true;
            }
        }
        if(exec) notifyFieldsChanged(VISIBILITY);
    }

    public void scroll(int delta) {
        boolean exec = false;
        int page = getPage();
        synchronized(monitor)
        {
            int oldPosition = position;
            int newPosition = delta + oldPosition;
            int maximum = range - page;
            if(newPosition > maximum) newPosition = maximum;
            if(newPosition < 0) newPosition = 0;
            if(oldPosition != newPosition)
            {
                position = newPosition;
                exec = true;
            }
        }
        if(exec) notifyFieldsChanged(POSITION);
    }

    public void setPosition(int position) {
        boolean exec = false;
        int page = getPage();
        synchronized(monitor)
        {
            int oldPosition = this.position;
            int newPosition = position;
            int maximum = range - page;
            if(newPosition > maximum) newPosition = maximum;
            if(newPosition < 0) newPosition = 0;
            if(oldPosition != newPosition)
            {
                this.position = newPosition;
                exec = true;
            }
        }
        if(exec) notifyFieldsChanged(POSITION);
    }

    public void setRange(int range) {
        int fields = 0;
        int page = getPage();
        synchronized(monitor)
        {
            if(this.range != range)
            {
                int oldPosition;
                int newPosition = oldPosition = position;
                int maximum = range - page;
                if(newPosition > maximum) newPosition = maximum;
                if(newPosition < 0) newPosition = 0;
                if(oldPosition != newPosition)
                {
                    position = newPosition;
                    fields |= POSITION;
                }
                this.range = range;
                fields |= RANGE;
            }
        }
        if(fields != 0) notifyFieldsChanged(fields);
    }

    public int getPosition() {
        return position;
    }

    public int getRange() {
        return range;
    }

    protected void notifyFieldsChanged(int fields) {
    }
}
