/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.media.control;

import javax.microedition.media.*;

public interface VideoControl extends GUIControl
{
    public static final int USE_DIRECT_VIDEO = 1;

    public Object initDisplayMode(int mode, Object argument);

    public void setVisible(boolean visibility);

    public void setDisplayFullScreen(boolean fullScreen) throws MediaException;

    public void setDisplayLocation(int left, int top);

    public void setDisplaySize(int width, int height) throws MediaException;

    public int getDisplayX();

    public int getDisplayY();

    public int getDisplayWidth();

    public int getDisplayHeight();

    public int getSourceWidth();

    public int getSourceHeight();

    public byte[] getSnapshot(String type) throws MediaException;
}
