/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.*;

public class FastMultilinedStringBuilder extends MultilinedStringBuilder
{
    private int width;
    private Font font;

    public FastMultilinedStringBuilder() {
    }

    public FastMultilinedStringBuilder(int initialCapacity) {
        super(initialCapacity);
    }

    public void clear() {
        super.clear();
        reset();
    }

    public void set(int position, char character) {
        super.set(position, character);
        reset();
    }

    public final void split(Font font, int width) {
        if(font == null) font = Font.getDefaultFont();
        if(font != this.font || width != this.width)
        {
            this.font = font;
            this.width = width;
            super.split(font, width);
        }
    }

    public final void reset() {
        width = 0;
        font = null;
    }

    protected void insertChar(int position, char character) {
        super.insertChar(position, character);
        reset();
    }

    protected void insertArray(int position, char[] src, int offset, int length) {
        super.insertArray(position, src, offset, length);
        reset();
    }

    protected void insertString(int position, String string) {
        super.insertString(position, string);
        reset();
    }

    protected void appendChar(char character) {
        super.appendChar(character);
        reset();
    }

    protected void appendArray(char[] src, int offset, int length) {
        super.appendArray(src, offset, length);
        reset();
    }

    protected void appendString(String string) {
        super.appendString(string);
        reset();
    }

    protected void deletePortion(int beginIndex, int endIndex) {
        super.deletePortion(beginIndex, endIndex);
        reset();
    }
}
