/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.microedition.system.console;

import javax.microedition.rms.*;
import malik.emulator.microedition.system.*;
import malik.emulator.util.*;

public class ListRecordStoresConsoleCommand extends ConsoleCommand
{
    public ListRecordStoresConsoleCommand() {
        super(
            "записи",
            "Использование:\n записи\nВыводит на консоль список всех записей приложения.\nВ скобках указывается текущее состояние записи: зарезервирована, открыта, закрыта или ошибка."
        );
    }

    protected void execute(String[] arguments, final Console console) {
        ((Thread) (new Thread("записи") {
            public void run() {
                int len;
                String[] records = RecordStore.listRecordStores();
                StringBuilder text = new StringBuilder();
                len = records.length;
                for(int i = 0; i < len; i++)
                {
                    String name = records[i];
                    text.append(name);
                    switch(RecordStore.getState(name))
                    {
                    case RecordStore.STATE_RESERV:
                        text.append(" (зарезервирована)\n");
                        break;
                    case RecordStore.STATE_OPENED:
                        text.append(" (открыта)\n");
                        break;
                    case RecordStore.STATE_CLOSED:
                        text.append(" (закрыта)\n");
                        break;
                    default:
                        text.append(" (ошибка)\n");
                        break;
                    }
                }
                console.println(text.append("Всего записей: ").append(len).toString());
            }
        })).start();
    }
}
