/*
    Редактор шрифтов UFN
    Эта программа создана специально для программы Малик Эмулятор.

    Copyright © 2019, 2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package ru.malik.elaborarer.ufneditor;

import javax.microedition.lcdui.*;
import malik.emulator.fileformats.font.*;

public abstract class FontCustomItem extends CustomItem
{
    final UnicodeRasterFont font;

    public FontCustomItem(UnicodeRasterFont font) {
        super(null);
        this.font = font;
    }

    public void notifyFontChanged() {
    }

    public final UnicodeRasterFont getFont() {
        return font;
    }

    protected abstract void paint(Graphics render, int contentWidth, int contentHeight);

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected int getPrefContentWidth(int contentHeight) {
        return 0;
    }

    protected int getPrefContentHeight(int contentWidth) {
        return 0;
    }
}
