/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Ball;
import arkanoid.NormalBall;
import arkanoid.StandardCaret;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

abstract class Caret {
    protected static final int HEIGHT = 3;
    protected static final int WIDTH = 17;
    protected static Vector balls;
    protected static Caret curCaret;
    protected static int curLevel;
    protected static int X;
    protected static int newX;
    protected static int Y;
    protected static boolean isShown;
    protected static int fLeft;
    protected static int fRight;
    protected static Ball gluedBall;
    protected int width = 17;
    protected int step;

    protected Caret() {
    }

    protected abstract void paintCaret(Graphics var1);

    protected abstract boolean myReflect(Ball var1, Graphics var2);

    protected abstract void myAction(int var1, Graphics var2);

    protected void myInit() {
        Caret.curCaret.width = 17 - curLevel;
        Caret.curCaret.step = Caret.curCaret.width / 3;
    }

    protected void myHide(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(X, Y - 3 + 1, this.width, 3);
    }

    protected void myKeyDown(Graphics g) {
    }

    protected void myKeyUp(Graphics g) {
        if (gluedBall != null) {
            Caret.setGlued(null);
        }
    }

    protected static void setCurrent(Caret caret, Graphics g) {
        Caret.hide(g);
        newX += (Caret.curCaret.width - caret.width) / 2;
        curCaret = caret;
        curCaret.myInit();
        Caret.paint(g);
    }

    public static void hide(Graphics g) {
        if (isShown) {
            curCaret.myHide(g);
            isShown = false;
        }
    }

    protected final void show(Graphics g) {
        if (!isShown) {
            X = newX;
            this.paintCaret(g);
            isShown = true;
        }
    }

    public static void paint(Graphics g) {
        Caret.hide(g);
        curCaret.show(g);
        if (gluedBall != null) {
            gluedBall.paint(g);
        }
    }

    public static void setLevel(int level) {
        curLevel = level;
        curCaret = StandardCaret.getCaret();
        gluedBall = null;
        curCaret.myInit();
    }

    public static void set(int lBorder, int rBorder, int y, Vector vballs) {
        balls = vballs;
        fLeft = lBorder;
        fRight = rBorder;
        int fieldMid = (fLeft + fRight) / 2;
        newX = fieldMid - Caret.curCaret.width / 2;
        Y = y;
        curCaret.myInit();
        NormalBall firstBall = new NormalBall();
        firstBall.set(fieldMid - 4 / 2, Caret.top() - 4);
        firstBall.setSpeed(1, -2);
        Caret.setGlued(firstBall);
    }

    public static void move(int dx) {
        int d = newX + Caret.curCaret.width + (dx *= Caret.curCaret.step) - fRight;
        if (d > 0) {
            dx -= d;
        }
        if ((d = fLeft - newX - dx + 1) > 0) {
            dx += d;
        }
        newX += dx;
        if (gluedBall != null) {
            d = gluedBall.right() + dx - fRight + 1;
            if (d > 0) {
                dx -= d;
            }
            if ((d = fLeft - gluedBall.left() - dx + 1) > 0) {
                dx += d;
            }
            gluedBall.move(dx, 0);
        }
    }

    public static boolean isGlued() {
        return gluedBall != null;
    }

    protected static void setGlued(Ball ball) {
        if (ball != null) {
            balls.removeElement(ball);
        }
        if (gluedBall != null) {
            balls.addElement(gluedBall);
        }
        gluedBall = ball;
    }

    protected static final int left() {
        return newX;
    }

    protected final int right() {
        return newX + this.width - 1;
    }

    public static int top() {
        return Y - 3 + 1;
    }

    public static int bottom() {
        return Y;
    }

    public static boolean reflect(Ball ball, Graphics g) {
        return curCaret.myReflect(ball, g);
    }

    public static void action(int act, Graphics g) {
        curCaret.myAction(act, g);
    }

    public static void keyDown(Graphics g) {
        curCaret.myKeyDown(g);
    }

    public static void keyUp(Graphics g) {
        curCaret.myKeyUp(g);
    }

    static {
        HEIGHT = 3;
        WIDTH = 17;
        isShown = false;
    }
}

