/*
 * Decompiled with CFR 0.152.
 */
package arkanoid;

import arkanoid.Ball;
import arkanoid.Caret;
import arkanoid.StandardCaret;
import javax.microedition.lcdui.Graphics;

class GlueCaret
extends Caret {
    protected static GlueCaret caret = new GlueCaret();
    private static int nofGlues = 0;

    protected GlueCaret() {
    }

    public static GlueCaret getCaret() {
        return caret;
    }

    protected void paintCaret(Graphics g) {
        g.setColor(0);
        int topLine = Caret.Y - 3 + 1;
        g.fillRect(Caret.X, topLine + 1, this.width, 2);
        int i = 0;
        while (i < this.width) {
            int r = i == this.width - 1 ? i : i + 1;
            g.drawLine(Caret.X + i, topLine, Caret.X + r, topLine);
            i += 3;
        }
    }

    protected void myInit() {
        super.myInit();
        nofGlues = 1;
    }

    protected boolean myReflect(Ball ball, Graphics g) {
        if (ball.right() < Caret.left() || ball.left() > this.right()) {
            return false;
        }
        ball.reflectVer(Caret.top());
        Caret.setGlued(ball);
        ball.move(0, Caret.top() - ball.bottom() - 1);
        return true;
    }

    protected void myAction(int act, Graphics g) {
        if (act == 1) {
            ++nofGlues;
        } else {
            StandardCaret.getCaret().myAction(act, g);
        }
    }

    protected void myKeyUp(Graphics g) {
        if (Caret.gluedBall != null) {
            super.myKeyUp(g);
            if (nofGlues > 0) {
                --nofGlues;
            }
            if (nofGlues == 0) {
                Caret.setCurrent(StandardCaret.getCaret(), g);
            }
        }
    }
}

