/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

public class LoadBD {
    private static final boolean DEBUG = false;
    private static ColorBD MyColorBD;
    private static MyGameBase midlet;
    public byte[] imgData;
    public int imgLength;

    public LoadBD(ColorBD colorbd) {
        MyColorBD = colorbd;
        midlet = ColorBD.midlet;
        this.imgData = new byte[3072];
    }

    public static int RandomC64(int seed) {
        int lo = seed & 0xFF;
        int hi = seed >> 8 & 0xFF;
        int a = (hi & 1) << 7;
        int b = lo >> 1 & 0x7F;
        int r = lo + ((lo & 1) << 7);
        int c = r >> 8;
        r = (r & 0xFF) + c + 19;
        c = r >> 8;
        lo = r & 0xFF;
        r = hi + c + a;
        c = r >> 8;
        r = (r & 0xFF) + c + b;
        hi = r & 0xFF;
        return hi * 256 + lo;
    }

    private byte Translate(int c) {
        return MyGameBase.replace[c];
    }

    private void DrawLine(int x, int y, int aLength, int aDirection, short id) {
        if (x >= 0 && x <= 39 && y >= 0 && y <= 24 && aLength >= 1 && aLength <= 40 && aDirection >= 0 && aDirection <= 7) {
            for (int counter = 1; counter <= aLength; ++counter) {
                ColorBD.Cave[0 + 40 * y + x] = (byte)id;
                x += MyGameBase.DrawLine_X[aDirection];
                y += MyGameBase.DrawLine_Y[aDirection];
            }
        }
    }

    private void DrawFilledRect(int x, int y, int aWidth, int aHeight, short id, short fid) {
        for (int counter1 = 0; counter1 < aWidth; ++counter1) {
            for (int counter2 = 0; counter2 < aHeight; ++counter2) {
                ColorBD.Cave[0 + 40 * (y + counter2) + x + counter1] = (byte)fid;
            }
        }
        this.DrawRect(x, y, aWidth, aHeight, id);
    }

    private void DrawRect(int x, int y, int aWidth, int aHeight, short id) {
        if (x >= 0 && x <= 39 && y >= 0 && y <= 24 && aWidth >= 1 && aWidth <= 40 && aHeight >= 0 && aHeight <= 22) {
            int counter1;
            for (counter1 = 0; counter1 < aWidth; ++counter1) {
                ColorBD.Cave[0 + 40 * y + x + counter1] = (byte)id;
                ColorBD.Cave[0 + 40 * (y + aHeight - 1) + x + counter1] = (byte)id;
            }
            for (counter1 = 0; counter1 < aHeight; ++counter1) {
                ColorBD.Cave[0 + 40 * (y + counter1) + x] = (byte)id;
                ColorBD.Cave[0 + 40 * (y + counter1) + x + aWidth - 1] = (byte)id;
            }
        }
    }

    private short[] ReadLevelData(String file, int level) {
        short[] data = new short[512];
        int i = 0;
        try {
            int b;
            InputStream is = this.getClass().getResourceAsStream("/res_bd/" + file);
            is.read();
            is.read();
            for (int l = 0; l < level; ++l) {
                for (i = 0; i < 26; ++i) {
                    is.read();
                }
                while (is.read() != 255) {
                }
            }
            data[i++] = (short)level;
            for (i = 0; i < 26; ++i) {
                b = is.read();
                data[i] = (short)b;
            }
            i = 26;
            while (true) {
                b = is.read();
                data[i] = (short)b;
                if (b == 255 || b == -1) break;
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("ReadLevelData Exception: " + e);
        }
        return data;
    }

    public boolean LoadLevel(String GameFile, int level, int difficulty) {
        int i = 0;
        short[] buf = this.ReadLevelData(GameFile, MyGameBase.caves[level % 20]);
        for (int j = 0; j < 960; ++j) {
            ColorBD.Cave[j] = this.Translate(1);
        }
        ColorBD.caveTimer = buf[i + 0];
        ColorBD.caveWTimer = buf[i + 0];
        ColorBD.caveGemVal = buf[i + 1];
        ColorBD.caveXGemVal = buf[i + 2];
        ColorBD.caveGems = buf[i + 8 + difficulty];
        ColorBD.caveTime = buf[i + 13 + difficulty];
        int seed = buf[i + 3 + difficulty];
        for (int y = 1; y <= 21; ++y) {
            for (int x = 0; x <= 39; ++x) {
                short ID = 1;
                seed = LoadBD.RandomC64(seed);
                short prob = (short)(seed >> 8);
                for (int r = 0; r <= 3; ++r) {
                    if (prob >= buf[i + 27 - 5 + r]) continue;
                    ID = buf[i + 23 - 5 + r];
                }
                ColorBD.Cave[80 + 40 * y + x] = this.Translate((byte)ID);
            }
        }
        this.DrawRect(0, 2, 40, 22, this.Translate(7));
        this.DrawLine(0, 24, 40, 2, this.Translate(7));
        try {
            short c;
            int cd = i + 31 - 5;
            while ((c = buf[cd]) != 255) {
                short ID = (short)(c & 0x3F);
                switch (3 & c >> 6) {
                    case 0: {
                        int x = buf[++cd];
                        short y = buf[++cd];
                        ColorBD.Cave[0 + 40 * y + x] = this.Translate((byte)ID);
                        if (ID != 37) break;
                        ColorBD.posX = x;
                        ColorBD.posY = y - 2;
                        break;
                    }
                    case 1: {
                        int x = buf[++cd];
                        short y = buf[++cd];
                        short l = buf[++cd];
                        short d = buf[++cd];
                        this.DrawLine(x, y, l, d, this.Translate(ID));
                        break;
                    }
                    case 2: {
                        int x = buf[++cd];
                        short y = buf[++cd];
                        short w = buf[++cd];
                        short h = buf[++cd];
                        short FID = buf[++cd];
                        this.DrawFilledRect(x, y, w, h, this.Translate(ID), this.Translate(FID));
                        break;
                    }
                    case 3: {
                        int x = buf[++cd];
                        short y = buf[++cd];
                        short w = buf[++cd];
                        short h = buf[++cd];
                        this.DrawRect(x, y, w, h, this.Translate(ID));
                    }
                }
                ++cd;
            }
        }
        catch (Exception e) {
            System.out.println("Level Draw: " + e);
        }
        buf = null;
        return true;
    }

    private int ReadImageData(String file) {
        int len = 0;
        try {
            InputStream is = this.getClass().getResourceAsStream("/res_bd/" + file);
            len = is.read(this.imgData, 0, 3072);
            is.close();
        }
        catch (Exception e) {
            System.out.println("ReadImageData(): " + e);
        }
        this.imgLength = len;
        return len;
    }

    public void ReadImage(String file) {
        byte[] d = this.imgData;
        int len = this.ReadImageData(file);
    }

    public void SetImagePalette(int pal) {
        byte[] d = this.imgData;
        int[] c = MyGameBase.rgb;
        int[] t = ColorBD.midlet.colors == 0 ? MyGameBase.tblA : MyGameBase.tblB;
        int p = MyGameBase.caves[pal % 20] * 4;
        for (int i = 0; i < 256; ++i) {
            if (d[i] != 80 || d[i + 1] != 76 || d[i + 2] != 84 || d[i + 3] != 69) continue;
            System.out.println("PLTE at " + i);
            i += 4;
            d[i++] = (byte)c[t[p + 0] * 3 + 0];
            d[i++] = (byte)c[t[p + 0] * 3 + 1];
            d[i++] = (byte)c[t[p + 0] * 3 + 2];
            d[i++] = (byte)c[t[p + 3] * 3 + 0];
            d[i++] = (byte)c[t[p + 3] * 3 + 1];
            d[i++] = (byte)c[t[p + 3] * 3 + 2];
            d[i++] = (byte)c[t[p + 1] * 3 + 0];
            d[i++] = (byte)c[t[p + 1] * 3 + 1];
            d[i++] = (byte)c[t[p + 1] * 3 + 2];
            d[i++] = (byte)((c[t[p + 0] * 3 + 0] + c[t[p + 3] * 3 + 0]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 1] + c[t[p + 3] * 3 + 1]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 2] + c[t[p + 3] * 3 + 2]) / 2);
            d[i++] = (byte)((c[t[p + 2] * 3 + 0] + c[t[p + 3] * 3 + 0]) / 2);
            d[i++] = (byte)((c[t[p + 2] * 3 + 1] + c[t[p + 3] * 3 + 1]) / 2);
            d[i++] = (byte)((c[t[p + 2] * 3 + 2] + c[t[p + 3] * 3 + 2]) / 2);
            d[i++] = (byte)c[t[p + 2] * 3 + 0];
            d[i++] = (byte)c[t[p + 2] * 3 + 1];
            d[i++] = (byte)c[t[p + 2] * 3 + 2];
            d[i++] = (byte)((c[t[p + 0] * 3 + 0] + c[t[p + 2] * 3 + 0]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 1] + c[t[p + 2] * 3 + 1]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 2] + c[t[p + 2] * 3 + 2]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 0] + c[t[p + 1] * 3 + 0]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 1] + c[t[p + 1] * 3 + 1]) / 2);
            d[i++] = (byte)((c[t[p + 0] * 3 + 2] + c[t[p + 1] * 3 + 2]) / 2);
            d[i++] = (byte)((c[t[p + 1] * 3 + 0] + c[t[p + 2] * 3 + 0]) / 2);
            d[i++] = (byte)((c[t[p + 1] * 3 + 1] + c[t[p + 2] * 3 + 1]) / 2);
            d[i++] = (byte)((c[t[p + 1] * 3 + 2] + c[t[p + 2] * 3 + 2]) / 2);
            break;
        }
    }
}

