/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.AffineTransform;
import com.motorola.iden.micro3d.Light;
import com.motorola.iden.micro3d.Vector3D;

public class Layout3D {
    public static final int PARALLEL_SCALE = 24;
    public static final int PARALLEL_WIDTH = 25;
    public static final int PARALLEL_WIDTH_HEIGHT = 26;
    public static final int PERSPECTIVE_FOV = 21;
    public static final int PERSPECTIVE_WIDTH = 22;
    public static final int PERSPECTIVE_WIDTH_HEIGHT = 23;
    Light light;
    boolean isSemiTransparent;
    boolean isToonShaded;
    int toonThreshold;
    int toonHighColor;
    int toonLowColor;
    private AffineTransform viewPointTransform;
    private AffineTransform viewTransform;
    int projectionType = 24;
    final int[] projectionParameters = new int[]{4096, 4096, 0, 0};
    Vector3D rotateAxis;
    int rotateAngle;

    public Light getLight() {
        return this.light;
    }

    public int[] getProjectionParameters() {
        int[] nArray = this.projectionParameters;
        switch (this.projectionType) {
            case 24: 
            case 26: {
                return new int[]{nArray[0], nArray[1]};
            }
            case 25: {
                return new int[]{nArray[0]};
            }
            case 21: 
            case 22: {
                return new int[]{nArray[0], nArray[1], nArray[2]};
            }
            case 23: {
                return new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.projectionType);
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int getToonHighColor() {
        return this.toonHighColor;
    }

    public int getToonLowColor() {
        return this.toonLowColor;
    }

    public int getToonThreshold() {
        return this.toonThreshold;
    }

    public AffineTransform getViewPointTransform() {
        if (this.viewPointTransform == null) {
            Vector3D vector3D = new Vector3D();
            Vector3D vector3D2 = new Vector3D(0, 0, 4096);
            Vector3D vector3D3 = new Vector3D(0, 4096, 0);
            this.viewPointTransform = AffineTransform.getViewPointTransform(vector3D, vector3D2, vector3D3);
        }
        return this.viewPointTransform;
    }

    public AffineTransform getViewTransform() {
        return this.viewTransform;
    }

    public boolean isSemiTransparent() {
        return this.isSemiTransparent;
    }

    public boolean isToonShaded() {
        return this.isToonShaded;
    }

    public void rotateV(Vector3D vector3D, int n2) {
        this.rotateAngle = n2;
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(vector3D);
        } else {
            this.rotateAxis.set(vector3D);
        }
        this.viewTransform = null;
    }

    public void rotateX(int n2) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(4096, 0, 0);
        } else {
            this.rotateAxis.set(4096, 0, 0);
        }
        this.rotateAngle = n2;
        this.viewTransform = null;
    }

    public void rotateY(int n2) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(0, 4096, 0);
        } else {
            this.rotateAxis.set(0, 4096, 0);
        }
        this.rotateAngle = n2;
        this.viewTransform = null;
    }

    public void rotateZ(int n2) {
        if (this.rotateAxis == null) {
            this.rotateAxis = new Vector3D(0, 0, 4096);
        } else {
            this.rotateAxis.set(0, 0, 4096);
        }
        this.rotateAngle = n2;
        this.viewTransform = null;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public void setProjection(int n2, int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        switch (n2) {
            case 24: 
            case 26: {
                if (nArray.length < 2) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = nArray[0];
                this.projectionParameters[1] = nArray[1];
                break;
            }
            case 25: {
                if (nArray.length < 1) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = nArray[0];
                break;
            }
            case 21: {
                if (nArray.length < 3) {
                    throw new IllegalArgumentException();
                }
                int n3 = nArray[0];
                int n4 = nArray[1];
                int n5 = nArray[2];
                if (n3 >= n4 || n3 < 1 || n4 > Short.MAX_VALUE || n5 < 1 || n5 > 2047) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = n3;
                this.projectionParameters[1] = n4;
                this.projectionParameters[2] = n5;
                break;
            }
            case 22: {
                if (nArray.length < 3) {
                    throw new IllegalArgumentException();
                }
                int n6 = nArray[0];
                int n7 = nArray[1];
                int n8 = nArray[2];
                if (n6 >= n7 || n6 < 1 || n7 > Short.MAX_VALUE || n8 < 0) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = n6;
                this.projectionParameters[1] = n7;
                this.projectionParameters[2] = n8;
                break;
            }
            case 23: {
                if (nArray.length < 4) {
                    throw new IllegalArgumentException();
                }
                int n9 = nArray[0];
                int n10 = nArray[1];
                int n11 = nArray[2];
                int n12 = nArray[3];
                if (n9 >= n10 || n9 < 1 || n10 > Short.MAX_VALUE || n11 < 0 || n12 < 0) {
                    throw new IllegalArgumentException();
                }
                this.projectionParameters[0] = n9;
                this.projectionParameters[1] = n10;
                this.projectionParameters[2] = n11;
                this.projectionParameters[3] = n12;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.projectionType = n2;
    }

    public void setSemiTransparent(boolean bl2) {
        this.isSemiTransparent = bl2;
    }

    public void setToonShading(boolean bl2) {
        this.isToonShaded = bl2;
    }

    public void setToonShading(int n2, int n3, int n4) {
        if ((n2 & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException();
        }
        this.toonThreshold = n2;
        this.toonHighColor = n3;
        this.toonLowColor = n4;
    }

    public void setViewPoint(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        this.setViewPointTransform(AffineTransform.getViewPointTransform(vector3D, vector3D2, vector3D3));
    }

    public void setViewPointTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new NullPointerException();
        }
        this.viewPointTransform = affineTransform;
    }

    public void setViewTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new NullPointerException();
        }
        this.viewTransform = affineTransform;
    }
}

