/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackReference$AttachOptions;
import com.sun.jna.CallbackReference$DefaultCallbackProxy;
import com.sun.jna.CallbackReference$NativeFunctionHandler;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure$ByValue;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.win32.DLLCallback;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map directCallbackMap = new WeakHashMap();
    static final Map pointerCallbackMap = new WeakHashMap();
    static final Map allocations = new WeakHashMap();
    private static final Map allocatedMemory = Collections.synchronizedMap(new WeakHashMap());
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Map initializers;
    Pointer cbstruct;
    Pointer trampoline;
    CallbackProxy proxy;
    Method method;
    int callingConvention;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CallbackThreadInitializer setCallbackThreadInitializer(Callback callback, CallbackThreadInitializer callbackThreadInitializer) {
        Map map = initializers;
        synchronized (map) {
            if (callbackThreadInitializer != null) {
                return initializers.put(callback, callbackThreadInitializer);
            }
            return (CallbackThreadInitializer)initializers.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadGroup initializeThread(Callback callback, CallbackReference$AttachOptions callbackReference$AttachOptions) {
        CallbackThreadInitializer callbackThreadInitializer = null;
        if (callback instanceof CallbackReference$DefaultCallbackProxy) {
            callback = ((CallbackReference$DefaultCallbackProxy)callback).getCallback();
        }
        Object object = initializers;
        synchronized (object) {
            callbackThreadInitializer = (CallbackThreadInitializer)initializers.get(callback);
        }
        object = null;
        if (callbackThreadInitializer != null) {
            object = callbackThreadInitializer.getThreadGroup(callback);
            callbackReference$AttachOptions.name = callbackThreadInitializer.getName(callback);
            callbackReference$AttachOptions.daemon = callbackThreadInitializer.isDaemon(callback);
            callbackReference$AttachOptions.detach = callbackThreadInitializer.detach(callback);
            callbackReference$AttachOptions.write();
        }
        return object;
    }

    public static Callback getCallback(Class clazz, Pointer pointer) {
        return CallbackReference.getCallback(clazz, pointer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Callback getCallback(Class clazz, Pointer pointer, boolean bl2) {
        if (pointer == null) {
            return null;
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Callback type must be an interface");
        }
        Map map = bl2 ? directCallbackMap : callbackMap;
        Map map2 = pointerCallbackMap;
        synchronized (map2) {
            Callback callback = null;
            Reference reference = (Reference)pointerCallbackMap.get(pointer);
            if (reference != null) {
                callback = (Callback)reference.get();
                if (callback != null && !clazz.isAssignableFrom(callback.getClass())) {
                    throw new IllegalStateException("Pointer " + pointer + " already mapped to " + callback + ".\nNative code may be re-using a default function pointer, in which case you may need to use a common Callback class wherever the function pointer is reused.");
                }
                return callback;
            }
            int n2 = AltCallingConvention.class.isAssignableFrom(clazz) ? 63 : 0;
            HashMap<String, Method> hashMap = new HashMap<String, Method>(Native.getLibraryOptions(clazz));
            hashMap.put("invoking-method", CallbackReference.getCallbackMethod(clazz));
            CallbackReference$NativeFunctionHandler callbackReference$NativeFunctionHandler = new CallbackReference$NativeFunctionHandler(pointer, n2, hashMap);
            callback = (Callback)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)callbackReference$NativeFunctionHandler);
            map.remove(callback);
            pointerCallbackMap.put(pointer, new WeakReference<Callback>(callback));
            return callback;
        }
    }

    private CallbackReference(Callback callback, int n2, boolean bl2) {
        super(callback);
        Object object;
        TypeMapper typeMapper = Native.getTypeMapper(callback.getClass());
        this.callingConvention = n2;
        boolean bl3 = Platform.isPPC();
        if (bl2) {
            object = CallbackReference.getCallbackMethod(callback);
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (bl3 && (classArray[i2] == Float.TYPE || classArray[i2] == Double.TYPE)) {
                    bl2 = false;
                    break;
                }
                if (typeMapper == null || typeMapper.getFromNativeConverter(classArray[i2]) == null) continue;
                bl2 = false;
                break;
            }
            if (typeMapper != null && typeMapper.getToNativeConverter(((Method)object).getReturnType()) != null) {
                bl2 = false;
            }
        }
        object = Native.getStringEncoding(callback.getClass());
        long l2 = 0L;
        if (bl2) {
            this.method = CallbackReference.getCallbackMethod(callback);
            Class[] classArray = this.method.getParameterTypes();
            Class<?> clazz = this.method.getReturnType();
            int n3 = 1;
            if (callback instanceof DLLCallback) {
                n3 |= 2;
            }
            l2 = Native.createNativeCallback(callback, this.method, classArray, clazz, n2, n3, (String)object);
        } else {
            int n4;
            Object object2;
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new CallbackReference$DefaultCallbackProxy(this, CallbackReference.getCallbackMethod(callback), typeMapper, (String)object);
            Class[] classArray = this.proxy.getParameterTypes();
            Class clazz = this.proxy.getReturnType();
            if (typeMapper != null) {
                for (int i3 = 0; i3 < classArray.length; ++i3) {
                    object2 = typeMapper.getFromNativeConverter(classArray[i3]);
                    if (object2 == null) continue;
                    classArray[i3] = object2.nativeType();
                }
                ToNativeConverter toNativeConverter = typeMapper.getToNativeConverter(clazz);
                if (toNativeConverter != null) {
                    clazz = toNativeConverter.nativeType();
                }
            }
            for (n4 = 0; n4 < classArray.length; ++n4) {
                classArray[n4] = this.getNativeType(classArray[n4]);
                if (CallbackReference.isAllowableNativeType(classArray[n4])) continue;
                object2 = "Callback argument " + classArray[n4] + " requires custom type conversion";
                throw new IllegalArgumentException((String)object2);
            }
            if (!CallbackReference.isAllowableNativeType(clazz = this.getNativeType(clazz))) {
                String string = "Callback return type " + clazz + " requires custom type conversion";
                throw new IllegalArgumentException(string);
            }
            n4 = callback instanceof DLLCallback ? 2 : 0;
            l2 = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, classArray, clazz, n2, n4, (String)object);
        }
        this.cbstruct = l2 != 0L ? new Pointer(l2) : null;
        allocatedMemory.put(this, new WeakReference<CallbackReference>(this));
    }

    private Class getNativeType(Class clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            Structure.validate(clazz);
            if (!Structure$ByValue.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                return NativeMappedConverter.getInstance(clazz).nativeType();
            }
            if (clazz == String.class || clazz == WString.class || clazz == String[].class || clazz == WString[].class || Callback.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        }
        return clazz;
    }

    private static Method checkMethod(Method method) {
        if (method.getParameterTypes().length > 256) {
            String string = "Method signature exceeds the maximum parameter count: " + method;
            throw new UnsupportedOperationException(string);
        }
        return method;
    }

    static Class findCallbackClass(Class clazz) {
        if (!Callback.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not derived from com.sun.jna.Callback");
        }
        if (clazz.isInterface()) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!Callback.class.isAssignableFrom(classArray[i2])) continue;
            try {
                CallbackReference.getCallbackMethod(classArray[i2]);
                return classArray[i2];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
        }
        if (Callback.class.isAssignableFrom(clazz.getSuperclass())) {
            return CallbackReference.findCallbackClass(clazz.getSuperclass());
        }
        return clazz;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    private static Method getCallbackMethod(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        Method[] methodArray2 = clazz.getMethods();
        HashSet<Method> hashSet = new HashSet<Method>(Arrays.asList(methodArray));
        hashSet.retainAll(Arrays.asList(methodArray2));
        Method[] methodArray3 = hashSet.iterator();
        while (methodArray3.hasNext()) {
            Method method = (Method)methodArray3.next();
            if (!Callback.FORBIDDEN_NAMES.contains(method.getName())) continue;
            methodArray3.remove();
        }
        methodArray3 = hashSet.toArray(new Method[hashSet.size()]);
        if (methodArray3.length == 1) {
            return CallbackReference.checkMethod(methodArray3[0]);
        }
        for (int i2 = 0; i2 < methodArray3.length; ++i2) {
            Method method = methodArray3[i2];
            if (!"callback".equals(method.getName())) continue;
            return CallbackReference.checkMethod(method);
        }
        String string = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException(string);
    }

    private void setCallbackOptions(int n2) {
        this.cbstruct.setInt(Native.POINTER_SIZE, n2);
    }

    public Pointer getTrampoline() {
        if (this.trampoline == null) {
            this.trampoline = this.cbstruct.getPointer(0L);
        }
        return this.trampoline;
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.cbstruct != null) {
            try {
                Native.freeNativeCallback(this.cbstruct.peer);
            }
            finally {
                this.cbstruct.peer = 0L;
                this.cbstruct = null;
                allocatedMemory.remove(this);
            }
        }
    }

    static void disposeAll() {
        LinkedList linkedList = new LinkedList(allocatedMemory.keySet());
        for (CallbackReference callbackReference : linkedList) {
            callbackReference.dispose();
        }
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback callback) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(callback.getClass()) && (invocationHandler = Proxy.getInvocationHandler(callback)) instanceof CallbackReference$NativeFunctionHandler) {
            return ((CallbackReference$NativeFunctionHandler)invocationHandler).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback callback) {
        return CallbackReference.getFunctionPointer(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pointer getFunctionPointer(Callback callback, boolean bl2) {
        Pointer pointer = null;
        if (callback == null) {
            return null;
        }
        pointer = CallbackReference.getNativeFunctionPointer(callback);
        if (pointer != null) {
            return pointer;
        }
        Map map = Native.getLibraryOptions(callback.getClass());
        int n2 = callback instanceof AltCallingConvention ? 63 : (map != null && map.containsKey("calling-convention") ? (Integer)map.get("calling-convention") : 0);
        Map map2 = bl2 ? directCallbackMap : callbackMap;
        Map map3 = pointerCallbackMap;
        synchronized (map3) {
            CallbackReference callbackReference = (CallbackReference)map2.get(callback);
            if (callbackReference == null) {
                callbackReference = new CallbackReference(callback, n2, bl2);
                map2.put(callback, callbackReference);
                pointerCallbackMap.put(callbackReference.getTrampoline(), new WeakReference<Callback>(callback));
                if (initializers.containsKey(callback)) {
                    callbackReference.setCallbackOptions(1);
                }
            }
            return callbackReference.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class clazz) {
        return clazz == Void.TYPE || clazz == Void.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Character.TYPE || clazz == Character.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || Structure$ByValue.class.isAssignableFrom(clazz) && Structure.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz);
    }

    private static Pointer getNativeString(Object object, boolean bl2) {
        if (object != null) {
            NativeString nativeString = new NativeString(object.toString(), bl2);
            allocations.put(object, nativeString);
            return nativeString.getPointer();
        }
        return null;
    }

    static /* synthetic */ Callback access$000(CallbackReference callbackReference) {
        return callbackReference.getCallback();
    }

    static /* synthetic */ Pointer access$100(Object object, boolean bl2) {
        return CallbackReference.getNativeString(object, bl2);
    }

    static {
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod("callback", Object[].class);
        }
        catch (Exception exception) {
            throw new Error("Error looking up CallbackProxy.callback() method");
        }
        initializers = new WeakHashMap();
    }
}

