/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.IEnumMoniker;
import com.sun.jna.platform.win32.COM.IRunningObjectTable;
import com.sun.jna.platform.win32.COM.Moniker;
import com.sun.jna.platform.win32.COM.util.EnumMoniker$1;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinDef$ULONGByReference;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.PointerByReference;
import java.util.Iterator;

public class EnumMoniker
implements Iterable {
    ObjectFactory factory;
    IRunningObjectTable rawRot;
    IEnumMoniker raw;
    Moniker rawNext;

    protected EnumMoniker(IEnumMoniker iEnumMoniker, IRunningObjectTable iRunningObjectTable, ObjectFactory objectFactory) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        this.rawRot = iRunningObjectTable;
        this.raw = iEnumMoniker;
        this.factory = objectFactory;
        WinNT$HRESULT winNT$HRESULT = iEnumMoniker.Reset();
        COMUtils.checkRC(winNT$HRESULT);
        this.cacheNext();
    }

    protected void cacheNext() {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        PointerByReference pointerByReference = new PointerByReference();
        WinDef$ULONGByReference winDef$ULONGByReference = new WinDef$ULONGByReference();
        WinNT$HRESULT winNT$HRESULT = this.raw.Next(new WinDef$ULONG(1L), pointerByReference, winDef$ULONGByReference);
        if (WinNT.S_OK.equals(winNT$HRESULT) && winDef$ULONGByReference.getValue().intValue() > 0) {
            this.rawNext = new Moniker(pointerByReference.getValue());
        } else {
            if (!WinNT.S_FALSE.equals(winNT$HRESULT)) {
                COMUtils.checkRC(winNT$HRESULT);
            }
            this.rawNext = null;
        }
    }

    public Iterator iterator() {
        return new EnumMoniker$1(this);
    }
}

