/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinUser$RAWINPUTDEVICELIST;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;

public final class User32Util {
    public static final int registerWindowMessage(String string) {
        int n2 = User32.INSTANCE.RegisterWindowMessage(string);
        if (n2 == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return n2;
    }

    public static final WinDef$HWND createWindow(String string, String string2, int n2, int n3, int n4, int n5, int n6, WinDef$HWND winDef$HWND, WinDef.HMENU hMENU, WinDef.HINSTANCE hINSTANCE, WinDef.LPVOID lPVOID) {
        return User32Util.createWindowEx(0, string, string2, n2, n3, n4, n5, n6, winDef$HWND, hMENU, hINSTANCE, lPVOID);
    }

    public static final WinDef$HWND createWindowEx(int n2, String string, String string2, int n3, int n4, int n5, int n6, int n7, WinDef$HWND winDef$HWND, WinDef.HMENU hMENU, WinDef.HINSTANCE hINSTANCE, WinDef.LPVOID lPVOID) {
        WinDef$HWND winDef$HWND2 = User32.INSTANCE.CreateWindowEx(n2, string, string2, n3, n4, n5, n6, n7, winDef$HWND, hMENU, hINSTANCE, lPVOID);
        if (winDef$HWND2 == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winDef$HWND2;
    }

    public static final void destroyWindow(WinDef$HWND winDef$HWND) {
        if (!User32.INSTANCE.DestroyWindow(winDef$HWND)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final List GetRawInputDeviceList() {
        IntByReference intByReference = new IntByReference(0);
        WinUser$RAWINPUTDEVICELIST winUser$RAWINPUTDEVICELIST = new WinUser$RAWINPUTDEVICELIST();
        int n2 = winUser$RAWINPUTDEVICELIST.sizeof();
        int n3 = User32.INSTANCE.GetRawInputDeviceList(null, intByReference, n2);
        if (n3 != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        int n4 = intByReference.getValue();
        WinUser$RAWINPUTDEVICELIST[] winUser$RAWINPUTDEVICELISTArray = (WinUser$RAWINPUTDEVICELIST[])winUser$RAWINPUTDEVICELIST.toArray(n4);
        n3 = User32.INSTANCE.GetRawInputDeviceList(winUser$RAWINPUTDEVICELISTArray, intByReference, n2);
        if (n3 == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (n3 != winUser$RAWINPUTDEVICELISTArray.length) {
            throw new IllegalStateException("Mismatched allocated (" + winUser$RAWINPUTDEVICELISTArray.length + ") vs. received devices count (" + n3 + ")");
        }
        return Arrays.asList(winUser$RAWINPUTDEVICELISTArray);
    }
}

