/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Quaternion;
import emulator.graphics3D.Vector4f;

public final class Transform3D {
    public float[] m_matrix = new float[16];
    private static final float[] a = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public Transform3D() {
        this.setIdentity();
    }

    public final void setIdentity() {
        System.arraycopy(a, 0, this.m_matrix, 0, 16);
    }

    public final void get(float[] fArray) {
        System.arraycopy(this.m_matrix, 0, fArray, 0, 16);
    }

    public final void set(float[] fArray) {
        System.arraycopy(fArray, 0, this.m_matrix, 0, 16);
    }

    public final void set(Transform3D transform3D) {
        System.arraycopy(transform3D.m_matrix, 0, this.m_matrix, 0, 16);
    }

    public final void invert() {
        if (!G3DUtils.Invert4x4(this.m_matrix)) {
            throw new ArithmeticException();
        }
    }

    public final void transpose() {
        this.a(1, 4);
        this.a(2, 8);
        this.a(3, 12);
        this.a(7, 13);
        this.a(11, 14);
        this.a(6, 9);
    }

    private void a(int n2, int n3) {
        float f2 = this.m_matrix[n2];
        this.m_matrix[n2] = this.m_matrix[n3];
        this.m_matrix[n3] = f2;
    }

    public final void postMultiply(Transform3D transform3D, boolean bl2) {
        float[] fArray = new float[16];
        float[] fArray2 = (bl2 ? this : transform3D).m_matrix;
        float[] fArray3 = (bl2 ? transform3D : this).m_matrix;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                int n2 = i3 << 2;
                int n3 = n2 + i2;
                fArray[n3] = fArray[n3] + fArray2[0 + i2] * fArray3[n2 + 0];
                int n4 = n2 + i2;
                fArray[n4] = fArray[n4] + fArray2[4 + i2] * fArray3[n2 + 1];
                int n5 = n2 + i2;
                fArray[n5] = fArray[n5] + fArray2[8 + i2] * fArray3[n2 + 2];
                int n6 = n2 + i2;
                fArray[n6] = fArray[n6] + fArray2[12 + i2] * fArray3[n2 + 3];
            }
        }
        System.arraycopy(fArray, 0, this.m_matrix, 0, 16);
    }

    public final void postRotate(float f2, float f3, float f4, float f5) {
        Quaternion quaternion = new Quaternion();
        quaternion.setAngleAxis(f2, f3, f4, f5);
        this.postRotateQuat(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public final void postRotateQuat(float f2, float f3, float f4, float f5) {
        Quaternion quaternion = new Quaternion(f2, f3, f4, f5);
        quaternion.normalize();
        Transform3D transform3D = new Transform3D();
        float[] fArray = transform3D.m_matrix;
        float f6 = quaternion.x * quaternion.x;
        float f7 = quaternion.x * quaternion.y;
        float f8 = quaternion.x * quaternion.z;
        float f9 = quaternion.x * quaternion.w;
        float f10 = quaternion.y * quaternion.y;
        float f11 = quaternion.y * quaternion.z;
        float f12 = quaternion.y * quaternion.w;
        float f13 = quaternion.z * quaternion.z;
        float f14 = quaternion.z * quaternion.w;
        fArray[0] = 1.0f - 2.0f * (f10 + f13);
        fArray[1] = 2.0f * (f7 - f14);
        fArray[2] = 2.0f * (f8 + f12);
        fArray[4] = 2.0f * (f7 + f14);
        fArray[5] = 1.0f - 2.0f * (f6 + f13);
        fArray[6] = 2.0f * (f11 - f9);
        fArray[8] = 2.0f * (f8 - f12);
        fArray[9] = 2.0f * (f11 + f9);
        fArray[10] = 1.0f - 2.0f * (f6 + f10);
        this.postMultiply(transform3D, false);
    }

    public final void postScale(float f2, float f3, float f4) {
        this.m_matrix[0] = this.m_matrix[0] * f2;
        this.m_matrix[1] = this.m_matrix[1] * f3;
        this.m_matrix[2] = this.m_matrix[2] * f4;
        this.m_matrix[4] = this.m_matrix[4] * f2;
        this.m_matrix[5] = this.m_matrix[5] * f3;
        this.m_matrix[6] = this.m_matrix[6] * f4;
        this.m_matrix[8] = this.m_matrix[8] * f2;
        this.m_matrix[9] = this.m_matrix[9] * f3;
        this.m_matrix[10] = this.m_matrix[10] * f4;
        this.m_matrix[12] = this.m_matrix[12] * f2;
        this.m_matrix[13] = this.m_matrix[13] * f3;
        this.m_matrix[14] = this.m_matrix[14] * f4;
    }

    public final void postTranslate(float f2, float f3, float f4) {
        this.m_matrix[3] = this.m_matrix[3] + (this.m_matrix[0] * f2 + this.m_matrix[1] * f3 + this.m_matrix[2] * f4);
        this.m_matrix[7] = this.m_matrix[7] + (this.m_matrix[4] * f2 + this.m_matrix[5] * f3 + this.m_matrix[6] * f4);
        this.m_matrix[11] = this.m_matrix[11] + (this.m_matrix[8] * f2 + this.m_matrix[9] * f3 + this.m_matrix[10] * f4);
        this.m_matrix[15] = this.m_matrix[15] + (this.m_matrix[12] * f2 + this.m_matrix[13] * f3 + this.m_matrix[14] * f4);
    }

    private void a(float[] fArray, int n2) {
        float f2 = this.m_matrix[0] * fArray[n2 + 0] + this.m_matrix[1] * fArray[n2 + 1] + this.m_matrix[2] * fArray[n2 + 2] + this.m_matrix[3] * fArray[n2 + 3];
        float f3 = this.m_matrix[4] * fArray[n2 + 0] + this.m_matrix[5] * fArray[n2 + 1] + this.m_matrix[6] * fArray[n2 + 2] + this.m_matrix[7] * fArray[n2 + 3];
        float f4 = this.m_matrix[8] * fArray[n2 + 0] + this.m_matrix[9] * fArray[n2 + 1] + this.m_matrix[10] * fArray[n2 + 2] + this.m_matrix[11] * fArray[n2 + 3];
        float f5 = this.m_matrix[12] * fArray[n2 + 0] + this.m_matrix[13] * fArray[n2 + 1] + this.m_matrix[14] * fArray[n2 + 2] + this.m_matrix[15] * fArray[n2 + 3];
        fArray[n2 + 0] = f2;
        fArray[n2 + 1] = f3;
        fArray[n2 + 2] = f4;
        fArray[n2 + 3] = f5;
    }

    public final void transform(float[] fArray) {
        for (int i2 = 0; i2 < fArray.length; i2 += 4) {
            this.a(fArray, i2);
        }
    }

    public final void transform(Vector4f vector4f) {
        float f2 = this.m_matrix[0] * vector4f.x + this.m_matrix[1] * vector4f.y + this.m_matrix[2] * vector4f.z + this.m_matrix[3] * vector4f.w;
        float f3 = this.m_matrix[4] * vector4f.x + this.m_matrix[5] * vector4f.y + this.m_matrix[6] * vector4f.z + this.m_matrix[7] * vector4f.w;
        float f4 = this.m_matrix[8] * vector4f.x + this.m_matrix[9] * vector4f.y + this.m_matrix[10] * vector4f.z + this.m_matrix[11] * vector4f.w;
        float f5 = this.m_matrix[12] * vector4f.x + this.m_matrix[13] * vector4f.y + this.m_matrix[14] * vector4f.z + this.m_matrix[15] * vector4f.w;
        vector4f.x = f2;
        vector4f.y = f3;
        vector4f.z = f4;
        vector4f.w = f5;
    }
}

