/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.Settings;
import emulator.debug.Profiler;
import emulator.q;
import emulator.ui.IScreen;
import emulator.y;
import java.util.Arrays;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;
import javax.microedition.lcdui.c;
import javax.microedition.lcdui.d;
import javax.microedition.lcdui.e;
import javax.microedition.lcdui.f;
import javax.microedition.lcdui.g;
import javax.microedition.lcdui.h;
import javax.microedition.lcdui.i;
import javax.microedition.lcdui.j;
import javax.microedition.lcdui.k;
import kemnn.cF;
import kemnn.cG;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Displayable {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int W = 2;
    public static final int H = 3;
    String title;
    Vector commands;
    boolean menuShown;
    CommandListener cmdListener = null;
    Item focusedItem = null;
    int w;
    int h;
    int[] bounds;
    Ticker ticker;
    int tickerX;
    private static long lastFrameTime;
    private static long lastFpsUpdateTime;
    private static int framesCount;
    boolean fullScreen;
    private static final long MILLI_TO_NANO = 1000000L;
    Composite swtContent;
    private Rectangle swtContentArea;
    private boolean swtInitialized;
    Menu swtMenu;
    SelectionListener swtMenuSelectionListener = new k(this);
    private final MenuListener swtMenuListener = new j(this);
    boolean forceUpdateSize;
    static KeyListener swtKeyListener;
    private Command leftCommand;
    private Command rightCommand;
    private final Vector menuCommands = new Vector();

    public Displayable() {
        this.commands = new Vector();
        IScreen iScreen = Emulator.getEmulator().getScreen();
        this.w = iScreen.getWidth();
        this.h = iScreen.getHeight();
        this.bounds = this instanceof Canvas ? new int[]{0, 0, this.w, this.h - Screen.fontHeight4} : new int[]{0, Screen.fontHeight4, this.w - 4, this.h - Screen.fontHeight4};
    }

    public int getWidth() {
        if (this.swtContentArea != null) {
            return this.swtContentArea.width;
        }
        return this.bounds[2];
    }

    public int getHeight() {
        if (this.swtContentArea != null) {
            return this.swtContentArea.height;
        }
        return this.bounds[3];
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isShown() {
        return Display.a == this;
    }

    protected void defocus() {
        if (this.focusedItem != null) {
            this.focusedItem.defocus();
            this.focusedItem = null;
        }
    }

    protected void setItemCommands(Item item) {
        this.focusedItem = item;
        this.updateCommands();
    }

    protected void removeItemCommands(Item item) {
        if (item == null || item != this.focusedItem) {
            return;
        }
        this.focusedItem = null;
        this.updateCommands();
    }

    /*
     * WARNING - void declaration
     */
    protected void updateCommands() {
        void var4_9;
        this.leftCommand = null;
        this.rightCommand = null;
        Object object = null;
        int n2 = 0;
        this.menuCommands.clear();
        Object[] objectArray = this.commands.toArray(new Command[0]);
        Arrays.sort(objectArray);
        if (this.focusedItem != null && (n2 = this.focusedItem.commands.size()) > 0) {
            this.menuCommands.addAll(this.focusedItem.commands);
        }
        this.menuCommands.addAll(Arrays.asList(objectArray));
        block4: for (Object object2 : objectArray) {
            int n3 = ((Command)object2).getCommandType();
            switch (n3) {
                case 4: {
                    if (object != null) continue block4;
                    object = object2;
                    this.menuCommands.remove(object2);
                    this.menuCommands.insertElementAt(object2, n2);
                    continue block4;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    if (this.rightCommand != null) continue block4;
                    this.rightCommand = object2;
                    this.menuCommands.remove(object2);
                }
            }
        }
        String string = "";
        String string2 = "";
        if (this.menuCommands.size() > 1) {
            String string3 = y.a("LCDUI_MENU_COMMAND", "Menu");
        } else if (this.menuCommands.size() != 0) {
            String string4 = ((Command)this.menuCommands.get(0)).getLabel();
        } else if (this.leftCommand != null) {
            String string5 = this.leftCommand.getLabel();
        }
        if (this.rightCommand != null) {
            string2 = this.rightCommand.getLabel();
        }
        Emulator.getEmulator().getScreen().setCommandLeft((String)var4_9);
        Emulator.getEmulator().getScreen().setCommandRight(string2);
    }

    protected boolean isCommandsEmpty() {
        return this.commands.isEmpty();
    }

    public void addCommand(Command command) {
        if (command == null || this.commands.contains(command)) {
            return;
        }
        this.commands.add(command);
        if (Emulator.getCurrentDisplay().getCurrent() == this) {
            this.updateCommands();
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.contains(command)) {
            this.commands.remove(command);
            if (Emulator.getCurrentDisplay().getCurrent() == this) {
                this.updateCommands();
            }
        }
    }

    protected Command getLeftSoftCommand() {
        if (this.menuCommands.size() != 0) {
            return (Command)this.menuCommands.get(0);
        }
        return this.leftCommand;
    }

    protected Command getRightSoftCommand() {
        return this.rightCommand;
    }

    public boolean handleSoftKeyAction(int n2, boolean bl2) {
        if (this.cmdListener == null && this instanceof Canvas) {
            return false;
        }
        if (q.a(n2)) {
            if (this.menuCommands.size() > 1) {
                if (bl2 && this.menuShown) {
                    this.menuShown = false;
                    if (this.swtMenu != null) {
                        this.hideSwtMenu();
                    } else {
                        this.repaintScreen();
                    }
                } else if (bl2) {
                    this.menuShown = true;
                    if (this.swtMenu != null) {
                        this.showSwtMenu(false, -1, -1);
                    } else {
                        this.repaintScreen();
                    }
                }
                return !Settings.motorolaSoftKeyFix;
            }
            Command command = this.getLeftSoftCommand();
            if (bl2 && command != null) {
                Emulator.getEmulator().getLogStream().println("Left command: " + command);
                if (this instanceof Alert && command == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().a(command, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(command)) {
                    Emulator.getEventQueue().a(command, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().a(command, this);
                }
            }
            return command != null && !Settings.motorolaSoftKeyFix;
        }
        if (q.b(n2)) {
            Command command = this.getRightSoftCommand();
            if (bl2 && command != null) {
                Emulator.getEmulator().getLogStream().println("Right command: " + command);
                if (this instanceof Alert && command == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().a(command, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(command)) {
                    Emulator.getEventQueue().a(command, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().a(command, this);
                }
            }
            return command != null && !Settings.motorolaSoftKeyFix;
        }
        return false;
    }

    public void _callCommandAction(Command command) {
        if (this.cmdListener != null && command != null) {
            this.cmdListener.commandAction(command, this);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.cmdListener = commandListener;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.isShown()) {
            Displayable.syncExec(new c(this));
        }
    }

    protected void sizeChanged(int n2, int n3) {
    }

    public void _invokeSizeChanged(int n2, int n3) {
        this._invokeSizeChanged(n2, n3, true);
    }

    void _invokeSizeChanged(int n2, int n3, boolean bl2) {
        IScreen iScreen = Emulator.getEmulator().getScreen();
        if (this.swtContent != null) {
            Displayable.asyncExec(new d(this));
            iScreen.repaint();
            return;
        }
        if (this.w != n2 || this.h != n3 || this.forceUpdateSize) {
            this.forceUpdateSize = false;
            this.w = n2;
            this.h = n3;
            if (!this.fullScreen) {
                n3 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
            }
            if (!(this instanceof Canvas)) {
                n2 -= 4;
            }
            this.bounds[2] = n2;
            this.bounds[3] = n3;
            if (bl2) {
                this.sizeChanged(n2, n3);
            }
        }
        this.repaintScreen();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.tickerX = this.w;
        this.updateSize(true);
    }

    protected void _paintTicker(Graphics graphics) {
        if (this.ticker == null) {
            if (!this.fullScreen && this instanceof Canvas) {
                graphics.setColor(-1);
                graphics.fillRect(0, this.bounds[3], this.w, Screen.fontHeight4);
            }
            return;
        }
        kemnn.f.b(graphics, 0, Screen.fontHeight4 + this.bounds[3] - 1, this.w, Screen.fontHeight4);
        String string = this.ticker.getString();
        if (string == null) {
            return;
        }
        graphics.setFont(Screen.font);
        graphics.drawString(string, this.tickerX, Screen.fontHeight4 + this.bounds[3] - 1 + 2, 0);
        this.tickerX -= 5;
        if (this.tickerX < -Screen.font.stringWidth(string)) {
            this.tickerX = this.w;
        }
    }

    void repaintScreen() {
        int n2;
        if (this instanceof Canvas) {
            n2 = 1;
        } else {
            if (!(this instanceof Screen)) {
                return;
            }
            n2 = 4;
        }
        try {
            Emulator.getEventQueue().d(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void repaintScreen(Item item) {
        this.repaintScreen();
    }

    protected void _paintSoftMenu(Graphics graphics) {
        kemnn.k.a(graphics, Emulator.getCurrentDisplay().getCurrent());
    }

    public static void _fpsLimiter(boolean bl2) {
        long l2;
        long l3;
        long l4;
        if (bl2 && Settings.speedModifier == 1 && Settings.frameRate <= 120 && (l4 = (l3 = 1000000000L / (long)Settings.frameRate) - (l2 = System.nanoTime() - lastFrameTime)) > 0L) {
            try {
                Thread.sleep(l4 / 1000000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        lastFrameTime = System.nanoTime();
        if (bl2) {
            ++framesCount;
        }
        if ((l2 = lastFrameTime - lastFpsUpdateTime) >= 2000000000L) {
            Profiler.FPS = (int)(((long)framesCount * 1000L + 500L) * 1000000L / l2);
            lastFpsUpdateTime = lastFrameTime;
            framesCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void _checkForSteps(Object object) {
        if (Settings.steps >= 0) {
            if (Settings.steps == 0) {
                long l2 = System.currentTimeMillis();
                try {
                    while (Settings.steps == 0) {
                        if (object == null) {
                            Thread.sleep(50L);
                            continue;
                        }
                        Object object2 = object;
                        synchronized (object2) {
                            object.wait(50L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Settings.aLong1235 += System.currentTimeMillis() - l2;
            }
            --Settings.steps;
        }
    }

    public static void _resetXRayGraphics() {
        Graphics.resetXRayCache();
    }

    void constructSwt() {
        Displayable.syncExec(new e(this));
    }

    protected Composite _constructSwtContent(int n2) {
        return new Composite(Displayable.getSwtParent(), 0);
    }

    protected Rectangle _layoutSwtContent() {
        Rectangle rectangle = Displayable.getSwtParent().getClientArea();
        this.swtContent.setBounds(0, 0, rectangle.width, rectangle.height);
        return this.swtContent.getClientArea();
    }

    public Composite _getSwtContent() {
        return this.swtContent;
    }

    protected void finalize() {
        Displayable.syncExec(new f(this));
        super.finalize();
    }

    static Composite getSwtParent() {
        return ((cG)Emulator.getEmulator().getScreen()).a();
    }

    static void syncExec(Runnable runnable) {
        cF.a(runnable);
    }

    static void asyncExec(Runnable runnable) {
        cF.b(runnable);
    }

    static void safeSyncExec(Runnable runnable) {
        try {
            cF.a(runnable);
        }
        catch (SWTException sWTException) {
            Throwable throwable = sWTException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected void _shown() {
        this.updateSize(false);
    }

    public void _swtHidden() {
    }

    public void _swtShown() {
        if (this.swtContent != null && !this.swtContent.isDisposed()) {
            this._swtUpdateSizes();
        } else if (this.swtMenu == null) {
            this.swtInitMenu();
        }
    }

    public void _swtUpdateSizes() {
        Rectangle rectangle = this._layoutSwtContent();
        if (this.swtContentArea == null || !this.swtInitialized || rectangle.width != this.swtContentArea.width || rectangle.height != this.swtContentArea.height) {
            this.swtInitialized = true;
            this.swtContentArea = rectangle;
            this._swtResized(rectangle.width, rectangle.height);
        }
    }

    void swtInitMenu() {
        if (this.swtMenu != null) {
            return;
        }
        this.swtMenu = new Menu(Displayable.getSwtParent());
        this.swtMenu.addMenuListener(this.swtMenuListener);
        Displayable.getSwtParent().setMenu(this.swtMenu);
    }

    void showSwtMenu(boolean bl2, int n2, int n3) {
        Displayable.syncExec(new g(this, bl2, n2, n3));
    }

    void hideSwtMenu() {
        Displayable.syncExec(new h(this));
    }

    void swtUpdateMenuCommands(boolean bl2) {
        for (MenuItem menuItem : this.swtMenu.getItems()) {
            menuItem.dispose();
        }
        for (int i2 = 0; i2 < this.menuCommands.size(); ++i2) {
            Command command = (Command)this.menuCommands.get(i2);
            MenuItem menuItem = new MenuItem(this.swtMenu, 8);
            menuItem.addSelectionListener(this.swtMenuSelectionListener);
            menuItem.setData(command);
            menuItem.setText(command.getLongLabel());
        }
    }

    public void _swtResized(int n2, int n3) {
    }

    void updateSize(boolean bl2) {
        IScreen iScreen = Emulator.getEmulator().getScreen();
        if (bl2) {
            this.forceUpdateSize = true;
            this._invokeSizeChanged(iScreen.getWidth(), iScreen.getHeight(), false);
            this.forceUpdateSize = true;
        }
        if (Emulator.getCurrentDisplay().getCurrent() != this) {
            return;
        }
        Emulator.getEventQueue().d(iScreen.getWidth(), iScreen.getHeight());
    }

    static /* synthetic */ Rectangle access$002(Displayable displayable, Rectangle rectangle) {
        displayable.swtContentArea = rectangle;
        return displayable.swtContentArea;
    }

    static {
        swtKeyListener = new i();
        lastFpsUpdateTime = lastFrameTime = System.nanoTime();
        framesCount = 0;
    }
}

