/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.Component$Identifier$Axis;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Controller;
import net.java.games.input.DIIdentifierMap;
import net.java.games.input.RawDevice;
import net.java.games.input.RawDeviceInfo;
import net.java.games.input.RawMouse;
import net.java.games.input.RawMouse$Axis;
import net.java.games.input.RawMouse$Button;
import net.java.games.input.Rumbler;
import net.java.games.input.SetupAPIDevice;

class RawMouseInfo
extends RawDeviceInfo {
    private final RawDevice device;
    private final int id;
    private final int num_buttons;
    private final int sample_rate;

    public RawMouseInfo(RawDevice rawDevice, int n2, int n3, int n4) {
        this.device = rawDevice;
        this.id = n2;
        this.num_buttons = n3;
        this.sample_rate = n4;
    }

    @Override
    public final int getUsage() {
        return 2;
    }

    @Override
    public final int getUsagePage() {
        return 1;
    }

    @Override
    public final long getHandle() {
        return this.device.getHandle();
    }

    @Override
    public final Controller createControllerFromDevice(RawDevice rawDevice, SetupAPIDevice setupAPIDevice) {
        if (this.num_buttons == 0) {
            return null;
        }
        Component[] componentArray = new Component[3 + this.num_buttons];
        int n2 = 0;
        componentArray[n2++] = new RawMouse$Axis(rawDevice, Component$Identifier$Axis.X);
        componentArray[n2++] = new RawMouse$Axis(rawDevice, Component$Identifier$Axis.Y);
        componentArray[n2++] = new RawMouse$Axis(rawDevice, Component$Identifier$Axis.Z);
        for (int i2 = 0; i2 < this.num_buttons; ++i2) {
            Component$Identifier$Button component$Identifier$Button = DIIdentifierMap.mapMouseButtonIdentifier(DIIdentifierMap.getButtonIdentifier(i2));
            componentArray[n2++] = new RawMouse$Button(rawDevice, component$Identifier$Button, i2);
        }
        RawMouse rawMouse = new RawMouse(setupAPIDevice.getName(), rawDevice, componentArray, new Controller[0], new Rumbler[0]);
        return rawMouse;
    }
}

