/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

public final class ZipShort
implements Cloneable {
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private int value;

    public ZipShort(int n2) {
        this.value = n2;
    }

    public ZipShort(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipShort(byte[] byArray, int n2) {
        this.value = ZipShort.getValue(byArray, n2);
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(this.value & 0xFF);
        byArray2[1] = (byte)((this.value & 0xFF00) >> 8);
        return byArray2;
    }

    public final int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int n2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 & 0xFF);
        byArray2[1] = (byte)((n2 & 0xFF00) >> 8);
        return byArray2;
    }

    public static int getValue(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] << 8 & 0xFF00;
        return n3 += byArray[n2] & 0xFF;
    }

    public static int getValue(byte[] byArray) {
        return ZipShort.getValue(byArray, 0);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)object).getValue();
    }

    public final int hashCode() {
        return this.value;
    }
}

