/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridj.BridJ;
import org.bridj.JNI;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary$SymbolAccepter;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.ann.Name;
import org.bridj.ann.Symbol;
import org.bridj.demangling.Demangler$MemberRef;
import org.bridj.demangling.Demangler$Symbol;
import org.bridj.demangling.GCC4Demangler;
import org.bridj.demangling.VC9Demangler;
import org.bridj.util.AnnotationUtils;

public class NativeLibrary {
    volatile long handle;
    volatile long symbols;
    String path;
    final File canonicalFile;
    NativeEntities nativeEntities = new NativeEntities();
    Map addrToName;
    Map nameToSym;

    protected NativeLibrary(String string, long l2, long l3) {
        this.path = string;
        this.handle = l2;
        this.symbols = l3;
        this.canonicalFile = string == null ? null : new File(string).getCanonicalFile();
        Platform.addNativeLibrary(this);
    }

    long getSymbolsHandle() {
        return this.symbols;
    }

    NativeEntities getNativeEntities() {
        return this.nativeEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String followGNULDScript(String string) {
        try (Reader reader = new FileReader(string);){
            String string2;
            char c2;
            while ((c2 = (char)reader.read()) == ' ' || c2 == '\t' || c2 == '\n') {
            }
            if (c2 != '/') return string;
            if (reader.read() != 42) return string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            reader = bufferedReader;
            StringBuilder stringBuilder = new StringBuilder("/*");
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append('\n');
            }
            String string3 = stringBuilder.toString();
            Pattern pattern = Pattern.compile("GROUP\\s*\\(\\s*([^\\s)]+)[^)]*\\)");
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find()) {
                String string4 = matcher.group(1);
                if (BridJ.verbose) {
                    BridJ.info("Parsed LD script '" + string + "', found absolute reference to '" + string4 + "'");
                }
                String string5 = string4;
                return string5;
            }
            BridJ.error("Failed to parse LD script '" + string + "' !");
            return string;
        }
        catch (Throwable throwable) {
            BridJ.error("Unexpected error: " + throwable, throwable);
        }
        return string;
    }

    public static NativeLibrary load(String string) {
        long l2 = 0L;
        File file = new File(string);
        boolean bl2 = file.exists();
        if (file.isAbsolute() && !bl2) {
            return null;
        }
        if (Platform.isUnix() && bl2) {
            string = NativeLibrary.followGNULDScript(string);
        }
        if ((l2 = JNI.loadLibrary(string)) == 0L) {
            return null;
        }
        long l3 = JNI.loadLibrarySymbols(string);
        return new NativeLibrary(string, l2, l3);
    }

    long getHandle() {
        if (this.path != null && this.handle == 0L) {
            throw new RuntimeException("Library was released and cannot be used anymore");
        }
        return this.handle;
    }

    protected void finalize() {
        this.release();
    }

    public synchronized void release() {
        if (this.handle == 0L) {
            return;
        }
        if (BridJ.verbose) {
            BridJ.info("Releasing library '" + this.path + "'");
        }
        this.nativeEntities.release();
        JNI.freeLibrarySymbols(this.symbols);
        JNI.freeLibrary(this.handle);
        this.handle = 0L;
        if (this.canonicalFile != null && Platform.temporaryExtractedLibraryCanonicalFiles.remove(this.canonicalFile)) {
            if (this.canonicalFile.delete()) {
                if (BridJ.verbose) {
                    BridJ.info("Deleted temporary library file '" + this.canonicalFile + "'");
                }
            } else {
                BridJ.error("Failed to delete temporary library file '" + this.canonicalFile + "'");
            }
        }
    }

    public Pointer getSymbolPointer(String string) {
        return Pointer.pointerToAddress(this.getSymbolAddress(string));
    }

    public long getSymbolAddress(String string) {
        Demangler$Symbol demangler$Symbol;
        if (this.nameToSym != null && (demangler$Symbol = (Demangler$Symbol)this.nameToSym.get(string)) != null) {
            return demangler$Symbol.getAddress();
        }
        long l2 = JNI.findSymbolInLibrary(this.getHandle(), string);
        if (l2 == 0L) {
            l2 = JNI.findSymbolInLibrary(this.getHandle(), "_" + string);
        }
        return l2;
    }

    public synchronized Demangler$Symbol getSymbol(AnnotatedElement annotatedElement) {
        Symbol symbol = (Symbol)AnnotationUtils.getAnnotation(Symbol.class, annotatedElement, new Annotation[0]);
        String string = null;
        Name name = annotatedElement.getAnnotation(Name.class);
        if (name != null) {
            string = name.value();
        } else if (annotatedElement instanceof Member) {
            string = ((Member)((Object)annotatedElement)).getName();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (symbol != null) {
            arrayList.addAll(Arrays.asList(symbol.value()));
        }
        if (string != null) {
            arrayList.add(string);
        }
        for (String object : arrayList) {
            Demangler$Symbol demangler$Symbol = this.getSymbol(object);
            if (demangler$Symbol == null) {
                demangler$Symbol = this.getSymbol("_" + object);
            }
            if (demangler$Symbol == null) {
                demangler$Symbol = this.getSymbol(object + (Platform.useUnicodeVersionOfWindowsAPIs ? "W" : "A"));
            }
            if (demangler$Symbol == null) continue;
            return demangler$Symbol;
        }
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            for (Demangler$Symbol demangler$Symbol : this.getSymbols()) {
                if (!demangler$Symbol.matches(method)) continue;
                return demangler$Symbol;
            }
        }
        return null;
    }

    public boolean isMSVC() {
        return Platform.isWindows();
    }

    public Demangler$Symbol getFirstMatchingSymbol(NativeLibrary$SymbolAccepter nativeLibrary$SymbolAccepter) {
        for (Demangler$Symbol demangler$Symbol : this.getSymbols()) {
            if (!nativeLibrary$SymbolAccepter.accept(demangler$Symbol)) continue;
            return demangler$Symbol;
        }
        return null;
    }

    public Collection getSymbols() {
        block2: {
            try {
                this.scanSymbols();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || BridJ.error("Failed to scan symbols of library '" + this.path + "'", exception)) break block2;
                throw new AssertionError();
            }
        }
        return this.nameToSym == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.nameToSym.values());
    }

    public String getSymbolName(long l2) {
        if (this.addrToName == null && this.getSymbolsHandle() != 0L) {
            return JNI.findSymbolName(this.getHandle(), this.getSymbolsHandle(), l2);
        }
        Demangler$Symbol demangler$Symbol = this.getSymbol(l2);
        return demangler$Symbol == null ? null : demangler$Symbol.getSymbol();
    }

    public Demangler$Symbol getSymbol(long l2) {
        try {
            this.scanSymbols();
            Demangler$Symbol demangler$Symbol = (Demangler$Symbol)this.addrToName.get(l2);
            return demangler$Symbol;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get name of address " + l2, exception);
        }
    }

    public Demangler$Symbol getSymbol(String string) {
        try {
            long l2;
            if (this.nameToSym == null && (l2 = JNI.findSymbolInLibrary(this.getHandle(), string)) != 0L) {
                Demangler$Symbol demangler$Symbol = new Demangler$Symbol(string, this);
                demangler$Symbol.setAddress(l2);
                return demangler$Symbol;
            }
            this.scanSymbols();
            if (this.nameToSym == null) {
                return null;
            }
            Demangler$Symbol demangler$Symbol = (Demangler$Symbol)this.nameToSym.get(string);
            if (this.addrToName == null && demangler$Symbol == null && (l2 = JNI.findSymbolInLibrary(this.getHandle(), string)) != 0L) {
                demangler$Symbol = new Demangler$Symbol(string, this);
                demangler$Symbol.setAddress(l2);
                this.nameToSym.put(string, demangler$Symbol);
            }
            return demangler$Symbol;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    void scanSymbols() {
        if (this.addrToName != null) {
            return;
        }
        this.nameToSym = new HashMap();
        String[] stringArray = null;
        if (stringArray == null) {
            stringArray = JNI.getLibrarySymbols(this.getHandle(), this.getSymbolsHandle());
        }
        if (stringArray == null) {
            return;
        }
        this.addrToName = new HashMap();
        boolean bl2 = !Platform.is64Bits();
        for (String string : stringArray) {
            void object;
            Object object2;
            if (string == null) continue;
            long l2 = JNI.findSymbolInLibrary(this.getHandle(), string);
            if (l2 == 0L && string.startsWith("_")) {
                object2 = string.substring(1);
                l2 = JNI.findSymbolInLibrary(this.getHandle(), (String)object2);
                if (l2 == 0L) {
                    object2 = "_" + string;
                    l2 = JNI.findSymbolInLibrary(this.getHandle(), (String)object2);
                }
                if (l2 != 0L) {
                    Object object3 = object2;
                }
            }
            if (l2 == 0L) {
                if (!BridJ.verbose) continue;
                BridJ.warning("Symbol '" + (String)object + "' not found.");
                continue;
            }
            object2 = new Demangler$Symbol((String)object, this);
            ((Demangler$Symbol)object2).setAddress(l2);
            this.addrToName.put(l2, object2);
            this.nameToSym.put(object, object2);
        }
        if (BridJ.debug) {
            BridJ.info("Found " + this.nameToSym.size() + " symbols in '" + this.path + "' :");
            for (Demangler$Symbol demangler$Symbol : this.nameToSym.values()) {
                BridJ.info("DEBUG(BridJ): library=\"" + this.path + "\", symbol=\"" + demangler$Symbol.getSymbol() + "\", address=" + Long.toHexString(demangler$Symbol.getAddress()) + ", demangled=\"" + demangler$Symbol.getParsedRef() + "\"");
            }
        }
    }

    public Demangler$MemberRef parseSymbol(String string) {
        if ("__cxa_pure_virtual".equals(string)) {
            return null;
        }
        if (Platform.isWindows()) {
            try {
                Demangler$MemberRef demangler$MemberRef = new VC9Demangler(this, string).parseSymbol();
                if (demangler$MemberRef != null) {
                    return demangler$MemberRef;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new GCC4Demangler(this, string).parseSymbol();
    }
}

