/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ListIterator;
import org.bridj.AbstractIntegral;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.CommonPointerIOs;
import org.bridj.DefaultNativeList;
import org.bridj.DynamicCallback;
import org.bridj.DynamicFunction;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.NativeList;
import org.bridj.NativeObject;
import org.bridj.NativeObjectInterface;
import org.bridj.Platform;
import org.bridj.Pointer$1;
import org.bridj.Pointer$2;
import org.bridj.Pointer$3;
import org.bridj.Pointer$4;
import org.bridj.Pointer$5;
import org.bridj.Pointer$6;
import org.bridj.Pointer$7;
import org.bridj.Pointer$DisorderedPointer;
import org.bridj.Pointer$FreeReleaser;
import org.bridj.Pointer$ListType;
import org.bridj.Pointer$OrderedPointer;
import org.bridj.Pointer$Releaser;
import org.bridj.Pointer$StringType;
import org.bridj.PointerIO;
import org.bridj.PointerLRUCache;
import org.bridj.SizeT;
import org.bridj.ann.Convention$Style;
import org.bridj.util.DefaultParameterizedType;
import org.bridj.util.Utils;

public abstract class Pointer
implements Comparable,
Iterable {
    public static final Pointer NULL = null;
    public static final int SIZE = Platform.POINTER_SIZE;
    protected static final long UNKNOWN_VALIDITY = -1L;
    protected static final long NO_PARENT = 0L;
    private static final long POINTER_MASK;
    public static final int defaultAlignment;
    protected final PointerIO io;
    private final long peer_;
    protected final long offsetInParent;
    protected final Pointer parent;
    protected volatile Object sibling;
    protected final long validStart;
    protected final long validEnd;
    Throwable creationTrace;
    Throwable deletionTrace;
    Throwable releaseTrace;
    private static final int LRU_POINTER_CACHE_SIZE = 8;
    private static final int LRU_POINTER_CACHE_TOLERANCE = 1;
    private static final ThreadLocal localCachedPointers;
    static Pointer$Releaser freeReleaser;

    Pointer(PointerIO pointerIO, long l2, long l3, long l4, Pointer pointer, long l5, Object object) {
        this.io = pointerIO;
        this.peer_ = l2;
        this.validStart = l3;
        this.validEnd = l4;
        this.parent = pointer;
        this.offsetInParent = l5;
        this.sibling = object;
        if (l2 == 0L) {
            throw new IllegalArgumentException("Pointer instance cannot have NULL peer ! (use null Pointer instead)");
        }
        if (BridJ.debugPointers) {
            this.creationTrace = new RuntimeException().fillInStackTrace();
        }
    }

    public static Type pointerType(Type type) {
        return DefaultParameterizedType.paramType(Pointer.class, new Type[]{type});
    }

    public static Type intEnumType(Class clazz) {
        return DefaultParameterizedType.paramType(IntValuedEnum.class, new Type[]{clazz});
    }

    public synchronized void release() {
        Object object = this.sibling;
        this.sibling = null;
        if (object instanceof Pointer) {
            ((Pointer)object).release();
        }
        if (BridJ.debugPointerReleases) {
            this.releaseTrace = new RuntimeException().fillInStackTrace();
        }
    }

    public int compareTo(Pointer pointer) {
        long l2;
        if (pointer == null) {
            return 1;
        }
        long l3 = this.getPeer();
        return l3 == (l2 = pointer.getPeer()) ? 0 : (l3 < l2 ? -1 : 1);
    }

    public int compareBytes(Pointer pointer, long l2) {
        return this.compareBytesAtOffset(0L, pointer, 0L, l2);
    }

    public int compareBytesAtOffset(long l2, Pointer pointer, long l3, long l4) {
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        return JNI.memcmp(l5, pointer.getCheckedPeer(l3, l4), l4);
    }

    public int hashCode() {
        int n2 = new Long(this.getPeer()).hashCode();
        return n2;
    }

    public String toString() {
        return "Pointer(peer = 0x" + Long.toHexString(this.getPeer()) + ", targetType = " + Utils.toString(this.getTargetType()) + ", order = " + this.order() + ")";
    }

    protected final void invalidPeer(long l2, long l3) {
        throw new IndexOutOfBoundsException("Cannot access to memory data of length " + l3 + " at offset " + (l2 - this.getPeer()) + " : valid memory start is " + this.validStart + ", valid memory size is " + (this.validEnd - this.validStart));
    }

    private final long getCheckedPeer(long l2, long l3) {
        long l4 = this.getPeer() + l2;
        if (this.validStart != -1L && (l4 < this.validStart || l4 + l3 > this.validEnd)) {
            this.invalidPeer(l4, l3);
        }
        return l4;
    }

    public Pointer offset(long l2) {
        return this.offset(l2, this.getIO());
    }

    Pointer offset(long l2, PointerIO pointerIO) {
        Object object;
        if (l2 == 0L) {
            return pointerIO == this.io ? this : this.as(pointerIO);
        }
        long l3 = this.getPeer() + l2;
        Object object2 = object = this.getSibling() != null ? this.getSibling() : this;
        if (this.validStart == -1L) {
            return Pointer.newPointer(pointerIO, l3, this.isOrdered(), -1L, -1L, null, 0L, null, object);
        }
        if (l3 > this.validEnd || l3 < this.validStart) {
            throw new IndexOutOfBoundsException("Invalid pointer offset : " + l2 + " (validBytes = " + this.getValidBytes() + ") !");
        }
        return Pointer.newPointer(pointerIO, l3, this.isOrdered(), this.validStart, this.validEnd, null, 0L, null, object);
    }

    public Pointer validBytes(long l2) {
        long l3 = this.getPeer();
        long l4 = l3 + l2;
        if (this.validStart == l3 && this.validEnd == l4) {
            return this;
        }
        if (this.validEnd != -1L && l4 > this.validEnd) {
            throw new IndexOutOfBoundsException("Cannot extend validity of pointed memory from " + this.validEnd + " to " + l4);
        }
        Object object = this.getSibling() != null ? this.getSibling() : this;
        return Pointer.newPointer(this.getIO(), l3, this.isOrdered(), this.validStart, l4, this.parent, this.offsetInParent, null, object);
    }

    public Pointer withoutValidityInformation() {
        long l2 = this.getPeer();
        if (this.validStart == -1L) {
            return this;
        }
        Object object = this.getSibling() != null ? this.getSibling() : this;
        return Pointer.newPointer(this.getIO(), l2, this.isOrdered(), -1L, -1L, this.parent, this.offsetInParent, null, object);
    }

    public Pointer clone() {
        long l2 = this.getValidElements();
        if (l2 < 0L) {
            throw new UnsupportedOperationException("Number of bytes unknown, unable to clone memory (use validBytes(long))");
        }
        Pointer pointer = Pointer.allocateArray(this.getIO(), l2);
        this.copyTo(pointer);
        return pointer;
    }

    public Pointer validElements(long l2) {
        return this.validBytes(l2 * this.getIO("Cannot define elements validity").getTargetSize());
    }

    public Pointer getReference() {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot get reference to this pointer, it wasn't created from Pointer.getPointer(offset) or from a similar method.");
        }
        PointerIO pointerIO = this.getIO();
        return this.parent.offset(this.offsetInParent).as(pointerIO == null ? null : pointerIO.getReferenceIO());
    }

    public final long getPeer() {
        if (BridJ.debugPointerReleases && this.releaseTrace != null) {
            throw new RuntimeException("Pointer was released here:\n\t" + Utils.toString(this.releaseTrace).replaceAll("\n", "\n\t"));
        }
        return this.peer_;
    }

    public static Pointer allocateDynamicCallback(DynamicCallback dynamicCallback, Convention$Style convention$Style, Type type, Type ... typeArray) {
        if (dynamicCallback == null) {
            throw new IllegalArgumentException("Java callback handler cannot be null !");
        }
        if (type == null) {
            throw new IllegalArgumentException("Callback return type cannot be null !");
        }
        if (typeArray == null) {
            throw new IllegalArgumentException("Invalid (null) list of parameter types !");
        }
        try {
            MethodCallInfo methodCallInfo = new MethodCallInfo(type, typeArray, false);
            Method method = DynamicCallback.class.getMethod("apply", Object[].class);
            methodCallInfo.setMethod(method);
            methodCallInfo.setJavaSignature("([Ljava/lang/Object;)Ljava/lang/Object;");
            methodCallInfo.setCallingConvention(convention$Style);
            methodCallInfo.setGenericCallback(true);
            methodCallInfo.setJavaCallback(dynamicCallback);
            return CRuntime.createCToJavaCallback(methodCallInfo, DynamicCallback.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to allocate dynamic callback for convention " + (Object)((Object)convention$Style) + ", return type " + Utils.toString(type) + " and parameter types " + Arrays.asList(typeArray) + " : " + exception, exception);
        }
    }

    public Pointer as(PointerIO pointerIO) {
        return this.viewAs(this.isOrdered(), pointerIO);
    }

    public Pointer order(ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.nativeOrder()) == this.isOrdered()) {
            return this;
        }
        return this.viewAs(!this.isOrdered(), this.getIO());
    }

    public ByteOrder order() {
        ByteOrder byteOrder = this.isOrdered() ? ByteOrder.nativeOrder() : (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        return byteOrder;
    }

    Pointer viewAs(boolean bl2, PointerIO pointerIO) {
        if (pointerIO == this.io && bl2 == this.isOrdered()) {
            return this;
        }
        return Pointer.newPointer(pointerIO, this.getPeer(), bl2, this.getValidStart(), this.getValidEnd(), this.getParent(), this.getOffsetInParent(), null, this.getSibling() != null ? this.getSibling() : this);
    }

    public final PointerIO getIO() {
        return this.io;
    }

    public abstract boolean isOrdered();

    final long getOffsetInParent() {
        return this.offsetInParent;
    }

    final Pointer getParent() {
        return this.parent;
    }

    final Object getSibling() {
        return this.sibling;
    }

    final long getValidEnd() {
        return this.validEnd;
    }

    final long getValidStart() {
        return this.validStart;
    }

    public Pointer as(Type type) {
        PointerIO pointerIO = PointerIO.getInstance(type);
        return this.as(pointerIO);
    }

    public Pointer as(Class clazz) {
        return this.as((Type)clazz);
    }

    public DynamicFunction asDynamicFunction(Convention$Style convention$Style, Type type, Type ... typeArray) {
        return CRuntime.getInstance().getDynamicFunctionFactory(null, convention$Style, type, typeArray).newInstance(this);
    }

    public Pointer asUntyped() {
        return this.as((Class)null);
    }

    public long getValidBytes() {
        long l2 = this.getValidEnd();
        return l2 == -1L ? -1L : l2 - this.getPeer();
    }

    public long getValidElements() {
        long l2 = this.getValidBytes();
        long l3 = this.getTargetSize();
        if (l2 < 0L || l3 <= 0L) {
            return -1L;
        }
        return l2 / l3;
    }

    public ListIterator iterator() {
        return new Pointer$1(this);
    }

    public static Pointer pointerToEnum(IntValuedEnum intValuedEnum) {
        Class<?> clazz;
        if (intValuedEnum instanceof FlagSet) {
            clazz = ((FlagSet)((Object)intValuedEnum)).getEnumClass();
        } else if (intValuedEnum instanceof Enum) {
            clazz = intValuedEnum.getClass();
        } else {
            throw new RuntimeException("Expected a FlagSet or an Enum, got " + intValuedEnum);
        }
        PointerIO pointerIO = PointerIO.getInstance(DefaultParameterizedType.paramType(IntValuedEnum.class, new Type[]{clazz}));
        Pointer pointer = Pointer.allocate(pointerIO);
        pointer.setInt((int)intValuedEnum.value());
        return pointer;
    }

    public static Pointer pointerTo(NativeObject nativeObject) {
        return Pointer.getPointer(nativeObject);
    }

    public static Pointer getPointer(NativeObject nativeObject) {
        return Pointer.getPointer(nativeObject, null);
    }

    public static Pointer getPointer(NativeObjectInterface nativeObjectInterface) {
        return Pointer.getPointer((NativeObject)nativeObjectInterface);
    }

    public static Pointer getPointer(NativeObject nativeObject, Type type) {
        return nativeObject == null ? null : nativeObject.peer;
    }

    public static long getAddress(NativeObject nativeObject, Class clazz) {
        return Pointer.getPeer(Pointer.getPointer(nativeObject, clazz));
    }

    public NativeObject getNativeObjectAtOffset(long l2, Type type) {
        return BridJ.createNativeObjectFromPointer(l2 == 0L ? this : this.offset(l2), type);
    }

    public Pointer setNativeObject(NativeObject nativeObject, Type type) {
        BridJ.copyNativeObjectToAddress(nativeObject, type, this);
        return this;
    }

    public NativeObject getNativeObjectAtOffset(long l2, Class clazz) {
        return this.getNativeObjectAtOffset(l2, (Type)clazz);
    }

    public NativeObject getNativeObject(Class clazz) {
        return this.getNativeObject((Type)clazz);
    }

    public NativeObject getNativeObject(Type type) {
        NativeObject nativeObject = this.getNativeObjectAtOffset(0L, type);
        return nativeObject;
    }

    public boolean isAligned() {
        return this.isAligned(this.getIO("Cannot check alignment").getTargetAlignment());
    }

    public boolean isAligned(long l2) {
        return Pointer.isAligned(this.getPeer(), l2);
    }

    protected static boolean isAligned(long l2, long l3) {
        return Pointer.computeRemainder(l2, l3) == 0;
    }

    protected static int computeRemainder(long l2, long l3) {
        switch ((int)l3) {
            case -1: 
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return (int)(l2 & 1L);
            }
            case 4: {
                return (int)(l2 & 3L);
            }
            case 8: {
                return (int)(l2 & 7L);
            }
            case 16: {
                return (int)(l2 & 0xFL);
            }
            case 32: {
                return (int)(l2 & 0x1FL);
            }
            case 64: {
                return (int)(l2 & 0x3FL);
            }
        }
        if (l3 < 0L) {
            return 0;
        }
        return (int)(l2 % l3);
    }

    public Object get() {
        return this.get(0L);
    }

    public static Object get(Pointer pointer) {
        return pointer == null ? null : pointer.get();
    }

    public Object get(long l2) {
        return this.getIO("Cannot get pointed value").get(this, l2);
    }

    public Object set(Object object) {
        return this.set(0L, object);
    }

    private static long getTargetSizeToAllocateArrayOrThrow(PointerIO pointerIO) {
        long l2 = -1L;
        if (pointerIO == null || (l2 = pointerIO.getTargetSize()) < 0L) {
            Pointer.throwBecauseUntyped("Cannot allocate array ");
        }
        return l2;
    }

    private static void throwBecauseUntyped(String string) {
        throw new RuntimeException("Pointer is not typed (call Pointer.as(Type) to create a typed pointer) : " + string);
    }

    static void throwUnexpected(Throwable throwable) {
        throw new RuntimeException("Unexpected error", throwable);
    }

    public Object set(long l2, Object object) {
        this.getIO("Cannot set pointed value").set(this, l2, object);
        return object;
    }

    public static long getPeer(Pointer pointer) {
        return pointer == null ? 0L : pointer.getPeer();
    }

    public long getTargetSize() {
        return this.getIO("Cannot compute target size").getTargetSize();
    }

    public Pointer next() {
        return this.next(1L);
    }

    public Pointer next(long l2) {
        return this.offset(this.getIO("Cannot get pointers to next or previous targets").getTargetSize() * l2);
    }

    public static void release(Pointer ... pointerArray) {
        for (Pointer pointer : pointerArray) {
            if (pointer == null) continue;
            pointer.release();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Pointer)) {
            return false;
        }
        Pointer pointer = (Pointer)object;
        return this.getPeer() == pointer.getPeer();
    }

    public static Pointer pointerToAddress(long l2) {
        return Pointer.pointerToAddress(l2, (PointerIO)null);
    }

    public static Pointer pointerToAddress(long l2, long l3) {
        return Pointer.newPointer(null, l2, true, l2, l2 + l3, null, 0L, null, null);
    }

    public static Pointer pointerToAddress(long l2, Class clazz, Pointer$Releaser pointer$Releaser) {
        return Pointer.pointerToAddress(l2, (Type)clazz, pointer$Releaser);
    }

    public static Pointer pointerToAddress(long l2, Type type, Pointer$Releaser pointer$Releaser) {
        PointerIO pointerIO = PointerIO.getInstance(type);
        return Pointer.newPointer(pointerIO, l2, true, -1L, -1L, null, -1L, pointer$Releaser, null);
    }

    public static Pointer pointerToAddress(long l2, PointerIO pointerIO) {
        if (BridJ.cachePointers) {
            return ((PointerLRUCache)localCachedPointers.get()).get(l2, pointerIO);
        }
        return Pointer.pointerToAddress_(l2, pointerIO);
    }

    private static Pointer pointerToAddress_(long l2, PointerIO pointerIO) {
        return Pointer.newPointer(pointerIO, l2, true, -1L, -1L, null, 0L, null, null);
    }

    static Pointer pointerToAddress(long l2, PointerIO pointerIO, Pointer$Releaser pointer$Releaser) {
        return Pointer.newPointer(pointerIO, l2, true, -1L, -1L, null, 0L, pointer$Releaser, null);
    }

    public static Pointer pointerToAddress(long l2, Pointer$Releaser pointer$Releaser) {
        return Pointer.newPointer(null, l2, true, -1L, -1L, null, 0L, pointer$Releaser, null);
    }

    public static Pointer pointerToAddress(long l2, long l3, Pointer$Releaser pointer$Releaser) {
        return Pointer.newPointer(null, l2, true, l2, l2 + l3, null, 0L, pointer$Releaser, null);
    }

    public static Pointer pointerToAddress(long l2, long l3, PointerIO pointerIO, Pointer$Releaser pointer$Releaser) {
        return Pointer.newPointer(pointerIO, l2, true, l2, l2 + l3, null, 0L, pointer$Releaser, null);
    }

    public static Pointer pointerToAddress(long l2, Class clazz) {
        return Pointer.pointerToAddress(l2, (Type)clazz);
    }

    public static Pointer pointerToAddress(long l2, Type type) {
        return Pointer.newPointer(PointerIO.getInstance(type), l2, true, -1L, -1L, null, -1L, null, null);
    }

    static Pointer pointerToAddress(long l2, long l3, PointerIO pointerIO) {
        return Pointer.newPointer(pointerIO, l2, true, l2, l2 + l3, null, 0L, null, null);
    }

    static Pointer newPointer(PointerIO pointerIO, long l2, boolean bl2, long l3, long l4, Pointer pointer, long l5, Pointer$Releaser pointer$Releaser, Object object) {
        if ((l2 &= POINTER_MASK) == 0L) {
            return null;
        }
        if (l4 != -1L && l4 <= l3) {
            return null;
        }
        if (pointer$Releaser == null) {
            if (bl2) {
                return new Pointer$OrderedPointer(pointerIO, l2, l3, l4, pointer, l5, object);
            }
            return new Pointer$DisorderedPointer(pointerIO, l2, l3, l4, pointer, l5, object);
        }
        assert (object == null);
        if (bl2) {
            return new Pointer$3(pointerIO, l2, l3, l4, pointer, l5, object, pointer$Releaser);
        }
        return new Pointer$4(pointerIO, l2, l3, l4, pointer, l5, object, pointer$Releaser);
    }

    public static Pointer allocateTypedPointer(Class clazz) {
        return Pointer.allocate(PointerIO.getInstance(clazz));
    }

    public static Pointer allocateTypedPointers(Class clazz, long l2) {
        return Pointer.allocateArray(PointerIO.getInstance(clazz), l2);
    }

    public static Pointer allocatePointer(Class clazz) {
        return Pointer.allocatePointer((Type)clazz);
    }

    public static Pointer allocatePointer(Type type) {
        return Pointer.allocate(PointerIO.getPointerInstance(type));
    }

    public static Pointer allocatePointerPointer(Type type) {
        return Pointer.allocatePointer(Pointer.pointerType(type));
    }

    public static Pointer allocatePointerPointer(Class clazz) {
        return Pointer.allocatePointerPointer((Type)clazz);
    }

    public static Pointer allocatePointer() {
        return Pointer.allocate(PointerIO.getPointerInstance());
    }

    public static Pointer allocatePointers(int n2) {
        return Pointer.allocateArray(PointerIO.getPointerInstance(), (long)n2);
    }

    public static Pointer allocatePointers(Class clazz, int n2) {
        return Pointer.allocatePointers((Type)clazz, n2);
    }

    public static Pointer allocatePointers(Type type, int n2) {
        return Pointer.allocateArray(PointerIO.getPointerInstance(type), (long)n2);
    }

    public static Pointer allocate(Class clazz) {
        return Pointer.allocate((Type)clazz);
    }

    public static Pointer allocate(Type type) {
        return Pointer.allocateArray(type, 1L);
    }

    public static Pointer allocate(PointerIO pointerIO) {
        return Pointer.allocateBytes(pointerIO, Pointer.getTargetSizeToAllocateArrayOrThrow(pointerIO), null);
    }

    public static Pointer allocateArray(PointerIO pointerIO, long l2) {
        return Pointer.allocateBytes(pointerIO, Pointer.getTargetSizeToAllocateArrayOrThrow(pointerIO) * l2, null);
    }

    public static Pointer allocateArray(PointerIO pointerIO, long l2, Pointer$Releaser pointer$Releaser) {
        return Pointer.allocateBytes(pointerIO, Pointer.getTargetSizeToAllocateArrayOrThrow(pointerIO) * l2, pointer$Releaser);
    }

    public static Pointer allocateBytes(PointerIO pointerIO, long l2, Pointer$Releaser pointer$Releaser) {
        return Pointer.allocateAlignedBytes(pointerIO, l2, defaultAlignment, pointer$Releaser);
    }

    public static Pointer allocateAlignedBytes(PointerIO pointerIO, long l2, int n2, Pointer$Releaser pointer$Releaser) {
        long l3;
        if (l2 == 0L) {
            return null;
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Cannot allocate a negative amount of memory !");
        }
        long l4 = 0L;
        if (n2 <= 1) {
            l3 = JNI.mallocNulled(l2);
        } else {
            l3 = JNI.mallocNulled(l2 + (long)n2 - 1L);
            long l5 = l3 % (long)n2;
            if (l5 > 0L) {
                l4 = (long)n2 - l5;
            }
        }
        if (l3 == 0L) {
            throw new RuntimeException("Failed to allocate " + l2);
        }
        Pointer pointer = Pointer.newPointer(pointerIO, l3, true, l3, l3 + l2 + l4, null, 0L, pointer$Releaser == null ? freeReleaser : new Pointer$5(pointer$Releaser), null);
        if (l4 > 0L) {
            pointer = pointer.offset(l4);
        }
        return pointer;
    }

    public synchronized Pointer withReleaser(Pointer$Releaser pointer$Releaser) {
        return Pointer.newPointer(this.getIO(), this.getPeer(), this.isOrdered(), this.getValidStart(), this.getValidEnd(), null, 0L, pointer$Releaser, null);
    }

    public static Pointer allocateArray(Class clazz, long l2) {
        return Pointer.allocateArray((Type)clazz, l2);
    }

    public static Pointer allocateArray(Type type, long l2) {
        if (l2 == 0L) {
            return null;
        }
        PointerIO pointerIO = PointerIO.getInstance(type);
        if (pointerIO == null) {
            throw new UnsupportedOperationException("Cannot allocate memory for type " + (type instanceof Class ? ((Class)type).getName() : type.toString()));
        }
        return Pointer.allocateArray(pointerIO, l2);
    }

    public static Pointer allocateAlignedArray(Class clazz, long l2, int n2) {
        return Pointer.allocateAlignedArray((Type)clazz, l2, n2);
    }

    public static Pointer allocateAlignedArray(Type type, long l2, int n2) {
        PointerIO pointerIO = PointerIO.getInstance(type);
        if (pointerIO == null) {
            throw new UnsupportedOperationException("Cannot allocate memory for type " + (type instanceof Class ? ((Class)type).getName() : type.toString()));
        }
        return Pointer.allocateAlignedBytes(pointerIO, Pointer.getTargetSizeToAllocateArrayOrThrow(pointerIO) * l2, n2, null);
    }

    public static Pointer pointerToBuffer(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof IntBuffer) {
            return Pointer.pointerToInts((IntBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return Pointer.pointerToLongs((LongBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return Pointer.pointerToShorts((ShortBuffer)buffer);
        }
        if (buffer instanceof ByteBuffer) {
            return Pointer.pointerToBytes((ByteBuffer)buffer);
        }
        if (buffer instanceof CharBuffer) {
            return Pointer.pointerToChars((CharBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return Pointer.pointerToFloats((FloatBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return Pointer.pointerToDoubles((DoubleBuffer)buffer);
        }
        throw new UnsupportedOperationException("Unhandled buffer type : " + buffer.getClass().getName());
    }

    public void updateBuffer(Buffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Cannot update a null Buffer !");
        }
        if (Utils.isDirect(buffer)) {
            long l2 = JNI.getDirectBufferAddress(buffer);
            if (l2 != this.getPeer()) {
                throw new IllegalArgumentException("Direct buffer does not point to the same location as this Pointer instance, updating it makes no sense !");
            }
        } else {
            if (buffer instanceof IntBuffer) {
                ((IntBuffer)buffer).duplicate().put(this.getIntBuffer());
                return;
            }
            if (buffer instanceof LongBuffer) {
                ((LongBuffer)buffer).duplicate().put(this.getLongBuffer());
                return;
            }
            if (buffer instanceof ShortBuffer) {
                ((ShortBuffer)buffer).duplicate().put(this.getShortBuffer());
                return;
            }
            if (buffer instanceof ByteBuffer) {
                ((ByteBuffer)buffer).duplicate().put(this.getByteBuffer());
                return;
            }
            if (buffer instanceof FloatBuffer) {
                ((FloatBuffer)buffer).duplicate().put(this.getFloatBuffer());
                return;
            }
            if (buffer instanceof DoubleBuffer) {
                ((DoubleBuffer)buffer).duplicate().put(this.getDoubleBuffer());
                return;
            }
            throw new UnsupportedOperationException("Unhandled buffer type : " + buffer.getClass().getName());
        }
    }

    public static Pointer pointerToInt(int n2) {
        Pointer pointer = Pointer.allocate(PointerIO.getIntInstance());
        pointer.setInt(n2);
        return pointer;
    }

    public static Pointer pointerToInts(int ... nArray) {
        if (nArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getIntInstance(), (long)nArray.length);
        pointer.setIntsAtOffset(0L, nArray, 0, nArray.length);
        return pointer;
    }

    public static Pointer pointerToInts(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        Pointer pointer = Pointer.allocateInts(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setIntsAtOffset((long)(i2 * n3 * 4), nArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToInts(int[][][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = nArray[0][0].length;
        Pointer pointer = Pointer.allocateInts(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setIntsAtOffset((long)(n6 * 4), nArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateInt() {
        return Pointer.allocate(PointerIO.getIntInstance());
    }

    public static Pointer allocateInts(long l2) {
        return Pointer.allocateArray(PointerIO.getIntInstance(), l2);
    }

    public static Pointer allocateInts(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getIntInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateInts(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getIntInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToLong(long l2) {
        Pointer pointer = Pointer.allocate(PointerIO.getLongInstance());
        pointer.setLong(l2);
        return pointer;
    }

    public static Pointer pointerToLongs(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getLongInstance(), (long)lArray.length);
        pointer.setLongsAtOffset(0L, lArray, 0, lArray.length);
        return pointer;
    }

    public static Pointer pointerToLongs(long[][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        int n3 = lArray[0].length;
        Pointer pointer = Pointer.allocateLongs(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setLongsAtOffset((long)(i2 * n3 * 8), lArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToLongs(long[][][] lArray) {
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        int n3 = lArray[0].length;
        int n4 = lArray[0][0].length;
        Pointer pointer = Pointer.allocateLongs(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setLongsAtOffset((long)(n6 * 8), lArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateLong() {
        return Pointer.allocate(PointerIO.getLongInstance());
    }

    public static Pointer allocateLongs(long l2) {
        return Pointer.allocateArray(PointerIO.getLongInstance(), l2);
    }

    public static Pointer allocateLongs(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getLongInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateLongs(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getLongInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToShort(short s2) {
        Pointer pointer = Pointer.allocate(PointerIO.getShortInstance());
        pointer.setShort(s2);
        return pointer;
    }

    public static Pointer pointerToShorts(short ... sArray) {
        if (sArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getShortInstance(), (long)sArray.length);
        pointer.setShortsAtOffset(0L, sArray, 0, sArray.length);
        return pointer;
    }

    public static Pointer pointerToShorts(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n2 = sArray.length;
        int n3 = sArray[0].length;
        Pointer pointer = Pointer.allocateShorts(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setShortsAtOffset((long)(i2 * n3 * 2), sArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToShorts(short[][][] sArray) {
        if (sArray == null) {
            return null;
        }
        int n2 = sArray.length;
        int n3 = sArray[0].length;
        int n4 = sArray[0][0].length;
        Pointer pointer = Pointer.allocateShorts(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setShortsAtOffset((long)(n6 * 2), sArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateShort() {
        return Pointer.allocate(PointerIO.getShortInstance());
    }

    public static Pointer allocateShorts(long l2) {
        return Pointer.allocateArray(PointerIO.getShortInstance(), l2);
    }

    public static Pointer allocateShorts(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getShortInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateShorts(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getShortInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToByte(byte by2) {
        Pointer pointer = Pointer.allocate(PointerIO.getByteInstance());
        pointer.setByte(by2);
        return pointer;
    }

    public static Pointer pointerToBytes(byte ... byArray) {
        if (byArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getByteInstance(), (long)byArray.length);
        pointer.setBytesAtOffset(0L, byArray, 0, byArray.length);
        return pointer;
    }

    public static Pointer pointerToBytes(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = byArray[0].length;
        Pointer pointer = Pointer.allocateBytes(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setBytesAtOffset((long)(i2 * n3 * 1), byArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToBytes(byte[][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = byArray[0].length;
        int n4 = byArray[0][0].length;
        Pointer pointer = Pointer.allocateBytes(n2, (long)n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setBytesAtOffset((long)(n6 * 1), byArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateByte() {
        return Pointer.allocate(PointerIO.getByteInstance());
    }

    public static Pointer allocateBytes(long l2) {
        return Pointer.allocateArray(PointerIO.getByteInstance(), l2);
    }

    public static Pointer allocateBytes(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getByteInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateBytes(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getByteInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToChar(char c2) {
        Pointer pointer = Pointer.allocate(PointerIO.getCharInstance());
        pointer.setChar(c2);
        return pointer;
    }

    public static Pointer pointerToChars(char ... cArray) {
        if (cArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getCharInstance(), (long)cArray.length);
        pointer.setCharsAtOffset(0L, cArray, 0, cArray.length);
        return pointer;
    }

    public static Pointer pointerToChars(char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        int n3 = cArray[0].length;
        Pointer pointer = Pointer.allocateChars(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setCharsAtOffset((long)(i2 * n3 * Platform.WCHAR_T_SIZE), cArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToChars(char[][][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        int n3 = cArray[0].length;
        int n4 = cArray[0][0].length;
        Pointer pointer = Pointer.allocateChars(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setCharsAtOffset((long)(n6 * Platform.WCHAR_T_SIZE), cArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateChar() {
        return Pointer.allocate(PointerIO.getCharInstance());
    }

    public static Pointer allocateChars(long l2) {
        return Pointer.allocateArray(PointerIO.getCharInstance(), l2);
    }

    public static Pointer allocateChars(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getCharInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateChars(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getCharInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToFloat(float f2) {
        Pointer pointer = Pointer.allocate(PointerIO.getFloatInstance());
        pointer.setFloat(f2);
        return pointer;
    }

    public static Pointer pointerToFloats(float ... fArray) {
        if (fArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getFloatInstance(), (long)fArray.length);
        pointer.setFloatsAtOffset(0L, fArray, 0, fArray.length);
        return pointer;
    }

    public static Pointer pointerToFloats(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        Pointer pointer = Pointer.allocateFloats(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setFloatsAtOffset((long)(i2 * n3 * 4), fArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToFloats(float[][][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        Pointer pointer = Pointer.allocateFloats(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setFloatsAtOffset((long)(n6 * 4), fArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateFloat() {
        return Pointer.allocate(PointerIO.getFloatInstance());
    }

    public static Pointer allocateFloats(long l2) {
        return Pointer.allocateArray(PointerIO.getFloatInstance(), l2);
    }

    public static Pointer allocateFloats(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getFloatInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateFloats(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getFloatInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToDouble(double d2) {
        Pointer pointer = Pointer.allocate(PointerIO.getDoubleInstance());
        pointer.setDouble(d2);
        return pointer;
    }

    public static Pointer pointerToDoubles(double ... dArray) {
        if (dArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getDoubleInstance(), (long)dArray.length);
        pointer.setDoublesAtOffset(0L, dArray, 0, dArray.length);
        return pointer;
    }

    public static Pointer pointerToDoubles(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        Pointer pointer = Pointer.allocateDoubles(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setDoublesAtOffset((long)(i2 * n3 * 8), dArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToDoubles(double[][][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray[0][0].length;
        Pointer pointer = Pointer.allocateDoubles(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setDoublesAtOffset((long)(n6 * 8), dArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateDouble() {
        return Pointer.allocate(PointerIO.getDoubleInstance());
    }

    public static Pointer allocateDoubles(long l2) {
        return Pointer.allocateArray(PointerIO.getDoubleInstance(), l2);
    }

    public static Pointer allocateDoubles(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getDoubleInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateDoubles(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getDoubleInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToBoolean(boolean bl2) {
        Pointer pointer = Pointer.allocate(PointerIO.getBooleanInstance());
        pointer.setBoolean(bl2);
        return pointer;
    }

    public static Pointer pointerToBooleans(boolean ... blArray) {
        if (blArray == null) {
            return null;
        }
        Pointer pointer = Pointer.allocateArray(PointerIO.getBooleanInstance(), (long)blArray.length);
        pointer.setBooleansAtOffset(0L, blArray, 0, blArray.length);
        return pointer;
    }

    public static Pointer pointerToBooleans(boolean[][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n2 = blArray.length;
        int n3 = blArray[0].length;
        Pointer pointer = Pointer.allocateBooleans(n2, n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setBooleansAtOffset(i2 * n3 * 1, blArray[i2], 0, n3);
        }
        return pointer;
    }

    public static Pointer pointerToBooleans(boolean[][][] blArray) {
        if (blArray == null) {
            return null;
        }
        int n2 = blArray.length;
        int n3 = blArray[0].length;
        int n4 = blArray[0][0].length;
        Pointer pointer = Pointer.allocateBooleans(n2, n3, n4);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = (n5 + i3) * n4;
                pointer.setBooleansAtOffset(n6 * 1, blArray[i2][i3], 0, n4);
            }
        }
        return pointer;
    }

    public static Pointer allocateBoolean() {
        return Pointer.allocate(PointerIO.getBooleanInstance());
    }

    public static Pointer allocateBooleans(long l2) {
        return Pointer.allocateArray(PointerIO.getBooleanInstance(), l2);
    }

    public static Pointer allocateBooleans(long l2, long l3) {
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getBooleanInstance(), new long[]{l2, l3}, 0), l2);
    }

    public static Pointer allocateBooleans(long l2, long l3, long l4) {
        long[] lArray = new long[]{l2, l3, l4};
        return Pointer.allocateArray(PointerIO.getArrayInstance(PointerIO.getArrayInstance(PointerIO.getBooleanInstance(), lArray, 1), lArray, 0), l2);
    }

    public static Pointer pointerToInts(IntBuffer intBuffer) {
        if (intBuffer == null) {
            return null;
        }
        if (!intBuffer.isDirect()) {
            int[] nArray = intBuffer.array();
            int n2 = intBuffer.arrayOffset();
            int n3 = nArray.length - n2;
            Pointer pointer = Pointer.allocateInts(n3);
            pointer.setIntsAtOffset(0L, nArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(intBuffer);
        long l3 = JNI.getDirectBufferCapacity(intBuffer);
        if (l2 == 0L || (l3 *= 4L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.intIO;
        boolean bl2 = intBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, intBuffer);
    }

    public static Pointer pointerToLongs(LongBuffer longBuffer) {
        if (longBuffer == null) {
            return null;
        }
        if (!longBuffer.isDirect()) {
            long[] lArray = longBuffer.array();
            int n2 = longBuffer.arrayOffset();
            int n3 = lArray.length - n2;
            Pointer pointer = Pointer.allocateLongs(n3);
            pointer.setLongsAtOffset(0L, lArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(longBuffer);
        long l3 = JNI.getDirectBufferCapacity(longBuffer);
        if (l2 == 0L || (l3 *= 8L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.longIO;
        boolean bl2 = longBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, longBuffer);
    }

    public static Pointer pointerToShorts(ShortBuffer shortBuffer) {
        if (shortBuffer == null) {
            return null;
        }
        if (!shortBuffer.isDirect()) {
            short[] sArray = shortBuffer.array();
            int n2 = shortBuffer.arrayOffset();
            int n3 = sArray.length - n2;
            Pointer pointer = Pointer.allocateShorts(n3);
            pointer.setShortsAtOffset(0L, sArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(shortBuffer);
        long l3 = JNI.getDirectBufferCapacity(shortBuffer);
        if (l2 == 0L || (l3 *= 2L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.shortIO;
        boolean bl2 = shortBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, shortBuffer);
    }

    public static Pointer pointerToBytes(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (!byteBuffer.isDirect()) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset();
            int n3 = byArray.length - n2;
            Pointer pointer = Pointer.allocateBytes(n3);
            pointer.setBytesAtOffset(0L, byArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(byteBuffer);
        long l3 = JNI.getDirectBufferCapacity(byteBuffer);
        if (l2 == 0L || (l3 *= 1L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.byteIO;
        boolean bl2 = byteBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, byteBuffer);
    }

    public static Pointer pointerToChars(CharBuffer charBuffer) {
        if (charBuffer == null) {
            return null;
        }
        if (!charBuffer.isDirect()) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset();
            int n3 = cArray.length - n2;
            Pointer pointer = Pointer.allocateChars(n3);
            pointer.setCharsAtOffset(0L, cArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(charBuffer);
        long l3 = JNI.getDirectBufferCapacity(charBuffer);
        if (l2 == 0L || (l3 *= (long)Platform.WCHAR_T_SIZE) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.charIO;
        boolean bl2 = charBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, charBuffer);
    }

    public static Pointer pointerToFloats(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return null;
        }
        if (!floatBuffer.isDirect()) {
            float[] fArray = floatBuffer.array();
            int n2 = floatBuffer.arrayOffset();
            int n3 = fArray.length - n2;
            Pointer pointer = Pointer.allocateFloats(n3);
            pointer.setFloatsAtOffset(0L, fArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(floatBuffer);
        long l3 = JNI.getDirectBufferCapacity(floatBuffer);
        if (l2 == 0L || (l3 *= 4L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.floatIO;
        boolean bl2 = floatBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, floatBuffer);
    }

    public static Pointer pointerToDoubles(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            return null;
        }
        if (!doubleBuffer.isDirect()) {
            double[] dArray = doubleBuffer.array();
            int n2 = doubleBuffer.arrayOffset();
            int n3 = dArray.length - n2;
            Pointer pointer = Pointer.allocateDoubles(n3);
            pointer.setDoublesAtOffset(0L, dArray, n2, n3);
            return pointer;
        }
        long l2 = JNI.getDirectBufferAddress(doubleBuffer);
        long l3 = JNI.getDirectBufferCapacity(doubleBuffer);
        if (l2 == 0L || (l3 *= 8L) == 0L) {
            return null;
        }
        PointerIO pointerIO = CommonPointerIOs.doubleIO;
        boolean bl2 = doubleBuffer.order().equals(ByteOrder.nativeOrder());
        return Pointer.newPointer(pointerIO, l2, bl2, l2, l2 + l3, null, 0L, null, doubleBuffer);
    }

    public Type getTargetType() {
        PointerIO pointerIO = this.getIO();
        return pointerIO == null ? null : pointerIO.getTargetType();
    }

    public Pointer getPointer() {
        return this.getPointerAtOffset(0L, (PointerIO)null);
    }

    public Pointer getPointerAtOffset(long l2) {
        return this.getPointerAtOffset(l2, (PointerIO)null);
    }

    public Pointer getPointerAtIndex(long l2) {
        return this.getPointerAtOffset(l2 * (long)SIZE);
    }

    public Pointer getPointer(Class clazz) {
        return this.getPointerAtOffset(0L, PointerIO.getInstance(clazz));
    }

    public Pointer getPointer(PointerIO pointerIO) {
        return this.getPointerAtOffset(0L, pointerIO);
    }

    public Pointer getPointerAtOffset(long l2, Class clazz) {
        return this.getPointerAtOffset(l2, (Type)clazz);
    }

    public Pointer getPointerAtOffset(long l2, Type type) {
        return this.getPointerAtOffset(l2, type == null ? null : PointerIO.getInstance(type));
    }

    public Pointer getPointerAtOffset(long l2, PointerIO pointerIO) {
        long l3 = this.getSizeTAtOffset(l2);
        if (l3 == 0L) {
            return null;
        }
        return Pointer.newPointer(pointerIO, l3, this.isOrdered(), -1L, -1L, this, l2, null, null);
    }

    public Pointer setPointer(Pointer pointer) {
        return this.setPointerAtOffset(0L, pointer);
    }

    public Pointer setPointerAtOffset(long l2, Pointer pointer) {
        this.setSizeTAtOffset(l2, pointer == null ? 0L : pointer.getPeer());
        return this;
    }

    public Pointer setPointerAtIndex(long l2, Pointer pointer) {
        this.setPointerAtOffset(l2 * (long)SIZE, pointer);
        return this;
    }

    public Pointer[] getPointersAtOffset(long l2, int n2) {
        return this.getPointersAtOffset(l2, n2, (PointerIO)null);
    }

    public Pointer[] getPointers() {
        long l2 = this.getValidElements("Cannot create array if remaining length is not known. Please use getPointers(int length) instead.");
        return this.getPointersAtOffset(0L, (int)l2);
    }

    public Pointer[] getPointers(int n2) {
        return this.getPointersAtOffset(0L, n2);
    }

    public Pointer[] getPointersAtOffset(long l2, int n2, Type type) {
        return this.getPointersAtOffset(l2, n2, type == null ? null : PointerIO.getInstance(type));
    }

    public Pointer[] getPointersAtOffset(long l2, int n2, Class clazz) {
        return this.getPointersAtOffset(l2, n2, (Type)clazz);
    }

    public Pointer[] getPointersAtOffset(long l2, int n2, PointerIO pointerIO) {
        Pointer[] pointerArray = new Pointer[n2];
        int n3 = Platform.POINTER_SIZE;
        for (int i2 = 0; i2 < n2; ++i2) {
            pointerArray[i2] = this.getPointerAtOffset(l2 + (long)(i2 * n3), pointerIO);
        }
        return pointerArray;
    }

    public Pointer setPointersAtOffset(long l2, Pointer[] pointerArray) {
        return this.setPointersAtOffset(l2, pointerArray, 0, pointerArray.length);
    }

    public Pointer setPointersAtOffset(long l2, Pointer[] pointerArray, int n2, int n3) {
        if (pointerArray == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n4 = n3;
        int n5 = Platform.POINTER_SIZE;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.setPointerAtOffset(l2 + (long)(i2 * n5), pointerArray[n2 + i2]);
        }
        return this;
    }

    public Pointer setPointers(Pointer[] pointerArray) {
        return this.setPointersAtOffset(0L, pointerArray);
    }

    public Object getArrayAtOffset(long l2, int n2) {
        return this.getIO("Cannot create sublist").getArray(this, l2, n2);
    }

    public Object getArray(int n2) {
        return this.getArrayAtOffset(0L, n2);
    }

    public Object getArray() {
        return this.getArray((int)this.getValidElements());
    }

    public Buffer getBufferAtOffset(long l2, int n2) {
        return this.getIO("Cannot create Buffer").getBuffer(this, l2, n2);
    }

    public Buffer getBuffer(int n2) {
        return this.getBufferAtOffset(0L, n2);
    }

    public Buffer getBuffer() {
        return this.getBuffer((int)this.getValidElements());
    }

    public Pointer setArrayAtOffset(long l2, Object object) {
        this.getIO("Cannot create sublist").setArray(this, l2, object);
        return this;
    }

    public static Pointer pointerToArray(Object object) {
        if (object == null) {
            return null;
        }
        PointerIO pointerIO = PointerIO.getArrayIO(object);
        if (pointerIO == null) {
            Pointer.throwBecauseUntyped("Cannot create pointer to array");
        }
        Pointer pointer = Pointer.allocateArray(pointerIO, (long)Array.getLength(object));
        pointerIO.setArray(pointer, 0L, object);
        return pointer;
    }

    public Pointer setArray(Object object) {
        return this.setArrayAtOffset(0L, object);
    }

    public static Pointer pointerToSizeT(long l2) {
        Pointer pointer = Pointer.allocate(PointerIO.getSizeTInstance());
        pointer.setSizeT(l2);
        return pointer;
    }

    public static Pointer pointerToSizeT(SizeT sizeT) {
        Pointer pointer = Pointer.allocate(PointerIO.getSizeTInstance());
        pointer.setSizeT(sizeT);
        return pointer;
    }

    public static Pointer pointerToSizeTs(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)lArray.length).setSizeTsAtOffset(0L, lArray);
    }

    public static Pointer pointerToSizeTs(SizeT ... sizeTArray) {
        if (sizeTArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)sizeTArray.length).setSizeTsAtOffset(0L, sizeTArray);
    }

    public static Pointer pointerToSizeTs(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), (long)nArray.length).setSizeTsAtOffset(0L, nArray);
    }

    public static Pointer allocateSizeTs(long l2) {
        return Pointer.allocateArray(PointerIO.getSizeTInstance(), l2);
    }

    public static Pointer allocateSizeT() {
        return Pointer.allocate(PointerIO.getSizeTInstance());
    }

    public long getSizeT() {
        return SizeT.SIZE == 8 ? this.getLong() : (long)this.getInt();
    }

    public long getSizeTAtOffset(long l2) {
        return SizeT.SIZE == 8 ? this.getLongAtOffset(l2) : (long)this.getIntAtOffset(l2);
    }

    public long getSizeTAtIndex(long l2) {
        return this.getSizeTAtOffset(l2 * (long)SizeT.SIZE);
    }

    public long[] getSizeTs() {
        long l2 = this.getValidElements("Cannot create array if remaining length is not known. Please use getSizeTs(int length) instead.");
        if (SizeT.SIZE == 8) {
            return this.getLongs((int)l2);
        }
        return this.getSizeTs((int)l2);
    }

    public long[] getSizeTs(int n2) {
        if (SizeT.SIZE == 8) {
            return this.getLongs(n2);
        }
        return this.getSizeTsAtOffset(0L, n2);
    }

    public long[] getSizeTsAtOffset(long l2, int n2) {
        if (SizeT.SIZE == 8) {
            return this.getLongsAtOffset(l2, n2);
        }
        int[] nArray = this.getIntsAtOffset(l2, n2);
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = nArray[i2];
        }
        return lArray;
    }

    public Pointer setSizeT(long l2) {
        if (SizeT.SIZE == 8) {
            this.setLong(l2);
        } else {
            this.setInt(SizeT.safeIntCast(l2));
        }
        return this;
    }

    public Pointer setSizeT(SizeT sizeT) {
        return this.setSizeT(sizeT.longValue());
    }

    public Pointer setSizeTAtOffset(long l2, long l3) {
        if (SizeT.SIZE == 8) {
            this.setLongAtOffset(l2, l3);
        } else {
            this.setIntAtOffset(l2, SizeT.safeIntCast(l3));
        }
        return this;
    }

    public Pointer setSizeTAtIndex(long l2, long l3) {
        return this.setSizeTAtOffset(l2 * (long)SizeT.SIZE, l3);
    }

    public Pointer setSizeTAtOffset(long l2, SizeT sizeT) {
        return this.setSizeTAtOffset(l2, sizeT.longValue());
    }

    public Pointer setSizeTs(long[] lArray) {
        if (SizeT.SIZE == 8) {
            return this.setLongs(lArray);
        }
        return this.setSizeTsAtOffset(0L, lArray);
    }

    public Pointer setSizeTs(int[] nArray) {
        if (SizeT.SIZE == 4) {
            return this.setInts(nArray);
        }
        return this.setSizeTsAtOffset(0L, nArray);
    }

    public Pointer setSizeTs(SizeT[] sizeTArray) {
        return this.setSizeTsAtOffset(0L, sizeTArray);
    }

    public Pointer setSizeTsAtOffset(long l2, long[] lArray) {
        return this.setSizeTsAtOffset(l2, lArray, 0, lArray.length);
    }

    public abstract Pointer setSizeTsAtOffset(long var1, long[] var3, int var4, int var5);

    public Pointer setSizeTsAtOffset(long l2, SizeT ... sizeTArray) {
        if (sizeTArray == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n2 = sizeTArray.length;
        int n3 = SizeT.SIZE;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setSizeTAtOffset(l2 + (long)(i2 * n3), sizeTArray[i2].longValue());
        }
        return this;
    }

    public abstract Pointer setSizeTsAtOffset(long var1, int[] var3);

    public static Pointer pointerToCLong(long l2) {
        Pointer pointer = Pointer.allocate(PointerIO.getCLongInstance());
        pointer.setCLong(l2);
        return pointer;
    }

    public static Pointer pointerToCLong(CLong cLong) {
        Pointer pointer = Pointer.allocate(PointerIO.getCLongInstance());
        pointer.setCLong(cLong);
        return pointer;
    }

    public static Pointer pointerToCLongs(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)lArray.length).setCLongsAtOffset(0L, lArray);
    }

    public static Pointer pointerToCLongs(CLong ... cLongArray) {
        if (cLongArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)cLongArray.length).setCLongsAtOffset(0L, cLongArray);
    }

    public static Pointer pointerToCLongs(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        return Pointer.allocateArray(PointerIO.getCLongInstance(), (long)nArray.length).setCLongsAtOffset(0L, nArray);
    }

    public static Pointer allocateCLongs(long l2) {
        return Pointer.allocateArray(PointerIO.getCLongInstance(), l2);
    }

    public static Pointer allocateCLong() {
        return Pointer.allocate(PointerIO.getCLongInstance());
    }

    public long getCLong() {
        return CLong.SIZE == 8 ? this.getLong() : (long)this.getInt();
    }

    public long getCLongAtOffset(long l2) {
        return CLong.SIZE == 8 ? this.getLongAtOffset(l2) : (long)this.getIntAtOffset(l2);
    }

    public long getCLongAtIndex(long l2) {
        return this.getCLongAtOffset(l2 * (long)CLong.SIZE);
    }

    public long[] getCLongs() {
        long l2 = this.getValidElements("Cannot create array if remaining length is not known. Please use getCLongs(int length) instead.");
        if (CLong.SIZE == 8) {
            return this.getLongs((int)l2);
        }
        return this.getCLongs((int)l2);
    }

    public long[] getCLongs(int n2) {
        if (CLong.SIZE == 8) {
            return this.getLongs(n2);
        }
        return this.getCLongsAtOffset(0L, n2);
    }

    public long[] getCLongsAtOffset(long l2, int n2) {
        if (CLong.SIZE == 8) {
            return this.getLongsAtOffset(l2, n2);
        }
        int[] nArray = this.getIntsAtOffset(l2, n2);
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = nArray[i2];
        }
        return lArray;
    }

    public Pointer setCLong(long l2) {
        if (CLong.SIZE == 8) {
            this.setLong(l2);
        } else {
            this.setInt(SizeT.safeIntCast(l2));
        }
        return this;
    }

    public Pointer setCLong(CLong cLong) {
        return this.setCLong(cLong.longValue());
    }

    public Pointer setCLongAtOffset(long l2, long l3) {
        if (CLong.SIZE == 8) {
            this.setLongAtOffset(l2, l3);
        } else {
            this.setIntAtOffset(l2, SizeT.safeIntCast(l3));
        }
        return this;
    }

    public Pointer setCLongAtIndex(long l2, long l3) {
        return this.setCLongAtOffset(l2 * (long)CLong.SIZE, l3);
    }

    public Pointer setCLongAtOffset(long l2, CLong cLong) {
        return this.setCLongAtOffset(l2, cLong.longValue());
    }

    public Pointer setCLongs(long[] lArray) {
        if (CLong.SIZE == 8) {
            return this.setLongs(lArray);
        }
        return this.setCLongsAtOffset(0L, lArray);
    }

    public Pointer setCLongs(int[] nArray) {
        if (CLong.SIZE == 4) {
            return this.setInts(nArray);
        }
        return this.setCLongsAtOffset(0L, nArray);
    }

    public Pointer setCLongs(CLong[] cLongArray) {
        return this.setCLongsAtOffset(0L, cLongArray);
    }

    public Pointer setCLongsAtOffset(long l2, long[] lArray) {
        return this.setCLongsAtOffset(l2, lArray, 0, lArray.length);
    }

    public abstract Pointer setCLongsAtOffset(long var1, long[] var3, int var4, int var5);

    public Pointer setCLongsAtOffset(long l2, CLong ... cLongArray) {
        if (cLongArray == null) {
            throw new IllegalArgumentException("Null values");
        }
        int n2 = cLongArray.length;
        int n3 = CLong.SIZE;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setCLongAtOffset(l2 + (long)(i2 * n3), cLongArray[i2].longValue());
        }
        return this;
    }

    public abstract Pointer setCLongsAtOffset(long var1, int[] var3);

    void setSignedIntegralAtOffset(long l2, long l3, long l4) {
        switch ((int)l4) {
            case 1: {
                if (l3 > 127L || l3 < -128L) {
                    throw new RuntimeException("Value out of byte bounds : " + l3);
                }
                this.setByteAtOffset(l2, (byte)l3);
                break;
            }
            case 2: {
                if (l3 > 32767L || l3 < -32768L) {
                    throw new RuntimeException("Value out of short bounds : " + l3);
                }
                this.setShortAtOffset(l2, (short)l3);
                break;
            }
            case 4: {
                if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
                    throw new RuntimeException("Value out of int bounds : " + l3);
                }
                this.setIntAtOffset(l2, (int)l3);
                break;
            }
            case 8: {
                this.setLongAtOffset(l2, l3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot write integral type of size " + l4 + " (value = " + l3 + ")");
            }
        }
    }

    long getSignedIntegralAtOffset(long l2, long l3) {
        switch ((int)l3) {
            case 1: {
                return this.getByteAtOffset(l2);
            }
            case 2: {
                return this.getShortAtOffset(l2);
            }
            case 4: {
                return this.getIntAtOffset(l2);
            }
            case 8: {
                return this.getLongAtOffset(l2);
            }
        }
        throw new IllegalArgumentException("Cannot read integral type of size " + l3);
    }

    public static Pointer pointerToPointer(Pointer pointer) {
        Pointer pointer2 = Pointer.allocate(PointerIO.getPointerInstance());
        pointer2.setPointerAtOffset(0L, pointer);
        return pointer2;
    }

    public static Pointer pointerToPointers(Pointer ... pointerArray) {
        if (pointerArray == null) {
            return null;
        }
        int n2 = pointerArray.length;
        int n3 = SIZE;
        PointerIO pointerIO = PointerIO.getPointerInstance();
        Pointer pointer = Pointer.allocateArray(pointerIO, (long)n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointer.setPointerAtOffset(i2 * n3, pointerArray[i2]);
        }
        return pointer;
    }

    public Pointer setValuesAtOffset(long l2, Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            this.setIntsAtOffset(l2, (IntBuffer)buffer);
            return this;
        }
        if (buffer instanceof LongBuffer) {
            this.setLongsAtOffset(l2, (LongBuffer)buffer);
            return this;
        }
        if (buffer instanceof ShortBuffer) {
            this.setShortsAtOffset(l2, (ShortBuffer)buffer);
            return this;
        }
        if (buffer instanceof ByteBuffer) {
            this.setBytesAtOffset(l2, (ByteBuffer)buffer);
            return this;
        }
        if (buffer instanceof CharBuffer) {
            this.setCharsAtOffset(l2, (CharBuffer)buffer);
            return this;
        }
        if (buffer instanceof FloatBuffer) {
            this.setFloatsAtOffset(l2, (FloatBuffer)buffer);
            return this;
        }
        if (buffer instanceof DoubleBuffer) {
            this.setDoublesAtOffset(l2, (DoubleBuffer)buffer);
            return this;
        }
        throw new UnsupportedOperationException("Unhandled buffer type : " + buffer.getClass().getName());
    }

    public Pointer setValuesAtOffset(long l2, Buffer buffer, int n2, int n3) {
        if (buffer instanceof IntBuffer) {
            this.setIntsAtOffset(l2, (IntBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof LongBuffer) {
            this.setLongsAtOffset(l2, (LongBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof ShortBuffer) {
            this.setShortsAtOffset(l2, (ShortBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof ByteBuffer) {
            this.setBytesAtOffset(l2, (ByteBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof CharBuffer) {
            this.setCharsAtOffset(l2, (CharBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof FloatBuffer) {
            this.setFloatsAtOffset(l2, (FloatBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        if (buffer instanceof DoubleBuffer) {
            this.setDoublesAtOffset(l2, (DoubleBuffer)buffer, (long)n2, (long)n3);
            return this;
        }
        throw new UnsupportedOperationException("Unhandled buffer type : " + buffer.getClass().getName());
    }

    public Pointer setValues(Buffer buffer) {
        if (buffer instanceof IntBuffer) {
            this.setInts((IntBuffer)buffer);
            return this;
        }
        if (buffer instanceof LongBuffer) {
            this.setLongs((LongBuffer)buffer);
            return this;
        }
        if (buffer instanceof ShortBuffer) {
            this.setShorts((ShortBuffer)buffer);
            return this;
        }
        if (buffer instanceof ByteBuffer) {
            this.setBytes((ByteBuffer)buffer);
            return this;
        }
        if (buffer instanceof CharBuffer) {
            this.setChars((CharBuffer)buffer);
            return this;
        }
        if (buffer instanceof FloatBuffer) {
            this.setFloats((FloatBuffer)buffer);
            return this;
        }
        if (buffer instanceof DoubleBuffer) {
            this.setDoubles((DoubleBuffer)buffer);
            return this;
        }
        throw new UnsupportedOperationException("Unhandled buffer type : " + buffer.getClass().getName());
    }

    public Pointer copyBytesAtOffsetTo(long l2, Pointer pointer, long l3, long l4) {
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        JNI.memcpy(pointer.getCheckedPeer(l3, l4), l5, l4);
        return this;
    }

    public Pointer copyBytesTo(Pointer pointer, long l2) {
        return this.copyBytesAtOffsetTo(0L, pointer, 0L, l2);
    }

    public Pointer moveBytesAtOffsetTo(long l2, Pointer pointer, long l3, long l4) {
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        JNI.memmove(pointer.getCheckedPeer(l3, l4), l5, l4);
        return this;
    }

    public Pointer moveBytesTo(Pointer pointer, long l2) {
        return this.moveBytesAtOffsetTo(0L, pointer, 0L, l2);
    }

    public Pointer moveBytesTo(Pointer pointer) {
        return this.moveBytesTo(pointer, this.getValidBytes("Cannot move an unbounded memory location. Please use validBytes(long)."));
    }

    final long getValidBytes(String string) {
        long l2 = this.getValidBytes();
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException(string);
        }
        return l2;
    }

    final long getValidElements(String string) {
        long l2 = this.getValidElements();
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException(string);
        }
        return l2;
    }

    final PointerIO getIO(String string) {
        PointerIO pointerIO = this.getIO();
        if (pointerIO == null) {
            Pointer.throwBecauseUntyped(string);
        }
        return pointerIO;
    }

    public Pointer copyTo(Pointer pointer) {
        return this.copyTo(pointer, this.getValidElements());
    }

    public Pointer copyTo(Pointer pointer, long l2) {
        PointerIO pointerIO = this.getIO("Cannot copy untyped pointer without byte count information. Please use copyBytesAtOffsetTo(offset, destination, destinationOffset, byteCount) instead");
        return this.copyBytesAtOffsetTo(0L, pointer, 0L, l2 * pointerIO.getTargetSize());
    }

    public Pointer find(Pointer pointer) {
        if (pointer == null) {
            return null;
        }
        long l2 = JNI.memmem(this.getPeer(), this.getValidBytes("Cannot search an unbounded memory area. Please set bounds with validBytes(long)."), pointer.getPeer(), pointer.getValidBytes("Cannot search for an unbounded content. Please set bounds with validBytes(long)."));
        return Pointer.pointerToAddress(l2, this.io);
    }

    public Pointer findLast(Pointer pointer) {
        if (pointer == null) {
            return null;
        }
        long l2 = JNI.memmem_last(this.getPeer(), this.getValidBytes("Cannot search an unbounded memory area. Please set bounds with validBytes(long)."), pointer.getPeer(), pointer.getValidBytes("Cannot search for an unbounded content. Please set bounds with validBytes(long)."));
        return Pointer.pointerToAddress(l2, this.io);
    }

    public abstract Pointer setInt(int var1);

    public abstract Pointer setIntAtOffset(long var1, int var3);

    public Pointer setIntAtIndex(long l2, int n2) {
        return this.setIntAtOffset(l2 * 4L, n2);
    }

    public Pointer setInts(int[] nArray) {
        return this.setIntsAtOffset(0L, nArray, 0, nArray.length);
    }

    public Pointer setIntsAtOffset(long l2, int[] nArray) {
        return this.setIntsAtOffset(l2, nArray, 0, nArray.length);
    }

    public Pointer setIntsAtOffset(long l2, int[] nArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(4 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 4 * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_int_array_disordered(l3, nArray, n2, n3);
            return this;
        }
        JNI.set_int_array(l3, nArray, n2, n3);
        return this;
    }

    public abstract int getInt();

    public abstract int getIntAtOffset(long var1);

    public int getIntAtIndex(long l2) {
        return this.getIntAtOffset(l2 * 4L);
    }

    public int[] getInts(int n2) {
        return this.getIntsAtOffset(0L, n2);
    }

    public int[] getInts() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getInts(int length) instead.");
        return this.getInts((int)(l2 / 4L));
    }

    public int[] getIntsAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(4 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 4 * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_int_array_disordered(l3, n2);
        }
        return JNI.get_int_array(l3, n2);
    }

    public abstract Pointer setLong(long var1);

    public abstract Pointer setLongAtOffset(long var1, long var3);

    public Pointer setLongAtIndex(long l2, long l3) {
        return this.setLongAtOffset(l2 * 8L, l3);
    }

    public Pointer setLongs(long[] lArray) {
        return this.setLongsAtOffset(0L, lArray, 0, lArray.length);
    }

    public Pointer setLongsAtOffset(long l2, long[] lArray) {
        return this.setLongsAtOffset(l2, lArray, 0, lArray.length);
    }

    public Pointer setLongsAtOffset(long l2, long[] lArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(8 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 8 * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_long_array_disordered(l3, lArray, n2, n3);
            return this;
        }
        JNI.set_long_array(l3, lArray, n2, n3);
        return this;
    }

    public abstract long getLong();

    public abstract long getLongAtOffset(long var1);

    public long getLongAtIndex(long l2) {
        return this.getLongAtOffset(l2 * 8L);
    }

    public long[] getLongs(int n2) {
        return this.getLongsAtOffset(0L, n2);
    }

    public long[] getLongs() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getLongs(int length) instead.");
        return this.getLongs((int)(l2 / 8L));
    }

    public long[] getLongsAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(8 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 8 * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_long_array_disordered(l3, n2);
        }
        return JNI.get_long_array(l3, n2);
    }

    public abstract Pointer setShort(short var1);

    public abstract Pointer setShortAtOffset(long var1, short var3);

    public Pointer setShortAtIndex(long l2, short s2) {
        return this.setShortAtOffset(l2 * 2L, s2);
    }

    public Pointer setShorts(short[] sArray) {
        return this.setShortsAtOffset(0L, sArray, 0, sArray.length);
    }

    public Pointer setShortsAtOffset(long l2, short[] sArray) {
        return this.setShortsAtOffset(l2, sArray, 0, sArray.length);
    }

    public Pointer setShortsAtOffset(long l2, short[] sArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(2 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 2 * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_short_array_disordered(l3, sArray, n2, n3);
            return this;
        }
        JNI.set_short_array(l3, sArray, n2, n3);
        return this;
    }

    public abstract short getShort();

    public abstract short getShortAtOffset(long var1);

    public short getShortAtIndex(long l2) {
        return this.getShortAtOffset(l2 * 2L);
    }

    public short[] getShorts(int n2) {
        return this.getShortsAtOffset(0L, n2);
    }

    public short[] getShorts() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getShorts(int length) instead.");
        return this.getShorts((int)(l2 / 2L));
    }

    public short[] getShortsAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(2 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 2 * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_short_array_disordered(l3, n2);
        }
        return JNI.get_short_array(l3, n2);
    }

    public abstract Pointer setByte(byte var1);

    public abstract Pointer setByteAtOffset(long var1, byte var3);

    public Pointer setByteAtIndex(long l2, byte by2) {
        return this.setByteAtOffset(l2 * 1L, by2);
    }

    public Pointer setBytes(byte[] byArray) {
        return this.setBytesAtOffset(0L, byArray, 0, byArray.length);
    }

    public Pointer setBytesAtOffset(long l2, byte[] byArray) {
        return this.setBytesAtOffset(l2, byArray, 0, byArray.length);
    }

    public Pointer setBytesAtOffset(long l2, byte[] byArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(1 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 1 * n3);
        }
        JNI.set_byte_array(l3, byArray, n2, n3);
        return this;
    }

    public abstract byte getByte();

    public abstract byte getByteAtOffset(long var1);

    public byte getByteAtIndex(long l2) {
        return this.getByteAtOffset(l2 * 1L);
    }

    public byte[] getBytes(int n2) {
        return this.getBytesAtOffset(0L, n2);
    }

    public byte[] getBytes() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getBytes(int length) instead.");
        return this.getBytes((int)(l2 / 1L));
    }

    public byte[] getBytesAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(1 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 1 * n2);
        }
        return JNI.get_byte_array(l3, n2);
    }

    public abstract Pointer setChar(char var1);

    public abstract Pointer setCharAtOffset(long var1, char var3);

    public Pointer setCharAtIndex(long l2, char c2) {
        return this.setCharAtOffset(l2 * (long)Platform.WCHAR_T_SIZE, c2);
    }

    public Pointer setChars(char[] cArray) {
        return this.setCharsAtOffset(0L, cArray, 0, cArray.length);
    }

    public Pointer setCharsAtOffset(long l2, char[] cArray) {
        return this.setCharsAtOffset(l2, cArray, 0, cArray.length);
    }

    public Pointer setCharsAtOffset(long l2, char[] cArray, int n2, int n3) {
        if (Platform.WCHAR_T_SIZE == 4) {
            return this.setIntsAtOffset(l2, Pointer.wcharsToInts(cArray, n2, n3));
        }
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(Platform.WCHAR_T_SIZE * n3) > this.validEnd)) {
            this.invalidPeer(l3, Platform.WCHAR_T_SIZE * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_char_array_disordered(l3, cArray, n2, n3);
            return this;
        }
        JNI.set_char_array(l3, cArray, n2, n3);
        return this;
    }

    public abstract char getChar();

    public abstract char getCharAtOffset(long var1);

    public char getCharAtIndex(long l2) {
        return this.getCharAtOffset(l2 * (long)Platform.WCHAR_T_SIZE);
    }

    public char[] getChars(int n2) {
        return this.getCharsAtOffset(0L, n2);
    }

    public char[] getChars() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getChars(int length) instead.");
        return this.getChars((int)(l2 / (long)Platform.WCHAR_T_SIZE));
    }

    public char[] getCharsAtOffset(long l2, int n2) {
        if (Platform.WCHAR_T_SIZE == 4) {
            return Pointer.intsToWChars(this.getIntsAtOffset(l2, n2));
        }
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(Platform.WCHAR_T_SIZE * n2) > this.validEnd)) {
            this.invalidPeer(l3, Platform.WCHAR_T_SIZE * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_char_array_disordered(l3, n2);
        }
        return JNI.get_char_array(l3, n2);
    }

    public abstract Pointer setFloat(float var1);

    public abstract Pointer setFloatAtOffset(long var1, float var3);

    public Pointer setFloatAtIndex(long l2, float f2) {
        return this.setFloatAtOffset(l2 * 4L, f2);
    }

    public Pointer setFloats(float[] fArray) {
        return this.setFloatsAtOffset(0L, fArray, 0, fArray.length);
    }

    public Pointer setFloatsAtOffset(long l2, float[] fArray) {
        return this.setFloatsAtOffset(l2, fArray, 0, fArray.length);
    }

    public Pointer setFloatsAtOffset(long l2, float[] fArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(4 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 4 * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_float_array_disordered(l3, fArray, n2, n3);
            return this;
        }
        JNI.set_float_array(l3, fArray, n2, n3);
        return this;
    }

    public abstract float getFloat();

    public abstract float getFloatAtOffset(long var1);

    public float getFloatAtIndex(long l2) {
        return this.getFloatAtOffset(l2 * 4L);
    }

    public float[] getFloats(int n2) {
        return this.getFloatsAtOffset(0L, n2);
    }

    public float[] getFloats() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getFloats(int length) instead.");
        return this.getFloats((int)(l2 / 4L));
    }

    public float[] getFloatsAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(4 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 4 * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_float_array_disordered(l3, n2);
        }
        return JNI.get_float_array(l3, n2);
    }

    public abstract Pointer setDouble(double var1);

    public abstract Pointer setDoubleAtOffset(long var1, double var3);

    public Pointer setDoubleAtIndex(long l2, double d2) {
        return this.setDoubleAtOffset(l2 * 8L, d2);
    }

    public Pointer setDoubles(double[] dArray) {
        return this.setDoublesAtOffset(0L, dArray, 0, dArray.length);
    }

    public Pointer setDoublesAtOffset(long l2, double[] dArray) {
        return this.setDoublesAtOffset(l2, dArray, 0, dArray.length);
    }

    public Pointer setDoublesAtOffset(long l2, double[] dArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(8 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 8 * n3);
        }
        if (!this.isOrdered()) {
            JNI.set_double_array_disordered(l3, dArray, n2, n3);
            return this;
        }
        JNI.set_double_array(l3, dArray, n2, n3);
        return this;
    }

    public abstract double getDouble();

    public abstract double getDoubleAtOffset(long var1);

    public double getDoubleAtIndex(long l2) {
        return this.getDoubleAtOffset(l2 * 8L);
    }

    public double[] getDoubles(int n2) {
        return this.getDoublesAtOffset(0L, n2);
    }

    public double[] getDoubles() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getDoubles(int length) instead.");
        return this.getDoubles((int)(l2 / 8L));
    }

    public double[] getDoublesAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(8 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 8 * n2);
        }
        if (!this.isOrdered()) {
            return JNI.get_double_array_disordered(l3, n2);
        }
        return JNI.get_double_array(l3, n2);
    }

    public abstract Pointer setBoolean(boolean var1);

    public abstract Pointer setBooleanAtOffset(long var1, boolean var3);

    public Pointer setBooleanAtIndex(long l2, boolean bl2) {
        return this.setBooleanAtOffset(l2 * 1L, bl2);
    }

    public Pointer setBooleans(boolean[] blArray) {
        return this.setBooleansAtOffset(0L, blArray, 0, blArray.length);
    }

    public Pointer setBooleansAtOffset(long l2, boolean[] blArray) {
        return this.setBooleansAtOffset(l2, blArray, 0, blArray.length);
    }

    public Pointer setBooleansAtOffset(long l2, boolean[] blArray, int n2, int n3) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(1 * n3) > this.validEnd)) {
            this.invalidPeer(l3, 1 * n3);
        }
        JNI.set_boolean_array(l3, blArray, n2, n3);
        return this;
    }

    public abstract boolean getBoolean();

    public abstract boolean getBooleanAtOffset(long var1);

    public boolean getBooleanAtIndex(long l2) {
        return this.getBooleanAtOffset(l2 * 1L);
    }

    public boolean[] getBooleans(int n2) {
        return this.getBooleansAtOffset(0L, n2);
    }

    public boolean[] getBooleans() {
        long l2 = this.getValidBytes("Cannot create array if remaining length is not known. Please use getBooleans(int length) instead.");
        return this.getBooleans((int)(l2 / 1L));
    }

    public boolean[] getBooleansAtOffset(long l2, int n2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)(1 * n2) > this.validEnd)) {
            this.invalidPeer(l3, 1 * n2);
        }
        return JNI.get_boolean_array(l3, n2);
    }

    public void getInts(int[] nArray) {
        this.getIntBuffer().get(nArray);
    }

    public void getInts(IntBuffer intBuffer) {
        intBuffer.duplicate().put(this.getIntBuffer());
    }

    public void getIntsAtOffset(long l2, int[] nArray, int n2, int n3) {
        this.getIntBufferAtOffset(l2, n3).get(nArray, n2, n3);
    }

    public Pointer setInts(IntBuffer intBuffer) {
        return this.setIntsAtOffset(0L, intBuffer, 0L, (long)intBuffer.capacity());
    }

    public Pointer setIntsAtOffset(long l2, IntBuffer intBuffer) {
        return this.setIntsAtOffset(l2, intBuffer, 0L, (long)intBuffer.capacity());
    }

    public Pointer setIntsAtOffset(long l2, IntBuffer intBuffer, long l3, long l4) {
        if (intBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (intBuffer.isDirect()) {
            long l5 = l4 * 4L;
            long l6 = l3 * 4L;
            long l7 = JNI.getDirectBufferCapacity(intBuffer);
            if ((l7 *= 4L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 4L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 4L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(intBuffer) + l6, l5);
        } else if (intBuffer.isReadOnly()) {
            this.getIntBufferAtOffset(l2, l4).put(intBuffer.duplicate());
        } else {
            this.setIntsAtOffset(l2, intBuffer.array(), (int)((long)intBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public IntBuffer getIntBuffer(long l2) {
        return this.getIntBufferAtOffset(0L, l2);
    }

    public IntBuffer getIntBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getIntBuffer(long length) instead.");
        return this.getIntBufferAtOffset(0L, l2 / 4L);
    }

    public IntBuffer getIntBufferAtOffset(long l2, long l3) {
        long l4 = 4L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer.asIntBuffer();
    }

    public void getLongs(long[] lArray) {
        this.getLongBuffer().get(lArray);
    }

    public void getLongs(LongBuffer longBuffer) {
        longBuffer.duplicate().put(this.getLongBuffer());
    }

    public void getLongsAtOffset(long l2, long[] lArray, int n2, int n3) {
        this.getLongBufferAtOffset(l2, n3).get(lArray, n2, n3);
    }

    public Pointer setLongs(LongBuffer longBuffer) {
        return this.setLongsAtOffset(0L, longBuffer, 0L, (long)longBuffer.capacity());
    }

    public Pointer setLongsAtOffset(long l2, LongBuffer longBuffer) {
        return this.setLongsAtOffset(l2, longBuffer, 0L, (long)longBuffer.capacity());
    }

    public Pointer setLongsAtOffset(long l2, LongBuffer longBuffer, long l3, long l4) {
        if (longBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (longBuffer.isDirect()) {
            long l5 = l4 * 8L;
            long l6 = l3 * 8L;
            long l7 = JNI.getDirectBufferCapacity(longBuffer);
            if ((l7 *= 8L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 8L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 8L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(longBuffer) + l6, l5);
        } else if (longBuffer.isReadOnly()) {
            this.getLongBufferAtOffset(l2, l4).put(longBuffer.duplicate());
        } else {
            this.setLongsAtOffset(l2, longBuffer.array(), (int)((long)longBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public LongBuffer getLongBuffer(long l2) {
        return this.getLongBufferAtOffset(0L, l2);
    }

    public LongBuffer getLongBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getLongBuffer(long length) instead.");
        return this.getLongBufferAtOffset(0L, l2 / 8L);
    }

    public LongBuffer getLongBufferAtOffset(long l2, long l3) {
        long l4 = 8L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer.asLongBuffer();
    }

    public void getShorts(short[] sArray) {
        this.getShortBuffer().get(sArray);
    }

    public void getShorts(ShortBuffer shortBuffer) {
        shortBuffer.duplicate().put(this.getShortBuffer());
    }

    public void getShortsAtOffset(long l2, short[] sArray, int n2, int n3) {
        this.getShortBufferAtOffset(l2, n3).get(sArray, n2, n3);
    }

    public Pointer setShorts(ShortBuffer shortBuffer) {
        return this.setShortsAtOffset(0L, shortBuffer, 0L, (long)shortBuffer.capacity());
    }

    public Pointer setShortsAtOffset(long l2, ShortBuffer shortBuffer) {
        return this.setShortsAtOffset(l2, shortBuffer, 0L, (long)shortBuffer.capacity());
    }

    public Pointer setShortsAtOffset(long l2, ShortBuffer shortBuffer, long l3, long l4) {
        if (shortBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (shortBuffer.isDirect()) {
            long l5 = l4 * 2L;
            long l6 = l3 * 2L;
            long l7 = JNI.getDirectBufferCapacity(shortBuffer);
            if ((l7 *= 2L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 2L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 2L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(shortBuffer) + l6, l5);
        } else if (shortBuffer.isReadOnly()) {
            this.getShortBufferAtOffset(l2, l4).put(shortBuffer.duplicate());
        } else {
            this.setShortsAtOffset(l2, shortBuffer.array(), (int)((long)shortBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public ShortBuffer getShortBuffer(long l2) {
        return this.getShortBufferAtOffset(0L, l2);
    }

    public ShortBuffer getShortBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getShortBuffer(long length) instead.");
        return this.getShortBufferAtOffset(0L, l2 / 2L);
    }

    public ShortBuffer getShortBufferAtOffset(long l2, long l3) {
        long l4 = 2L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer.asShortBuffer();
    }

    public void getBytes(byte[] byArray) {
        this.getByteBuffer().get(byArray);
    }

    public void getBytes(ByteBuffer byteBuffer) {
        byteBuffer.duplicate().put(this.getByteBuffer());
    }

    public void getBytesAtOffset(long l2, byte[] byArray, int n2, int n3) {
        this.getByteBufferAtOffset(l2, n3).get(byArray, n2, n3);
    }

    public Pointer setBytes(ByteBuffer byteBuffer) {
        return this.setBytesAtOffset(0L, byteBuffer, 0L, (long)byteBuffer.capacity());
    }

    public Pointer setBytesAtOffset(long l2, ByteBuffer byteBuffer) {
        return this.setBytesAtOffset(l2, byteBuffer, 0L, (long)byteBuffer.capacity());
    }

    public Pointer setBytesAtOffset(long l2, ByteBuffer byteBuffer, long l3, long l4) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (byteBuffer.isDirect()) {
            long l5 = l4 * 1L;
            long l6 = l3 * 1L;
            long l7 = JNI.getDirectBufferCapacity(byteBuffer);
            if ((l7 *= 1L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 1L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 1L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(byteBuffer) + l6, l5);
        } else if (byteBuffer.isReadOnly()) {
            this.getByteBufferAtOffset(l2, l4).put(byteBuffer.duplicate());
        } else {
            this.setBytesAtOffset(l2, byteBuffer.array(), (int)((long)byteBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public ByteBuffer getByteBuffer(long l2) {
        return this.getByteBufferAtOffset(0L, l2);
    }

    public ByteBuffer getByteBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getByteBuffer(long length) instead.");
        return this.getByteBufferAtOffset(0L, l2 / 1L);
    }

    public ByteBuffer getByteBufferAtOffset(long l2, long l3) {
        long l4 = 1L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer;
    }

    public Pointer setChars(CharBuffer charBuffer) {
        return this.setCharsAtOffset(0L, charBuffer, 0L, (long)charBuffer.capacity());
    }

    public Pointer setCharsAtOffset(long l2, CharBuffer charBuffer) {
        return this.setCharsAtOffset(l2, charBuffer, 0L, (long)charBuffer.capacity());
    }

    public Pointer setCharsAtOffset(long l2, CharBuffer charBuffer, long l3, long l4) {
        if (charBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (Platform.WCHAR_T_SIZE == 4) {
            int n2 = 0;
            while ((long)n2 < l4) {
                this.setCharAtOffset(l2 + (long)n2, charBuffer.get((int)(l3 + (long)n2)));
                ++n2;
            }
            return this;
        }
        if (charBuffer.isDirect()) {
            long l5 = l4 * (long)Platform.WCHAR_T_SIZE;
            long l6 = l3 * (long)Platform.WCHAR_T_SIZE;
            long l7 = JNI.getDirectBufferCapacity(charBuffer);
            if ((l7 *= (long)Platform.WCHAR_T_SIZE) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + (long)Platform.WCHAR_T_SIZE * l4 > this.validEnd)) {
                this.invalidPeer(l8, (long)Platform.WCHAR_T_SIZE * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(charBuffer) + l6, l5);
        } else {
            this.setCharsAtOffset(l2, charBuffer.array(), (int)((long)charBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public void getFloats(float[] fArray) {
        this.getFloatBuffer().get(fArray);
    }

    public void getFloats(FloatBuffer floatBuffer) {
        floatBuffer.duplicate().put(this.getFloatBuffer());
    }

    public void getFloatsAtOffset(long l2, float[] fArray, int n2, int n3) {
        this.getFloatBufferAtOffset(l2, n3).get(fArray, n2, n3);
    }

    public Pointer setFloats(FloatBuffer floatBuffer) {
        return this.setFloatsAtOffset(0L, floatBuffer, 0L, (long)floatBuffer.capacity());
    }

    public Pointer setFloatsAtOffset(long l2, FloatBuffer floatBuffer) {
        return this.setFloatsAtOffset(l2, floatBuffer, 0L, (long)floatBuffer.capacity());
    }

    public Pointer setFloatsAtOffset(long l2, FloatBuffer floatBuffer, long l3, long l4) {
        if (floatBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (floatBuffer.isDirect()) {
            long l5 = l4 * 4L;
            long l6 = l3 * 4L;
            long l7 = JNI.getDirectBufferCapacity(floatBuffer);
            if ((l7 *= 4L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 4L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 4L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(floatBuffer) + l6, l5);
        } else if (floatBuffer.isReadOnly()) {
            this.getFloatBufferAtOffset(l2, l4).put(floatBuffer.duplicate());
        } else {
            this.setFloatsAtOffset(l2, floatBuffer.array(), (int)((long)floatBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public FloatBuffer getFloatBuffer(long l2) {
        return this.getFloatBufferAtOffset(0L, l2);
    }

    public FloatBuffer getFloatBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getFloatBuffer(long length) instead.");
        return this.getFloatBufferAtOffset(0L, l2 / 4L);
    }

    public FloatBuffer getFloatBufferAtOffset(long l2, long l3) {
        long l4 = 4L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer.asFloatBuffer();
    }

    public void getDoubles(double[] dArray) {
        this.getDoubleBuffer().get(dArray);
    }

    public void getDoubles(DoubleBuffer doubleBuffer) {
        doubleBuffer.duplicate().put(this.getDoubleBuffer());
    }

    public void getDoublesAtOffset(long l2, double[] dArray, int n2, int n3) {
        this.getDoubleBufferAtOffset(l2, n3).get(dArray, n2, n3);
    }

    public Pointer setDoubles(DoubleBuffer doubleBuffer) {
        return this.setDoublesAtOffset(0L, doubleBuffer, 0L, (long)doubleBuffer.capacity());
    }

    public Pointer setDoublesAtOffset(long l2, DoubleBuffer doubleBuffer) {
        return this.setDoublesAtOffset(l2, doubleBuffer, 0L, (long)doubleBuffer.capacity());
    }

    public Pointer setDoublesAtOffset(long l2, DoubleBuffer doubleBuffer, long l3, long l4) {
        if (doubleBuffer == null) {
            throw new IllegalArgumentException("Null values");
        }
        if (doubleBuffer.isDirect()) {
            long l5 = l4 * 8L;
            long l6 = l3 * 8L;
            long l7 = JNI.getDirectBufferCapacity(doubleBuffer);
            if ((l7 *= 8L) < l6 + l5) {
                throw new IndexOutOfBoundsException("The provided buffer has a capacity (" + l7 + " bytes) smaller than the requested write operation (" + l5 + " bytes starting at byte offset " + l6 + ")");
            }
            long l8 = this.getPeer() + l2;
            if (this.validStart != -1L && (l8 < this.validStart || l8 + 8L * l4 > this.validEnd)) {
                this.invalidPeer(l8, 8L * l4);
            }
            JNI.memcpy(l8, JNI.getDirectBufferAddress(doubleBuffer) + l6, l5);
        } else if (doubleBuffer.isReadOnly()) {
            this.getDoubleBufferAtOffset(l2, l4).put(doubleBuffer.duplicate());
        } else {
            this.setDoublesAtOffset(l2, doubleBuffer.array(), (int)((long)doubleBuffer.arrayOffset() + l3), (int)l4);
        }
        return this;
    }

    public DoubleBuffer getDoubleBuffer(long l2) {
        return this.getDoubleBufferAtOffset(0L, l2);
    }

    public DoubleBuffer getDoubleBuffer() {
        long l2 = this.getValidBytes("Cannot create buffer if remaining length is not known. Please use getDoubleBuffer(long length) instead.");
        return this.getDoubleBufferAtOffset(0L, l2 / 8L);
    }

    public DoubleBuffer getDoubleBufferAtOffset(long l2, long l3) {
        long l4 = 8L * l3;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l4 > this.validEnd)) {
            this.invalidPeer(l5, l4);
        }
        ByteBuffer byteBuffer = JNI.newDirectByteBuffer(l5, l4);
        byteBuffer.order(this.order());
        return byteBuffer.asDoubleBuffer();
    }

    private static void notAString(Pointer$StringType pointer$StringType, String string) {
        throw new RuntimeException("There is no " + (Object)((Object)pointer$StringType) + " String here ! (" + string + ")");
    }

    protected void checkIntRefCount(Pointer$StringType pointer$StringType, long l2) {
        int n2 = this.getIntAtOffset(l2);
        if (n2 <= 0) {
            Pointer.notAString(pointer$StringType, "invalid refcount: " + n2);
        }
    }

    public String getString(Pointer$StringType pointer$StringType) {
        return this.getStringAtOffset(0L, pointer$StringType, null);
    }

    public String getString(Pointer$StringType pointer$StringType, Charset charset) {
        return this.getStringAtOffset(0L, pointer$StringType, charset);
    }

    String getSTLStringAtOffset(long l2, Pointer$StringType pointer$StringType, Charset charset) {
        char c2;
        Pointer pointer;
        long l3;
        boolean bl2 = pointer$StringType == Pointer$StringType.WideSTL;
        int n2 = 16;
        int n3 = bl2 ? n2 * Platform.WCHAR_T_SIZE : n2;
        long l4 = this.getSizeTAtOffset(l2 + (long)n3 + (long)SIZE);
        if (l4 < (long)(n2 - 1)) {
            l3 = l2;
            pointer = this;
        } else {
            l3 = 0L;
            pointer = this.getPointerAtOffset(l2 + (long)n3 + (long)SIZE);
        }
        char c3 = c2 = bl2 ? pointer.getCharAtOffset(l3 + l4 * (long)Platform.WCHAR_T_SIZE) : pointer.getByteAtOffset(l3 + l4);
        if (c2 != '\u0000') {
            Pointer.notAString(pointer$StringType, "STL string format is not recognized : did not find a NULL char at the expected end of string of expected length " + l4);
        }
        return pointer.getStringAtOffset(l3, bl2 ? Pointer$StringType.WideC : Pointer$StringType.C, charset);
    }

    static Pointer setSTLString(Pointer pointer, long l2, String string, Pointer$StringType pointer$StringType, Charset charset) {
        char c2;
        Pointer pointer2;
        long l3;
        boolean bl2 = pointer$StringType == Pointer$StringType.WideSTL;
        int n2 = 16;
        int n3 = bl2 ? n2 * Platform.WCHAR_T_SIZE : n2;
        long l4 = l2 + (long)n3 + (long)SIZE;
        long l5 = l4 + (long)SIZE;
        long l6 = string.length();
        if (pointer == null) {
            throw new UnsupportedOperationException("Cannot create STL strings (yet)");
        }
        long l7 = pointer.getSizeTAtOffset(l4);
        long l8 = pointer.getSizeTAtOffset(l5);
        if (l7 < 0L || l8 < 0L || l7 > l8) {
            Pointer.notAString(pointer$StringType, "STL string format not recognized : currentLength = " + l7 + ", currentCapacity = " + l8);
        }
        if (l6 > l8) {
            throw new RuntimeException("The target STL string is not large enough to write a string of length " + l6 + " (current capacity = " + l8 + ")");
        }
        pointer.setSizeTAtOffset(l4, l6);
        if (l6 < (long)(n2 - 1)) {
            l3 = l2;
            pointer2 = pointer;
        } else {
            l3 = 0L;
            pointer2 = pointer.getPointerAtOffset(l2 + (long)n3 + (long)SizeT.SIZE);
        }
        char c3 = c2 = bl2 ? pointer2.getCharAtOffset(l3 + l7 * (long)Platform.WCHAR_T_SIZE) : pointer2.getByteAtOffset(l3 + l7);
        if (c2 != '\u0000') {
            Pointer.notAString(pointer$StringType, "STL string format is not recognized : did not find a NULL char at the expected end of string of expected length " + l7);
        }
        pointer2.setStringAtOffset(l3, string, bl2 ? Pointer$StringType.WideC : Pointer$StringType.C, charset);
        return pointer;
    }

    public String getStringAtOffset(long l2, Pointer$StringType pointer$StringType, Charset charset) {
        try {
            switch (pointer$StringType) {
                case PascalShort: {
                    long l3 = this.getByteAtOffset(l2) & 0xFF;
                    return new String(this.getBytesAtOffset(l2 + 1L, SizeT.safeIntCast(l3)), Pointer.charset(charset));
                }
                case PascalWide: {
                    this.checkIntRefCount(pointer$StringType, l2 - 8L);
                }
                case BSTR: {
                    long l4 = this.getIntAtOffset(l2 - 4L);
                    if (l4 < 0L || (l4 & 1L) == 1L) {
                        Pointer.notAString(pointer$StringType, "invalid byte length: " + l4);
                    }
                    if (this.getCharAtOffset(l2 + l4) != '\u0000') {
                        Pointer.notAString(pointer$StringType, "no null short after the " + l4 + " declared bytes");
                    }
                    return new String(this.getCharsAtOffset(l2, SizeT.safeIntCast(l4 / (long)Platform.WCHAR_T_SIZE)));
                }
                case PascalAnsi: {
                    this.checkIntRefCount(pointer$StringType, l2 - 8L);
                    long l5 = this.getIntAtOffset(l2 - 4L);
                    if (l5 < 0L) {
                        Pointer.notAString(pointer$StringType, "invalid byte length: " + l5);
                    }
                    if (this.getByteAtOffset(l2 + l5) != 0) {
                        Pointer.notAString(pointer$StringType, "no null short after the " + l5 + " declared bytes");
                    }
                    return new String(this.getBytesAtOffset(l2, SizeT.safeIntCast(l5)), Pointer.charset(charset));
                }
                case C: {
                    long l6 = this.strlen(l2);
                    return new String(this.getBytesAtOffset(l2, SizeT.safeIntCast(l6)), Pointer.charset(charset));
                }
                case WideC: {
                    long l7 = this.wcslen(l2);
                    return new String(this.getCharsAtOffset(l2, SizeT.safeIntCast(l7)));
                }
                case STL: 
                case WideSTL: {
                    return this.getSTLStringAtOffset(l2, pointer$StringType, charset);
                }
            }
            throw new RuntimeException("Unhandled string type : " + (Object)((Object)pointer$StringType));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Pointer.throwUnexpected(unsupportedEncodingException);
            return null;
        }
    }

    public Pointer setString(String string, Pointer$StringType pointer$StringType) {
        return Pointer.setString(this, 0L, string, pointer$StringType, null);
    }

    public Pointer setStringAtOffset(long l2, String string, Pointer$StringType pointer$StringType, Charset charset) {
        return Pointer.setString(this, l2, string, pointer$StringType, charset);
    }

    private static String charset(Charset charset) {
        return (charset == null ? Charset.defaultCharset() : charset).name();
    }

    static Pointer setString(Pointer pointer, long l2, String string, Pointer$StringType pointer$StringType, Charset charset) {
        try {
            if (string == null) {
                return null;
            }
            switch (pointer$StringType) {
                case PascalShort: {
                    byte[] byArray = string.getBytes(Pointer.charset(charset));
                    int n2 = byArray.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(n2 + 1);
                    }
                    if (n2 > 255) {
                        throw new IllegalArgumentException("Pascal strings cannot be more than 255 chars long (tried to write string of byte length " + n2 + ")");
                    }
                    pointer.setByteAtOffset(l2, (byte)n2);
                    pointer.setBytesAtOffset(l2 + 1L, byArray, 0, n2);
                    break;
                }
                case C: {
                    byte[] byArray = string.getBytes(Pointer.charset(charset));
                    int n3 = byArray.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(n3 + 1);
                    }
                    pointer.setBytesAtOffset(l2, byArray, 0, n3);
                    pointer.setByteAtOffset(l2 + (long)n3, (byte)0);
                    break;
                }
                case WideC: {
                    char[] cArray = string.toCharArray();
                    int n4 = cArray.length * Platform.WCHAR_T_SIZE;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(n4 + 2);
                    }
                    pointer.setCharsAtOffset(l2, cArray);
                    pointer.setCharAtOffset(l2 + (long)n4, '\u0000');
                    break;
                }
                case PascalWide: {
                    int n5;
                    int n6 = 8;
                    char[] cArray = string.toCharArray();
                    int n7 = cArray.length * Platform.WCHAR_T_SIZE;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(n6 + n7 + 2);
                        n5 = n6;
                        l2 = n5;
                    } else {
                        n5 = 0;
                    }
                    pointer.setIntAtOffset(l2 - 8L, 1);
                    pointer.setIntAtOffset(l2 - 4L, n7);
                    pointer.setCharsAtOffset(l2, cArray);
                    pointer.setCharAtOffset(l2 + (long)n7, '\u0000');
                    return pointer.offset(n5);
                }
                case PascalAnsi: {
                    int n8;
                    int n9 = 8;
                    byte[] byArray = string.getBytes(Pointer.charset(charset));
                    int n10 = byArray.length;
                    if (pointer == null) {
                        pointer = Pointer.allocateBytes(n9 + n10 + 1);
                        n8 = n9;
                        l2 = n8;
                    } else {
                        n8 = 0;
                    }
                    pointer.setIntAtOffset(l2 - 8L, 1);
                    pointer.setIntAtOffset(l2 - 4L, n10);
                    pointer.setBytesAtOffset(l2, byArray);
                    pointer.setByteAtOffset(l2 + (long)n10, (byte)0);
                    return pointer.offset(n8);
                }
                case BSTR: {
                    int n11;
                    int n12 = 4;
                    char[] cArray = string.toCharArray();
                    int n13 = cArray.length * Platform.WCHAR_T_SIZE;
                    if (pointer == null) {
                        pointer = Pointer.allocateChars(n12 + n13 + 2);
                        n11 = n12;
                        l2 = n11;
                    } else {
                        n11 = 0;
                    }
                    pointer.setIntAtOffset(l2 - 4L, n13);
                    pointer.setCharsAtOffset(l2, cArray);
                    pointer.setCharAtOffset(l2 + (long)n13, '\u0000');
                    return pointer.offset(n11);
                }
                case STL: 
                case WideSTL: {
                    return Pointer.setSTLString(pointer, l2, string, pointer$StringType, charset);
                }
                default: {
                    throw new RuntimeException("Unhandled string type : " + (Object)((Object)pointer$StringType));
                }
            }
            return pointer;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Pointer.throwUnexpected(unsupportedEncodingException);
            return null;
        }
    }

    public static Pointer pointerToString(String string, Pointer$StringType pointer$StringType, Charset charset) {
        return Pointer.setString(null, 0L, string, pointer$StringType, charset);
    }

    public static Pointer pointerToCString(String string) {
        return Pointer.setString(null, 0L, string, Pointer$StringType.C, null);
    }

    public static Pointer pointerToCStrings(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        Pointer[] pointerArray = new Pointer[n2];
        Pointer pointer = Pointer.allocateArray(PointerIO.getPointerInstance(Byte.class), n2, new Pointer$6(n2, pointerArray));
        for (int i2 = 0; i2 < n2; ++i2) {
            pointerArray[i2] = Pointer.pointerToCString(stringArray[i2]);
            pointer.set(i2, pointerArray[i2]);
        }
        return pointer;
    }

    public static Pointer pointerToWideCString(String string) {
        return Pointer.setString(null, 0L, string, Pointer$StringType.WideC, null);
    }

    public static Pointer pointerToWideCStrings(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        Pointer[] pointerArray = new Pointer[n2];
        Pointer pointer = Pointer.allocateArray(PointerIO.getPointerInstance(Character.class), n2, new Pointer$7(n2, pointerArray));
        for (int i2 = 0; i2 < n2; ++i2) {
            pointerArray[i2] = Pointer.pointerToWideCString(stringArray[i2]);
            pointer.set(i2, pointerArray[i2]);
        }
        return pointer;
    }

    public String getCString() {
        return this.getCStringAtOffset(0L);
    }

    public String getCStringAtOffset(long l2) {
        return this.getStringAtOffset(l2, Pointer$StringType.C, null);
    }

    public Pointer setCString(String string) {
        return this.setCStringAtOffset(0L, string);
    }

    public Pointer setCStringAtOffset(long l2, String string) {
        return this.setStringAtOffset(l2, string, Pointer$StringType.C, null);
    }

    public String getWideCString() {
        return this.getWideCStringAtOffset(0L);
    }

    public String getWideCStringAtOffset(long l2) {
        return this.getStringAtOffset(l2, Pointer$StringType.WideC, null);
    }

    public Pointer setWideCString(String string) {
        return this.setWideCStringAtOffset(0L, string);
    }

    public Pointer setWideCStringAtOffset(long l2, String string) {
        return this.setStringAtOffset(l2, string, Pointer$StringType.WideC, null);
    }

    protected long strlen(long l2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + 1L > this.validEnd)) {
            this.invalidPeer(l3, 1L);
        }
        return JNI.strlen(l3);
    }

    protected long wcslen(long l2) {
        long l3 = this.getPeer() + l2;
        if (this.validStart != -1L && (l3 < this.validStart || l3 + (long)Platform.WCHAR_T_SIZE > this.validEnd)) {
            this.invalidPeer(l3, Platform.WCHAR_T_SIZE);
        }
        return JNI.wcslen(l3);
    }

    public void clearValidBytes() {
        long l2 = this.getValidBytes();
        if (l2 < 0L) {
            throw new UnsupportedOperationException("Number of valid bytes is unknown. Please use clearBytes(long) or validBytes(long).");
        }
        this.clearBytes(l2);
    }

    public void clearBytes(long l2) {
        this.clearBytesAtOffset(0L, l2, (byte)0);
    }

    public void clearBytesAtOffset(long l2, long l3, byte by2) {
        long l4 = this.getPeer() + l2;
        if (this.validStart != -1L && (l4 < this.validStart || l4 + l3 > this.validEnd)) {
            this.invalidPeer(l4, l3);
        }
        JNI.memset(l4, by2, l3);
    }

    public Pointer findByte(long l2, byte by2, long l3) {
        long l4;
        long l5 = this.getPeer() + l2;
        if (this.validStart != -1L && (l5 < this.validStart || l5 + l3 > this.validEnd)) {
            this.invalidPeer(l5, l3);
        }
        return (l4 = JNI.memchr(l5, by2, l3)) == 0L ? null : this.offset(l4 - l5);
    }

    public final Object apply(long l2) {
        return this.get(l2);
    }

    public final void update(long l2, Object object) {
        this.set(l2, object);
    }

    public Object[] toArray() {
        this.getIO("Cannot create array");
        return this.toArray((int)this.getValidElements("Length of pointed memory is unknown, cannot create array out of this pointer"));
    }

    Object[] toArray(int n2) {
        Class clazz = Utils.getClass(this.getIO("Cannot create array").getTargetType());
        if (clazz == null) {
            throw new RuntimeException("Unable to get the target type's class (target type = " + this.io.getTargetType() + ")");
        }
        return this.toArray((Object[])Array.newInstance(clazz, n2));
    }

    public Object[] toArray(Object[] objectArray) {
        int n2 = (int)this.getValidElements();
        if (n2 < 0) {
            Pointer.throwBecauseUntyped("Cannot create array");
        }
        if (objectArray.length != n2) {
            return this.toArray();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.get(i2);
        }
        return objectArray;
    }

    public NativeList asList() {
        return this.asList(Pointer$ListType.FixedCapacity);
    }

    public NativeList asList(Pointer$ListType pointer$ListType) {
        return new DefaultNativeList(this, pointer$ListType);
    }

    public static NativeList allocateList(PointerIO pointerIO, long l2) {
        DefaultNativeList defaultNativeList = new DefaultNativeList(Pointer.allocateArray(pointerIO, l2), Pointer$ListType.Dynamic);
        defaultNativeList.clear();
        return defaultNativeList;
    }

    public static NativeList allocateList(Class clazz, long l2) {
        return Pointer.allocateList((Type)clazz, l2);
    }

    public static NativeList allocateList(Type type, long l2) {
        return Pointer.allocateList(PointerIO.getInstance(type), l2);
    }

    private static char[] intsToWChars(int[] nArray) {
        int n2 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)nArray[i2];
        }
        return cArray;
    }

    private static int[] wcharsToInts(char[] cArray, int n2, int n3) {
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = cArray[n2 + i2];
        }
        return nArray;
    }

    public Pointer setIntegralAtOffset(long l2, AbstractIntegral abstractIntegral) {
        switch (abstractIntegral.byteSize()) {
            case 8: {
                this.setLongAtOffset(l2, abstractIntegral.longValue());
                break;
            }
            case 4: {
                this.setIntAtOffset(l2, SizeT.safeIntCast(abstractIntegral.longValue()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported integral size");
            }
        }
        return this;
    }

    public long getIntegralAtOffset(long l2, int n2) {
        switch (n2) {
            case 8: {
                return this.getLongAtOffset(l2);
            }
            case 4: {
                return this.getIntAtOffset(l2);
            }
        }
        throw new UnsupportedOperationException("Unsupported integral size");
    }

    static /* synthetic */ Pointer access$000(long l2, PointerIO pointerIO) {
        return Pointer.pointerToAddress_(l2, pointerIO);
    }

    static {
        Platform.initLibrary();
        POINTER_MASK = Platform.is64Bits() ? -1L : 0xFFFFFFFFL;
        defaultAlignment = Integer.parseInt(Platform.getenvOrProperty("BRIDJ_DEFAULT_ALIGNMENT", "bridj.defaultAlignment", "-1"));
        localCachedPointers = new Pointer$2();
        freeReleaser = new Pointer$FreeReleaser();
    }
}

