/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    public int handle;
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        super(device);
        this.device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new(0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float f2) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        f2 = Math.max(0.0f, f2);
        this.handle = Gdip.GraphicsPath_Clone(path.handle);
        if (f2 != 0.0f) {
            Gdip.GraphicsPath_Flatten(this.handle, 0, f2);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData pathData) {
        this(device);
        if (pathData == null) {
            SWT.error(4);
        }
        this.init(pathData);
    }

    public void addArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        f4 = DPIUtil.autoScaleUp(f4);
        f5 = DPIUtil.autoScaleUp(f5);
        this.addArcInPixels(f2, f3, f4, f5, f6, f7);
    }

    void addArcInPixels(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f3 += f5;
            f5 = -f5;
        }
        if (f4 == 0.0f || f5 == 0.0f || f7 == 0.0f) {
            return;
        }
        if (f4 == f5) {
            Gdip.GraphicsPath_AddArc(this.handle, f2, f3, f4, f5, -f6, -f7);
        } else {
            int n2;
            int n3 = Gdip.GraphicsPath_new(0);
            if (n3 == 0) {
                SWT.error(2);
            }
            if ((n2 = Gdip.Matrix_new(f4, 0.0f, 0.0f, f5, f2, f3)) == 0) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc(n3, 0.0f, 0.0f, 1.0f, 1.0f, -f6, -f7);
            Gdip.GraphicsPath_Transform(n3, n2);
            Gdip.GraphicsPath_AddPath(this.handle, n3, true);
            Gdip.Matrix_delete(n2);
            Gdip.GraphicsPath_delete(n3);
        }
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.handle, path.handle, false);
        this.currentPoint.X = path.currentPoint.X;
        this.currentPoint.Y = path.currentPoint.Y;
    }

    public void addRectangle(float f2, float f3, float f4, float f5) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        f4 = DPIUtil.autoScaleUp(f4);
        f5 = DPIUtil.autoScaleUp(f5);
        this.addRectangleInPixels(f2, f3, f4, f5);
    }

    void addRectangleInPixels(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rectF = new RectF();
        rectF.X = f2;
        rectF.Y = f3;
        rectF.Width = f4;
        rectF.Height = f5;
        Gdip.GraphicsPath_AddRectangle(this.handle, rectF);
        this.currentPoint.X = f2;
        this.currentPoint.Y = f3;
    }

    public void addString(String string, float f2, float f3, Font font) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        this.addStringInPixels(string, f2, f3, font);
    }

    void addStringInPixels(String string, float f2, float f3, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = this.device.internal_new_GC(null);
        int[] nArray = new int[1];
        int n4 = GC.createGdipFont(n3, font.handle, 0, this.device.fontCollection, nArray, null);
        PointF pointF = new PointF();
        pointF.X = f2 - Gdip.Font_GetSize(n4) / 6.0f;
        pointF.Y = f3;
        int n5 = Gdip.Font_GetStyle(n4);
        float f4 = Gdip.Font_GetSize(n4);
        Gdip.GraphicsPath_AddString(this.handle, cArray, n2, nArray[0], n5, f4, pointF, 0);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
        Gdip.FontFamily_delete(nArray[0]);
        Gdip.Font_delete(n4);
        this.device.internal_dispose_GC(n3, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.handle);
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float f2, float f3, GC gC, boolean bl2) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        return this.containsInPixels(f2, f3, gC, bl2);
    }

    boolean containsInPixels(float f2, float f3, GC gC, boolean bl2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.initGdip();
        gC.checkGC(120);
        int n2 = OS.GetPolyFillMode(gC.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(this.handle, n2);
        if (bl2) {
            return Gdip.GraphicsPath_IsOutlineVisible(this.handle, f2, f3, gC.data.gdipPen, gC.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible(this.handle, f2, f3, gC.data.gdipGraphics);
    }

    public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        f4 = DPIUtil.autoScaleUp(f4);
        f5 = DPIUtil.autoScaleUp(f5);
        f6 = DPIUtil.autoScaleUp(f6);
        f7 = DPIUtil.autoScaleUp(f7);
        this.cubicToInPixels(f2, f3, f4, f5, f6, f7);
    }

    void cubicToInPixels(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f2, f3, f4, f5, f6, f7);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    @Override
    void destroy() {
        Gdip.GraphicsPath_delete(this.handle);
        this.handle = 0;
    }

    public void getBounds(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        this.getBoundsInPixels(fArray);
        fArray = DPIUtil.autoScaleDown(fArray);
    }

    void getBoundsInPixels(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        RectF rectF = new RectF();
        Gdip.GraphicsPath_GetBounds(this.handle, rectF, 0, 0);
        fArray[0] = rectF.X;
        fArray[1] = rectF.Y;
        fArray[2] = rectF.Width;
        fArray[3] = rectF.Height;
    }

    public void getCurrentPoint(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        this.getCurrentPointInPixels(fArray);
        fArray = DPIUtil.autoScaleDown(fArray);
    }

    void getCurrentPointInPixels(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        fArray[0] = this.currentPoint.X;
        fArray[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        PathData pathData = this.getPathDataInPixels();
        pathData.points = DPIUtil.autoScaleDown(pathData.points);
        return pathData;
    }

    PathData getPathDataInPixels() {
        int n2 = Gdip.GraphicsPath_GetPointCount(this.handle);
        byte[] byArray = new byte[n2];
        float[] fArray = new float[n2 * 2];
        Gdip.GraphicsPath_GetPathTypes(this.handle, byArray, n2);
        Gdip.GraphicsPath_GetPathPoints(this.handle, fArray, n2);
        byte[] byArray2 = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by2 = byArray[n3];
            boolean bl2 = false;
            switch (by2 & 7) {
                case 0: {
                    byArray2[n4++] = 1;
                    bl2 = (by2 & 0x80) != 0;
                    ++n3;
                    break;
                }
                case 1: {
                    byArray2[n4++] = 2;
                    bl2 = (by2 & 0x80) != 0;
                    ++n3;
                    break;
                }
                case 3: {
                    byArray2[n4++] = 4;
                    bl2 = (byArray[n3 + 2] & 0x80) != 0;
                    n3 += 3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
            if (!bl2) continue;
            byArray2[n4++] = 5;
        }
        if (n4 != byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            byArray2 = byArray3;
        }
        PathData pathData = new PathData();
        pathData.types = byArray2;
        pathData.points = fArray;
        return pathData;
    }

    public void lineTo(float f2, float f3) {
        this.lineToInPixels(DPIUtil.autoScaleUp(f2), DPIUtil.autoScaleUp(f3));
    }

    void lineToInPixels(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.handle, this.currentPoint.X, this.currentPoint.Y, f2, f3);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    void init(PathData pathData) {
        byte[] byArray = pathData.types;
        float[] fArray = pathData.points;
        int n2 = 0;
        block7: for (int i2 = 0; i2 < byArray.length; ++i2) {
            switch (byArray[i2]) {
                case 1: {
                    this.moveTo(fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 2: {
                    this.lineTo(fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 4: {
                    this.cubicTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 3: {
                    this.quadTo(fArray[n2++], fArray[n2++], fArray[n2++], fArray[n2++]);
                    continue block7;
                }
                case 5: {
                    this.close();
                    continue block7;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void moveTo(float f2, float f3) {
        this.moveToInPixels(DPIUtil.autoScaleUp(f2), DPIUtil.autoScaleUp(f3));
    }

    void moveToInPixels(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure(this.handle);
        this.currentPoint.X = this.startPoint.X = f2;
        this.currentPoint.Y = this.startPoint.Y = f3;
    }

    public void quadTo(float f2, float f3, float f4, float f5) {
        f2 = DPIUtil.autoScaleUp(f2);
        f3 = DPIUtil.autoScaleUp(f3);
        f4 = DPIUtil.autoScaleUp(f4);
        f5 = DPIUtil.autoScaleUp(f5);
        this.quadToInPixels(f2, f3, f4, f5);
    }

    void quadToInPixels(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float f6 = this.currentPoint.X + 2.0f * (f2 - this.currentPoint.X) / 3.0f;
        float f7 = this.currentPoint.Y + 2.0f * (f3 - this.currentPoint.Y) / 3.0f;
        float f8 = f6 + (f4 - this.currentPoint.X) / 3.0f;
        float f9 = f7 + (f5 - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f6, f7, f8, f9, f4, f5);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

