/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;

public class ImageList {
    int handle;
    int style;
    int refCount;
    Image[] images;

    public ImageList(int n2) {
        this(n2, 32, 32);
    }

    public ImageList(int n2, int n3, int n4) {
        this.style = n2;
        int n5 = 1;
        if (OS.IsWinCE) {
            n5 |= 0;
        } else if (OS.COMCTL32_MAJOR >= 6) {
            n5 |= 0x20;
        } else {
            int n6 = OS.GetDC(0);
            int n7 = OS.GetDeviceCaps(n6, 12);
            int n8 = OS.GetDeviceCaps(n6, 14);
            OS.ReleaseDC(0, n6);
            int n9 = n7 * n8;
            switch (n9) {
                case 4: {
                    n5 |= 4;
                    break;
                }
                case 8: {
                    n5 |= 8;
                    break;
                }
                case 16: {
                    n5 |= 0x10;
                    break;
                }
                case 24: {
                    n5 |= 0x18;
                    break;
                }
                case 32: {
                    n5 |= 0x20;
                    break;
                }
                default: {
                    n5 |= 0;
                }
            }
        }
        if ((n2 & 0x4000000) != 0) {
            n5 |= 0x2000;
        }
        this.handle = OS.ImageList_Create(n3, n4, n5, 16, 16);
        this.images = new Image[4];
    }

    public int add(Image image) {
        Image[] imageArray;
        int n2;
        int n3 = OS.ImageList_GetImageCount(this.handle);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.images[n2] != null && this.images[n2].isDisposed()) {
                this.images[n2] = null;
            }
            if (this.images[n2] == null) break;
        }
        if (n3 == 0) {
            imageArray = image.getBoundsInPixels();
            OS.ImageList_SetIconSize(this.handle, imageArray.width, imageArray.height);
        }
        this.set(n2, image, n3);
        if (n2 == this.images.length) {
            imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        return n2;
    }

    public int addRef() {
        return ++this.refCount;
    }

    int copyBitmap(int n2, int n3, int n4) {
        int n5;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n2, BITMAP.sizeof, bITMAP);
        int n6 = OS.GetDC(0);
        int n7 = OS.CreateCompatibleDC(n6);
        OS.SelectObject(n7, n2);
        int n8 = OS.CreateCompatibleDC(n6);
        if (bITMAP.bmBitsPixel == 32 && OS.COMCTL32_MAJOR >= 6) {
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER.biWidth = n3;
            bITMAPINFOHEADER.biHeight = -n4;
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)24;
            bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
            byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
            OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
            if (OS.IsWinCE) {
                int n9 = 65280;
                int n10 = 0xFF0000;
                int n11 = -16777216;
                int n12 = BITMAPINFOHEADER.sizeof;
                byArray[n12] = (byte)((n9 & 0xFF000000) >> 24);
                byArray[n12 + 1] = (byte)((n9 & 0xFF0000) >> 16);
                byArray[n12 + 2] = (byte)((n9 & 0xFF00) >> 8);
                byArray[n12 + 3] = (byte)((n9 & 0xFF) >> 0);
                byArray[n12 + 4] = (byte)((n10 & 0xFF000000) >> 24);
                byArray[n12 + 5] = (byte)((n10 & 0xFF0000) >> 16);
                byArray[n12 + 6] = (byte)((n10 & 0xFF00) >> 8);
                byArray[n12 + 7] = (byte)((n10 & 0xFF) >> 0);
                byArray[n12 + 8] = (byte)((n11 & 0xFF000000) >> 24);
                byArray[n12 + 9] = (byte)((n11 & 0xFF0000) >> 16);
                byArray[n12 + 10] = (byte)((n11 & 0xFF00) >> 8);
                byArray[n12 + 11] = (byte)((n11 & 0xFF) >> 0);
            }
            int[] nArray = new int[1];
            n5 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
        } else {
            n5 = OS.CreateCompatibleBitmap(n6, n3, n4);
        }
        OS.SelectObject(n8, n5);
        if (n3 != bITMAP.bmWidth || n4 != bITMAP.bmHeight) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n8, 3);
            }
            OS.StretchBlt(n8, 0, 0, n3, n4, n7, 0, 0, bITMAP.bmWidth, bITMAP.bmHeight, 0xCC0020);
        } else {
            OS.BitBlt(n8, 0, 0, n3, n4, n7, 0, 0, 0xCC0020);
        }
        OS.DeleteDC(n7);
        OS.DeleteDC(n8);
        OS.ReleaseDC(0, n6);
        return n5;
    }

    int copyIcon(int n2, int n3, int n4) {
        int n5;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (n5 = OS.CopyImage(n2, 1, n3, n4, 0)) != 0 ? n5 : n2;
    }

    int copyWithAlpha(int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        byte by2;
        byte by3;
        int n9;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n2, BITMAP.sizeof, bITMAP);
        int n10 = bITMAP.bmWidth;
        int n11 = bITMAP.bmHeight;
        int n12 = OS.GetDC(0);
        int n13 = OS.CreateCompatibleDC(n12);
        int n14 = OS.SelectObject(n13, n2);
        int n15 = OS.CreateCompatibleDC(n12);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n10;
        bITMAPINFOHEADER.biHeight = -n11;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray2 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray2, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n16 = OS.CreateDIBSection(0, byArray2, 0, nArray, 0, 0);
        if (n16 == 0) {
            SWT.error(2);
        }
        int n17 = OS.SelectObject(n15, n16);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(n16, BITMAP.sizeof, bITMAP2);
        int n18 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(n15, 0, 0, n10, n11, n13, 0, 0, 0xCC0020);
        byte[] byArray3 = new byte[n18];
        OS.MoveMemory(byArray3, bITMAP2.bmBits, n18);
        if (byArray != null) {
            n9 = bITMAP2.bmWidthBytes - n10 * 4;
            by3 = 0;
            by2 = 3;
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n10; ++n7) {
                    byte by4 = by3;
                    by3 = (byte)(by3 + 1);
                    byArray3[by2] = byArray[by4];
                    by2 += 4;
                }
                by2 += n9;
            }
        } else {
            n9 = n3 & 0xFF;
            by3 = (byte)(n3 >> 8 & 0xFF);
            by2 = (byte)(n3 >> 16 & 0xFF);
            n8 = bITMAP2.bmWidthBytes - n10 * 4;
            n7 = 3;
            for (n6 = 0; n6 < n11; ++n6) {
                for (int i2 = 0; i2 < n10; ++i2) {
                    byArray3[n7] = byArray3[n7 - 1] == n9 && byArray3[n7 - 2] == by3 && byArray3[n7 - 3] == by2 ? 0 : -1;
                    n7 += 4;
                }
                n7 += n8;
            }
        }
        OS.MoveMemory(bITMAP2.bmBits, byArray3, n18);
        if (n10 != n4 || n11 != n5) {
            BITMAPINFOHEADER bITMAPINFOHEADER2 = new BITMAPINFOHEADER();
            bITMAPINFOHEADER2.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER2.biWidth = n4;
            bITMAPINFOHEADER2.biHeight = -n5;
            bITMAPINFOHEADER2.biPlanes = 1;
            bITMAPINFOHEADER2.biBitCount = (short)32;
            bITMAPINFOHEADER2.biCompression = 0;
            byte[] byArray4 = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(byArray4, bITMAPINFOHEADER2, BITMAPINFOHEADER.sizeof);
            int[] nArray2 = new int[1];
            n8 = OS.CreateDIBSection(0, byArray4, 0, nArray2, 0, 0);
            n7 = OS.CreateCompatibleDC(n12);
            n6 = OS.SelectObject(n7, n8);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n7, 3);
            }
            OS.StretchBlt(n7, 0, 0, n4, n5, n15, 0, 0, n10, n11, 0xCC0020);
            OS.SelectObject(n7, n6);
            OS.DeleteDC(n7);
            OS.SelectObject(n15, n17);
            OS.DeleteDC(n15);
            OS.DeleteObject(n16);
            n16 = n8;
        } else {
            OS.SelectObject(n15, n17);
            OS.DeleteDC(n15);
        }
        OS.SelectObject(n13, n14);
        OS.DeleteDC(n13);
        OS.ReleaseDC(0, n12);
        return n16;
    }

    int createMaskFromAlpha(ImageData imageData, int n2, int n3) {
        int n4;
        int n5;
        int n6 = imageData.width;
        int n7 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n6, n7, 1, new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255)), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n8 = 0;
        for (n5 = 0; n5 < imageData2.height; ++n5) {
            for (n4 = 0; n4 < imageData2.width; ++n4) {
                imageData2.setPixel(n4, n5, (imageData.alphaData[n8++] & 0xFF) <= 127 ? 1 : 0);
            }
        }
        n5 = OS.CreateBitmap(n6, n7, 1, 1, imageData2.data);
        if (n6 != n2 || n7 != n3) {
            n4 = OS.GetDC(0);
            int n9 = OS.CreateCompatibleDC(n4);
            OS.SelectObject(n9, n5);
            int n10 = OS.CreateCompatibleDC(n4);
            int n11 = OS.CreateBitmap(n2, n3, 1, 1, null);
            OS.SelectObject(n10, n11);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n10, 3);
            }
            OS.StretchBlt(n10, 0, 0, n2, n3, n9, 0, 0, n6, n7, 0xCC0020);
            OS.DeleteDC(n9);
            OS.DeleteDC(n10);
            OS.ReleaseDC(0, n4);
            OS.DeleteObject(n5);
            n5 = n11;
        }
        return n5;
    }

    int createMask(int n2, int n3, int n4, int n5, int n6) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n2, BITMAP.sizeof, bITMAP);
        int n7 = bITMAP.bmWidth;
        int n8 = bITMAP.bmHeight;
        int n9 = OS.CreateBitmap(n3, n4, 1, 1, null);
        int n10 = OS.GetDC(0);
        int n11 = OS.CreateCompatibleDC(n10);
        if (n5 != -1) {
            int n12;
            OS.SelectObject(n11, n2);
            boolean bl2 = bITMAP.bmBits != 0;
            byte[] byArray = null;
            if (!OS.IsWinCE && n6 != -1 && bl2 && bITMAP.bmBitsPixel <= 8) {
                n12 = 1 << bITMAP.bmBitsPixel;
                byte[] byArray2 = new byte[n12 * 4];
                OS.GetDIBColorTable(n11, 0, n12, byArray2);
                int n13 = n6 * 4;
                byte[] byArray3 = new byte[byArray2.length];
                byArray3[n13] = -1;
                byArray3[n13 + 1] = -1;
                byArray3[n13 + 2] = -1;
                OS.SetDIBColorTable(n11, 0, n12, byArray3);
                byArray = byArray2;
                OS.SetBkColor(n11, 0xFFFFFF);
            } else {
                OS.SetBkColor(n11, n5);
            }
            n12 = OS.CreateCompatibleDC(n10);
            OS.SelectObject(n12, n9);
            if (n3 != n7 || n4 != n8) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(n12, 3);
                }
                OS.StretchBlt(n12, 0, 0, n3, n4, n11, 0, 0, n7, n8, 0xCC0020);
            } else {
                OS.BitBlt(n12, 0, 0, n3, n4, n11, 0, 0, 0xCC0020);
            }
            OS.DeleteDC(n12);
            if (byArray != null) {
                OS.SetDIBColorTable(n11, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
        } else {
            int n14 = OS.SelectObject(n11, n9);
            OS.PatBlt(n11, 0, 0, n3, n4, 66);
            OS.SelectObject(n11, n14);
        }
        OS.ReleaseDC(0, n10);
        OS.DeleteDC(n11);
        return n9;
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0;
        this.images = null;
    }

    public Image get(int n2) {
        return this.images[n2];
    }

    public int getStyle() {
        return this.style;
    }

    public int getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int indexOf(Image image) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.images[i2] == null) continue;
            if (this.images[i2].isDisposed()) {
                this.images[i2] = null;
            }
            if (this.images[i2] == null || !this.images[i2].equals(image)) continue;
            return i2;
        }
        return -1;
    }

    public void put(int n2, Image image) {
        int n3 = OS.ImageList_GetImageCount(this.handle);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        if (image != null) {
            this.set(n2, image, n3);
        }
        this.images[n2] = image;
    }

    public void remove(int n2) {
        int n3 = OS.ImageList_GetImageCount(this.handle);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        OS.ImageList_Remove(this.handle, n2);
        System.arraycopy(this.images, n2 + 1, this.images, n2, --n3 - n2);
        this.images[n2] = null;
    }

    public int removeRef() {
        return --this.refCount;
    }

    void set(int n2, Image image, int n3) {
        int n4 = image.handle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        switch (image.type) {
            case 0: {
                int n5 = 0;
                int n6 = 0;
                ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
                switch (imageData.getTransparencyType()) {
                    case 1: {
                        boolean bl2 = true;
                        if (imageData.alphaData == null) {
                            bl2 = false;
                        } else {
                            for (byte by2 : imageData.alphaData) {
                                if (by2 == 0) continue;
                                bl2 = false;
                                break;
                            }
                        }
                        if (OS.COMCTL32_MAJOR >= 6 && !bl2) {
                            n5 = this.copyWithAlpha(n4, -1, imageData.alphaData, nArray[0], nArray2[0]);
                            break;
                        }
                        n5 = this.copyBitmap(n4, nArray[0], nArray2[0]);
                        n6 = this.createMaskFromAlpha(imageData, nArray[0], nArray2[0]);
                        break;
                    }
                    case 4: {
                        int n7 = -1;
                        Color color = image.getBackground();
                        if (color != null) {
                            n7 = color.handle;
                        }
                        n5 = this.copyBitmap(n4, nArray[0], nArray2[0]);
                        n6 = this.createMask(n4, nArray[0], nArray2[0], n7, imageData.transparentPixel);
                        break;
                    }
                    default: {
                        n5 = this.copyBitmap(n4, nArray[0], nArray2[0]);
                        if (n2 == n3) break;
                        n6 = this.createMask(n4, nArray[0], nArray2[0], -1, -1);
                    }
                }
                if (n2 == n3) {
                    OS.ImageList_Add(this.handle, n5, n6);
                } else {
                    OS.ImageList_Replace(this.handle, n2, n5, n6);
                }
                if (n6 != 0) {
                    OS.DeleteObject(n6);
                }
                if (n5 == n4) break;
                OS.DeleteObject(n5);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon(this.handle, n2 == n3 ? -1 : n2, n4);
                    break;
                }
                int n8 = this.copyIcon(n4, nArray[0], nArray2[0]);
                OS.ImageList_ReplaceIcon(this.handle, n2 == n3 ? -1 : n2, n8);
                OS.DestroyIcon(n8);
            }
        }
    }

    public int size() {
        int n2 = 0;
        int n3 = OS.ImageList_GetImageCount(this.handle);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.images[i2] == null) continue;
            if (this.images[i2].isDisposed()) {
                this.images[i2] = null;
            }
            if (this.images[i2] == null) continue;
            ++n2;
        }
        return n2;
    }
}

