/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n2) {
        super(composite, n2);
    }

    void clearArea(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            RECT rECT = new RECT();
            OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
            int n6 = OS.GetDCEx(this.handle, 0, 26);
            this.drawBackground(n6, rECT);
            OS.ReleaseDC(this.handle, n6);
        }
    }

    public void drawBackground(GC gC, int n2, int n3, int n4, int n5) {
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        this.drawBackgroundInPixels(gC, n2, n3, n4, n5, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void reskinChildren(int n2) {
        if (this.caret != null) {
            this.caret.reskin(n2);
        }
        if (this.ime != null) {
            this.ime.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.checkWidget();
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        n7 = DPIUtil.autoScaleUp(n7);
        this.scrollInPixels(n2, n3, n4, n5, n6, n7, bl2);
    }

    void scrollInPixels(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8;
        int n9;
        boolean bl3;
        this.forceResize();
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n4, n5, n4 + n6, n5 + n7);
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (OS.IntersectRect(rECT2, rECT, rECT2)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                n9 = 384;
                OS.RedrawWindow(this.handle, null, 0, n9);
            }
        }
        n9 = n2 - n4;
        int n10 = n3 - n5;
        if (this.findImageControl() != null) {
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n8 = 1029;
                if (bl2) {
                    n8 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n8);
            }
            OS.OffsetRect(rECT, n9, n10);
            if (OS.IsWinCE) {
                OS.InvalidateRect(this.handle, rECT, true);
            } else {
                n8 = 1029;
                if (bl2) {
                    n8 |= 0x80;
                }
                OS.RedrawWindow(this.handle, rECT, 0, n8);
            }
        } else {
            n8 = 6;
            OS.ScrollWindowEx(this.handle, n9, n10, rECT, null, 0, null, n8);
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                Rectangle rectangle = control.getBoundsInPixels();
                if (Math.min(n4 + n6, rectangle.x + rectangle.width) < Math.max(n4, rectangle.x) || Math.min(n5 + n7, rectangle.y + rectangle.height) < Math.max(n5, rectangle.y)) continue;
                control.setLocationInPixels(rectangle.x + n9, rectangle.y + n10);
            }
        }
        if (bl3) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    @Override
    TCHAR windowClass() {
        if (this.display.useOwnDC) {
            return this.display.windowOwnDCClass;
        }
        return super.windowClass();
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        if (n3 == Display.SWT_RESTORECARET && (this.state & 2) != 0 && this.caret != null) {
            this.caret.killFocus();
            this.caret.setFocus();
            return 1;
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.caret != null) {
            switch (n2) {
                case 8: 
                case 27: 
                case 127: {
                    break;
                }
                default: {
                    int[] nArray;
                    if (OS.GetKeyState(17) < 0 || !OS.SystemParametersInfo(4128, 0, nArray = new int[1], 0) || nArray[0] == 0) break;
                    OS.SetCursor(0);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_IME_COMPOSITION(int n2, int n3) {
        POINT pOINT;
        short s2;
        short s3;
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION(n2, n3)) != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION == OS.VERSION(5, 1) && OS.IsDBLocale && (s3 = OS.PRIMARYLANGID(s2 = OS.GetSystemDefaultUILanguage())) == 18 && this.caret != null && this.caret.isFocusCaret() && OS.GetCaretPos(pOINT = new POINT())) {
            COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
            cOMPOSITIONFORM.dwStyle = 2;
            cOMPOSITIONFORM.x = pOINT.x;
            cOMPOSITIONFORM.y = pOINT.y;
            int n4 = OS.ImmGetContext(this.handle);
            OS.ImmSetCompositionWindow(n4, cOMPOSITIONFORM);
            OS.ImmReleaseContext(this.handle, n4);
        }
        return super.WM_IME_COMPOSITION(n2, n3);
    }

    @Override
    LRESULT WM_IME_COMPOSITION_START(int n2, int n3) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_COMPOSITION_START(n2, n3)) != null) {
            return lRESULT;
        }
        return super.WM_IME_COMPOSITION_START(n2, n3);
    }

    @Override
    LRESULT WM_IME_ENDCOMPOSITION(int n2, int n3) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_IME_ENDCOMPOSITION(n2, n3)) != null) {
            return lRESULT;
        }
        return super.WM_IME_ENDCOMPOSITION(n2, n3);
    }

    @Override
    LRESULT WM_INPUTLANGCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_INPUTLANGCHANGE(n2, n3);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setIMEFont();
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.ime != null) {
            this.ime.WM_KEYDOWN(n2, n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        Object object;
        if (this.ime != null && (object = this.ime.WM_KILLFOCUS(n2, n3)) != null) {
            return object;
        }
        object = this.caret;
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (object != null) {
            ((Caret)object).killFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT;
        if (this.ime != null && (lRESULT = this.ime.WM_LBUTTONDOWN(n2, n3)) != null) {
            return lRESULT;
        }
        return super.WM_LBUTTONDOWN(n2, n3);
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.resizeIME();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGED(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(n2, n3);
        boolean bl3 = bl2 = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl3 = bl2 = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        return lRESULT;
    }
}

