/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCHITTESTINFO;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final int TabFolderProc;
    static final TCHAR TabFolderClass;
    boolean createdAsRTL;
    static final int ID_UPDOWN = 1;

    public TabFolder(Composite composite, int n2) {
        super(composite, TabFolder.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TabFolderProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        if (OS.IsPPC && (n2 & 0x80) == 0) {
            n2 |= 0x400;
        }
        n2 = TabFolder.checkBits(n2, 128, 1024, 0, 0, 0, 0);
        return n2 & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        this.checkWidget();
        Point point = super.computeSizeInPixels(n2, n3, bl2);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n4 = rECT.left - rECT.right;
        int n5 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n5 != 0) {
            OS.SendMessage(this.handle, 4874, n5 - 1, rECT2);
            n4 = Math.max(n4, rECT2.right - rECT.right);
        }
        RECT rECT3 = new RECT();
        OS.SetRect(rECT3, 0, 0, n4, point.y);
        OS.SendMessage(this.handle, 4904, 1, rECT3);
        int n6 = this.getBorderWidthInPixels();
        rECT3.left -= n6;
        rECT3.right += n6;
        n4 = rECT3.right - rECT3.left;
        point.x = Math.max(n4, point.x);
        return point;
    }

    @Override
    Rectangle computeTrimInPixels(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        OS.SendMessage(this.handle, 4904, 1, rECT);
        int n6 = this.getBorderWidthInPixels();
        rECT.left -= n6;
        rECT.right += n6;
        rECT.top -= n6;
        rECT.bottom += n6;
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n7, n8);
    }

    void createItem(TabItem tabItem, int n2) {
        TabItem[] tabItemArray;
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        if (n3 == this.items.length) {
            tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if (OS.SendMessage(this.handle, OS.TCM_INSERTITEM, n2, (TCITEM)(tabItemArray = new TCITEM())) == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, n3 - n2);
        this.items[n2] = tabItem;
        if (n3 == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, true);
        }
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsPPC) {
            OS.SendMessage(this.handle, 8199, 524, 0);
        }
        int n2 = OS.SendMessage(this.handle, 4909, 0, 0);
        OS.SendMessage(n2, 1048, 0, Short.MAX_VALUE);
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem tabItem) {
        int n2;
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        for (n2 = 0; n2 < n3 && this.items[n2] != tabItem; ++n2) {
        }
        if (n2 == n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (OS.SendMessage(this.handle, 4872, n2, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n3 - n2);
        this.items[n3] = null;
        if (n3 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (n3 > 0 && n2 == n4) {
            this.setSelection(Math.max(0, n4 - 1), true);
        }
    }

    @Override
    void drawThemeBackground(int n2, int n3, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, n3, rECT2, 2);
        if (OS.IntersectRect(new RECT(), rECT2, rECT)) {
            OS.DrawThemeBackground(this.display.hTabTheme(), n2, 10, 0, rECT2, null);
        }
    }

    @Override
    Control findThemeControl() {
        return this;
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public TabItem getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return this.items[n2];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TCHITTESTINFO tCHITTESTINFO = new TCHITTESTINFO();
        tCHITTESTINFO.x = point.x;
        tCHITTESTINFO.y = point.y;
        int n2 = OS.SendMessage(this.handle, 4877, 0, tCHITTESTINFO);
        if (n2 == -1) {
            return null;
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4868, 0, 0);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        TabItem[] tabItemArray = new TabItem[n2];
        System.arraycopy(this.items, 0, tabItemArray, 0, n2);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n2 == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n2]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4875, 0, 0);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBoundsInPixels();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.imageList.add(image);
            int n3 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, n3);
            return n2;
        }
        int n4 = this.imageList.indexOf(image);
        if (n4 == -1) {
            n4 = this.imageList.add(image);
        } else {
            this.imageList.put(n4, image);
        }
        return n4;
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.items[i2] != tabItem) continue;
            return i2;
        }
        return -1;
    }

    @Override
    Point minimumSize(int n2, int n3, boolean bl2) {
        Control[] controlArray = this._getChildren();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Serializable serializable;
            int n6;
            Control control = controlArray[i2];
            int n7 = OS.SendMessage(this.handle, 4868, 0, 0);
            for (n6 = 0; n6 < n7 && this.items[n6].control != control; ++n6) {
            }
            if (n6 == n7) {
                serializable = DPIUtil.autoScaleUp(control.getBounds());
                n4 = Math.max(n4, serializable.x + serializable.width);
                n5 = Math.max(n5, serializable.y + serializable.height);
                continue;
            }
            serializable = DPIUtil.autoScaleUp(control.computeSize(DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n3), bl2));
            n4 = Math.max(n4, ((Point)serializable).x);
            n5 = Math.max(n5, ((Point)serializable).y);
        }
        return new Point(n4, n5);
    }

    @Override
    boolean mnemonicHit(char c2) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            TabItem tabItem = this.items[i2];
            if (tabItem == null) continue;
            char c3 = this.findMnemonic(tabItem.getText());
            if (Character.toUpperCase(c2) != Character.toUpperCase(c3) || !this.forceFocus()) continue;
            if (i2 != this.getSelectionIndex()) {
                this.setSelection(i2, true);
            }
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c2) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            TabItem tabItem = this.items[i2];
            if (tabItem == null) continue;
            char c3 = this.findMnemonic(tabItem.getText());
            if (Character.toUpperCase(c2) != Character.toUpperCase(c3)) continue;
            return true;
        }
        return false;
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                TabItem tabItem = this.items[i2];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            TabItem tabItem = this.items[i2];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n2) {
        if (this.items != null) {
            int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
            for (int i2 = 0; i2 < n3; ++i2) {
                TabItem tabItem = this.items[i2];
                if (tabItem == null) continue;
                tabItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            for (int i2 = tabItemArray.length - 1; i2 >= 0; --i2) {
                int n2 = this.indexOf(tabItemArray[i2]);
                if (n2 == -1) continue;
                this.setSelection(n2, false);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientAreaInPixels();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientAreaInPixels();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
            int n2 = OS.SendMessage(this.handle, 4875, 0, 0);
            if (n2 != -1) {
                TabItem tabItem = this.items[n2];
                Control control = tabItem.control;
                if (control != null && !control.isDisposed()) {
                    control.setBoundsInPixels(this.getClientAreaInPixels());
                }
            }
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n2 || n2 >= n3) {
            return;
        }
        this.setSelection(n2, false);
    }

    void setSelection(int n2, boolean bl2) {
        Widget widget;
        int n3 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n3 == n2) {
            return;
        }
        if (n3 != -1) {
            TabItem tabItem = this.items[n3];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, n2, 0);
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n4 != -1) {
            widget = this.items[n4];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            if (bl2) {
                Event event = new Event();
                event.item = widget;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            if (n2 != 0x6000000) {
                n2 = this.style & Integer.MIN_VALUE;
            }
            int n3 = this.items.length;
            for (int i2 = 0; i2 < n3 && this.items[i2] != null; ++i2) {
                this.items[i2].updateTextDirection(n2);
            }
            return true;
        }
        return false;
    }

    @Override
    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        int n2 = nMTTDISPINFO.idFrom;
        int n3 = OS.SendMessage(this.handle, 4909, 0, 0);
        if (n3 == nMTTDISPINFO.hwndFrom) {
            TabItem tabItem;
            int n4 = -2080374784;
            nMTTDISPINFO.uFlags = (this.style & n4) != 0 && (this.style & n4) != n4 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (0 <= n2 && n2 < this.items.length && (tabItem = this.items[n2]) != null) {
                return tabItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    @Override
    boolean traversePage(boolean bl2) {
        int n2 = this.getItemCount();
        if (n2 <= 1) {
            return false;
        }
        int n3 = this.getSelectionIndex();
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4 = bl2 ? 1 : -1;
            n3 = (n3 + n4 + n2) % n2;
        }
        this.setSelection(n3, true);
        if (n3 == this.getSelectionIndex()) {
            OS.SendMessage(this.handle, 295, 3, 0);
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        int n2;
        Object object;
        super.updateOrientation();
        int n3 = OS.GetWindow(this.handle, 5);
        while (n3 != 0) {
            object = new TCHAR(0, 128);
            OS.GetClassName(n3, (TCHAR)object, ((TCHAR)object).length());
            String string = ((TCHAR)object).toString(0, ((TCHAR)object).strlen());
            if (string.equals("msctls_updown32")) {
                n2 = OS.GetWindowLong(n3, -20);
                n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
                OS.SetWindowLong(n3, -20, n2 &= 0xFFFFDFFF);
                OS.InvalidateRect(n3, null, true);
                break;
            }
            n3 = OS.GetWindow(n3, 2);
        }
        object = new RECT();
        OS.GetWindowRect(this.handle, (RECT)object);
        int n4 = ((RECT)object).right - ((RECT)object).left;
        n2 = ((RECT)object).bottom - ((RECT)object).top;
        OS.SetWindowPos(this.handle, 0, 0, 0, n4 - 1, n2 - 1, 6);
        OS.SetWindowPos(this.handle, 0, 0, 0, n4, n2, 6);
        if (this.imageList != null) {
            TabItem tabItem;
            Point point = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            int n5 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, n5);
            TCITEM tCITEM = new TCITEM();
            tCITEM.mask = 2;
            for (int i2 = 0; i2 < this.items.length && (tabItem = this.items[i2]) != null; ++i2) {
                Image image = tabItem.image;
                if (image == null) continue;
                tCITEM.iImage = this.imageIndex(image);
                OS.SendMessage(this.handle, OS.TCM_SETITEM, i2, tCITEM);
            }
        }
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            n2 |= 0x8000;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= 2;
        }
        return n2 | 0 | 0x4000;
    }

    @Override
    TCHAR windowClass() {
        return TabFolderClass;
    }

    @Override
    int windowProc() {
        return TabFolderProc;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8193);
    }

    @Override
    LRESULT WM_GETOBJECT(int n2, int n3) {
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n2, n3);
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 37: 
            case 39: {
                boolean bl2;
                boolean bl3 = bl2 = (this.style & 0x4000000) != 0;
                if (bl2 == this.createdAsRTL) break;
                int n4 = this.callWindowProc(this.handle, 256, n2 == 39 ? 37 : 39, n3);
                return new LRESULT(n4);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSELEAVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            int n4 = OS.SendMessage(this.handle, 4909, 0, 0);
            if (OS.SendMessage(n4, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(n4, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(n4, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_NCHITTEST(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCHITTEST(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = OS.DefWindowProc(this.handle, 132, n2, n3);
        return new LRESULT(n4);
    }

    @Override
    LRESULT WM_NOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_NOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PARENTNOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_PARENTNOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return lRESULT;
        }
        if ((this.style & 0x4000000) != 0) {
            int n4 = OS.LOWORD(n2);
            switch (n4) {
                case 1: {
                    int n5 = OS.HIWORD(n2);
                    int n6 = n3;
                    if (n5 != 1) break;
                    int n7 = OS.GetWindowLong(n6, -20);
                    OS.SetWindowLong(n6, -20, n7 | 0x400000);
                    break;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n4 != -1) {
            TabItem tabItem = this.items[n4];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        int n5 = OS.GetWindowLong(this.handle, -16);
        if ((n5 & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT);
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n8 = rECT.right - rECT.left;
        int n9 = rECT.bottom - rECT.top;
        if (n6 == n8 && n7 == n9) {
            return lRESULT;
        }
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT2);
        int n10 = -rECT2.right;
        int n11 = -rECT2.bottom;
        if (n6 != n8) {
            n4 = n8;
            if (n6 < n8) {
                n4 = n6;
            }
            OS.SetRect(rECT, n4 - n10, 0, n6, n7);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n7 != n9) {
            n4 = n9;
            if (n7 < n9) {
                n4 = n7;
            }
            if (n6 < n8) {
                n8 -= n10;
            }
            OS.SetRect(rECT, 0, n4 - n11, n8, n7);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        int n4 = nMHDR.code;
        switch (n4) {
            case -552: 
            case -551: {
                Object object;
                TabItem tabItem = null;
                int n5 = OS.SendMessage(this.handle, 4875, 0, 0);
                if (n5 != -1) {
                    tabItem = this.items[n5];
                }
                if (tabItem != null && (object = tabItem.control) != null && !((Widget)object).isDisposed()) {
                    if (n4 == -551) {
                        ((Control)object).setBoundsInPixels(this.getClientAreaInPixels());
                    }
                    ((Control)object).setVisible(n4 == -551);
                }
                if (n4 != -551) break;
                object = new Event();
                ((Event)object).item = tabItem;
                this.sendSelectionEvent(13, (Event)object, false);
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    static {
        TabFolderClass = new TCHAR(0, "SysTabControl32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TabFolderClass, wNDCLASS);
        TabFolderProc = wNDCLASS.lpfnWndProc;
        int n2 = OS.GetModuleHandle(null);
        int n3 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n2;
        wNDCLASS.style &= 0xFFFFBFFC;
        int n4 = TabFolderClass.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, TabFolderClass, n4);
        wNDCLASS.lpszClassName = n5;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, n5);
    }
}

