/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFWGamepadState$Buffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class GLFWGamepadState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUTTONS;
    public static final int AXES;

    protected GLFWGamepadState(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected GLFWGamepadState create(long l2, ByteBuffer byteBuffer) {
        return new GLFWGamepadState(l2, byteBuffer);
    }

    public GLFWGamepadState(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), GLFWGamepadState.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer buttons() {
        return GLFWGamepadState.nbuttons(this.address());
    }

    public byte buttons(int n2) {
        return GLFWGamepadState.nbuttons(this.address(), n2);
    }

    public FloatBuffer axes() {
        return GLFWGamepadState.naxes(this.address());
    }

    public float axes(int n2) {
        return GLFWGamepadState.naxes(this.address(), n2);
    }

    public GLFWGamepadState buttons(ByteBuffer byteBuffer) {
        GLFWGamepadState.nbuttons(this.address(), byteBuffer);
        return this;
    }

    public GLFWGamepadState buttons(int n2, byte by2) {
        GLFWGamepadState.nbuttons(this.address(), n2, by2);
        return this;
    }

    public GLFWGamepadState axes(FloatBuffer floatBuffer) {
        GLFWGamepadState.naxes(this.address(), floatBuffer);
        return this;
    }

    public GLFWGamepadState axes(int n2, float f2) {
        GLFWGamepadState.naxes(this.address(), n2, f2);
        return this;
    }

    public GLFWGamepadState set(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.buttons(byteBuffer);
        this.axes(floatBuffer);
        return this;
    }

    public GLFWGamepadState set(GLFWGamepadState gLFWGamepadState) {
        MemoryUtil.memCopy(gLFWGamepadState.address(), this.address(), SIZEOF);
        return this;
    }

    public static GLFWGamepadState malloc() {
        return new GLFWGamepadState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static GLFWGamepadState calloc() {
        return new GLFWGamepadState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static GLFWGamepadState create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new GLFWGamepadState(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static GLFWGamepadState create(long l2) {
        return new GLFWGamepadState(l2, null);
    }

    public static GLFWGamepadState createSafe(long l2) {
        return l2 == 0L ? null : new GLFWGamepadState(l2, null);
    }

    public static GLFWGamepadState$Buffer malloc(int n2) {
        return new GLFWGamepadState$Buffer(MemoryUtil.nmemAllocChecked(GLFWGamepadState.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static GLFWGamepadState$Buffer calloc(int n2) {
        return new GLFWGamepadState$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static GLFWGamepadState$Buffer create(int n2) {
        ByteBuffer byteBuffer = GLFWGamepadState.__create(n2, SIZEOF);
        return new GLFWGamepadState$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static GLFWGamepadState$Buffer create(long l2, int n2) {
        return new GLFWGamepadState$Buffer(l2, n2);
    }

    public static GLFWGamepadState$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new GLFWGamepadState$Buffer(l2, n2);
    }

    public static GLFWGamepadState mallocStack() {
        return GLFWGamepadState.malloc(MemoryStack.stackGet());
    }

    public static GLFWGamepadState callocStack() {
        return GLFWGamepadState.calloc(MemoryStack.stackGet());
    }

    public static GLFWGamepadState mallocStack(MemoryStack memoryStack) {
        return GLFWGamepadState.malloc(memoryStack);
    }

    public static GLFWGamepadState callocStack(MemoryStack memoryStack) {
        return GLFWGamepadState.calloc(memoryStack);
    }

    public static GLFWGamepadState$Buffer mallocStack(int n2) {
        return GLFWGamepadState.malloc(n2, MemoryStack.stackGet());
    }

    public static GLFWGamepadState$Buffer callocStack(int n2) {
        return GLFWGamepadState.calloc(n2, MemoryStack.stackGet());
    }

    public static GLFWGamepadState$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return GLFWGamepadState.malloc(n2, memoryStack);
    }

    public static GLFWGamepadState$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return GLFWGamepadState.calloc(n2, memoryStack);
    }

    public static GLFWGamepadState malloc(MemoryStack memoryStack) {
        return new GLFWGamepadState(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static GLFWGamepadState calloc(MemoryStack memoryStack) {
        return new GLFWGamepadState(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static GLFWGamepadState$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new GLFWGamepadState$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static GLFWGamepadState$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new GLFWGamepadState$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nbuttons(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)BUTTONS, 15);
    }

    public static byte nbuttons(long l2, int n2) {
        return UNSAFE.getByte(null, l2 + (long)BUTTONS + Checks.check(n2, 15) * 1L);
    }

    public static FloatBuffer naxes(long l2) {
        return MemoryUtil.memFloatBuffer(l2 + (long)AXES, 6);
    }

    public static float naxes(long l2, int n2) {
        return UNSAFE.getFloat(null, l2 + (long)AXES + Checks.check(n2, 6) * 4L);
    }

    public static void nbuttons(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)BUTTONS, byteBuffer.remaining() * 1);
    }

    public static void nbuttons(long l2, int n2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)BUTTONS + Checks.check(n2, 15) * 1L, by2);
    }

    public static void naxes(long l2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(floatBuffer, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(floatBuffer), l2 + (long)AXES, floatBuffer.remaining() * 4);
    }

    public static void naxes(long l2, int n2, float f2) {
        UNSAFE.putFloat(null, l2 + (long)AXES + Checks.check(n2, 6) * 4L, f2);
    }

    static {
        Struct$Layout struct$Layout = GLFWGamepadState.__struct(GLFWGamepadState.__array(1, 15), GLFWGamepadState.__array(4, 6));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        BUTTONS = struct$Layout.offsetof(0);
        AXES = struct$Layout.offsetof(1);
    }
}

