/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL32C
extends GL31C {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    protected GL32C() {
        throw new UnsupportedOperationException();
    }

    public static native void nglGetBufferParameteri64v(int var0, int var1, long var2);

    public static void glGetBufferParameteri64v(int n2, int n3, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        GL32C.nglGetBufferParameteri64v(n2, n3, MemoryUtil.memAddress(longBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameteri64(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            LongBuffer longBuffer = memoryStack.callocLong(1);
            GL32C.nglGetBufferParameteri64v(n2, n3, MemoryUtil.memAddress(longBuffer));
            long l2 = longBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsBaseVertex(int n2, int n3, int n4, long l2, int n5) {
        GL32C.nglDrawElementsBaseVertex(n2, n3, n4, l2, n5);
    }

    public static void glDrawElementsBaseVertex(int n2, int n3, ByteBuffer byteBuffer, int n4) {
        GL32C.nglDrawElementsBaseVertex(n2, byteBuffer.remaining() >> GLChecks.typeToByteShift(n3), n3, MemoryUtil.memAddress(byteBuffer), n4);
    }

    public static void glDrawElementsBaseVertex(int n2, ByteBuffer byteBuffer, int n3) {
        GL32C.nglDrawElementsBaseVertex(n2, byteBuffer.remaining(), 5121, MemoryUtil.memAddress(byteBuffer), n3);
    }

    public static void glDrawElementsBaseVertex(int n2, ShortBuffer shortBuffer, int n3) {
        GL32C.nglDrawElementsBaseVertex(n2, shortBuffer.remaining(), 5123, MemoryUtil.memAddress(shortBuffer), n3);
    }

    public static void glDrawElementsBaseVertex(int n2, IntBuffer intBuffer, int n3) {
        GL32C.nglDrawElementsBaseVertex(n2, intBuffer.remaining(), 5125, MemoryUtil.memAddress(intBuffer), n3);
    }

    public static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7);

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, int n5, int n6, long l2, int n7) {
        GL32C.nglDrawRangeElementsBaseVertex(n2, n3, n4, n5, n6, l2, n7);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6) {
        GL32C.nglDrawRangeElementsBaseVertex(n2, n3, n4, byteBuffer.remaining() >> GLChecks.typeToByteShift(n5), n5, MemoryUtil.memAddress(byteBuffer), n6);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5) {
        GL32C.nglDrawRangeElementsBaseVertex(n2, n3, n4, byteBuffer.remaining(), 5121, MemoryUtil.memAddress(byteBuffer), n5);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, ShortBuffer shortBuffer, int n5) {
        GL32C.nglDrawRangeElementsBaseVertex(n2, n3, n4, shortBuffer.remaining(), 5123, MemoryUtil.memAddress(shortBuffer), n5);
    }

    public static void glDrawRangeElementsBaseVertex(int n2, int n3, int n4, IntBuffer intBuffer, int n5) {
        GL32C.nglDrawRangeElementsBaseVertex(n2, n3, n4, intBuffer.remaining(), 5125, MemoryUtil.memAddress(intBuffer), n5);
    }

    public static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6);

    public static void glDrawElementsInstancedBaseVertex(int n2, int n3, int n4, long l2, int n5, int n6) {
        GL32C.nglDrawElementsInstancedBaseVertex(n2, n3, n4, l2, n5, n6);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, int n3, ByteBuffer byteBuffer, int n4, int n5) {
        GL32C.nglDrawElementsInstancedBaseVertex(n2, byteBuffer.remaining() >> GLChecks.typeToByteShift(n3), n3, MemoryUtil.memAddress(byteBuffer), n4, n5);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        GL32C.nglDrawElementsInstancedBaseVertex(n2, byteBuffer.remaining(), 5121, MemoryUtil.memAddress(byteBuffer), n3, n4);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, ShortBuffer shortBuffer, int n3, int n4) {
        GL32C.nglDrawElementsInstancedBaseVertex(n2, shortBuffer.remaining(), 5123, MemoryUtil.memAddress(shortBuffer), n3, n4);
    }

    public static void glDrawElementsInstancedBaseVertex(int n2, IntBuffer intBuffer, int n3, int n4) {
        GL32C.nglDrawElementsInstancedBaseVertex(n2, intBuffer.remaining(), 5125, MemoryUtil.memAddress(intBuffer), n3, n4);
    }

    public static native void nglMultiDrawElementsBaseVertex(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void glMultiDrawElementsBaseVertex(int n2, IntBuffer intBuffer, int n3, PointerBuffer pointerBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, intBuffer.remaining());
            Checks.check((Buffer)intBuffer2, intBuffer.remaining());
        }
        GL32C.nglMultiDrawElementsBaseVertex(n2, MemoryUtil.memAddress(intBuffer), n3, MemoryUtil.memAddress(pointerBuffer), intBuffer.remaining(), MemoryUtil.memAddress(intBuffer2));
    }

    public static native void glProvokingVertex(int var0);

    public static native void glTexImage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public static native void glTexImage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    public static native void nglGetMultisamplefv(int var0, int var1, long var2);

    public static void glGetMultisamplefv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GL32C.nglGetMultisamplefv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultisamplef(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GL32C.nglGetMultisamplefv(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void glSampleMaski(int var0, int var1);

    public static native void glFramebufferTexture(int var0, int var1, int var2, int var3);

    public static native long glFenceSync(int var0, int var1);

    public static native boolean nglIsSync(long var0);

    public static boolean glIsSync(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return GL32C.nglIsSync(l2);
    }

    public static native void nglDeleteSync(long var0);

    public static void glDeleteSync(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        GL32C.nglDeleteSync(l2);
    }

    public static native int nglClientWaitSync(long var0, int var2, long var3);

    public static int glClientWaitSync(long l2, int n2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return GL32C.nglClientWaitSync(l2, n2, l3);
    }

    public static native void nglWaitSync(long var0, int var2, long var3);

    public static void glWaitSync(long l2, int n2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        GL32C.nglWaitSync(l2, n2, l3);
    }

    public static native void nglGetInteger64v(int var0, long var1);

    public static void glGetInteger64v(int n2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        GL32C.nglGetInteger64v(n2, MemoryUtil.memAddress(longBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            LongBuffer longBuffer = memoryStack.callocLong(1);
            GL32C.nglGetInteger64v(n2, MemoryUtil.memAddress(longBuffer));
            long l2 = longBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetInteger64i_v(int var0, int var1, long var2);

    public static void glGetInteger64i_v(int n2, int n3, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        GL32C.nglGetInteger64i_v(n2, n3, MemoryUtil.memAddress(longBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64i(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            LongBuffer longBuffer = memoryStack.callocLong(1);
            GL32C.nglGetInteger64i_v(n2, n3, MemoryUtil.memAddress(longBuffer));
            long l2 = longBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSynciv(long l2, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GL32C.nglGetSynciv(l2, n2, intBuffer2.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynci(long l2, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer2 = memoryStack.callocInt(1);
            GL32C.nglGetSynciv(l2, n2, 1, MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
            int n4 = intBuffer2.get(0);
            return n4;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static void glGetBufferParameteri64v(int n2, int n3, long[] lArray) {
        long l2 = GL.getICD().glGetBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(lArray, 1);
        }
        JNI.callPV(n2, n3, lArray, l2);
    }

    public static void glMultiDrawElementsBaseVertex(int n2, int[] nArray, int n3, PointerBuffer pointerBuffer, int[] nArray2) {
        long l2 = GL.getICD().glMultiDrawElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check((CustomBuffer)pointerBuffer, nArray.length);
            Checks.check(nArray2, nArray.length);
        }
        JNI.callPPPV(n2, nArray, n3, MemoryUtil.memAddress(pointerBuffer), nArray.length, nArray2, l2);
    }

    public static void glGetMultisamplefv(int n2, int n3, float[] fArray) {
        long l2 = GL.getICD().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetInteger64v(int n2, long[] lArray) {
        long l2 = GL.getICD().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(lArray, 1);
        }
        JNI.callPV(n2, lArray, l2);
    }

    public static void glGetInteger64i_v(int n2, int n3, long[] lArray) {
        long l2 = GL.getICD().glGetInteger64i_v;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(lArray, 1);
        }
        JNI.callPV(n2, n3, lArray, l2);
    }

    public static void glGetSynciv(long l2, int n2, int[] nArray, int[] nArray2) {
        long l3 = GL.getICD().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPPV(l2, n2, nArray2.length, nArray, nArray2, l3);
    }

    static {
        GL.initialize();
    }
}

