/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Struct;

class StructBuffer$StructIterator
implements Iterator {
    private long address;
    private ByteBuffer container;
    private Struct factory;
    private int index;
    private int fence;

    StructBuffer$StructIterator(long l2, ByteBuffer byteBuffer, Struct struct, int n2, int n3) {
        this.address = l2;
        this.container = byteBuffer;
        this.factory = struct;
        this.index = n2;
        this.fence = n3;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.fence;
    }

    public Struct next() {
        if (Checks.CHECKS && this.fence <= this.index) {
            throw new NoSuchElementException();
        }
        return this.factory.create(this.address + Integer.toUnsignedLong(this.index++) * (long)this.factory.sizeof(), this.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachRemaining(Consumer consumer) {
        int n2;
        Objects.requireNonNull(consumer);
        try {
            int n3 = this.factory.sizeof();
            for (n2 = this.index; n2 < this.fence; ++n2) {
                consumer.accept(this.factory.create(this.address + Integer.toUnsignedLong(n2) * (long)n3, this.container));
            }
        }
        finally {
            this.index = n2;
        }
    }
}

